/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.dialogs.PopupFilteredList;
import org.xmind.ui.gantt2.viewer.TaskTreeEditableTracker;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;
import org.xmind.ui.internal.taskinfo.ArrageAssigneeDialog;
import org.xmind.ui.internal.taskinfo.AssigneeItem;
import org.xmind.ui.internal.taskinfo.AssigneePopupFilteredList;
import org.xmind.ui.internal.taskinfo.AssigneeSheetManager;
import org.xmind.ui.internal.taskinfo.TaskInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.resources.ImageDescriptorProvider;
import org.xmind.ui.viewers.ImageCachedLabelProvider;
import org.xmind.ui.viewers.MComboViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTreeAssigneeEditableTracker
extends TaskTreeEditableTracker {
    private static final String ADDSAVEDASSIGNEE = "org.xmind.ui.taskinfo.assignee";
    private static final String NONE = "";
    private Set<String> assignees;

    public TaskTreeAssigneeEditableTracker(IFigure target, FigureCanvas canvas, TaskTreeItemPart host) {
        super(target, canvas, host);
    }

    @Override
    protected void edit() {
        this.editAssignee();
    }

    private void editAssignee() {
        MComboViewer assigneeCombo = this.createAssigneeCombo((Composite)this.canvas);
        final Control control = assigneeCombo.getControl();
        this.locateEditor(control, this.target, this.canvas.getViewport());
        assigneeCombo.open();
        PopupFilteredList dialog = assigneeCombo.getPopupList();
        if (dialog != null) {
            dialog.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TaskTreeAssigneeEditableTracker.this.preCancelEditing();
                    e.display.asyncExec(new Runnable(){

                        public void run() {
                            if (control != null && !control.isDisposed()) {
                                control.dispose();
                            }
                        }
                    });
                }
            });
        }
    }

    private MComboViewer createAssigneeCombo(final Composite parent) {
        final MComboViewer assigneeCombo = new MComboViewer(parent, 1024){

            protected PopupFilteredList createPopupList() {
                AssigneePopupFilteredList list = new AssigneePopupFilteredList(this.getControl().getShell());
                this.refreshPopupList((PopupFilteredList)list);
                list.addOpenListener(new IOpenListener(){

                    public void open(OpenEvent event) {
                        this.setSelection(event.getSelection());
                    }
                });
                return list;
            }
        };
        assigneeCombo.setEmptySelectionImitation((Object)this);
        assigneeCombo.getControl().setBackground(parent.getBackground());
        assigneeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        assigneeCombo.setLabelProvider((IBaseLabelProvider)new AssignComboLabelProvider());
        assigneeCombo.setPatternFilter(new PopupFilteredList.PatternFilter());
        assigneeCombo.setInput(this.getAssigneeComboInput());
        assigneeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object ele = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (TaskTreeAssigneeEditableTracker.ADDSAVEDASSIGNEE == ele) {
                    TaskTreeAssigneeEditableTracker.this.openArrageAssignee(parent);
                } else {
                    TaskTreeAssigneeEditableTracker.this.changeAssignee(ele, assigneeCombo);
                }
            }
        });
        assigneeCombo.setPermitsUnprovidedElement(true);
        return assigneeCombo;
    }

    private List<String> getAssigneeComboInput() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.assignees == null) {
            this.assignees = this.topic != null ? TaskInfoUtils.loadAllAssignees((IWorkbook)this.topic.getOwnedWorkbook()) : new TreeSet<String>();
            if (this.getFrequencyAssignees() != null) {
                this.assignees.addAll(this.getFrequencyAssignees());
            }
        }
        if (this.assignees.size() != 0) {
            list.add(NONE);
        }
        list.addAll(this.assignees);
        return list;
    }

    private Collection<String> getFrequencyAssignees() {
        TreeSet list = AssigneeSheetManager.getInstance().getAssigneeSheet().getAssignees();
        if (list == null || list.isEmpty()) {
            return null;
        }
        TreeSet<String> assignees = new TreeSet<String>();
        for (AssigneeItem item : list) {
            assignees.add(item.getName());
        }
        return assignees;
    }

    private void openArrageAssignee(Composite parent) {
        ArrageAssigneeDialog dialog = new ArrageAssigneeDialog(parent.getShell());
        dialog.create();
        dialog.getShell().setSize(322, 350);
        Rectangle parentBound = parent.getShell().getBounds();
        Rectangle shellBound = dialog.getShell().getBounds();
        dialog.getShell().setLocation(parentBound.x + (parentBound.width - shellBound.width) / 2, parentBound.y + (parentBound.height - shellBound.height) / 2);
        dialog.open();
    }

    private void changeAssignee(Object ele, MComboViewer assigneeCombo) {
        String assignee = (String)ele;
        if (assignee == null || NONE.equals(assignee.trim())) {
            TaskInfoUtils.changeAssigned((ITopic)this.topic, (ICommandStack)this.getCommandStack(), null);
            return;
        }
        TaskInfoUtils.changeAssigned((ITopic)this.topic, (ICommandStack)this.getCommandStack(), (String)((String)ele));
        if (this.assignees != null) {
            this.assignees.add(assignee);
        }
        assigneeCombo.update(this.getAssigneeComboInput(), null);
        this.preCancelEditing();
        assigneeCombo.getControl().dispose();
    }

    private class AssignComboLabelProvider
    extends ImageCachedLabelProvider
    implements IColorProvider,
    ImageDescriptorProvider {
        private AssignComboLabelProvider() {
        }

        protected Image createImage(Object element) {
            if (element != TaskTreeAssigneeEditableTracker.NONE && element instanceof String && !TaskTreeAssigneeEditableTracker.ADDSAVEDASSIGNEE.equals((String)element)) {
                return TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/assignee.png").createImage();
            }
            if (element != TaskTreeAssigneeEditableTracker.NONE && element instanceof String && !TaskMessages.NoneAssignCombo_text.equals((String)element)) {
                return TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/remove.png").createImage();
            }
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object element) {
            if (element != TaskTreeAssigneeEditableTracker.NONE && element instanceof String && !TaskTreeAssigneeEditableTracker.ADDSAVEDASSIGNEE.equals((String)element)) {
                return TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/assignee.png");
            }
            if (element != TaskTreeAssigneeEditableTracker.NONE && element instanceof String && !TaskMessages.NoneAssignCombo_text.equals((String)element)) {
                return TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/remove.png");
            }
            return null;
        }

        public String getText(Object element) {
            if (element == TaskTreeAssigneeEditableTracker.NONE) {
                return TaskMessages.NoneAssignCombo_text;
            }
            if (element == TaskTreeAssigneeEditableTracker.this) {
                return TaskMessages.EnterAssignCombo_text;
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element == TaskTreeAssigneeEditableTracker.this) {
                return invalidColor;
            }
            return validColor;
        }
    }
}

