/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.workbench.internal;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.xmind.workbench.internal.XMindNetWorkbench;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.Bundle;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IStorage;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.http.HttpRequest;
import org.xmind.core.net.http.JSONEntity;
import org.xmind.core.usagedata.IUsageDataSampler;
import org.xmind.core.usagedata.IUsageDataUploader;

public class CathyUsageDataCollector
implements IUsageDataSampler,
IUsageDataUploader,
ISchedulingRule {
    private static final String STORAGE_BUNDLE_NAME = "org.xmind.cathy";
    private static final String PATH_USAGE_DATA = "usageData";
    private static final String PATH_APP_SESSION_WITH_DATE_STAMP_AND_SESSION_ID = "records/%s/%s.json";
    private static final String PATH_REPORT_WITH_DATE_STAMP = "reports/%s.json";
    private static final String PATH_STATES = "states.json";
    private static final String CONFIG_URL = "https://s3.amazonaws.com/xmind-config/udc.json";
    private static final String PARAM_FILE_NAME_WITH_DATE_STAMP = "%s.json";
    private static final String KEY_ENDPOINT = "endpoint";
    private static final String KEY_CLIENT_ID = "client_id";
    private static final String KEY_NEXT_UPLOAD_TIME = "next_upload_time";
    private static final String KEY_FILE_NAME = "file_name";
    private static final String KEY_DATA = "data";
    private static final String KEY_APP_SESSIONS = "AppSessions";
    private static final long DEFAULT_SLEEP_INTERVALS = 300000L;
    private static final long NEXT_UPLOAD_DELAY = 604800000L;
    private static final long RETENTION_PERIOD = 1209600000L;
    private static final int HINT_NONE = 0;
    private static final int HINT_INCLUDING_TODAY = 1;
    private static final Pattern PATTERN_APP_SESSION_PATH = Pattern.compile("records/([^/]+)/([^/]+).json");
    private static final Pattern PATTERN_REPORT_PATH = Pattern.compile("reports/([^/]+).json");
    private final IStorage storage;
    private Queue<Runnable> jobQueue;
    private boolean uploadEnabled;
    private JSONObject states;
    private Thread jobThread;
    private String dateStamp;
    private String appSessionId;
    private JSONObject appSession;

    public CathyUsageDataCollector() {
        this(CathyUsageDataCollector.loadDefaultStorage());
    }

    public CathyUsageDataCollector(IStorage storage) {
        this.storage = storage == null ? new ByteArrayStorage() : storage;
        this.jobQueue = new ConcurrentLinkedQueue<Runnable>();
        this.jobThread = null;
        this.dateStamp = null;
        this.uploadEnabled = false;
        this.states = null;
        this.appSessionId = null;
        this.appSession = null;
    }

    public boolean isUploadEnabled() {
        return this.uploadEnabled;
    }

    public void setUploadEnabled(boolean uploadEnabled) {
        if (CathyUsageDataCollector.loggingGeneral()) {
            System.out.println("[UsageData] Upload enablement changed: " + uploadEnabled);
        }
        this.uploadEnabled = uploadEnabled;
        this.notifyJobThread();
    }

    public void put(final String key, final String value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.jobQueue.add(new Runnable(){

            public void run() {
                CathyUsageDataCollector.this.doPut(key, value);
            }
        });
        this.notifyJobThread();
    }

    public void put(final String key, final long value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.jobQueue.add(new Runnable(){

            public void run() {
                CathyUsageDataCollector.this.doPut(key, value);
            }
        });
        this.notifyJobThread();
    }

    public void increase(final String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.jobQueue.add(new Runnable(){

            public void run() {
                CathyUsageDataCollector.this.doIncrease(key);
            }
        });
        this.notifyJobThread();
    }

    public void forceUpload() {
        this.jobQueue.add(new Runnable(){

            public void run() {
                CathyUsageDataCollector.this.upload(1);
            }
        });
        this.notifyJobThread();
    }

    public void start() {
        Assert.isTrue((this.appSessionId == null ? 1 : 0) != 0);
        this.states = this.loadStates();
        if (this.states.optString(KEY_CLIENT_ID, null) == null) {
            this.states.put(KEY_CLIENT_ID, (Object)UUID.randomUUID().toString());
        }
        if (this.states.optLong(KEY_NEXT_UPLOAD_TIME, 0L) == 0L) {
            this.states.put(KEY_NEXT_UPLOAD_TIME, System.currentTimeMillis() + 604800000L);
        }
        this.dateStamp = CathyUsageDataCollector.currentDateStamp();
        this.appSessionId = UUID.randomUUID().toString();
        this.appSession = this.loadAppSession();
        this.saveStates(this.states);
        this.clearOutdatedRecords();
        this.startJobThread();
        if (CathyUsageDataCollector.loggingGeneral()) {
            System.out.println("[UsageData] Starting....");
            System.out.println("[UsageData] States: " + this.states.toString());
            System.out.println("[UsageData] Date stamp: " + this.dateStamp);
            System.out.println("[UsageData] App Session Id: " + this.appSessionId);
        }
        XMindNetWorkbench.getDefault().setUsageDataSampler(this);
    }

    public void stop() {
        Assert.isTrue((this.appSessionId != null ? 1 : 0) != 0);
        XMindNetWorkbench.getDefault().setUsageDataSampler(null);
        Job.getJobManager().cancel((Object)this);
        this.stopJobThread();
        if (CathyUsageDataCollector.loggingGeneral()) {
            System.out.println("[UsageData] Stopped.");
        }
    }

    private void doPut(String key, String value) {
        if (CathyUsageDataCollector.loggingRecords()) {
            System.out.println("[UsageData] Put: '" + key + "'='" + value + "'");
        }
        this.checkAppSession();
        CathyUsageDataCollector.setValue(this.appSession, key, value);
        this.saveAppSession(this.appSession);
    }

    private void doPut(String key, long value) {
        if (CathyUsageDataCollector.loggingRecords()) {
            System.out.println("[UsageData] Put: '" + key + "'='" + value + "'");
        }
        this.checkAppSession();
        CathyUsageDataCollector.setValue(this.appSession, key, value);
        this.saveAppSession(this.appSession);
    }

    private void doIncrease(String key) {
        if (CathyUsageDataCollector.loggingRecords()) {
            System.out.println("[UsageData] Increase: '" + key + "'");
        }
        this.checkAppSession();
        int value = CathyUsageDataCollector.getValue(this.appSession, key, 0);
        CathyUsageDataCollector.setValue(this.appSession, key, value + 1);
        this.saveAppSession(this.appSession);
    }

    private static void setValue(JSONObject o, String key, Object value) {
        int sepIndex = key.indexOf(47);
        if (sepIndex < 0) {
            o.put(key, value);
            return;
        }
        String prefix = key.substring(0, sepIndex);
        key = key.substring(sepIndex + 1);
        JSONObject p = o.optJSONObject(prefix);
        if (p == null) {
            p = new JSONObject();
            o.put(prefix, (Object)p);
        }
        CathyUsageDataCollector.setValue(p, key, value);
    }

    private static int getValue(JSONObject o, String key, int defValue) {
        int sepIndex = key.indexOf(47);
        if (sepIndex < 0) {
            return o.optInt(key, defValue);
        }
        String prefix = key.substring(0, sepIndex);
        key = key.substring(sepIndex + 1);
        JSONObject p = o.optJSONObject(prefix);
        if (p == null) {
            return defValue;
        }
        return CathyUsageDataCollector.getValue(p, key, defValue);
    }

    private void checkAppSession() {
        String newDateStamp = CathyUsageDataCollector.currentDateStamp();
        if (newDateStamp.equals(this.dateStamp)) {
            return;
        }
        this.dateStamp = newDateStamp;
        this.appSession = this.loadAppSession();
        if (CathyUsageDataCollector.loggingGeneral()) {
            System.out.println("[UsageData] Date stamp changed: " + this.dateStamp);
        }
        this.clearOutdatedRecords();
    }

    private JSONObject loadStates() {
        return this.readObject(PATH_STATES);
    }

    private void saveStates(JSONObject object) {
        this.writeObject(object, PATH_STATES);
    }

    private JSONObject loadAppSession() {
        String path = String.format(PATH_APP_SESSION_WITH_DATE_STAMP_AND_SESSION_ID, this.dateStamp, this.appSessionId);
        return this.readObject(path);
    }

    private void saveAppSession(JSONObject object) {
        this.writeObject(object, String.format(PATH_APP_SESSION_WITH_DATE_STAMP_AND_SESSION_ID, this.dateStamp, this.appSessionId));
    }

    private JSONObject readObject(String path) {
        block6: {
            IInputSource source = this.storage.getInputSource();
            if (source.hasEntry(path)) {
                JSONObject jSONObject;
                InputStream stream = source.openEntryStream(path);
                try {
                    jSONObject = new JSONObject(new JSONTokener((Reader)new InputStreamReader(stream, "UTF-8")));
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (Throwable e) {
                        if (!CathyUsageDataCollector.loggingIOErrors()) break block6;
                        e.printStackTrace();
                    }
                }
                stream.close();
                return jSONObject;
            }
        }
        return new JSONObject();
    }

    private void writeObject(JSONObject object, String path) {
        block8: {
            try {
                OutputStream stream = this.storage.getOutputTarget().openEntryStream(path);
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
                    try {
                        object.write((Writer)writer);
                    }
                    finally {
                        ((Writer)writer).close();
                    }
                }
                finally {
                    stream.close();
                }
            }
            catch (Throwable e) {
                if (!CathyUsageDataCollector.loggingIOErrors()) break block8;
                e.printStackTrace();
            }
        }
    }

    private void startJobThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                CathyUsageDataCollector.this.runJobLoop();
            }
        }, CathyUsageDataCollector.class.getSimpleName());
        t.setDaemon(true);
        t.setPriority(1);
        this.jobThread = t;
        t.start();
    }

    private void stopJobThread() {
        Thread t = this.jobThread;
        this.jobThread = null;
        if (t != null) {
            t.interrupt();
            try {
                t.join(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void runJobLoop() {
        Runnable job;
        while (this.jobThread != null) {
            if (this.checkUpload() || this.checkJob()) continue;
            this.sleep();
        }
        while ((job = this.jobQueue.poll()) != null) {
            this.runJob(job);
        }
    }

    private void sleep() {
        long nextWakeUpTime = this.uploadEnabled ? this.states.optLong(KEY_NEXT_UPLOAD_TIME, 0L) : 0L;
        try {
            Thread.sleep(nextWakeUpTime == 0L ? 300000L : Math.min(300000L, nextWakeUpTime - System.currentTimeMillis()));
        }
        catch (InterruptedException interruptedException) {}
    }

    private void notifyJobThread() {
        Thread t = this.jobThread;
        if (t != null) {
            t.interrupt();
        }
    }

    private boolean checkUpload() {
        if (!this.uploadEnabled) {
            return false;
        }
        long nextUploadTime = this.states.optLong(KEY_NEXT_UPLOAD_TIME, 0L);
        if (System.currentTimeMillis() < nextUploadTime) {
            return false;
        }
        this.upload(0);
        return true;
    }

    private void upload(int hint) {
        block2: {
            try {
                this.generateReports(hint);
                this.uploadReports(hint);
            }
            catch (Throwable e) {
                if (!CathyUsageDataCollector.loggingUploads()) break block2;
                e.printStackTrace();
            }
        }
        this.states.put(KEY_NEXT_UPLOAD_TIME, System.currentTimeMillis() + 604800000L);
        this.saveStates(this.states);
    }

    private boolean checkJob() {
        Runnable job = this.jobQueue.poll();
        if (job == null) {
            return false;
        }
        this.runJob(job);
        return true;
    }

    private void runJob(Runnable job) {
        block2: {
            try {
                job.run();
            }
            catch (Throwable e) {
                if (!CathyUsageDataCollector.loggingRecords()) break block2;
                e.printStackTrace();
            }
        }
    }

    private void generateReports(int hint) {
        if (CathyUsageDataCollector.loggingUploads()) {
            System.out.println("[UsageData] Generating reports....");
        }
        ArrayList<String> recordPaths = new ArrayList<String>();
        ArrayList<String> outdatedReportPaths = new ArrayList<String>();
        HashMap<String, JSONObject> dailyReports = new HashMap<String, JSONObject>();
        String oldestDateStamp = CathyUsageDataCollector.toDateStamp(System.currentTimeMillis() - 1209600000L);
        Iterator paths = this.storage.getInputSource().getEntries();
        while (paths.hasNext()) {
            String ds;
            String path = (String)paths.next();
            Matcher pathMatcher = PATTERN_REPORT_PATH.matcher(path);
            if (pathMatcher.matches()) {
                ds = pathMatcher.group(1);
                if (ds.compareTo(oldestDateStamp) >= 0) continue;
                outdatedReportPaths.add(path);
                continue;
            }
            pathMatcher = PATTERN_APP_SESSION_PATH.matcher(path);
            if (!pathMatcher.matches()) continue;
            ds = pathMatcher.group(1);
            String sessionId = pathMatcher.group(2);
            if ((hint & 1) == 0 && ds.compareTo(this.dateStamp) >= 0) continue;
            recordPaths.add(path);
            if (ds.compareTo(oldestDateStamp) < 0 || this.storage.getInputSource().hasEntry(String.format(PATH_REPORT_WITH_DATE_STAMP, ds))) continue;
            JSONObject report = (JSONObject)dailyReports.get(ds);
            if (report == null) {
                report = new JSONObject().put(KEY_APP_SESSIONS, (Object)new JSONObject());
                dailyReports.put(ds, report);
            }
            report.getJSONObject(KEY_APP_SESSIONS).put(sessionId, (Object)this.readObject(path));
        }
        for (String path : outdatedReportPaths) {
            this.storage.deleteEntry(path);
        }
        for (String ds : dailyReports.keySet()) {
            this.writeObject((JSONObject)dailyReports.get(ds), String.format(PATH_REPORT_WITH_DATE_STAMP, ds));
            if (!CathyUsageDataCollector.loggingUploads()) continue;
            System.out.println("[UsageData] Report generated for " + ds);
        }
        for (String path : recordPaths) {
            this.storage.deleteEntry(path);
            if (!CathyUsageDataCollector.loggingUploads()) continue;
            System.out.println("[UsageData] Record deleted: " + path);
        }
    }

    private void uploadReports(int hint) {
        final ArrayList<String> dateStamps = new ArrayList<String>();
        Iterator paths = this.storage.getInputSource().getEntries();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            Matcher pathMatcher = PATTERN_REPORT_PATH.matcher(path);
            if (!pathMatcher.matches()) continue;
            dateStamps.add(pathMatcher.group(1));
        }
        if (dateStamps.isEmpty()) {
            if (CathyUsageDataCollector.loggingUploads()) {
                System.out.println("[UsageData] No reports to upload.");
            }
            return;
        }
        if (CathyUsageDataCollector.loggingUploads()) {
            System.out.println("[UsageData] Uploading " + dateStamps.size() + " reports....");
        }
        final CathyUsageDataCollector family = this;
        Job uploadJob = new Job("Upload Usage Data"){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                String endpoint = CathyUsageDataCollector.this.retrieveEndpoint((IProgressMonitor)subMonitor.newChild(5));
                if (endpoint == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    SubMonitor loopMonitor = subMonitor.newChild(95).setWorkRemaining(dateStamps.size());
                    for (String dateStamp : dateStamps) {
                        CathyUsageDataCollector.this.uploadSingleReport((IProgressMonitor)loopMonitor.newChild(1), dateStamp, endpoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object f) {
                return f == family;
            }
        };
        uploadJob.setRule((ISchedulingRule)this);
        uploadJob.setPriority(50);
        uploadJob.setSystem(true);
        uploadJob.setUser(false);
        uploadJob.schedule();
    }

    private String retrieveEndpoint(IProgressMonitor monitor) {
        JSONObject data;
        URL configURL;
        String endpoint = this.getDebugEndpoint();
        if (endpoint != null && !"".equals(endpoint)) {
            if (CathyUsageDataCollector.loggingUploads()) {
                System.out.println("[UsageData] Upload endpoint (debug): " + endpoint);
            }
            return endpoint;
        }
        try {
            configURL = new URL(CONFIG_URL);
        }
        catch (MalformedURLException e) {
            if (CathyUsageDataCollector.loggingUploads()) {
                e.printStackTrace();
            }
            XMindNetWorkbench.log(e, "Malformed UDC config url: https://s3.amazonaws.com/xmind-config/udc.json");
            return null;
        }
        if (CathyUsageDataCollector.loggingUploads()) {
            System.out.println("[UsageData] Retrieving upload endpoint from 'https://s3.amazonaws.com/xmind-config/udc.json'....");
        }
        HttpRequest request = new HttpRequest(configURL, "GET", new FieldSet().add("Accept", (Object)"application/json"), null, null, null);
        try {
            request.execute(monitor);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (Exception e) {
            if (CathyUsageDataCollector.loggingUploads()) {
                e.printStackTrace();
            }
            XMindNetWorkbench.log(e, "Failed to retrieve usage data upload endpoint");
            return null;
        }
        if (CathyUsageDataCollector.loggingUploads()) {
            System.out.println("[UsageData] Endpoint retrieved: " + request.getResponseAsString());
        }
        if ((data = request.getResponseAsJSON()) == null) {
            return null;
        }
        return data.optString(KEY_ENDPOINT, null);
    }

    private void clearOutdatedRecords() {
        String oldestDateStamp = CathyUsageDataCollector.toDateStamp(System.currentTimeMillis() - 1209600000L);
        ArrayList<String> recordPaths = new ArrayList<String>();
        Iterator paths = this.storage.getInputSource().getEntries();
        while (paths.hasNext()) {
            String ds;
            String path = (String)paths.next();
            Matcher pathMatcher = PATTERN_APP_SESSION_PATH.matcher(path);
            if (!pathMatcher.matches() || (ds = pathMatcher.group(1)).compareTo(oldestDateStamp) >= 0) continue;
            recordPaths.add(path);
        }
        for (String path : recordPaths) {
            this.storage.deleteEntry(path);
            if (!CathyUsageDataCollector.loggingRecords()) continue;
            System.out.println("[UsageData] Deleting outdated record: " + path);
        }
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    private void uploadSingleReport(IProgressMonitor monitor, String dateStamp, String endpoint) throws InterruptedException {
        URL url;
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        String path = String.format(PATH_REPORT_WITH_DATE_STAMP, dateStamp);
        JSONObject data = this.readObject(path);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        String method = "POST";
        try {
            url = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            if (CathyUsageDataCollector.loggingUploads()) {
                e.printStackTrace();
            }
            XMindNetWorkbench.log(e, "Invalid endpoint URL: '" + endpoint + "'");
            return;
        }
        HttpRequest request = new HttpRequest(url, method, new FieldSet().add("Accept", (Object)"application/json"), (HttpEntity)new JSONEntity(new JSONObject().put(KEY_CLIENT_ID, (Object)this.states.getString(KEY_CLIENT_ID)).put(KEY_FILE_NAME, (Object)String.format(PARAM_FILE_NAME_WITH_DATE_STAMP, dateStamp)).put(KEY_DATA, (Object)data)), null, null);
        if (CathyUsageDataCollector.loggingUploads()) {
            System.out.println("[UsageData] Uploading report '" + dateStamp + "' to '" + endpoint + "'");
        }
        try {
            request.execute(monitor);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            if (CathyUsageDataCollector.loggingUploads()) {
                e.printStackTrace();
            }
            XMindNetWorkbench.log(e, "Failed to upload usage report '" + dateStamp + "'");
            return;
        }
        if (CathyUsageDataCollector.loggingUploads()) {
            System.out.println("[UsageData] Report '" + dateStamp + "' uploaded successfully.");
        }
        this.storage.deleteEntry(path);
        if (CathyUsageDataCollector.loggingUploads()) {
            System.out.println("[UsageData] Report '" + dateStamp + "' deleted.");
        }
    }

    private static String currentDateStamp() {
        return CathyUsageDataCollector.toDateStamp(System.currentTimeMillis());
    }

    private static String toDateStamp(long timeMillis) {
        return String.format("%1$tY-%1$tm-%1$td", timeMillis);
    }

    private String getDebugEndpoint() {
        return XMindNetWorkbench.getDebugValue("/debug/udc/endpoint");
    }

    private static boolean loggingGeneral() {
        return XMindNetWorkbench.isDebugging("/debug/udc/log/general");
    }

    private static boolean loggingRecords() {
        return XMindNetWorkbench.isDebugging("/debug/udc/log/records");
    }

    private static boolean loggingUploads() {
        return XMindNetWorkbench.isDebugging("/debug/udc/log/uploads");
    }

    private static boolean loggingIOErrors() {
        return XMindNetWorkbench.isDebugging("/debug/udc/log/ioerrors");
    }

    private static IStorage loadDefaultStorage() {
        IPath stateLocation;
        Bundle bundle = Platform.getBundle((String)STORAGE_BUNDLE_NAME);
        if (bundle == null) {
            if (CathyUsageDataCollector.loggingGeneral()) {
                System.out.println("[UsageData] Storage bundle (org.xmind.cathy) not found. In-memory storage is used.");
            }
            return null;
        }
        try {
            stateLocation = Platform.getStateLocation((Bundle)bundle);
        }
        catch (Exception e) {
            if (CathyUsageDataCollector.loggingGeneral()) {
                e.printStackTrace();
            }
            System.err.println("[UsageData] Storage bundle (org.xmind.cathy) has not data area. In-memory storage is used.");
            return null;
        }
        File storageDir = stateLocation.append(PATH_USAGE_DATA).toFile();
        if (CathyUsageDataCollector.loggingGeneral()) {
            System.out.println("[UsageData] Storage path: " + storageDir.getAbsolutePath());
        }
        return new DirectoryStorage(storageDir);
    }
}

