/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.Token;

public class EvernoteApi
extends DefaultApi10a {
    protected String serviceUrl() {
        return "https://www.evernote.com";
    }

    @Override
    public String getRequestTokenEndpoint() {
        return String.valueOf(this.serviceUrl()) + "/oauth";
    }

    @Override
    public String getAccessTokenEndpoint() {
        return String.valueOf(this.serviceUrl()) + "/oauth";
    }

    @Override
    public String getAuthorizationUrl(Token requestToken) {
        return String.format(String.valueOf(this.serviceUrl()) + "/OAuth.action?oauth_token=%s", requestToken.getToken());
    }

    public static class Sandbox
    extends EvernoteApi {
        @Override
        protected String serviceUrl() {
            return "https://sandbox.evernote.com";
        }
    }

    public static class Yinxiang
    extends EvernoteApi {
        @Override
        protected String serviceUrl() {
            return "https://app.yinxiang.com";
        }
    }
}

