/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    Font font;
    Font[] cellFont;
    boolean cached;
    boolean grayed;
    int columnSetHeight;
    int columnSetWidth;

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount(), true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, index);
        } else {
            this.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_iter_nth_child(parent.modelHandle, this.handle, 0, index);
        }
    }

    static Table checkNull(Table control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    Color _getBackground() {
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 3, ptr, -1);
        if (ptr[0] == 0) {
            return this.parent.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        OS.gdk_color_free(ptr[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Color _getBackground(int index) {
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this._getBackground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 3, ptr, -1);
        if (ptr[0] == 0) {
            return this._getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        OS.gdk_color_free(ptr[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    boolean _getChecked() {
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 0, ptr, -1);
        return ptr[0] != 0;
    }

    Color _getForeground() {
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 2, ptr, -1);
        if (ptr[0] == 0) {
            return this.parent.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        OS.gdk_color_free(ptr[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Color _getForeground(int index) {
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this._getForeground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 2, ptr, -1);
        if (ptr[0] == 0) {
            return this._getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        OS.gdk_color_free(ptr[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Image _getImage(int index) {
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return null;
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 0, ptr, -1);
        if (ptr[0] == 0) {
            return null;
        }
        ImageList imageList = this.parent.imageList;
        int imageIndex = imageList.indexOf(ptr[0]);
        OS.g_object_unref(ptr[0]);
        if (imageIndex == -1) {
            return null;
        }
        return imageList.get(imageIndex);
    }

    String _getText(int index) {
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return "";
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 1, ptr, -1);
        if (ptr[0] == 0) {
            return "";
        }
        int length = OS.strlen(ptr[0]);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr[0], length);
        OS.g_free(ptr[0]);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        if (this.parent.currentItem == this) {
            return;
        }
        if (this.cached || (this.parent.style & 0x10000000) == 0) {
            int columnCount = OS.gtk_tree_model_get_n_columns(this.parent.modelHandle);
            int i = 0;
            while (i < 2) {
                OS.gtk_list_store_set(this.parent.modelHandle, this.handle, i, 0, -1);
                ++i;
            }
            i = 2;
            while (i < columnCount) {
                OS.gtk_list_store_set(this.parent.modelHandle, this.handle, i, 0, -1);
                ++i;
            }
        }
        this.cached = false;
        this.font = null;
        this.cellFont = null;
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground();
    }

    public Rectangle getBounds() {
        return DPIUtil.autoScaleDown(this.getBoundsinPixels());
    }

    Rectangle getBoundsinPixels() {
        int parentHandle;
        int column;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((column = OS.gtk_tree_view_get_column(parentHandle = this.parent.handle, 0)) == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int textRenderer = this.parent.getTextRenderer(column);
        int pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (textRenderer == 0 || pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        boolean isExpander = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean isExpanded = OS.gtk_tree_view_row_expanded(parentHandle, path);
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.parent.modelHandle, this.handle, isExpander, isExpanded);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        OS.gtk_tree_path_free(path);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        int right = rect.x + rect.width;
        int[] x = new int[1];
        int[] w = new int[1];
        this.parent.ignoreSize = true;
        this.gtk_cell_renderer_get_preferred_size(textRenderer, parentHandle, w, null);
        this.parent.ignoreSize = false;
        rect.width = w[0];
        int[] buffer = new int[1];
        if (OS.gtk_tree_view_get_expander_column(parentHandle) == column) {
            OS.gtk_widget_style_get(parentHandle, OS.expander_size, buffer, 0);
            rect.x += buffer[0] + 4;
        }
        OS.gtk_widget_style_get(parentHandle, OS.horizontal_separator, buffer, 0);
        int horizontalSeparator = buffer[0];
        rect.x += horizontalSeparator;
        OS.gtk_tree_view_column_cell_get_position(column, textRenderer, x, null);
        rect.x += x[0];
        if (this.parent.columnCount > 0 && rect.x + rect.width > right) {
            rect.width = Math.max(0, right - rect.x);
        }
        int width = OS.gtk_tree_view_column_get_visible(column) ? rect.width + 1 : 0;
        Rectangle r = new Rectangle(rect.x, rect.y, width, rect.height + 1);
        if (this.parent.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            r.y += this.parent.getHeaderHeightInPixels();
        }
        return r;
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground(index);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels(index));
    }

    Rectangle getBoundsInPixels(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int parentHandle = this.parent.handle;
        int column = 0;
        column = index >= 0 && index < this.parent.columnCount ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        OS.gtk_tree_path_free(path);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        if (index == 0 && (this.parent.style & 0x20) != 0) {
            int[] x = new int[1];
            int[] w = new int[1];
            OS.gtk_tree_view_column_cell_get_position(column, this.parent.checkRenderer, x, w);
            rect.x += x[0] + w[0];
            rect.width -= x[0] + w[0];
        }
        int width = OS.gtk_tree_view_column_get_visible(column) ? rect.width + 1 : 0;
        Rectangle r = new Rectangle(rect.x, rect.y, width, rect.height + 1);
        if (this.parent.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            r.y += this.parent.getHeaderHeightInPixels();
        }
        return r;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this._getChecked();
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground(index);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    @Override
    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getImage(index);
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getImageBoundsInPixels(index));
    }

    Rectangle getImageBoundsInPixels(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int parentHandle = this.parent.handle;
        int column = 0;
        column = index >= 0 && index < this.parent.columnCount ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        OS.gtk_tree_path_free(path);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        int[] x = new int[1];
        int[] w = new int[1];
        OS.gtk_tree_view_column_cell_get_position(column, pixbufRenderer, x, w);
        if (OS.GTK3) {
            if (this.parent.pixbufSizeSet) {
                if (x[0] > 0) {
                    rect.x += x[0];
                }
            } else {
                int textRenderer = this.parent.getTextRenderer(column);
                if (textRenderer == 0) {
                    return new Rectangle(0, 0, 0, 0);
                }
                int[] xText = new int[1];
                int[] wText = new int[1];
                OS.gtk_tree_view_column_cell_get_position(column, textRenderer, xText, wText);
                rect.x += xText[0];
            }
        } else {
            rect.x += x[0];
        }
        rect.width = w[0];
        int width = OS.gtk_tree_view_column_get_visible(column) ? rect.width : 0;
        return new Rectangle(rect.x, rect.y, width, rect.height + 1);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return 0;
    }

    @Override
    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    @Override
    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getText(index);
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextBoundsInPixels(index));
    }

    Rectangle getTextBoundsInPixels(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int parentHandle = this.parent.handle;
        int column = 0;
        column = index >= 0 && index < this.parent.columnCount ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int textRenderer = this.parent.getTextRenderer(column);
        int pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (textRenderer == 0 || pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        boolean isExpander = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean isExpanded = OS.gtk_tree_view_row_expanded(parentHandle, path);
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.parent.modelHandle, this.handle, isExpander, isExpanded);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        OS.gtk_tree_path_free(path);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        int right = rect.x + rect.width;
        int[] x = new int[1];
        int[] w = new int[1];
        this.parent.ignoreSize = true;
        this.gtk_cell_renderer_get_preferred_size(textRenderer, parentHandle, w, null);
        this.parent.ignoreSize = false;
        int[] buffer = new int[1];
        if (OS.gtk_tree_view_get_expander_column(parentHandle) == column) {
            OS.gtk_widget_style_get(parentHandle, OS.expander_size, buffer, 0);
            rect.x += buffer[0] + 4;
        }
        OS.gtk_widget_style_get(parentHandle, OS.horizontal_separator, buffer, 0);
        int horizontalSeparator = buffer[0];
        rect.x += horizontalSeparator;
        OS.gtk_tree_view_column_cell_get_position(column, textRenderer, x, null);
        if (OS.GTK3) {
            Image image = this._getImage(index);
            int imageWidth = 0;
            if (image != null) {
                imageWidth = image.getBoundsInPixels().width;
            }
            rect.x = x[0] < imageWidth ? (rect.x += imageWidth) : (rect.x += x[0]);
        } else {
            rect.x += x[0];
        }
        if (this.parent.columnCount > 0 && rect.x + rect.width > right) {
            rect.width = Math.max(0, right - rect.x);
        }
        int width = OS.gtk_tree_view_column_get_visible(column) ? rect.width + 1 : 0;
        return new Rectangle(rect.x, rect.y, width, rect.height + 1);
    }

    @Override
    void releaseHandle() {
        if (this.handle != 0) {
            OS.g_free(this.handle);
        }
        this.handle = 0;
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.font = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground().equals(color)) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 3, gdkColor, -1);
        this.cached = true;
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground(index).equals(color)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, modelIndex + 3, gdkColor, -1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int parentHandle = this.parent.handle;
                    int column = 0;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
                    if (column == 0) {
                        return;
                    }
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.cellDataProc, parentHandle, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.cellDataProc, parentHandle, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this._getChecked() == checked) {
            return;
        }
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 0, checked, -1);
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 1, !checked ? false : this.grayed, -1);
        this.cached = true;
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        int fontHandle = font != null ? font.handle : 0;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 4, fontHandle, -1);
        this.cached = true;
    }

    public void setFont(int index, Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[count];
        }
        if ((oldFont = this.cellFont[index]) == font) {
            return;
        }
        this.cellFont[index] = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        int fontHandle = font != null ? font.handle : 0;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, modelIndex + 4, fontHandle, -1);
        this.cached = true;
        if (font != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int parentHandle = this.parent.handle;
                    int column = 0;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
                    if (column == 0) {
                        return;
                    }
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.cellDataProc, parentHandle, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.cellDataProc, parentHandle, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground().equals(color)) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 2, gdkColor, -1);
        this.cached = true;
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground(index).equals(color)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, modelIndex + 2, gdkColor, -1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int parentHandle = this.parent.handle;
                    int column = 0;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
                    if (column == 0) {
                        return;
                    }
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.cellDataProc, parentHandle, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.cellDataProc, parentHandle, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 0, ptr, -1);
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 1, ptr[0] == 0 ? false : grayed, -1);
        this.cached = true;
    }

    public void setImage(int index, Image image) {
        int column;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image != null && image.type == 1 && image.equals(this._getImage(index))) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int pixbuf = 0;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            }
            pixbuf = imageList.getPixbuf(imageIndex);
        }
        if (OS.GTK3) {
            int parentHandle = this.parent.handle;
            column = OS.gtk_tree_view_get_column(parentHandle, index);
            int pixbufRenderer = this.parent.getPixbufRenderer(column);
            int[] currentWidth = new int[1];
            int[] currentHeight = new int[1];
            OS.gtk_cell_renderer_get_fixed_size(pixbufRenderer, currentWidth, currentHeight);
            if (!this.parent.pixbufSizeSet) {
                if (image != null) {
                    int iWidth = image.getBoundsInPixels().width;
                    int iHeight = image.getBoundsInPixels().height;
                    if (iWidth > currentWidth[0] || iHeight > currentHeight[0]) {
                        OS.gtk_cell_renderer_set_fixed_size(pixbufRenderer, iWidth, iHeight);
                        this.parent.pixbufSizeSet = true;
                        this.columnSetHeight = iHeight;
                        this.columnSetWidth = iWidth;
                    }
                }
            } else if (this.columnSetWidth > currentWidth[0] || this.columnSetHeight > currentHeight[0]) {
                OS.gtk_cell_renderer_set_fixed_size(pixbufRenderer, this.columnSetWidth, this.columnSetHeight);
            }
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, modelIndex + 0, pixbuf, -1);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == null && image != null) {
            int parentHandle = this.parent.handle;
            int column2 = OS.gtk_tree_view_get_column(parentHandle, index);
            int[] w = new int[1];
            int pixbufRenderer = this.parent.getPixbufRenderer(column2);
            OS.gtk_tree_view_column_cell_get_position(column2, pixbufRenderer, null, w);
            if (w[0] < image.getBoundsInPixels().width && !OS.GTK3) {
                int style = OS.gtk_widget_get_modifier_style(parentHandle);
                this.parent.modifyStyle(parentHandle, style);
            }
        }
        this.cached = true;
        if (this.parent.columnCount == 0) {
            column = OS.gtk_tree_view_get_column(this.parent.handle, index);
            this.parent.maxWidth = Math.max(this.parent.maxWidth, this.parent.calculateWidth(column, this.handle));
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    @Deprecated
    public void setImageIndent(int indent) {
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        this.cached = true;
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this._getText(index).equals(string)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, modelIndex + 1, buffer, -1);
        this.cached = true;
        if (this.parent.columnCount == 0) {
            int column = OS.gtk_tree_view_get_column(this.parent.handle, index);
            this.parent.maxWidth = Math.max(this.parent.maxWidth, this.parent.calculateWidth(column, this.handle));
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }
}

