/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.Core;
import org.xmind.core.IIdentifiable;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.Property;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;

public class ResourceUtils {
    public static List<IStyle> duplicateStyles(List<IStyle> styles) {
        ArrayList<IStyle> newStyles = new ArrayList<IStyle>();
        IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserStyleSheet();
        for (IStyle styleDuplicated : styles) {
            IStyle newStyle = styleSheet.createStyle(styleDuplicated.getType());
            Iterator ps = styleDuplicated.properties();
            while (ps.hasNext()) {
                Property p = (Property)ps.next();
                newStyle.setProperty(p.key, p.value);
            }
            newStyle.setName(NLS.bind((String)MindMapMessages.ResourceUtil_Copy_name, (Object)styleDuplicated.getName()));
            styleSheet.addStyle(newStyle, "normal-styles");
            newStyles.add(newStyle);
        }
        MindMapUI.getResourceManager().saveUserStyleSheet();
        return newStyles;
    }

    public static List<IStyle> duplicateThemes(List<IStyle> themes) {
        ArrayList<IStyle> newThemes = new ArrayList<IStyle>();
        IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserThemeSheet();
        for (IStyle styleDuplicated : themes) {
            IStyle themeCreated = styleSheet.createStyle(styleDuplicated.getType());
            themeCreated.setName(NLS.bind((String)MindMapMessages.ResourceUtil_Copy_name, (Object)styleDuplicated.getName()));
            Iterator defaultStyles = styleDuplicated.defaultStyles();
            while (defaultStyles.hasNext()) {
                Property p = (Property)defaultStyles.next();
                IStyle defaultStyle = styleDuplicated.getDefaultStyle(p.key);
                if (defaultStyle == null) continue;
                IStyle styleCreated = styleSheet.createStyle(ResourceUtils.transformStyleFamilyToStyleType(p.key));
                Iterator ps = defaultStyle.properties();
                while (ps.hasNext()) {
                    Property next = (Property)ps.next();
                    styleCreated.setProperty(next.key, next.value);
                }
                themeCreated.setDefaultStyleId(p.key, styleCreated.getId());
                styleSheet.addStyle(styleCreated, "automatic-styles");
            }
            styleSheet.addStyle(themeCreated, "master-styles");
            newThemes.add(themeCreated);
        }
        MindMapUI.getResourceManager().saveUserThemeSheet();
        return newThemes;
    }

    private static String transformStyleFamilyToStyleType(String family) {
        if ("centralTopic".equals(family) || "mainTopic".equals(family) || "subTopic".equals(family) || "summaryTopic".equals(family) || "floatingTopic".equals(family) || "calloutTopic".equals(family)) {
            return "topic";
        }
        if ("relationship".equals(family)) {
            return "relationship";
        }
        if ("boundary".equals(family)) {
            return "boundary";
        }
        if ("map".equals(family)) {
            return "map";
        }
        if ("summary".equals(family)) {
            return "summary";
        }
        return null;
    }

    public static void deleteStyles(List<IStyle> styles) {
        boolean isTheme = false;
        for (IStyle style : styles) {
            if ("theme".equals(style.getType())) {
                isTheme = true;
            }
            IStyleSheet sheet = style.getOwnedStyleSheet();
            ElementRegistry elementRegistry = (ElementRegistry)sheet.getAdapter(ElementRegistry.class);
            elementRegistry.unregister((IIdentifiable)style);
            sheet.removeStyle(style);
        }
        if (isTheme) {
            MindMapUI.getResourceManager().saveUserThemeSheet();
        } else {
            MindMapUI.getResourceManager().saveUserStyleSheet();
        }
    }

    public static boolean confirmToDeleteStyles(Shell shell, List<IStyle> styles) {
        StringBuilder sb = new StringBuilder(styles.size() * 10);
        boolean isTheme = false;
        for (IStyle style : styles) {
            if ("theme".equals(style.getType())) {
                isTheme = true;
            }
            if (sb.length() > 0) {
                sb.append(',');
                sb.append(' ');
            }
            sb.append('\'');
            sb.append(style.getName());
            sb.append('\'');
        }
        String styleNames = sb.toString();
        return MessageDialog.openConfirm((Shell)shell, (String)NLS.bind((String)MindMapMessages.DeleteStyles_MessageDialog_title, (Object)(isTheme ? MindMapMessages.DeleteStyle_MessageDialog_themes : MindMapMessages.DeleteStyle_MessageDialog_styles)), (String)NLS.bind((String)MindMapMessages.DeleteStyle_MessageDialog_description, (Object)styleNames));
    }

    public static void deleteTemplates(List<ITemplate> templates) {
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        List<ITemplate> userTemplates = resourceManager.getUserTemplates();
        for (ITemplate template : templates) {
            if (!userTemplates.contains(template)) continue;
            resourceManager.removeUserTemplate(template);
        }
    }

    public static List<ITemplate> duplicateTemplates(List<ITemplate> templates) {
        final ArrayList<ITemplate> newTemplates = new ArrayList<ITemplate>();
        File tempFolder = new File(Core.getWorkspace().getTempDir("transient-templates"));
        tempFolder.mkdirs();
        for (ITemplate template : templates) {
            final File tempFile = new File(tempFolder, String.valueOf(template.getName()) + " " + MindMapMessages.ResourceUtil_Duplicate_name + ".xmt");
            if (!tempFile.exists()) {
                try {
                    tempFile.createNewFile();
                }
                catch (IOException iOException) {}
            }
            final IWorkbookRef tempWR = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(tempFile.toURI(), null);
            final IWorkbookRef clonedWR = template.createWorkbookRef();
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    try {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        clonedWR.open((IProgressMonitor)subMonitor.newChild(30));
                        try {
                            tempWR.importFrom((IProgressMonitor)subMonitor.newChild(60), clonedWR);
                            tempWR.open((IProgressMonitor)monitor);
                            tempWR.save((IProgressMonitor)monitor);
                        }
                        finally {
                            subMonitor.setWorkRemaining(10);
                            clonedWR.close((IProgressMonitor)subMonitor.newChild(5));
                            tempWR.close((IProgressMonitor)subMonitor.newChild(5));
                        }
                    }
                    finally {
                        if (monitor != null) {
                            monitor.done();
                        }
                    }
                    ITemplate newTemplate = MindMapUI.getResourceManager().addUserTemplateFromWorkbookURI(tempWR.getURI());
                    newTemplates.add(newTemplate);
                    if (tempFile != null && tempFile.exists()) {
                        tempFile.delete();
                    }
                }
            });
        }
        return newTemplates;
    }

    public static void deleteMarkers(List<IMarker> markers) {
        for (IMarker marker : markers) {
            marker.getParent().removeMarker(marker);
        }
    }

    public static List<IMarker> addMarkersFor(IMarkerGroup markerGroup) {
        ArrayList<IMarker> newMarkers = new ArrayList<IMarker>();
        String[] sourcePaths = ResourceUtils.selectImageFile(Display.getCurrent().getActiveShell());
        if (sourcePaths == null) {
            return newMarkers;
        }
        IMarkerSheet ownedSheet = markerGroup.getOwnedSheet();
        String[] stringArray = sourcePaths;
        int n = sourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String sourcePath = stringArray[n2];
            if (ResourceUtils.imageValid(sourcePath)) {
                String targetPath;
                block18: {
                    targetPath = null;
                    FileInputStream sourceFIS = null;
                    try {
                        try {
                            sourceFIS = new FileInputStream(sourcePath);
                            targetPath = ownedSheet.allocateMarkerResource((InputStream)sourceFIS, sourcePath);
                        }
                        catch (IOException e) {
                            Logger.log(e);
                            if (sourceFIS != null) {
                                try {
                                    sourceFIS.close();
                                }
                                catch (IOException e2) {
                                    Logger.log(e2);
                                }
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (sourceFIS != null) {
                            try {
                                sourceFIS.close();
                            }
                            catch (IOException e) {
                                Logger.log(e);
                            }
                        }
                        throw throwable;
                    }
                    if (sourceFIS != null) {
                        try {
                            sourceFIS.close();
                        }
                        catch (IOException e) {
                            Logger.log(e);
                        }
                    }
                }
                if (targetPath != null) {
                    IMarker marker = ownedSheet.createMarker(targetPath);
                    marker.setName(FileUtils.getFileName((String)sourcePath));
                    markerGroup.addMarker(marker);
                    newMarkers.add(marker);
                }
            }
            ++n2;
        }
        return newMarkers;
    }

    private static String[] selectImageFile(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 4098);
        DialogUtils.makeDefaultImageSelectorDialog(dialog, true);
        String open = dialog.open();
        if (open == null) {
            return null;
        }
        String parent = dialog.getFilterPath();
        String[] fileNames = dialog.getFileNames();
        String[] paths = new String[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            paths[i] = new File(parent, fileNames[i]).getAbsolutePath();
            ++i;
        }
        return paths;
    }

    private static boolean imageValid(String sourcePath) {
        try {
            new Image((Device)Display.getCurrent(), sourcePath).dispose();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

