/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.graphicalpolicy.IGraphicalPolicy;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartListener;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.part.PartEvent;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.util.GEFUtils;
import org.xmind.ui.decorations.IBoundaryDecoration;
import org.xmind.ui.internal.decorators.BoundaryDecorator;
import org.xmind.ui.internal.figures.BoundaryFigure;
import org.xmind.ui.internal.graphicalpolicies.BoundaryGraphicalPolicy;
import org.xmind.ui.internal.mindmap.BoundaryFeedback;
import org.xmind.ui.internal.mindmap.BoundarySelectionFeedbackHelper;
import org.xmind.ui.internal.mindmap.BoundaryTitleTextPart;
import org.xmind.ui.internal.mindmap.BranchPart;
import org.xmind.ui.internal.mindmap.DecoratedAnchor;
import org.xmind.ui.internal.mindmap.NodePart;
import org.xmind.ui.internal.mindmap.TitleTextPart;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.IRangeListener;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITitleTextPart;
import org.xmind.ui.mindmap.RangeEvent;
import org.xmind.ui.util.MindMapUtils;

public class BoundaryPart
extends NodePart
implements IBoundaryPart {
    private List<IBranchPart> enclosingBranches = null;
    private ITitleTextPart title = null;
    private IAnchor anchor = null;
    private List<IRangeListener> rangeListeners = null;
    private IPartListener parentListener = new IPartListener(){

        public void childRemoving(PartEvent event) {
            if (event.child instanceof IBranchPart) {
                BoundaryPart.this.clearBranchesCache();
            }
        }

        public void childAdded(PartEvent event) {
            if (event.child instanceof IBranchPart) {
                BoundaryPart.this.clearBranchesCache();
            }
        }
    };

    public BoundaryPart() {
        this.setDecorator((IDecorator)BoundaryDecorator.getInstance());
        this.setGraphicalPolicy((IGraphicalPolicy)BoundaryGraphicalPolicy.getInstance());
    }

    @Override
    public IBoundary getBoundary() {
        return (IBoundary)this.getRealModel();
    }

    @Override
    public IBranchPart getOwnedBranch() {
        if (this.getParent() instanceof IBranchPart) {
            return (IBranchPart)this.getParent();
        }
        return null;
    }

    protected void register() {
        this.registerModel(this.getBoundary());
        super.register();
    }

    protected void unregister() {
        super.unregister();
        this.unregisterModel(this.getBoundary());
    }

    protected Object[] getModelChildren(Object model) {
        if (this.hasTitle() && !this.isPolygonShape(this.getFigure())) {
            return new Object[]{new ViewerModel(BoundaryTitleTextPart.class, this.getBoundary())};
        }
        return super.getModelChildren(model);
    }

    @Override
    public ITitleTextPart getTitle() {
        return this.title;
    }

    public void setTitle(ITitleTextPart title) {
        this.title = title;
        ((BoundaryFigure)this.getFigure()).setTitle(title == null ? null : title.getTextFigure());
    }

    private boolean hasTitle() {
        IBoundary titled = this.getBoundary();
        return titled.hasTitle() && !"".equals(titled.getTitleText());
    }

    public boolean isPolygonShape(IFigure figure) {
        if (figure == null || !(figure instanceof BoundaryFigure)) {
            return false;
        }
        IBoundaryDecoration decoration = ((BoundaryFigure)figure).getDecoration();
        if (decoration == null) {
            return false;
        }
        return "org.xmind.boundaryShape.polygon".equals(decoration.getId()) || "org.xmind.boundaryShape.roundedPolygon".equals(decoration.getId());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IBoundary.class)) {
            return this.getBoundary();
        }
        if (adapter == TitleTextPart.class || adapter == ITitleTextPart.class) {
            return this.getTitle();
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected void fillSourceConnections(List<IConnectionPart> list) {
        ISheetPart sheet;
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null && (sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class)) != null) {
            String id = this.getBoundary().getId();
            for (IRelationshipPart rel : sheet.getRelationships()) {
                IRelationship r = rel.getRelationship();
                if (r == null || !id.equals(r.getEnd2Id())) continue;
                list.add(rel);
            }
        }
    }

    @Override
    protected void fillTargetConnections(List<IConnectionPart> list) {
        ISheetPart sheet;
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null && (sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class)) != null) {
            String id = this.getBoundary().getId();
            for (IRelationshipPart rel : sheet.getRelationships()) {
                IRelationship r = rel.getRelationship();
                if (r == null || !id.equals(r.getEnd1Id())) continue;
                list.add(rel);
            }
        }
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("deletable role", "org.xmind.ui.editPolicy.deletable");
        reqHandler.installEditPolicy("editable role", "org.xmind.ui.editPolicy.editable");
        reqHandler.installEditPolicy("modifiable role", "org.xmind.ui.editPolicy.modifiable");
        reqHandler.installEditPolicy("movable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("navigable role", "org.xmind.ui.editPolicy.topicNavigable");
    }

    @Override
    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("startIndex");
        register.register("endIndex");
        register.register("range");
        register.register("titleText");
        register.register("style");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("startIndex".equals(type) || "endIndex".equals(type)) {
            this.refresh();
            this.getFigure().revalidate();
            IBranchPart branch = this.getOwnedBranch();
            if (branch != null) {
                branch.treeUpdate(true);
            }
            this.fireRangeChanged();
        } else if ("titleText".equals(type)) {
            ((BoundaryFigure)this.getFigure()).setTitleVisible(this.hasTitle() && !this.isPolygonShape(this.getFigure()));
            this.refresh();
            this.getFigure().revalidate();
        } else if ("style".equals(type)) {
            this.update();
            ((BoundaryFigure)this.getFigure()).setTitleVisible(this.hasTitle() && !this.isPolygonShape(this.getFigure()));
            this.refresh();
            this.getFigure().revalidate();
        } else {
            super.handleCoreEvent(event);
        }
    }

    @Override
    public List<IBranchPart> getEnclosingBranches() {
        if (this.enclosingBranches == null) {
            this.enclosingBranches = this.fillEnclosingBranches(new ArrayList<IBranchPart>());
        }
        return this.enclosingBranches;
    }

    private List<IBranchPart> fillEnclosingBranches(List<IBranchPart> list) {
        IBoundary b = this.getBoundary();
        List subtopics = b.getEnclosingTopics();
        if (!subtopics.isEmpty()) {
            IViewer viewer = this.getSite().getViewer();
            for (ITopic t : subtopics) {
                IBranchPart branch = MindMapUtils.findBranch(viewer.findPart((Object)t));
                if (branch == null) continue;
                list.add(branch);
            }
        }
        return list;
    }

    @Override
    public boolean encloses(IBranchPart subbranch) {
        return this.getBoundary().encloses(subbranch.getTopic());
    }

    private void clearBranchesCache() {
        this.enclosingBranches = null;
    }

    public void setParent(IPart parent) {
        if (this.getParent() instanceof BranchPart) {
            this.getParent().removePartListener(this.parentListener);
            ((BranchPart)this.getParent()).removeBoundary(this);
        }
        super.setParent(parent);
        if (this.getParent() instanceof BranchPart) {
            ((BranchPart)this.getParent()).addBoundary(this);
            this.getParent().addPartListener(this.parentListener);
        }
    }

    @Override
    public void refresh() {
        this.clearBranchesCache();
        super.refresh();
        ITitleTextPart title = this.getTitle();
        if (title != null) {
            title.refresh();
        }
    }

    @Override
    public void update() {
        super.update();
        ITitleTextPart title = this.getTitle();
        if (title != null) {
            title.update();
        }
    }

    protected IFigure createFigure() {
        BoundaryFigure figure = new BoundaryFigure();
        figure.setTitleVisible(this.hasTitle() && !this.isPolygonShape((IFigure)figure));
        return figure;
    }

    public IPart findAt(Point position) {
        IPart ret;
        ITitleTextPart title = this.getTitle();
        if (title != null && (ret = ((IGraphicalEditPart)title).findAt(position)) != null) {
            return this;
        }
        ret = super.findAt(position);
        return ret;
    }

    @Override
    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new BoundarySelectionFeedbackHelper();
    }

    @Override
    protected IFeedback createFeedback() {
        return new BoundaryFeedback(this);
    }

    public IFigure findTooltipAt(Point position) {
        if (this.hasTitle() && !this.isPolygonShape(this.getFigure()) && this.title != null && this.title.getFigure().containsPoint(position)) {
            return new Label(this.getBoundary().getTitleText());
        }
        return super.findTooltipAt(position);
    }

    public Cursor getCursor(Point pos) {
        int orientation = ((BoundaryFeedback)this.getFeedback()).getOrientation(pos);
        if (orientation != 0) {
            return GEFUtils.getPositionCursor((int)orientation);
        }
        return super.getCursor(pos);
    }

    public boolean containsPoint(Point position) {
        return super.containsPoint(position) || ((BoundaryFeedback)this.getFeedback()).getOrientation(position) != 0;
    }

    @Override
    public IAnchor getSourceAnchor(IGraphicalPart connection) {
        return this.getAnchor();
    }

    @Override
    public IAnchor getTargetAnchor(IGraphicalPart connection) {
        return this.getAnchor();
    }

    protected IAnchor getAnchor() {
        if (this.anchor == null) {
            this.anchor = new DecoratedAnchor(this.getFigure());
        }
        return this.anchor;
    }

    @Override
    public void addRangeListener(IRangeListener listener) {
        if (this.rangeListeners == null) {
            this.rangeListeners = new ArrayList<IRangeListener>();
        }
        this.rangeListeners.add(listener);
    }

    @Override
    public void removeRangeListener(IRangeListener listener) {
        if (this.rangeListeners != null) {
            this.rangeListeners.remove(listener);
        }
    }

    protected void fireRangeChanged() {
        if (this.rangeListeners == null) {
            return;
        }
        RangeEvent event = new RangeEvent(this);
        Object[] objectArray = this.rangeListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IRangeListener)o).rangeChanged(event);
            ++n2;
        }
    }
}

