/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.core.IComment;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.comments.CommentTextViewer;
import org.xmind.ui.internal.comments.CommentsPartActionBarContributor;
import org.xmind.ui.internal.comments.CommentsSelectionProvider;
import org.xmind.ui.internal.comments.ICommentTextViewerContainer;
import org.xmind.ui.internal.comments.ICommentsActionBarContributor;
import org.xmind.ui.internal.comments.SheetCommentsViewer;
import org.xmind.ui.internal.e4models.ViewModelPart;
import org.xmind.ui.resources.ColorUtils;

public class CommentsPart
extends ViewModelPart
implements IContributedContentsView,
IPartListener,
ISelectionChangedListener,
ICoreEventListener,
ICommentTextViewerContainer {
    public static final String PART_ID = "org.xmind.ui.modelPart.comment";
    public static final String BG_COLOR = "#ffffff";
    private static final String COMMENTS_EDIT_CONTEXT_ID = "org.xmind.ui.context.comments.edit";
    private static final String INVALID_COLER = "#f0f0f0";
    @Inject
    private EHandlerService handlerService;
    @Inject
    private EContextService contextService;
    private CommentsPartActionBarContributor contributor;
    private ISelectionProvider selectionProvider = new CommentsSelectionProvider();
    private List<TextAction> textActions = new ArrayList<TextAction>(7);
    private IGraphicalEditor contributingEditor;
    private ICoreEventRegister commentEventRegister;
    private ICoreEventRegister globalEventRegister;
    private Control control;
    private ScrolledComposite sc;
    private Composite contentComposite;
    private SheetCommentsViewer contentViewer;
    private ISheet sheet;
    private ControlListener controlListener;
    private CommitCommentHandler commitCommentHandler = new CommitCommentHandler();
    private IComment latestCreatedComment;
    private IComment selectedComment;
    private IComment editingComment;
    private boolean modified;
    private String insertTarget;
    private Map<String, Object> handlers = new HashMap<String, Object>();
    private Map<String, IAction> globalActions = new HashMap<String, IAction>(7);

    protected Control doCreateContent(Composite parent) {
        this.contributor = new CommentsPartActionBarContributor(this, this.contributingEditor);
        this.control = this.createControl(parent);
        this.activateHandlers();
        new ContextActivator();
        this.getAdapter(IWorkbenchWindow.class).getActivePage().addPartListener((IPartListener)this);
        return this.control;
    }

    private Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)BG_COLOR)));
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.contentComposite = this.createContentComposite(composite);
        return composite;
    }

    private Composite createContentComposite(Composite parent) {
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.setBackground(parent.getBackground());
        this.sc.setLayoutData((Object)new GridData(1808));
        this.sc.setExpandHorizontal(true);
        Composite composite = new Composite((Composite)this.sc, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 0;
        composite.setLayout((Layout)gridLayout);
        this.sc.setContent((Control)composite);
        this.sc.getVerticalBar().setIncrement(17);
        this.sc.addControlListener(this.getControlListener());
        return composite;
    }

    private ControlListener getControlListener() {
        if (this.controlListener == null) {
            this.controlListener = new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    e.widget.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CommentsPart.this.contentComposite != null && !CommentsPart.this.contentComposite.isDisposed()) {
                                CommentsPart.this.contentComposite.pack();
                            }
                        }
                    });
                }
            };
        }
        return this.controlListener;
    }

    private void setInitialInput() {
        IEditorPart activeEditor = this.getAdapter(IWorkbenchWindow.class).getActivePage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor) {
            this.setContributingEditor((IGraphicalEditor)activeEditor);
        } else {
            this.setInput(null);
        }
    }

    private void setInput(ISheet sheet) {
        if (this.sheet == sheet) {
            return;
        }
        this.sheet = sheet;
        this.unhookSheet();
        this.update();
        this.hookSheet();
    }

    private void hookSheet() {
        if (this.sheet != null) {
            if (this.commentEventRegister == null) {
                this.commentEventRegister = new CoreEventRegister((ICoreEventSupport)this.sheet.getOwnedWorkbook().getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
            }
            this.commentEventRegister.register("commentAdd");
            this.commentEventRegister.register("commentRemove");
            this.registerGlobalEvent();
        }
    }

    private void unhookSheet() {
        if (this.commentEventRegister != null) {
            this.commentEventRegister.unregisterAll();
            this.commentEventRegister = null;
        }
        this.unRegisterGlobalEvent();
    }

    private void registerGlobalEvent() {
        this.globalEventRegister = new CoreEventRegister((ICoreEventSupport)this.sheet.getOwnedWorkbook().getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
        this.globalEventRegister.register("commentContent");
    }

    private void unRegisterGlobalEvent() {
        if (this.globalEventRegister != null) {
            this.globalEventRegister.unregisterAll();
            this.globalEventRegister = null;
        }
    }

    private void update() {
        this.resetSelectedComment();
        this.updateCompositeEnabled();
        this.updateComments();
        this.setModified(false);
        this.setEditingComment(null);
        this.setInsertTarget(null);
    }

    private void resetSelectedComment() {
        this.contributor.selectedCommentChanged(null);
    }

    private void updateCompositeEnabled() {
        this.sc.setEnabled(this.sheet != null);
        if (this.sheet == null) {
            this.contentComposite.getParent().setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)INVALID_COLER)));
            this.contentComposite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)INVALID_COLER)));
        } else {
            this.contentComposite.getParent().setBackground(this.control.getBackground());
            this.contentComposite.setBackground(this.control.getBackground());
        }
    }

    private void updateComments() {
        this.contentComposite.setRedraw(false);
        this.clearContent();
        this.selectionProvider.setSelection(null);
        if (this.sheet != null) {
            this.contentViewer = new SheetCommentsViewer(this.sheet, this.contributor, this.selectionProvider, this, this.contributingEditor);
            this.contentViewer.create(this.contentComposite);
        }
        this.contentComposite.pack(true);
        this.contentComposite.layout(true, true);
        this.contentComposite.setRedraw(true);
    }

    private void clearContent() {
        Control[] controls = this.contentComposite.getChildren();
        if (controls != null) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control != null && !control.isDisposed()) {
                    control.dispose();
                    Object var2_5 = null;
                }
                ++n2;
            }
        }
    }

    protected boolean postConfiguration(IWorkbenchPart workbenchPart, MPart part) {
        this.setInitialInput();
        super.postConfiguration(workbenchPart, part);
        IWorkbenchPartSite site = workbenchPart.getSite();
        if (site instanceof IViewSite) {
            IActionBars actionBars = ((IViewSite)site).getActionBars();
            if (actionBars == null) {
                return false;
            }
            IServiceLocator serviceLocator = actionBars.getServiceLocator();
            if (serviceLocator == null) {
                return false;
            }
            IEclipseContext eclipseContext = (IEclipseContext)serviceLocator.getService(IEclipseContext.class);
            eclipseContext.set(ECommandService.class, (Object)((ECommandService)serviceLocator.getService(ECommandService.class)));
            eclipseContext.set(EHandlerService.class, (Object)((EHandlerService)serviceLocator.getService(EHandlerService.class)));
            this.registerGlobalTextActionHandlers();
            return true;
        }
        return false;
    }

    private void registerGlobalTextActionHandlers() {
        this.activateGlobalTextHandler(ActionFactory.UNDO, 1);
        this.activateGlobalTextHandler(ActionFactory.REDO, 2);
        this.activateGlobalTextHandler(ActionFactory.CUT, 3);
        this.activateGlobalTextHandler(ActionFactory.COPY, 4);
        this.activateGlobalTextHandler(ActionFactory.PASTE, 5);
        this.activateGlobalTextHandler(ActionFactory.SELECT_ALL, 7);
    }

    private void activateGlobalTextHandler(ActionFactory actionFactory, int textOp) {
        TextAction textAction = new TextAction(textOp);
        String commandId = actionFactory.getCommandId();
        textAction.setActionDefinitionId(commandId);
        EActionHandler handler = new EActionHandler((IAction)textAction);
        this.handlerService.activateHandler(commandId, (Object)handler);
        this.handlers.put(commandId, handler);
        textAction.setId(actionFactory.getId());
        ActionFactory.IWorkbenchAction workbenchAction = actionFactory.create(this.getAdapter(IWorkbenchWindow.class));
        textAction.setText(workbenchAction.getText());
        workbenchAction.dispose();
        this.textActions.add(textAction);
        this.globalActions.put(actionFactory.getId(), (IAction)textAction);
    }

    private void unregisterGlobalTextActionHandlers() {
        if (this.handlerService != null) {
            for (Map.Entry<String, Object> entry : this.handlers.entrySet()) {
                this.handlerService.deactivateHandler(entry.getKey(), entry.getValue());
            }
            this.handlers.clear();
        }
    }

    public IAction getGlobalAction(String actionId) {
        return this.globalActions.get(actionId);
    }

    public void updateTextActions(TextViewer textViewer) {
        if (textViewer != null) {
            for (TextAction action : this.textActions) {
                action.update(textViewer);
            }
        }
    }

    private void activateHandlers() {
        this.handlerService.activateHandler("org.xmind.ui.command.commitComments", (Object)this.commitCommentHandler);
    }

    private void deactivateHandlers() {
        this.handlerService.deactivateHandler("org.xmind.ui.command.commitComments", (Object)this.commitCommentHandler);
    }

    private void saveComment() {
        if (this.contentViewer != null) {
            this.contentViewer.save();
        }
    }

    protected void setFocus() {
        super.setFocus();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setFocus();
        }
    }

    private void setContributingEditor(IGraphicalEditor editor) {
        ISelectionProvider selectionProvider;
        if (editor == this.contributingEditor) {
            return;
        }
        if (this.contributingEditor != null && (selectionProvider = this.contributingEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.contributingEditor = editor;
        if (this.contributingEditor != null && (selectionProvider = this.contributingEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.contentViewer != null) {
            this.contentViewer.setTargetEditor(this.contributingEditor);
        }
        if (this.contributor != null) {
            this.contributor.setTargetEditor(this.contributingEditor);
        }
        ISheet sheet = this.getSheet(this.contributingEditor);
        this.setInput(sheet);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IGraphicalEditor) {
            this.setContributingEditor((IGraphicalEditor)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.contributingEditor) {
            this.setContributingEditor(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISheet sheet = this.getSheet(this.contributingEditor);
        this.setInput(sheet);
    }

    private ISheet getSheet(IGraphicalEditor editor) {
        if (editor != null && editor.getActivePageInstance() != null) {
            return (ISheet)editor.getActivePageInstance().getAdapter(ISheet.class);
        }
        return null;
    }

    public void handleCoreEvent(final CoreEvent event) {
        final String type = event.getType();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!CommentsPart.this.contentComposite.isDisposed()) {
                    if ("commentAdd".equals(type) || "commentRemove".equals(type)) {
                        CommentsPart.this.update();
                    } else if ("commentContent".equals(type)) {
                        IComment comment = (IComment)event.getSource();
                        if (comment.isOrphan()) {
                            return;
                        }
                        Object source = comment.getOwnedWorkbook().getElementById(comment.getObjectId());
                        if (source instanceof ITopic && ((ITopic)source).getOwnedSheet() == CommentsPart.this.sheet || source instanceof ISheet && source == CommentsPart.this.sheet) {
                            CommentsPart.this.update();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void moveToPreviousTextViewer(CommentTextViewer implementation) {
        List<CommentTextViewer> implementations = this.contentViewer.getImplementations();
        int index = implementations.indexOf(implementation);
        if (index <= 0 || index > implementations.size() - 1) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection((Object)implementations.get(index - 1)));
    }

    @Override
    public void moveToNextTextViewer(CommentTextViewer implementation) {
        List<CommentTextViewer> implementations = this.contentViewer.getImplementations();
        int index = implementations.indexOf(implementation);
        if (index < 0 || index >= implementations.size() - 1) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection((Object)implementations.get(index + 1)));
    }

    private void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
    }

    private CommentTextViewer getImplementation() {
        if (this.selectionProvider instanceof CommentsSelectionProvider) {
            Object obj;
            Object obj2;
            ISelection selection = this.selectionProvider.getSelection();
            if (selection instanceof IStructuredSelection && (obj2 = ((IStructuredSelection)selection).getFirstElement()) instanceof CommentTextViewer) {
                return (CommentTextViewer)obj2;
            }
            ISelection oldSelection = ((CommentsSelectionProvider)this.selectionProvider).getOldSelection();
            if (oldSelection instanceof IStructuredSelection && (obj = ((IStructuredSelection)oldSelection).getFirstElement()) instanceof CommentTextViewer) {
                return (CommentTextViewer)obj;
            }
        }
        return null;
    }

    @Override
    public Composite getContentComposite() {
        return this.contentComposite;
    }

    @Override
    public ScrolledComposite getScrolledComposite() {
        return this.sc;
    }

    public ICommentsActionBarContributor getContributor() {
        return this.contributor;
    }

    @Override
    public void setLatestCreatedComment(IComment latestCreatedComment) {
        this.latestCreatedComment = latestCreatedComment;
    }

    @Override
    public IComment getLatestCreatedComment() {
        return this.latestCreatedComment;
    }

    @Override
    public void setSelectedComment(IComment selectedComment) {
        this.selectedComment = selectedComment;
    }

    @Override
    public IComment getSelectedComment() {
        return this.selectedComment;
    }

    public Control getControl() {
        return this.control;
    }

    @Override
    public void createComment(String objectId) {
        this.contentViewer.createNewComment(objectId);
    }

    @Override
    public void cancelCreateComment() {
        this.contentViewer.cancelCreateNewComment();
    }

    @Override
    public void setEditingComment(IComment editingComment) {
        this.editingComment = editingComment;
    }

    @Override
    public IComment getEditingComment() {
        return this.editingComment;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public void setInsertTarget(String objectId) {
        this.insertTarget = objectId;
    }

    public String getInsertTarget() {
        return this.insertTarget;
    }

    public IWorkbenchPart getContributingPart() {
        return this.contributingEditor;
    }

    public void dispose() {
        this.unhookSheet();
        this.deactivateHandlers();
        if (this.contributor != null) {
            this.contributor.dispose();
        }
        if (this.sc != null && !this.sc.isDisposed()) {
            this.sc.removeControlListener(this.getControlListener());
        }
        this.getAdapter(IWorkbenchWindow.class).getActivePage().removePartListener((IPartListener)this);
        this.setContributingEditor(null);
        this.unregisterGlobalTextActionHandlers();
        super.dispose();
        this.textActions = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IContributedContentsView.class) {
            return adapter.cast(this);
        }
        if (adapter == ITextViewer.class) {
            return adapter.cast(this.getImplementation() == null ? null : this.getImplementation().getTextViewer());
        }
        return (T)super.getAdapter(adapter);
    }

    private class CommitCommentHandler {
        private CommitCommentHandler() {
        }

        @Execute
        public void execute() {
            CommentsPart.this.saveComment();
        }
    }

    private class ContextActivator
    implements IPartListener {
        public ContextActivator() {
            CommentsPart.this.getAdapter(IWorkbenchWindow.class).getActivePage().addPartListener((IPartListener)this);
        }

        public void partActivated(IWorkbenchPart part) {
            MPart modelPart = CommentsPart.this.getAdapter(MPart.class);
            Object e4Wrapper = modelPart.getTransientData().get("e4Wrapper");
            if (part == e4Wrapper) {
                this.activateContext();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            CommentsPart.this.getAdapter(IWorkbenchWindow.class).getActivePage().removePartListener((IPartListener)this);
        }

        public void partDeactivated(IWorkbenchPart part) {
            MPart modelPart = CommentsPart.this.getAdapter(MPart.class);
            Object e4Wrapper = modelPart.getTransientData().get("e4Wrapper");
            if (part == e4Wrapper) {
                this.deactivateContext();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        private void activateContext() {
            CommentsPart.this.contextService.activateContext(CommentsPart.COMMENTS_EDIT_CONTEXT_ID);
        }

        private void deactivateContext() {
            CommentsPart.this.contextService.deactivateContext(CommentsPart.COMMENTS_EDIT_CONTEXT_ID);
        }
    }

    private static class EActionHandler {
        private IAction action;

        public EActionHandler(IAction action) {
            this.action = action;
        }

        @Execute
        public void execute() {
            if (this.action.getStyle() == 2 || this.action.getStyle() == 8) {
                this.action.setChecked(!this.action.isChecked());
            }
            this.action.run();
        }

        @CanExecute
        public boolean canExecute() {
            return this.action.isEnabled();
        }
    }

    private class TextAction
    extends Action {
        private TextViewer textViewer;
        private int op;

        public TextAction(int op) {
            this.op = op;
        }

        public void run() {
            if (this.textViewer != null && this.textViewer.canDoOperation(this.op)) {
                this.textViewer.doOperation(this.op);
                CommentsPart.this.contentComposite.pack();
            }
        }

        public void update(TextViewer textViewer) {
            this.textViewer = textViewer;
            this.setEnabled(textViewer != null && textViewer.canDoOperation(this.op));
        }
    }
}

