/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xmind.core.IBoundary;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IRelationship;
import org.xmind.core.IResourceRef;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ISpanList;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.IRefCounter;
import org.xmind.core.util.Property;

public class ObjectRefManager
implements ICoreEventSource {
    public static final String FILE_ENTRY = "file-entry";
    public static final String MARKER = "marker";
    public static final String LABEL = "label";
    public static final String STYLE = "style";
    public static final String THEME = "theme";
    public static final String COMMENT = "comment";
    private final IWorkbook workbook;
    private final ICoreEventSupport eventSupport;
    private final Map<Object, CounterSet> counterSets;
    private final CoreEventRegister eventRegister;
    private final ICoreEventListener eventListener;
    private final Map<String, String> autoStyleGroups;
    private final Map<String, String> autoMarkerGroups;

    public ObjectRefManager(IWorkbook workbook, ICoreEventSupport eventSupport) {
        this.workbook = workbook;
        this.eventSupport = eventSupport;
        this.counterSets = new HashMap<Object, CounterSet>();
        this.eventListener = new ICoreEventListener(){

            public void handleCoreEvent(CoreEvent event) {
                ObjectRefManager.this.handleCoreEvent(event);
            }
        };
        this.eventRegister = new CoreEventRegister((ICoreEventSupport)workbook.getAdapter(ICoreEventSupport.class), this.eventListener);
        this.autoStyleGroups = new HashMap<String, String>();
        this.autoMarkerGroups = new HashMap<String, String>();
        this.counterSets.put(workbook, new CounterSet(workbook, null));
        for (ISheet sheet : workbook.getSheets()) {
            this.onSheetAdded(sheet);
        }
        this.eventRegister.register("sheetAdd");
        this.eventRegister.register("sheetRemove");
        this.eventRegister.register("rootTopic");
        this.eventRegister.register("topicAdd");
        this.eventRegister.register("topicRemove");
        this.eventRegister.register("topicHyperlink");
        this.eventRegister.register("imageSource");
        this.eventRegister.register(STYLE);
        this.eventRegister.register("styleAdd");
        this.eventRegister.register("themeId");
        this.eventRegister.register("extensionAdd");
        this.eventRegister.register("extensionRemove");
        this.eventRegister.register("workbookExtensionAdd");
        this.eventRegister.register("workbookExtensionRemove");
        this.eventRegister.register("resourceRefAdd");
        this.eventRegister.register("resourceRefRemove");
        this.eventRegister.register("workbookExtensionResourceRefAdd");
        this.eventRegister.register("workbookExtensionResourceRefRemove");
        this.eventRegister.register("topicNotes");
        this.eventRegister.register("boundaryAdd");
        this.eventRegister.register("boundaryRemove");
        this.eventRegister.register("summaryAdd");
        this.eventRegister.register("summaryRemove");
        this.eventRegister.register("relationshipAdd");
        this.eventRegister.register("relationshipRemove");
        this.eventRegister.register("markerRefAdd");
        this.eventRegister.register("markerRefRemove");
        this.eventRegister.register("labels");
        this.eventRegister.register("markerAdd");
        this.eventRegister.register("markerRemove");
        this.eventRegister.register("markerGroupAdd");
        this.eventRegister.register("markerGroupRemove");
    }

    public IRefCounter getRefCounterFor(Object container, String type) {
        CounterSet counterSet = this.counterSets.get(container);
        return counterSet == null ? null : counterSet.getCounter(type);
    }

    public Collection<String> getRefsFor(Object container, String type) {
        IRefCounter counter = this.getRefCounterFor(container, type);
        if (counter != null) {
            return counter.getCountedRefs();
        }
        return Collections.emptySet();
    }

    public int getRefCountFor(Object container, String type, String resourceId) {
        IRefCounter counter = this.getRefCounterFor(container, type);
        if (counter == null) {
            return 0;
        }
        return counter.getRefCount(resourceId);
    }

    public void increaseRefFor(Object container, String type, String resourceId) {
        IRefCounter counter = this.getRefCounterFor(container, type);
        if (counter == null) {
            return;
        }
        counter.increaseRef(resourceId);
    }

    public void decreaseRefFor(Object container, String type, String resourceId) {
        IRefCounter counter = this.getRefCounterFor(container, type);
        if (counter == null) {
            return;
        }
        counter.decreaseRef(resourceId);
    }

    private void handleCoreEvent(CoreEvent event) {
        Object source = event.getSource();
        if (source instanceof IWorkbookComponent && ((IWorkbookComponent)source).isOrphan()) {
            return;
        }
        String type = event.getType();
        if ("topicAdd".equals(type)) {
            this.onTopicAdded((ITopic)event.getSource(), (ITopic)event.getTarget());
        } else if ("topicRemove".equals(type)) {
            this.onTopicRemoved((ITopic)event.getSource(), (ITopic)event.getTarget());
        } else if (STYLE.equals(type)) {
            this.onStyleChanged(event.getSource(), (String)event.getOldValue(), (String)event.getNewValue());
        } else if ("themeId".equals(type)) {
            this.onStyleChanged(event.getSource(), (String)event.getOldValue(), (String)event.getNewValue());
        } else if ("topicHyperlink".equals(type)) {
            this.onTopicHyperlinkChanged((ITopic)event.getSource(), (String)event.getOldValue(), (String)event.getNewValue());
        } else if ("imageSource".equals(type)) {
            this.onImageSourceChanged((IImage)event.getSource(), (String)event.getOldValue(), (String)event.getNewValue());
        } else if ("sheetAdd".equals(type)) {
            this.onSheetAdded((ISheet)event.getTarget());
        } else if ("sheetRemove".equals(type)) {
            this.onSheetRemoved((ISheet)event.getTarget());
        } else if ("rootTopic".equals(type)) {
            this.onSheetRootTopicChanged((ISheet)event.getSource(), (ITopic)event.getOldValue(), (ITopic)event.getNewValue());
        } else if ("styleAdd".equals(type)) {
            this.onStyleAdded((IStyle)event.getTarget());
        } else if ("resourceRefAdd".equals(type)) {
            this.onResourceRefAdded((ITopic)event.getSource(), (IResourceRef)event.getTarget());
        } else if ("resourceRefRemove".equals(type)) {
            this.onResourceRefRemoved((ITopic)event.getSource(), (IResourceRef)event.getTarget());
        } else if ("workbookExtensionResourceRefAdd".equals(type)) {
            this.onResourceRefAdded((IWorkbook)event.getSource(), (IResourceRef)event.getTarget());
        } else if ("workbookExtensionResourceRefRemove".equals(type)) {
            this.onResourceRefRemoved((IWorkbook)event.getSource(), (IResourceRef)event.getTarget());
        } else if ("extensionAdd".equals(type)) {
            this.onTopicExtensionAdded((ITopic)event.getSource(), (ITopicExtension)event.getTarget());
        } else if ("extensionRemove".equals(type)) {
            this.onTopicExtensionRemoved((ITopic)event.getSource(), (ITopicExtension)event.getTarget());
        } else if ("workbookExtensionAdd".equals(type)) {
            this.onWorkbookExtensionAdded((IWorkbook)event.getSource(), (IWorkbookExtension)event.getTarget());
        } else if ("workbookExtensionRemove".equals(type)) {
            this.onWorkbookExtensionRemoved((IWorkbook)event.getSource(), (IWorkbookExtension)event.getTarget());
        } else if ("topicNotes".equals(type)) {
            this.handleNotesContent((ITopic)event.getSource(), (INotesContent)event.getOldValue(), false);
            this.handleNotesContent((ITopic)event.getSource(), (INotesContent)event.getNewValue(), true);
        } else if ("boundaryAdd".equals(type)) {
            this.onStyleChanged(event.getSource(), null, ((IStyled)event.getTarget()).getStyleId());
        } else if ("boundaryRemove".equals(type)) {
            this.onStyleChanged(event.getSource(), ((IStyled)event.getTarget()).getStyleId(), null);
        } else if ("summaryAdd".equals(type)) {
            this.onStyleChanged(event.getSource(), null, ((IStyled)event.getTarget()).getStyleId());
        } else if ("summaryRemove".equals(type)) {
            this.onStyleChanged(event.getSource(), ((IStyled)event.getTarget()).getStyleId(), null);
        } else if ("relationshipAdd".equals(type)) {
            this.onStyleChanged(event.getSource(), null, ((IStyled)event.getTarget()).getStyleId());
        } else if ("relationshipRemove".equals(type)) {
            this.onStyleChanged(event.getSource(), ((IStyled)event.getTarget()).getStyleId(), null);
        } else if ("markerRefAdd".equals(type)) {
            this.onMarkerRefAdded((ITopic)event.getSource(), (String)event.getTarget());
        } else if ("markerRefRemove".equals(type)) {
            this.onMarkerRefRemoved((ITopic)event.getSource(), (String)event.getTarget());
        } else if ("labels".equals(type)) {
            this.onLabelSetChanged((ITopic)event.getSource(), (Set)event.getOldValue(), (Set)event.getNewValue());
        } else if ("markerAdd".equals(type)) {
            this.onMarkerAdded((IMarker)event.getTarget());
        } else if ("markerRemove".equals(type)) {
            this.onMarkerRemoved((IMarker)event.getTarget());
        } else if ("markerGroupAdd".equals(type)) {
            this.onMarkerGroupAdded((IMarkerGroup)event.getTarget());
        } else if ("markerGroupRemove".equals(type)) {
            this.onMarkerGroupRemoved((IMarkerGroup)event.getTarget());
        }
    }

    private void onLabelSetChanged(ITopic topic, Set<?> oldLabels, Set<?> newLabels) {
        HashSet removedLabels = new HashSet();
        HashSet addedLabels = new HashSet(newLabels);
        for (Object oldLabel : oldLabels) {
            if (addedLabels.remove(oldLabel)) continue;
            removedLabels.add(oldLabel);
        }
        for (Object label : removedLabels) {
            this.decreaseRefFor(topic, LABEL, (String)label);
        }
        for (Object label : addedLabels) {
            this.increaseRefFor(topic, LABEL, (String)label);
        }
    }

    private void onMarkerRefAdded(ITopic topic, String markerId) {
        this.increaseRefFor(topic, MARKER, markerId);
        IMarker marker = this.workbook.getMarkerSheet().getMarker(markerId);
        if (marker != null) {
            String groupId;
            IMarkerGroup group;
            String resourcePath = marker.getResourcePath();
            if (resourcePath != null) {
                this.activateFileEntryRef(topic, resourcePath);
            }
            if ((group = marker.getParent()) == null && (groupId = this.autoMarkerGroups.get(markerId)) != null) {
                group = this.workbook.getMarkerSheet().getMarkerGroup(groupId);
                group.addMarker(marker);
            }
            if (group != null) {
                this.autoMarkerGroups.put(markerId, group.getId());
                if (group.getParent() == null) {
                    this.workbook.getMarkerSheet().addMarkerGroup(group);
                }
            }
        }
    }

    private void onMarkerRefRemoved(ITopic topic, String markerId) {
        this.decreaseRefFor(topic, MARKER, markerId);
        IMarker marker = this.workbook.getMarkerSheet().getMarker(markerId);
        if (marker != null) {
            IMarkerGroup group;
            String resourcePath = marker.getResourcePath();
            if (resourcePath != null) {
                this.deactivateFileEntryRef(topic, resourcePath);
            }
            if ((group = marker.getParent()) != null) {
                this.autoMarkerGroups.put(markerId, group.getId());
                if (this.getRefCountFor(this.workbook, MARKER, markerId) <= 0) {
                    group.removeMarker(marker);
                }
                if (group.isEmpty()) {
                    this.workbook.getMarkerSheet().removeMarkerGroup(group);
                }
            }
        }
    }

    private void onMarkerAdded(IMarker marker) {
        this.activateMarker(marker);
    }

    private void onMarkerRemoved(IMarker marker) {
        this.deactivateMarker(marker);
    }

    private void onMarkerGroupAdded(IMarkerGroup group) {
        for (IMarker marker : group.getMarkers()) {
            this.activateMarker(marker);
        }
    }

    private void onMarkerGroupRemoved(IMarkerGroup group) {
        for (IMarker marker : group.getMarkers()) {
            this.deactivateMarker(marker);
        }
    }

    private void activateMarker(IMarker marker) {
        String resourcePath = marker.getResourcePath();
        if (resourcePath == null || "".equals(resourcePath)) {
            return;
        }
        IFileEntry entry = this.workbook.getManifest().getFileEntry(resourcePath);
        if (entry == null) {
            return;
        }
        entry.increaseReference();
    }

    private void deactivateMarker(IMarker marker) {
        String resourcePath = marker.getResourcePath();
        if (resourcePath == null || "".equals(resourcePath)) {
            return;
        }
        IFileEntry entry = this.workbook.getManifest().getFileEntry(resourcePath);
        if (entry == null) {
            return;
        }
        entry.decreaseReference();
    }

    private void handleNotesContent(ITopic source, INotesContent content, boolean activating) {
        if (content == null || !(content instanceof IHtmlNotesContent)) {
            return;
        }
        for (IParagraph paragraph : ((IHtmlNotesContent)content).getParagraphs()) {
            if (activating) {
                this.onStyleChanged(source, null, paragraph.getStyleId());
            } else {
                this.onStyleChanged(source, paragraph.getStyleId(), null);
            }
            this.handleSpanList(source, (ISpanList)paragraph, activating);
        }
    }

    private void handleSpanList(ITopic source, ISpanList spanList, boolean activating) {
        for (ISpan span : spanList.getSpans()) {
            if (activating) {
                this.onStyleChanged(source, null, span.getStyleId());
                if (span instanceof IImageSpan) {
                    this.activateURL(source, ((IImageSpan)span).getSource());
                    continue;
                }
                if (!(span instanceof IHyperlinkSpan)) continue;
                this.activateURL(source, ((IHyperlinkSpan)span).getHref());
                this.handleSpanList(source, (ISpanList)((IHyperlinkSpan)span), activating);
                continue;
            }
            if (span instanceof IImageSpan) {
                this.deactivateURL(source, ((IImageSpan)span).getSource());
            } else if (span instanceof IHyperlinkSpan) {
                this.handleSpanList(source, (ISpanList)((IHyperlinkSpan)span), activating);
                this.deactivateURL(source, ((IHyperlinkSpan)span).getHref());
            }
            this.onStyleChanged(source, span.getStyleId(), null);
        }
    }

    private void onTopicExtensionAdded(ITopic topic, ITopicExtension ext) {
        for (IResourceRef ref : ext.getResourceRefs()) {
            this.onResourceRefAdded(topic, ref);
        }
    }

    private void onTopicExtensionRemoved(ITopic topic, ITopicExtension ext) {
        for (IResourceRef ref : ext.getResourceRefs()) {
            this.onResourceRefRemoved(topic, ref);
        }
    }

    private void onWorkbookExtensionAdded(IWorkbook workbook, IWorkbookExtension ext) {
        for (IResourceRef ref : ext.getResourceRefs()) {
            this.onResourceRefAdded(workbook, ref);
        }
    }

    private void onWorkbookExtensionRemoved(IWorkbook workbook, IWorkbookExtension ext) {
        for (IResourceRef ref : ext.getResourceRefs()) {
            this.onResourceRefRemoved(workbook, ref);
        }
    }

    private void onResourceRefAdded(ITopic topic, IResourceRef ref) {
        if (FILE_ENTRY.equals(ref.getType())) {
            this.activateFileEntryRef(topic, ref.getResourceId());
        }
    }

    private void onResourceRefRemoved(ITopic topic, IResourceRef ref) {
        if (FILE_ENTRY.equals(ref.getType())) {
            this.deactivateFileEntryRef(topic, ref.getResourceId());
        }
    }

    private void onResourceRefAdded(IWorkbook workbook, IResourceRef ref) {
        if (FILE_ENTRY.equals(ref.getType())) {
            this.activateFileEntryRef(workbook, ref.getResourceId());
        }
    }

    private void onResourceRefRemoved(IWorkbook workbook, IResourceRef ref) {
        if (FILE_ENTRY.equals(ref.getType())) {
            this.deactivateFileEntryRef(workbook, ref.getResourceId());
        }
    }

    private void onStyleAdded(IStyle style) {
        this.autoStyleGroups.put(style.getId(), style.getOwnedStyleSheet().findOwnedGroup(style));
    }

    private void onStyleChanged(Object source, String oldStyleId, String newStyleId) {
        IStyle newStyle;
        IStyle oldStyle = this.getLocalStyle(oldStyleId);
        if (oldStyle != null) {
            this.deactivateStyle(source, oldStyle);
        }
        if ((newStyle = this.getLocalStyle(newStyleId)) != null) {
            this.activateStyle(source, newStyle, null);
        }
    }

    private void activateStyle(Object source, IStyle style, String groupName) {
        if (style.getOwnedStyleSheet().findOwnedGroup(style) == null) {
            if (groupName == null && (groupName = this.autoStyleGroups.get(style.getId())) == null) {
                groupName = THEME.equals(style.getType()) ? "master-styles" : "normal-styles";
            }
            style.getOwnedStyleSheet().addStyle(style, groupName);
        }
        this.increaseRefFor(source, STYLE, style.getId());
        Iterator properties = style.properties();
        while (properties.hasNext()) {
            this.activateURL(source, ((Property)properties.next()).value);
        }
        Iterator defaultStyleIds = style.defaultStyles();
        while (defaultStyleIds.hasNext()) {
            IStyle defaultStyle = this.getLocalStyle(((Property)defaultStyleIds.next()).value);
            if (defaultStyle == null) continue;
            this.activateStyle(source, defaultStyle, "automatic-styles");
        }
    }

    private void deactivateStyle(Object source, IStyle style) {
        Iterator properties = style.properties();
        while (properties.hasNext()) {
            this.deactivateURL(source, ((Property)properties.next()).value);
        }
        Iterator defaultStyleIds = style.defaultStyles();
        while (defaultStyleIds.hasNext()) {
            IStyle defaultStyle = this.getLocalStyle(((Property)defaultStyleIds.next()).value);
            if (defaultStyle == null) continue;
            this.deactivateStyle(source, defaultStyle);
        }
        this.decreaseRefFor(source, STYLE, style.getId());
        if (this.getRefCountFor(this.workbook, STYLE, style.getId()) <= 0) {
            style.getOwnedStyleSheet().removeStyle(style);
        }
    }

    private IStyle getLocalStyle(String styleId) {
        if (styleId == null) {
            return null;
        }
        IStyleSheet styleSheet = this.workbook.getStyleSheet();
        IStyle style = styleSheet.findStyle(styleId);
        if (style == null || !styleSheet.equals(style.getOwnedStyleSheet())) {
            return null;
        }
        return style;
    }

    private void onTopicHyperlinkChanged(ITopic topic, String oldHyperlink, String newHyperlink) {
        this.deactivateURL(topic, oldHyperlink);
        this.activateURL(topic, newHyperlink);
    }

    private void activateURL(Object container, String url) {
        if (url == null) {
            return;
        }
        if (HyperlinkUtils.isAttachmentURL((String)url)) {
            String entryPath = HyperlinkUtils.toAttachmentPath((String)url);
            this.activateFileEntryRef(container, entryPath);
        }
    }

    private void deactivateURL(Object container, String url) {
        if (url == null) {
            return;
        }
        if (HyperlinkUtils.isAttachmentURL((String)url)) {
            String entryPath = HyperlinkUtils.toAttachmentPath((String)url);
            this.deactivateFileEntryRef(container, entryPath);
        }
    }

    private void activateFileEntryRef(Object container, String entryPath) {
        this.increaseRefFor(container, FILE_ENTRY, entryPath);
        IFileEntry entry = this.workbook.getManifest().getFileEntry(entryPath);
        if (entry != null) {
            entry.increaseReference();
        }
    }

    private void deactivateFileEntryRef(Object container, String entryPath) {
        IFileEntry entry = this.workbook.getManifest().getFileEntry(entryPath);
        if (entry != null) {
            entry.decreaseReference();
        }
        this.decreaseRefFor(container, FILE_ENTRY, entryPath);
    }

    private void onImageSourceChanged(IImage image, String oldSource, String newSource) {
        this.deactivateURL(image.getParent(), oldSource);
        this.activateURL(image.getParent(), newSource);
    }

    private void onTopicAdded(ITopic parent, ITopic topic) {
        this.counterSets.remove(topic);
        CounterSet counterSet = parent != null ? new CounterSet(topic, this.counterSets.get(parent)) : new CounterSet(topic, this.counterSets.get(topic.getOwnedSheet()));
        this.counterSets.put(topic, counterSet);
        this.onTopicHyperlinkChanged(topic, null, topic.getHyperlink());
        this.onImageSourceChanged(topic.getImage(), null, topic.getImage().getSource());
        this.onStyleChanged(topic, null, topic.getStyleId());
        for (IMarkerRef markerRef : topic.getMarkerRefs()) {
            this.onMarkerRefAdded(topic, markerRef.getMarkerId());
        }
        for (String label : topic.getLabels()) {
            this.increaseRefFor(topic, LABEL, label);
        }
        Iterator children = topic.getAllChildrenIterator();
        while (children.hasNext()) {
            this.onTopicAdded(topic, (ITopic)children.next());
        }
        this.handleNotesContent(topic, topic.getNotes().getContent("html"), true);
        for (IBoundary boundary : topic.getBoundaries()) {
            this.onStyleChanged(topic, null, boundary.getStyleId());
        }
        for (ISummary summary : topic.getSummaries()) {
            this.onStyleChanged(topic, null, summary.getStyleId());
        }
        for (ITopicExtension ext : topic.getExtensions()) {
            this.onTopicExtensionAdded(topic, ext);
        }
    }

    private void onTopicRemoved(ITopic parent, ITopic topic) {
        for (ITopicExtension ext : topic.getExtensions()) {
            this.onTopicExtensionRemoved(topic, ext);
        }
        for (IBoundary boundary : topic.getBoundaries()) {
            this.onStyleChanged(topic, boundary.getStyleId(), null);
        }
        for (ISummary summary : topic.getSummaries()) {
            this.onStyleChanged(topic, summary.getStyleId(), null);
        }
        this.handleNotesContent(topic, topic.getNotes().getContent("html"), false);
        Iterator children = topic.getAllChildrenIterator();
        while (children.hasNext()) {
            this.onTopicRemoved(topic, (ITopic)children.next());
        }
        for (String label : topic.getLabels()) {
            this.decreaseRefFor(topic, LABEL, label);
        }
        for (IMarkerRef markerRef : topic.getMarkerRefs()) {
            this.onMarkerRefRemoved(topic, markerRef.getMarkerId());
        }
        this.onStyleChanged(topic, topic.getStyleId(), null);
        this.onImageSourceChanged(topic.getImage(), topic.getImage().getSource(), null);
        this.onTopicHyperlinkChanged(topic, topic.getHyperlink(), null);
        this.counterSets.remove(topic);
    }

    private void onSheetAdded(ISheet sheet) {
        this.counterSets.remove(sheet);
        CounterSet counterSet = new CounterSet(sheet, this.counterSets.get(this.workbook));
        this.counterSets.put(sheet, counterSet);
        this.onTopicAdded(null, sheet.getRootTopic());
        this.onStyleChanged(sheet, null, sheet.getStyleId());
        this.onStyleChanged(sheet, null, sheet.getThemeId());
        for (IRelationship rel : sheet.getRelationships()) {
            this.onStyleChanged(sheet, null, rel.getStyleId());
        }
    }

    private void onSheetRemoved(ISheet sheet) {
        for (IRelationship rel : sheet.getRelationships()) {
            this.onStyleChanged(sheet, rel.getStyleId(), null);
        }
        this.onStyleChanged(sheet, sheet.getThemeId(), null);
        this.onStyleChanged(sheet, sheet.getStyleId(), null);
        this.onTopicRemoved(null, sheet.getRootTopic());
        this.counterSets.remove(sheet);
    }

    private void onSheetRootTopicChanged(ISheet sheet, ITopic oldRootTopic, ITopic newRootTopic) {
        this.onTopicRemoved(null, oldRootTopic);
        this.onTopicAdded(null, newRootTopic);
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.eventSupport.registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.eventSupport;
    }

    private void dispatchRefsChanged(Object container, String type, Collection<String> oldRefs, Collection<String> newRefs) {
        CoreEvent event = new CoreEvent((ICoreEventSource)this, "resourceRefs", (Object)type, oldRefs, newRefs);
        event.setData(container);
        this.eventSupport.dispatch((ICoreEventSource)this, event);
    }

    private class CounterSet {
        private final Map<String, RefCounter> counters = new HashMap<String, RefCounter>();

        public CounterSet(Object container, CounterSet parentSet) {
            this.addCounter(container, ObjectRefManager.FILE_ENTRY, parentSet);
            this.addCounter(container, ObjectRefManager.STYLE, parentSet);
            this.addCounter(container, ObjectRefManager.THEME, parentSet);
            this.addCounter(container, ObjectRefManager.MARKER, parentSet);
            this.addCounter(container, ObjectRefManager.LABEL, parentSet);
        }

        private void addCounter(Object container, String type, CounterSet parentSet) {
            this.counters.put(type, new RefCounter(container, type, parentSet == null ? null : parentSet.getCounter(type)));
        }

        public RefCounter getCounter(String type) {
            return this.counters.get(type);
        }
    }

    private class RefCounter
    implements IRefCounter {
        private final Object container;
        private final String type;
        private final Map<String, Integer> positiveCounts;
        private final Map<String, Integer> negativeCounts;
        private final RefCounter parent;

        protected RefCounter(Object container, String type, RefCounter parent) {
            this.container = container;
            this.type = type;
            this.positiveCounts = new HashMap<String, Integer>();
            this.negativeCounts = new HashMap<String, Integer>();
            this.parent = parent;
        }

        public void increaseRef(String resourceId) {
            Collection<String> oldRefs = this.getCountedRefs();
            Integer c = this.positiveCounts.get(resourceId);
            if (c == null) {
                c = this.negativeCounts.get(resourceId);
            }
            if ((c = c == null ? Integer.valueOf(1) : Integer.valueOf(c + 1)) > 0) {
                this.negativeCounts.remove(resourceId);
                this.positiveCounts.put(resourceId, c);
            } else {
                this.positiveCounts.remove(resourceId);
                this.negativeCounts.put(resourceId, c);
            }
            Collection<String> newRefs = this.getCountedRefs();
            if (!newRefs.equals(oldRefs)) {
                ObjectRefManager.this.dispatchRefsChanged(this.container, this.type, oldRefs, newRefs);
            }
            if (this.parent != null) {
                this.parent.increaseRef(resourceId);
            }
        }

        public void decreaseRef(String resourceId) {
            Collection<String> oldRefs = this.getCountedRefs();
            Integer c = this.positiveCounts.get(resourceId);
            if (c == null) {
                c = this.negativeCounts.get(resourceId);
            }
            if (c == null) {
                return;
            }
            if ((c = Integer.valueOf(c - 1)) > 0) {
                this.negativeCounts.remove(resourceId);
                this.positiveCounts.put(resourceId, c);
            } else {
                this.positiveCounts.remove(resourceId);
                this.negativeCounts.put(resourceId, c);
            }
            Collection<String> newRefs = this.getCountedRefs();
            if (!newRefs.equals(oldRefs)) {
                ObjectRefManager.this.dispatchRefsChanged(this.container, this.type, oldRefs, newRefs);
            }
            if (this.parent != null) {
                this.parent.decreaseRef(resourceId);
            }
        }

        public int getRefCount(String resourceId) {
            Integer c = this.positiveCounts.get(resourceId);
            if (c != null) {
                return c;
            }
            c = this.negativeCounts.get(resourceId);
            if (c != null) {
                return c;
            }
            return 0;
        }

        public Collection<String> getRefs() {
            HashSet<String> refs = new HashSet<String>(this.positiveCounts.keySet());
            refs.addAll(this.negativeCounts.keySet());
            return refs;
        }

        public Collection<String> getCountedRefs() {
            return new HashSet<String>(this.positiveCounts.keySet());
        }
    }
}

