/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmind.core.IParagraph;
import org.xmind.core.ISpan;
import org.xmind.core.IWorkbook;
import org.xmind.core.plain.HtmlSpan;
import org.xmind.core.plain.Workbook;

public class HtmlParagraph
implements IParagraph {
    private final Workbook ownerWorkbook;
    private final List<ISpan> spans;
    private String styleId;
    private boolean orphan;

    public HtmlParagraph(Workbook ownerWorkbook) {
        this.ownerWorkbook = ownerWorkbook;
        this.spans = new ArrayList<ISpan>();
        this.styleId = null;
        this.orphan = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        return null;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public String getStyleType() {
        return "paragraph";
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public List<ISpan> getSpans() {
        return Collections.unmodifiableList(this.spans);
    }

    public void addSpan(ISpan span) {
        if (span == null || span.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        this.spans.add(span);
    }

    public void removeSpan(ISpan span) {
        if (span == null || span.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        this.spans.remove(span);
    }

    protected void onParented() {
        this.orphan = false;
        for (ISpan span : this.spans) {
            if (!(span instanceof HtmlSpan)) continue;
            ((HtmlSpan)span).onParented();
        }
    }

    protected void onOrphan() {
        for (ISpan span : this.spans) {
            if (!(span instanceof HtmlSpan)) continue;
            ((HtmlSpan)span).onOrphan();
        }
        this.orphan = true;
    }
}

