/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.xmind.cathy.internal.dashboard.StructureListContentProvider;
import org.xmind.cathy.internal.dashboard.ThemeChooserDialog;
import org.xmind.core.style.IStyle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.internal.SpaceCollaborativeEngine;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dashboard.pages.DashboardPage;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.mindmap.WorkbookInitializer;
import org.xmind.ui.resources.ColorUtils;

public class NewFromStructuresDashboardPage
extends DashboardPage
implements IAdaptable {
    private static final int FRAME_WIDTH = 210;
    private static final int FRAME_HEIGHT = 130;
    private GalleryViewer viewer;
    private ResourceManager resources;

    public void setFocus() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void createControl(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.viewer = new GalleryViewer();
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        this.viewer.setEditDomain(editDomain);
        Properties properties = this.viewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("constrained", true);
        properties.set("stretched", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.contentPaneBorderWidth", 1);
        properties.set("org.xmind.ui.gallery.contentPaneBorderColor", (Object)((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cccccc"))));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(210, 130));
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 30, 0, new Insets(10, 65, 20, 65)));
        properties.set("org.xmind.ui.gallery.contentPaneSpaceCollaborativeEngine", (Object)new SpaceCollaborativeEngine());
        Control control = this.viewer.createControl(parent);
        control.setBackground(parent.getBackground());
        control.setForeground(parent.getForeground());
        StructureListContentProvider contentAndLabelProvider = new StructureListContentProvider();
        this.viewer.setContentProvider((IStructuredContentProvider)contentAndLabelProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new StructureListContentProvider.StructureListLabelProvider());
        this.viewer.setInput((Object)StructureListContentProvider.getDefaultInput());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                NewFromStructuresDashboardPage.this.handleStructureSelected(event.getSelection());
            }
        });
        this.setControl(control);
    }

    private void handleStructureSelected(ISelection selection) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (NewFromStructuresDashboardPage.this.viewer == null || NewFromStructuresDashboardPage.this.viewer.getControl() == null || NewFromStructuresDashboardPage.this.viewer.getControl().isDisposed()) {
                    return;
                }
                NewFromStructuresDashboardPage.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        });
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        if (selectedElement == null || !(selectedElement instanceof StructureListContentProvider.StructureDescriptor)) {
            return;
        }
        StructureListContentProvider.StructureDescriptor structure = (StructureListContentProvider.StructureDescriptor)selectedElement;
        IStyle theme = this.chooseTheme(this.viewer.getControl().getShell(), structure.getValue());
        if (theme == null) {
            return;
        }
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("CreateWorkbookCount");
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("CreateSheetCount");
        String vs = structure.getValue();
        String ID = vs.replaceAll("\\.", "_");
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase(String.format("Structure/TypeCount/%s", ID));
        WorkbookInitializer initializer = WorkbookInitializer.getDefault().withStructureClass(structure.getValue()).withTheme(theme);
        IEditorInput editorInput = MindMapUI.getEditorInputFactory().createEditorInputForWorkbookInitializer(initializer, null);
        this.getContext().openEditor(editorInput, "org.xmind.ui.MindMapEditor");
    }

    private IStyle chooseTheme(Shell shell, String structureClass) {
        ThemeChooserDialog dialog = new ThemeChooserDialog(shell, structureClass);
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        return dialog.getSelectedTheme();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.viewer != null) {
            if (adapter.isAssignableFrom(this.viewer.getClass())) {
                return adapter.cast(this.viewer);
            }
            Object obj = this.viewer.getAdapter(adapter);
            if (obj != null) {
                return (T)obj;
            }
        }
        return null;
    }
}

