/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class WelcomeDialog
extends Dialog {
    private Button uploadDataCheck;
    private ResourceManager resources;

    public WelcomeDialog(Shell parent) {
        super(parent);
        this.setShellStyle(0x11000C);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)newShell);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cccccc")));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 743;
        gridData.heightHint = 432;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        GridData gridData2 = new GridData(1808);
        composite2.setLayoutData((Object)gridData2);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.createTopSection(composite2);
        this.createBottomSection(composite2);
        return composite;
    }

    private void createTopSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.widthHint = 740;
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createHeaderSection(composite);
        this.createTitleSection(composite);
        this.createPlaceholderComposite(composite);
    }

    private void createPlaceholderComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.heightHint = 33;
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
    }

    private void createHeaderSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 128, true, false);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 10;
        layout.marginRight = 10;
        composite.setLayout((Layout)layout);
        this.createCloseButtonSection(composite);
        Listener controlMovedListener = this.createControlMovedListener((Control)composite);
        composite.addListener(3, controlMovedListener);
        composite.addListener(5, controlMovedListener);
        composite.addListener(4, controlMovedListener);
    }

    private void createCloseButtonSection(Composite parent) {
        Composite composite2 = new Composite(parent, 0);
        composite2.setBackground(composite2.getParent().getBackground());
        GridData layoutData2 = new GridData(131072, 128, true, true);
        composite2.setLayoutData((Object)layoutData2);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 5;
        layout2.marginHeight = 5;
        composite2.setLayout((Layout)layout2);
        final Label close = new Label(composite2, 131072);
        close.setBackground(composite2.getBackground());
        close.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        final Image focusedImage = (Image)this.resources.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"icons/welcome/close.png"));
        final Image noFocusedImage = (Image)this.resources.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"icons/welcome/close-d.png"));
        close.setImage(noFocusedImage);
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                close.setImage(noFocusedImage);
            }

            public void mouseEnter(MouseEvent e) {
                close.setImage(focusedImage);
            }
        };
        composite2.addMouseTrackListener(mouseTrackListener);
        close.addMouseTrackListener(mouseTrackListener);
        MouseListener mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                WelcomeDialog.this.close(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        composite2.addMouseListener(mouseListener);
        close.addMouseListener(mouseListener);
    }

    private Listener createControlMovedListener(final Control header) {
        Listener listener = new Listener(){
            Point point = null;
            Point startLocation = null;

            public void handleEvent(Event event) {
                Shell shell = WelcomeDialog.this.getShell();
                switch (event.type) {
                    case 3: {
                        if (WelcomeDialog.this.getShell().isDisposed()) {
                            return;
                        }
                        this.point = header.toDisplay(event.x, event.y);
                        this.startLocation = shell.getLocation();
                        break;
                    }
                    case 5: {
                        if (this.point == null) {
                            return;
                        }
                        Point p2 = header.toDisplay(event.x, event.y);
                        int deltaX = p2.x - this.point.x;
                        int deltaY = p2.y - this.point.y;
                        Rectangle rect = shell.getBounds();
                        rect.x = this.startLocation.x + deltaX;
                        rect.y = this.startLocation.y + deltaY;
                        shell.setLocation(rect.x, rect.y);
                        break;
                    }
                    case 4: {
                        this.point = null;
                    }
                }
            }
        };
        return listener;
    }

    private void createTitleSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 31;
        layout.marginLeft = 47;
        composite.setLayout((Layout)layout);
        Label titleLabel = new Label(composite, 0x1000000);
        titleLabel.setBackground(composite.getBackground());
        titleLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#4a4a4a")));
        titleLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
        titleLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold((FontData[])FontUtils.relativeHeight((FontData[])fontData, (int)21), (boolean)true))));
        titleLabel.setText(WorkbenchMessages.WelcomDialog_Welcom_title);
        Label title2 = new Label(composite, 1024);
        title2.setBackground(composite.getBackground());
        title2.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#4a4a4a")));
        GridData layoutData = new GridData(0x1000000, 1024, false, true);
        title2.setLayoutData((Object)layoutData);
        title2.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])fontData, (int)6))));
        title2.setText(WorkbenchMessages.WelcomDialog_WhatIsNew_title);
    }

    private void createBottomSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.createNewFeatureItems(composite);
        this.createButtonSection(composite);
    }

    private void createNewFeatureItems(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(4, true);
        layout.marginWidth = 50;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createImageItem(composite, (Image)this.resources.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"icons/welcome/slide.png")), WorkbenchMessages.WelcomeDialog_item_slide_title, WorkbenchMessages.WelcomeDialog_item_slide_description, new Runnable(){

            @Override
            public void run() {
            }
        });
        this.createImageItem(composite, (Image)this.resources.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"icons/welcome/cloud.png")), WorkbenchMessages.WelcomeDialog_item_cloud_title, WorkbenchMessages.WelcomeDialog_item_cloud_description, new Runnable(){

            @Override
            public void run() {
            }
        });
        this.createImageItem(composite, (Image)this.resources.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"icons/welcome/new_workspace.png")), WorkbenchMessages.WelcomeDialog_item_workspace_title, WorkbenchMessages.WelcomeDialog_item_workspace_description, new Runnable(){

            @Override
            public void run() {
            }
        });
        this.createImageItem(composite, (Image)this.resources.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"icons/welcome/high_dpi.png")), WorkbenchMessages.WelcomeDialog_item_high_dpi_title, WorkbenchMessages.WelcomeDialog_item_high_dpi_description, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void createImageItem(Composite parent, Image image, String title, String description, final Runnable action) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayoutFactory.fillDefaults().spacing(0, 20).applyTo(composite);
        Label imageLabel = new Label(composite, 0x1000000);
        imageLabel.setBackground(composite.getBackground());
        GridData gridData2 = new GridData(0x1000000, 128, true, false);
        imageLabel.setLayoutData((Object)gridData2);
        imageLabel.setImage(image);
        imageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                action.run();
            }
        });
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite.getBackground());
        GridData layoutData2 = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)layoutData2);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.verticalSpacing = 10;
        composite2.setLayout((Layout)layout2);
        FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
        Label titleLabel = new Label(composite2, 0);
        titleLabel.setBackground(composite2.getBackground());
        titleLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#4a4a4a")));
        titleLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        titleLabel.setText(title);
        titleLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold((FontData[])FontUtils.relativeHeight((FontData[])fontData, (int)2), (boolean)true))));
        Label descriptionLabel = new Label(composite2, 64);
        descriptionLabel.setBackground(composite2.getBackground());
        descriptionLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#4a4a4a")));
        descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        descriptionLabel.setAlignment(0x1000000);
        descriptionLabel.setText(description);
        descriptionLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])descriptionLabel.getFont().getFontData(), (int)0))));
    }

    private void createButtonSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(1, 1).applyTo(container);
        container.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#e8e8e8")));
        Composite composite = new Composite(container, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#fcfcfc")));
        GridData layoutData = new GridData(4, 1024, true, false);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(0, false);
        layout.marginWidth = 27;
        layout.marginHeight = 10;
        composite.setLayout((Layout)layout);
        this.createUploadDataCheck(composite);
        this.createOkButton(composite);
    }

    private void createUploadDataCheck(Composite parent) {
        if (!this.isShowUploadDataCheck()) {
            return;
        }
        ++((GridLayout)parent.getLayout()).numColumns;
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        this.uploadDataCheck = new Button(composite, 32);
        this.uploadDataCheck.setBackground(composite.getBackground());
        GridData gridData2 = new GridData(16384, 0x1000000, false, false);
        this.uploadDataCheck.setLayoutData((Object)gridData2);
        this.uploadDataCheck.setText(WorkbenchMessages.WelcomeDialog_uploadDataCheck_text);
        this.uploadDataCheck.setSelection(true);
        Hyperlink privacyHyperlink = new Hyperlink(composite, 0);
        privacyHyperlink.setBackground(composite.getBackground());
        privacyHyperlink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        privacyHyperlink.setText(WorkbenchMessages.WelcomeDialog_seePolicy_link);
        privacyHyperlink.setUnderlined(true);
        privacyHyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#006CF9")));
        composite.setFocus();
        privacyHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                Program.launch((String)LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/privacy/usage/"));
            }
        });
    }

    private boolean isShowUploadDataCheck() {
        return !Boolean.getBoolean("org.xmind.cathy.notShowUploadDataCheck");
    }

    private void createOkButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button okButton = new Button(parent, 8);
        okButton.setBackground(parent.getBackground());
        GridData gridData = null;
        gridData = ((GridLayout)parent.getLayout()).numColumns > 1 ? new GridData(0x1000000, 0x1000000, false, true) : new GridData(131072, 0x1000000, true, true);
        gridData.widthHint = 92;
        okButton.setLayoutData((Object)gridData);
        okButton.setText(WorkbenchMessages.WelcomeDialog_okButton_text);
        okButton.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])okButton.getFont().getFontData(), (int)1))));
        okButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                WelcomeDialog.this.close(false);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void close(boolean restoreDefaults) {
        if (this.uploadDataCheck != null && !this.uploadDataCheck.isDisposed()) {
            boolean isUploadData = true;
            if (!restoreDefaults) {
                isUploadData = this.uploadDataCheck.getSelection();
            }
            CathyPlugin.getDefault().getPreferenceStore().setValue("usageDataUploadingEnabled", isUploadData);
        }
        super.close();
    }
}

