/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import net.xmind.core.IAccount;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.views.Page;

public class FatalErrorPage
extends Page {
    private static final String COLOR_DESCRIPTION = "#9B9B9B";
    private SeawindLibrary library;
    private Composite titleBar;
    private Label userNameLabel;

    public FatalErrorPage(SeawindLibrary library, IAccount account) {
        this.library = library;
    }

    protected Control doCreateControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(1).applyTo(composite);
        Control body = this.createBody(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(body);
        return composite;
    }

    private Control createBody(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Control centerControl = this.createContent(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo(centerControl);
        return composite;
    }

    private Control createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 24).applyTo(composite);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setImage((Image)resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("unconnect.png")));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)imageLabel);
        Point imageSize = imageLabel.computeSize(-1, -1);
        Control textArea = this.createTextArea(composite, resources);
        GridDataFactory.fillDefaults().align(0x1000000, 4).grab(true, false).hint(imageSize.x, -1).applyTo(textArea);
        Control actionBar = this.createActionBar(composite);
        if (actionBar != null) {
            GridDataFactory.fillDefaults().grab(true, false).hint(imageSize.x, -1).applyTo(actionBar);
        }
        return composite;
    }

    private Control createTextArea(Composite parent, LocalResourceManager resources) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 12).applyTo(composite);
        Label descriptionLabel = new Label(composite, 0x1000040);
        descriptionLabel.setForeground((Color)resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_DESCRIPTION)));
        descriptionLabel.setFont((Font)resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().setStyle(0).setHeight(12)));
        descriptionLabel.setText(SeawindMessages.CloudDashboardPage_FatalError_message);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)descriptionLabel);
        return composite;
    }

    private Control createActionBar(Composite parent) {
        Composite actionBar = new Composite(parent, 0);
        actionBar.setBackground(parent.getBackground());
        actionBar.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(7, 7).numColumns(1).applyTo(actionBar);
        Button retryButton = new Button(actionBar, 0);
        retryButton.setText(SeawindMessages.CloudDashboardPage_RetryButton_text);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)retryButton);
        retryButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FatalErrorPage.this.library.sync();
            }
        });
        return actionBar;
    }

    public void updateUserInfo() {
        if (this.titleBar != null && this.userNameLabel != null) {
            this.userNameLabel.setText(this.library.getUserName() == null ? "" : this.library.getUserName());
            this.titleBar.layout(true, true);
        }
    }
}

