/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.io.PrefixedStorage;
import org.xmind.core.net.Entity;
import org.xmind.core.net.Field;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.seawind.internal.core.JSON;
import org.xmind.seawind.internal.core.SeawindClient;
import org.xmind.seawind.internal.core.SeawindHttpException;
import org.xmind.seawind.internal.core.StorageEntryEntity;

public class MockedSeawindClient
extends SeawindClient {
    private static final int SIMULATED_NETWORK_DELAY = 700;
    private static final String FIRST_REV = "1";
    private IStorage rootStorage;
    private IStorage storage;

    public MockedSeawindClient(IStorage storage) {
        this.rootStorage = storage;
        this.storage = null;
    }

    public boolean isAuthorized() {
        return this.storage != null;
    }

    public void grantAuthorization(String userName, String authToken) {
        super.grantAuthorization(userName, authToken);
        this.storage = new PrefixedStorage(this.rootStorage, String.valueOf(userName) + "/");
    }

    public void revokeAuthorization() {
        super.revokeAuthorization();
        this.storage = null;
    }

    public JSONObject downloadUserInfo(IProgressMonitor monitor) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        return this.getUserInfo();
    }

    private JSONObject getUserInfo() throws HttpException {
        String userInfoPath = "user.json";
        if (this.storage.getInputSource().hasEntry(userInfoPath)) {
            try {
                return JSON.readObject((IInputSource)this.storage.getInputSource(), (String)userInfoPath);
            }
            catch (IOException iOException) {
                throw new HttpException(null, 500, "Internal Server Error", null);
            }
        }
        JSONObject initialInfo = new JSONObject().put("capacity_max", 0x40000000L).put("capacity_used", 0L).put("cloud_actived", true);
        try {
            JSON.writeObject((JSONObject)initialInfo, (IOutputTarget)this.storage.getOutputTarget(), (String)userInfoPath);
        }
        catch (IOException iOException) {
            throw new HttpException(null, 500, "Internal Server Error", null);
        }
        return initialInfo;
    }

    public JSONObject activate(IProgressMonitor monitor, String email, String license, String uuid) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        String userInfoPath = "user.json";
        JSONObject userInfo = this.getUserInfo();
        try {
            JSON.writeObject((JSONObject)userInfo, (IOutputTarget)this.storage.getOutputTarget(), (String)userInfoPath);
        }
        catch (IOException iOException) {
            throw new HttpException(null, 500, "Internal Server Error", null);
        }
        return userInfo;
    }

    public JSONObject downloadWorkbookList(IProgressMonitor monitor) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        try {
            return this.readWorkingSet();
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    public JSONObject downloadFolderList(IProgressMonitor monitor) throws HttpException, InterruptedException {
        try {
            return JSON.readOrCreateObject((IInputSource)this.storage.getInputSource(), (String)"folders/folders.json");
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    public JSONObject uploadFolderList(IProgressMonitor monitor, JSONObject folderListObject) throws HttpException, InterruptedException {
        try {
            JSON.writeObject((JSONObject)folderListObject, (IOutputTarget)this.storage.getOutputTarget(), (String)"folders/folders.json");
            JSON.writeObject((JSONObject)folderListObject, (IOutputTarget)this.storage.getOutputTarget(), (String)"folders/folders_base.json");
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        return null;
    }

    public JSONObject downloadWorkbook(IProgressMonitor monitor, String workbookId) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        try {
            JSONObject workingSetObject = this.readWorkingSet();
            JSONObject workbookObject = this.findById(workingSetObject.optJSONArray("workbooks"), workbookId);
            if (workbookObject == null) {
                throw new HttpException(null, 404, "Not Found", null);
            }
            return workbookObject;
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    public JSONObject uploadWorkbook(IProgressMonitor monitor, String workbookId, JSONObject workbookObject, FieldSet files) throws HttpException, InterruptedException {
        if (files != null) {
            Thread.sleep(2100L);
        } else {
            Thread.sleep(700L);
        }
        JSONObject userInfo = this.getUserInfo();
        if (userInfo.getLong("capacity_used") > userInfo.getLong("capacity_max")) {
            throw new SeawindHttpException(new HttpException(null, 403, "Forbidden", null), 4301, "Storage Full", "You exceeds storage capacity", new JSONObject());
        }
        if (workbookObject == null) {
            workbookObject = new JSONObject().put("id", (Object)workbookId);
        }
        try {
            JSONObject workingSetObject;
            JSONArray workbookArray;
            JSONObject mockedWorkbookObject;
            String rev = FIRST_REV;
            if (files != null) {
                PrefixedStorage workbookStorage = new PrefixedStorage(this.storage, EncodingUtils.format((String)"workbooks/%s/", (Object[])new Object[]{workbookId}));
                IOutputTarget workbookTarget = workbookStorage.getOutputTarget();
                for (Field file : files) {
                    if (!file.name.startsWith("sheets/")) continue;
                    int lastSepIndex = file.name.lastIndexOf(47);
                    String filePrefix = file.name.substring(0, lastSepIndex + 1);
                    String fileName = file.name.substring(lastSepIndex + 1);
                    String path = String.valueOf(filePrefix) + EncodingUtils.format((String)"revs/%s/", (Object[])new Object[]{rev}) + fileName;
                    try (OutputStream stream = workbookTarget.openEntryStream(path);){
                        if (file.value instanceof HttpEntity) {
                            ((HttpEntity)file.value).writeTo(stream);
                            continue;
                        }
                        stream.write(file.value.toString().getBytes());
                    }
                }
            }
            if ((mockedWorkbookObject = this.findById(workbookArray = (workingSetObject = this.readWorkingSet()).optJSONArray("workbooks"), workbookId)) == null) {
                JSONArray sheetArray;
                mockedWorkbookObject = workbookObject;
                if (workbookArray == null) {
                    workbookArray = new JSONArray();
                    workingSetObject.put("workbooks", (Object)workbookArray);
                }
                if ((sheetArray = mockedWorkbookObject.optJSONArray("sheets")) != null) {
                    int i = 0;
                    while (i < sheetArray.length()) {
                        JSONObject sheetObject = sheetArray.getJSONObject(i);
                        sheetObject.put("rev", (Object)rev);
                        ++i;
                    }
                }
                if (workbookObject.has("modificationTime")) {
                    mockedWorkbookObject.put("modificationTime", workbookObject.getLong("modificationTime"));
                }
                workbookArray.put((Object)mockedWorkbookObject);
            } else {
                for (String key : workbookObject.keySet()) {
                    mockedWorkbookObject.put(key, workbookObject.get(key));
                }
            }
            workingSetObject.put("modificationTime", System.currentTimeMillis());
            this.storeWorkingSet(workingSetObject);
            return mockedWorkbookObject;
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    public JSONObject deleteWorkbook(IProgressMonitor monitor, String workbookId) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        try {
            JSONObject workingSetObject = this.readWorkingSet();
            JSONArray workbookArray = workingSetObject.optJSONArray("workbooks");
            int index = this.indexOfId(workbookArray, workbookId);
            if (index < 0) {
                throw new HttpException(null, 404, "Not Found", null);
            }
            JSONObject workbookObject = workbookArray.getJSONObject(index);
            workbookArray.remove(index);
            workingSetObject.put("modificationTime", System.currentTimeMillis());
            this.storeWorkingSet(workingSetObject);
            return workbookObject;
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    public JSONObject downloadSheet(IProgressMonitor monitor, String workbookId, String sheetId) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        try {
            JSONObject workingSetObject = this.readWorkingSet();
            JSONObject workbookObject = this.findById(workingSetObject.optJSONArray("workbooks"), workbookId);
            if (workbookObject == null) {
                throw new HttpException(null, 404, "Not Found", null);
            }
            JSONObject sheetObject = this.findById(workbookObject.optJSONArray("sheets"), sheetId);
            if (sheetObject == null) {
                throw new HttpException(null, 404, "Not Found", null);
            }
            return sheetObject;
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    public JSONObject uploadSheet(IProgressMonitor monitor, String workbookId, String sheetId, JSONObject sheetObject, HttpEntity content, HttpEntity previewImage) throws HttpException, InterruptedException {
        if (content != null || previewImage != null) {
            Thread.sleep(2100L);
        } else {
            Thread.sleep(700L);
        }
        JSONObject userInfo = this.getUserInfo();
        if (userInfo.getLong("capacity_used") > userInfo.getLong("capacity_max")) {
            throw new SeawindHttpException(new HttpException(null, 403, "Forbidden", null), 4301, "Storage Full", "You exceeds storage capacity", new JSONObject());
        }
        if (sheetObject == null) {
            sheetObject = new JSONObject().put("id", (Object)sheetId);
        }
        PrefixedStorage sheetStorage = new PrefixedStorage((IStorage)new PrefixedStorage(this.storage, EncodingUtils.format((String)"workbooks/%s/", (Object[])new Object[]{workbookId})), EncodingUtils.format((String)"sheets/%s/", (Object[])new Object[]{sheetId}));
        try {
            JSONObject workingSetObject = this.readWorkingSet();
            JSONArray workbookArray = workingSetObject.optJSONArray("workbooks");
            JSONObject mockedWorkbookObject = this.findById(workbookArray, workbookId);
            if (mockedWorkbookObject == null) {
                throw new HttpException(null, 404, "Not Found", null);
            }
            JSONArray sheetArray = mockedWorkbookObject.optJSONArray("sheets");
            JSONObject mockedSheetObject = this.findById(sheetArray, sheetId);
            if (mockedSheetObject == null) {
                String rev = FIRST_REV;
                mockedSheetObject = sheetObject;
                mockedSheetObject.put("id", (Object)sheetId);
                if (!mockedSheetObject.has("creationTime")) {
                    mockedSheetObject.put("creationTime", System.currentTimeMillis());
                }
                mockedSheetObject.put("rev", (Object)rev);
                if (sheetArray == null) {
                    sheetArray = new JSONArray();
                    mockedWorkbookObject.put("sheets", (Object)sheetArray);
                }
                sheetArray.put((Object)mockedSheetObject);
                try (OutputStream output = sheetStorage.getOutputTarget().openEntryStream(EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{rev}));){
                    content.writeTo(output);
                }
                if (previewImage != null) {
                    output = sheetStorage.getOutputTarget().openEntryStream(EncodingUtils.format((String)"revs/%s/preview.png", (Object[])new Object[]{rev}));
                    try {
                        previewImage.writeTo(output);
                    }
                    finally {
                        output.close();
                    }
                }
            } else {
                String rev = mockedSheetObject.getString("rev");
                if (content != null) {
                    String baseRev = sheetObject.optString("rev", null);
                    if (baseRev == null) {
                        throw new HttpException(null, 400, "Bad Request", null);
                    }
                    if (!baseRev.equals(rev)) {
                        throw new HttpException(null, 409, "Conflict: Request base = " + baseRev + ", Server base = " + rev, null);
                    }
                    rev = this.increaseRev(rev);
                    sheetObject.put("rev", (Object)rev);
                    try (OutputStream output = sheetStorage.getOutputTarget().openEntryStream(EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{rev}));){
                        content.writeTo(output);
                    }
                }
                if (previewImage != null) {
                    try (OutputStream output = sheetStorage.getOutputTarget().openEntryStream(EncodingUtils.format((String)"revs/%s/preview.png", (Object[])new Object[]{rev}));){
                        previewImage.writeTo(output);
                    }
                }
                for (String key : sheetObject.keySet()) {
                    mockedSheetObject.put(key, sheetObject.get(key));
                }
            }
            mockedSheetObject.put("modificationTime", System.currentTimeMillis());
            mockedWorkbookObject.put("modificationTime", System.currentTimeMillis());
            this.storeWorkingSet(workingSetObject);
            return mockedSheetObject;
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    public JSONObject deleteSheet(IProgressMonitor monitor, String workbookId, String sheetId, String rev) throws HttpException, InterruptedException {
        try {
            JSONObject workingSetObject = this.readWorkingSet();
            JSONArray workbookArray = workingSetObject.optJSONArray("workbooks");
            int workbookIndex = this.indexOfId(workbookArray, workbookId);
            if (workbookIndex < 0) {
                throw new HttpException(null, 404, "Not Found", null);
            }
            JSONObject workbookObject = workbookArray.getJSONObject(workbookIndex);
            JSONArray sheetArray = workbookObject.optJSONArray("sheets");
            int sheetIndex = this.indexOfId(sheetArray, sheetId);
            if (sheetIndex < 0) {
                throw new HttpException(null, 404, "Not Found", null);
            }
            JSONObject sheetObject = sheetArray.getJSONObject(sheetIndex);
            if (rev == null || !rev.equals(sheetObject.getString("rev"))) {
                throw new HttpException(null, 400, "Bad Request", null);
            }
            sheetArray.remove(sheetIndex);
            workbookObject.put("modificationTime", System.currentTimeMillis());
            this.storeWorkingSet(workingSetObject);
            Thread.sleep(700L);
            return workbookObject;
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    public void downloadSheetContent(IProgressMonitor monitor, String workbookId, String sheetId, IOutputTarget target, String targetPath, String hash) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        String rev = this.getLatestRev(workbookId, sheetId);
        String sourcePath = EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{rev});
        PrefixedStorage sheetStorage = new PrefixedStorage((IStorage)new PrefixedStorage(this.storage, EncodingUtils.format((String)"workbooks/%s/", (Object[])new Object[]{workbookId})), EncodingUtils.format((String)"sheets/%s/", (Object[])new Object[]{sheetId}));
        this.downloadSheetFile(sheetStorage.getInputSource(), sourcePath, target, targetPath);
    }

    public void downloadSheetPreviewImage(IProgressMonitor monitor, String workbookId, String sheetId, IOutputTarget target, String targetPath) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        String rev = this.getLatestRev(workbookId, sheetId);
        String entryPath = EncodingUtils.format((String)"revs/%s/preview.png", (Object[])new Object[]{rev});
        PrefixedStorage sheetStorage = new PrefixedStorage((IStorage)new PrefixedStorage(this.storage, EncodingUtils.format((String)"workbooks/%s/", (Object[])new Object[]{workbookId})), EncodingUtils.format((String)"sheets/%s/", (Object[])new Object[]{sheetId}));
        this.downloadSheetFile(sheetStorage.getInputSource(), entryPath, target, targetPath);
    }

    public void downloadResource(IProgressMonitor monitor, String hash, IOutputTarget target) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        PrefixedStorage resourceStorage = new PrefixedStorage(this.storage, "resources/");
        try {
            FileUtils.transfer((IInputSource)resourceStorage.getInputSource(), (String)hash, (IOutputTarget)target, (String)hash);
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    public void uploadResources(IProgressMonitor monitor, Set<String> hashes, IInputSource source) throws HttpException, InterruptedException {
        Thread.sleep(700L);
        JSONObject userInfo = this.getUserInfo();
        if (userInfo.getLong("capacity_used") > userInfo.getLong("capacity_max")) {
            throw new SeawindHttpException(new HttpException(null, 403, "Forbidden", null), 4301, "Storage Full", "You exceeds storage capacity", new JSONObject());
        }
        for (String hash : hashes) {
            PrefixedStorage resourceStorage = new PrefixedStorage(this.storage, "resources/");
            try {
                FileUtils.transfer((IInputSource)source, (String)hash, (IOutputTarget)resourceStorage.getOutputTarget(), (String)hash);
            }
            catch (IOException e) {
                throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
            }
        }
    }

    private void downloadSheetFile(IInputSource source, String sourcePath, IOutputTarget target, String targetPath) throws HttpException {
        if (!source.hasEntry(sourcePath)) {
            throw new HttpException(null, 404, "Not Found", null);
        }
        try {
            MockedSeawindClient.writeEntityTo((Entity)new StorageEntryEntity(source, sourcePath), (IOutputTarget)target, (String)targetPath);
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
    }

    private String getLatestRev(String workbookId, String sheetId) throws HttpException {
        String rev;
        try {
            JSONObject workingSetObject = this.readWorkingSet();
            JSONArray workbookArray = workingSetObject.optJSONArray("workbooks");
            int workbookIndex = this.indexOfId(workbookArray, workbookId);
            if (workbookIndex < 0) {
                throw new HttpException(null, 404, "Not Found", null);
            }
            JSONObject workbookObject = workbookArray.getJSONObject(workbookIndex);
            JSONArray sheetArray = workbookObject.optJSONArray("sheets");
            int sheetIndex = this.indexOfId(sheetArray, sheetId);
            if (sheetIndex < 0) {
                throw new HttpException(null, 404, "Not Found", null);
            }
            JSONObject sheetObject = sheetArray.getJSONObject(sheetIndex);
            rev = sheetObject.getString("rev");
        }
        catch (IOException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(null, 500, "Internal Server Error", (Throwable)e);
        }
        return rev;
    }

    private void storeWorkingSet(JSONObject workingSetObject) throws IOException {
        JSON.writeObject((JSONObject)workingSetObject, (IOutputTarget)this.storage.getOutputTarget(), (String)"workbooks.json");
    }

    private JSONObject readWorkingSet() throws IOException {
        return JSON.readOrCreateObject((IInputSource)this.storage.getInputSource(), (String)"workbooks.json");
    }

    private JSONObject findById(JSONArray array, String id) {
        if (array == null) {
            return null;
        }
        for (Object element : array) {
            JSONObject object = (JSONObject)element;
            if (!id.equals(object.getString("id"))) continue;
            return object;
        }
        return null;
    }

    private int indexOfId(JSONArray array, String id) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length()) {
            JSONObject object = array.getJSONObject(i);
            if (id.equals(object.getString("id"))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String increaseRev(String baseRev) {
        int i = Integer.parseInt(baseRev, 10);
        return String.valueOf(i + 1);
    }
}

