/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGBezierFigure
extends BezierFigure {
    private transient Rectangle2D.Double cachedDrawingArea;

    public SVGBezierFigure() {
        this(false);
    }

    public SVGBezierFigure(boolean isClosed) {
        super(isClosed);
        SVGAttributeKeys.FILL_OPEN_PATH.basicSet(this, true);
    }

    public Collection<Handle> createHandles(SVGPathFigure pathFigure, int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case 0: {
                int n = this.path.size();
                for (int i = 0; i < n; ++i) {
                    handles.add(new BezierNodeHandle(this, i, pathFigure));
                }
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (evt.getClickCount() == 2) {
            int index;
            this.willChange();
            if (SVGAttributeKeys.TRANSFORM.get(this) != null) {
                try {
                    p = (Point2D.Double)((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this)).inverseTransform(p, new Point2D.Double());
                }
                catch (NoninvertibleTransformException ex) {
                    System.err.println("Warning: SVGBezierFigure.handleMouseClick. Figure has noninvertible Transform.");
                }
            }
            if ((index = this.splitSegment(p, (float)(5.0 / view.getScaleFactor()))) != -1) {
                final BezierPath.Node newNode = this.getNode(index);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                        return labels.getString("edit.bezierPath.splitSegment.text");
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        SVGBezierFigure.this.willChange();
                        SVGBezierFigure.this.addNode(index, newNode);
                        SVGBezierFigure.this.changed();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        SVGBezierFigure.this.willChange();
                        SVGBezierFigure.this.removeNode(index);
                        SVGBezierFigure.this.changed();
                    }
                });
                this.changed();
                evt.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void transform(AffineTransform tx) {
        if (SVGAttributeKeys.TRANSFORM.get(this) != null || (tx.getType() & 1) != tx.getType()) {
            if (SVGAttributeKeys.TRANSFORM.get(this) == null) {
                SVGAttributeKeys.TRANSFORM.basicSetClone(this, tx);
            } else {
                AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                SVGAttributeKeys.TRANSFORM.basicSet(this, t);
            }
        } else {
            super.transform(tx);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            if (SVGAttributeKeys.TRANSFORM.get(this) == null) {
                this.cachedDrawingArea = this.path.getBounds2D();
            } else {
                BezierPath p2 = this.path.clone();
                p2.transform((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this));
                this.cachedDrawingArea = p2.getBounds2D();
            }
            double strokeTotalWidth = AttributeKeys.getStrokeTotalWidth(this);
            double width = strokeTotalWidth / 2.0;
            if ((Integer)SVGAttributeKeys.STROKE_JOIN.get(this) == 0) {
                width *= ((Double)SVGAttributeKeys.STROKE_MITER_LIMIT.get(this)).doubleValue();
            } else if ((Integer)SVGAttributeKeys.STROKE_CAP.get(this) != 0) {
                width += strokeTotalWidth * 2.0;
            }
            Geom.grow(this.cachedDrawingArea, width, width);
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public int findSegment(Point2D.Double find, double tolerance) {
        if (SVGAttributeKeys.TRANSFORM.get(this) != null) {
            try {
                find = (Point2D.Double)((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this)).inverseTransform(find, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                System.err.println("Warning: SVGBezierFigure.findSegment. Figure has noninvertible Transform.");
            }
        }
        return this.getBezierPath().findSegment(find, tolerance);
    }

    @Override
    public boolean joinSegments(Point2D.Double join, double tolerance) {
        int i;
        if (SVGAttributeKeys.TRANSFORM.get(this) != null) {
            try {
                join = (Point2D.Double)((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this)).inverseTransform(join, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                System.err.println("Warning: SVGBezierFigure.findSegment. Figure has noninvertible Transform.");
            }
        }
        if ((i = this.getBezierPath().findSegment(join, tolerance)) != -1 && i > 1) {
            this.removeNode(i);
            return true;
        }
        return false;
    }

    @Override
    public int splitSegment(Point2D.Double split, double tolerance) {
        int i;
        if (SVGAttributeKeys.TRANSFORM.get(this) != null) {
            try {
                split = (Point2D.Double)((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this)).inverseTransform(split, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                System.err.println("Warning: SVGBezierFigure.findSegment. Figure has noninvertible Transform.");
            }
        }
        if ((i = this.getBezierPath().findSegment(split, tolerance)) != -1) {
            this.addNode(i + 1, new BezierPath.Node(split));
        }
        return i + 1;
    }

    public void flattenTransform() {
        if (SVGAttributeKeys.TRANSFORM.get(this) != null) {
            this.path.transform((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this));
            SVGAttributeKeys.TRANSFORM.basicSet(this, null);
        }
        this.invalidate();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedDrawingArea = null;
    }
}

