/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jhotdraw.draw.DefaultDrawingViewTransferHandler;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;

public class DnDDrawingViewTransferHandler
extends DefaultDrawingViewTransferHandler {
    private static final boolean DEBUG = false;

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        boolean success;
        HashSet<Figure> transferFigures = new HashSet<Figure>();
        boolean bl = success = support.getComponent() instanceof JComponent ? this.importData((JComponent)support.getComponent(), support.getTransferable(), transferFigures) : false;
        if (success) {
            DrawingView view = (DrawingView)((Object)support.getComponent());
            Point dropPoint = support.getDropLocation().getDropPoint();
            Point2D.Double drawingDropPoint = view.viewToDrawing(dropPoint);
            Rectangle2D.Double drawingArea = null;
            for (Figure fig : transferFigures) {
                if (drawingArea == null) {
                    drawingArea = fig.getDrawingArea();
                    continue;
                }
                drawingArea.add(fig.getDrawingArea());
            }
            AffineTransform t = new AffineTransform();
            t.translate(-drawingArea.x, -drawingArea.y);
            t.translate(drawingDropPoint.x, drawingDropPoint.y);
            t.translate(drawingArea.width / -2.0, drawingArea.height / -2.0);
            for (Figure fig : transferFigures) {
                fig.willChange();
                fig.transform(t);
                fig.changed();
            }
        }
        return success;
    }
}

