/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import org.jhotdraw.color.AbstractHarmonicRule;
import org.jhotdraw.color.CompositeColor;
import org.jhotdraw.color.HarmonicColorModel;

public class SimpleHarmonicRule
extends AbstractHarmonicRule {
    private float difference;
    private int componentIndex;

    public SimpleHarmonicRule(int componentIndex, float difference, int baseIndex, int ... derivedIndices) {
        this.componentIndex = componentIndex;
        this.difference = difference;
        this.baseIndex = baseIndex;
        this.derivedIndices = derivedIndices;
    }

    public void setConstraint(float constraint) {
        this.difference = constraint;
    }

    public float getConstraint(float constraint) {
        return constraint;
    }

    public void setComponentIndex(int newValue) {
        this.componentIndex = newValue;
    }

    public int getComponentIndex() {
        return this.componentIndex;
    }

    @Override
    public void apply(HarmonicColorModel model) {
        CompositeColor baseColor;
        if (this.derivedIndices != null && (baseColor = model.get(this.getBaseIndex())) != null) {
            float[] derivedComponents = null;
            for (int i = 0; i < this.derivedIndices.length; ++i) {
                derivedComponents = baseColor.getComponents(derivedComponents);
                derivedComponents[this.componentIndex] = baseColor.getComponent(this.componentIndex) + this.difference * (float)(i + 1);
                model.set(this.derivedIndices[i], new CompositeColor(model.getColorSystem(), derivedComponents));
            }
        }
    }

    @Override
    public void colorChanged(HarmonicColorModel model, int index, CompositeColor oldValue, CompositeColor newValue) {
    }
}

