/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.Point;
import org.jhotdraw.color.ColorSystem;
import org.jhotdraw.color.ColorWheelImageProducer;
import org.jhotdraw.color.HSLRYBColorSystem;

public class HSLHarmonicColorWheelImageProducer
extends ColorWheelImageProducer {
    private float[] brights;
    private boolean isDiscrete = true;

    public HSLHarmonicColorWheelImageProducer(int w, int h) {
        super(new HSLRYBColorSystem(), w, h);
    }

    public HSLHarmonicColorWheelImageProducer(ColorSystem sys, int w, int h) {
        super(sys, w, h);
    }

    @Override
    protected void generateLookupTables() {
        this.isDiscrete = false;
        if (this.isDiscrete) {
            this.generateDiscreteLookupTables();
        } else {
            this.generateContiguousLookupTables();
        }
    }

    protected void generateContiguousLookupTables() {
        this.radials = new float[this.w * this.h];
        this.angulars = new float[this.w * this.h];
        this.brights = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float radius = this.getRadius();
        float blend = (radius + 2.0f) / radius - 1.0f;
        int cx = this.w / 2;
        int cy = this.h / 2;
        for (int x = 0; x < this.w; ++x) {
            int kx = x - cx;
            int squarekx = kx * kx;
            for (int y = 0; y < this.h; ++y) {
                float r;
                int ky = cy - y;
                int index = x + y * this.w;
                float sat = r = (float)Math.sqrt(squarekx + ky * ky) / radius;
                if (r <= 1.0f) {
                    this.alphas[index] = -16777216;
                    this.radials[index] = 1.0f;
                    this.brights[index] = 1.0f - sat;
                } else {
                    this.alphas[index] = (int)((blend - Math.min(blend, r - 1.0f)) * 255.0f / blend) << 24;
                    this.radials[index] = 1.0f;
                    this.brights[index] = 0.0f;
                }
                if (this.alphas[index] == 0) continue;
                this.angulars[index] = (float)(Math.atan2(ky, kx) / Math.PI / 2.0);
            }
        }
    }

    protected void generateDiscreteLookupTables() {
        this.radials = new float[this.w * this.h];
        this.angulars = new float[this.w * this.h];
        this.brights = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float radius = this.getRadius();
        float blend = (radius + 2.0f) / radius - 1.0f;
        int cx = this.w / 2;
        int cy = this.h / 2;
        for (int x = 0; x < this.w; ++x) {
            int kx = x - cx;
            int squarekx = kx * kx;
            for (int y = 0; y < this.h; ++y) {
                float r;
                int ky = cy - y;
                int index = x + y * this.w;
                float sat = r = (float)Math.sqrt(squarekx + ky * ky) / radius;
                if (r <= 1.0f) {
                    this.alphas[index] = -16777216;
                    this.radials[index] = 1.0f;
                    this.brights[index] = (float)Math.round((1.0f - sat) * 12.0f) / 12.0f;
                } else {
                    this.alphas[index] = (int)((blend - Math.min(blend, r - 1.0f)) * 255.0f / blend) << 24;
                    this.radials[index] = 1.0f;
                    this.brights[index] = 0.0f;
                }
                if (this.alphas[index] == 0) continue;
                this.angulars[index] = (float)Math.round((float)(Math.atan2(ky, kx) / Math.PI / 2.0) * 12.0f) / 12.0f;
            }
        }
    }

    @Override
    public void generateColorWheel() {
        float radius = Math.min(this.w, this.h);
        for (int index = 0; index < this.pixels.length; ++index) {
            if (this.alphas[index] == 0) continue;
            this.pixels[index] = this.alphas[index] | 0xFFFFFF & this.colorSystem.toRGB(this.angulars[index], this.radials[index], this.brights[index]);
        }
        this.newPixels();
        this.isPixelsValid = false;
    }

    @Override
    protected Point getColorLocation(Color c, int width, int height) {
        float[] hsb = new float[3];
        hsb = this.colorSystem.toComponents(c.getRGB(), hsb);
        return this.getColorLocation(hsb[0], hsb[1], hsb[2], width, height);
    }

    @Override
    protected Point getColorLocation(float hue, float saturation, float brightness, int width, int height) {
        float radius = (float)Math.min(width, height) / 2.0f;
        float radiusH = radius / 2.0f;
        saturation = Math.max(0.0f, Math.min(1.0f, saturation));
        brightness = Math.max(0.0f, Math.min(1.0f, brightness));
        Point p = new Point(width / 2 + (int)((double)(radius - radius * brightness) * Math.cos((double)hue * Math.PI * 2.0)), height / 2 - (int)((double)(radius - radius * brightness) * Math.sin((double)hue * Math.PI * 2.0)));
        return p;
    }

    @Override
    protected float[] getColorAt(int x, int y, int width, int height) {
        float r = (float)Math.sqrt((x -= width / 2) * x + (y -= height / 2) * y);
        float theta = (float)Math.atan2(-y, x);
        float radius = (float)Math.min(width, height) / 2.0f;
        float sat = r / radius;
        float hue = (float)((double)theta / Math.PI / 2.0);
        if (hue < 0.0f) {
            hue += 1.0f;
        }
        float[] hsb = new float[]{hue, 1.0f, 1.0f - sat};
        return hsb;
    }
}

