/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.customizer;

import java.text.SimpleDateFormat;
import net.sf.nachocalendar.components.CalendarPanel;
import net.sf.nachocalendar.components.DateField;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.components.DayRenderer;
import net.sf.nachocalendar.components.HeaderRenderer;
import net.sf.nachocalendar.customizer.Customizer;
import net.sf.nachocalendar.customizer.PropertiesSetter;
import net.sf.nachocalendar.model.DataModel;

public class DirectSetter
implements PropertiesSetter {
    private boolean initialized;
    private boolean allowsInvalid;
    private boolean printMoon;
    private boolean showOkCancel;
    private boolean showToday;
    private boolean antiAliased;
    private int firstDayOfWeek = 1;
    private Class headerRenderer;
    private Class model;
    private Class renderer;
    private String todayCaption;
    private boolean[] workingDays;
    private int selectionMode = 2;
    private int orientation = 0;
    private int scrollPosition = 0;
    private int yearPosition = 0;
    private String dateFormat;

    public DirectSetter(Customizer customizer) {
        this.init(customizer);
    }

    public DirectSetter() {
    }

    public void setCustomizer(Customizer customizer) {
        this.init(customizer);
    }

    private void init(Customizer customizer) {
        String yearposition;
        String scrollposition;
        String orientation;
        String selection;
        String model;
        String headerRenderer;
        String first = customizer.getString("firstDayOfWeek");
        if (first != null && first.toLowerCase().equals("monday")) {
            this.firstDayOfWeek = 2;
        }
        this.allowsInvalid = customizer.getBoolean("allowsInvalid");
        this.antiAliased = customizer.getBoolean("antiAliased");
        String dateFormat = customizer.getString("dateFormat");
        if (dateFormat != null) {
            this.dateFormat = dateFormat;
        }
        if ((headerRenderer = customizer.getString("headerRenderer")) != null) {
            this.headerRenderer = this.loadClass(headerRenderer);
        }
        if ((model = customizer.getString("model")) != null) {
            this.model = this.loadClass(model);
        }
        this.printMoon = customizer.getBoolean("printMoon");
        String renderer = customizer.getString("renderer");
        if (renderer != null) {
            this.renderer = this.loadClass(renderer);
        }
        this.showOkCancel = customizer.getBoolean("showOkCancel");
        this.showToday = customizer.getBoolean("showToday");
        this.todayCaption = customizer.getString("todayCaption");
        String workingDays = customizer.getString("workingDays");
        if (workingDays != null) {
            String[] work = workingDays.split(",");
            boolean[] wd = new boolean[7];
            for (int i = 0; i < work.length && i != 7; ++i) {
                wd[i] = Boolean.valueOf(work[i]);
            }
            this.workingDays = wd;
        }
        if ((selection = customizer.getString("selectionMode")) != null) {
            if (selection.toLowerCase().equals("singleinterval")) {
                this.selectionMode = 1;
            }
            if (selection.toLowerCase().equals("singleselection")) {
                this.selectionMode = 0;
            }
        }
        if ((orientation = customizer.getString("orientation")) != null && orientation.toLowerCase().equals("vertical")) {
            this.orientation = 1;
        }
        if ((scrollposition = customizer.getString("scrollPosition")) != null && scrollposition.toLowerCase().equals("right")) {
            this.scrollPosition = 1;
        }
        if ((yearposition = customizer.getString("yearPosition")) != null && yearposition.toLowerCase().equals("down")) {
            this.yearPosition = 1;
        }
        this.initialized = true;
    }

    private Class loadClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void customize(DateField datefield) {
        if (!this.initialized) {
            throw new IllegalStateException("This setter is not initialized.");
        }
        datefield.setFirstDayOfWeek(this.firstDayOfWeek);
        datefield.setAllowsInvalid(this.allowsInvalid);
        datefield.setAntiAliased(this.antiAliased);
        if (this.dateFormat != null) {
            datefield.setDateFormat(new SimpleDateFormat(this.dateFormat));
        }
        if (this.headerRenderer != null) {
            try {
                datefield.setHeaderRenderer((HeaderRenderer)this.headerRenderer.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.model != null) {
            try {
                datefield.setModel((DataModel)this.model.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        datefield.setPrintMoon(this.printMoon);
        if (this.renderer != null) {
            try {
                datefield.setRenderer((DayRenderer)this.renderer.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        datefield.setShowOkCancel(this.showOkCancel);
        datefield.setShowToday(this.showToday);
        if (this.todayCaption != null) {
            datefield.setTodayCaption(this.todayCaption);
        }
        if (this.workingDays != null) {
            datefield.setWorkingDays(this.workingDays);
        }
    }

    @Override
    public void customize(CalendarPanel calendarpanel) {
        if (!this.initialized) {
            throw new IllegalStateException("This setter is not initialized.");
        }
        calendarpanel.setFirstDayOfWeek(this.firstDayOfWeek);
        calendarpanel.setAntiAliased(this.antiAliased);
        calendarpanel.setSelectionMode(this.selectionMode);
        if (this.headerRenderer != null) {
            try {
                calendarpanel.setHeaderRenderer((HeaderRenderer)this.headerRenderer.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.model != null) {
            try {
                calendarpanel.setModel((DataModel)this.model.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        calendarpanel.setPrintMoon(this.printMoon);
        if (this.renderer != null) {
            try {
                calendarpanel.setRenderer((DayRenderer)this.renderer.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        calendarpanel.setShowToday(this.showToday);
        if (this.todayCaption != null) {
            calendarpanel.setTodayCaption(this.todayCaption);
        }
        if (this.workingDays != null) {
            calendarpanel.setWorkingdays(this.workingDays);
        }
        calendarpanel.setOrientation(this.orientation);
        calendarpanel.setScrollPosition(this.scrollPosition);
        calendarpanel.setYearPosition(this.yearPosition);
    }

    @Override
    public void customize(DatePanel datepanel) {
        if (!this.initialized) {
            throw new IllegalStateException("This setter is not initialized.");
        }
        datepanel.setFirstDayOfWeek(this.firstDayOfWeek);
        datepanel.setAntiAliased(this.antiAliased);
        datepanel.setSelectionMode(this.selectionMode);
        if (this.headerRenderer != null) {
            try {
                datepanel.setHeaderRenderer((HeaderRenderer)this.headerRenderer.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.model != null) {
            try {
                datepanel.setModel((DataModel)this.model.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        datepanel.setPrintMoon(this.printMoon);
        if (this.renderer != null) {
            try {
                datepanel.setRenderer((DayRenderer)this.renderer.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        datepanel.setShowToday(this.showToday);
        if (this.todayCaption != null) {
            datepanel.setTodayCaption(this.todayCaption);
        }
        if (this.workingDays != null) {
            datepanel.setWorkingDays(this.workingDays);
        }
    }
}

