/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.Utils;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.Http;
import org.yccheok.jstock.trading.api.HttpRespond;
import org.yccheok.jstock.trading.api.Order;
import org.yccheok.jstock.trading.api.SessionManager;

public class OrderManager {
    private static final Log log = LogFactory.getLog(OrderManager.class);

    private OrderManager() {
    }

    public static Pair<Order, String> createOrder(OrderSide orderSide, OrderType orderType, Map<String, Object> params) {
        String url = "orders";
        ArrayList<String> INPUT_FIELDS = new ArrayList<String>(Arrays.asList("symbol", "instrumentID", "accountID", "accountNo", "userID", "accountType", "ordType", "side", "comment", "orderQty", "amountCash", "autoStop", "price", "limitPrice"));
        ArrayList<String> RESULT_FIELDS = new ArrayList<String>(Arrays.asList("execID", "orderID", "orderNo", "cumQty", "instrumentID", "execType", "grossTradeAmt", "ordType", "side", "ordStatus", "limitPrice", "timeInForce", "expireTimestamp", "statusPath", "leavesQty"));
        String logType = orderSide.key.toLowerCase() + "_" + SessionManager.getInstance().getUser().getActiveAccount().accType.code;
        HttpRespond respond = Http.post(url, params, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            log.error((Object)"Create Status error - Http");
            Utils.remoteLog(logType, -1, "", params);
            return new Pair<Object, String>(null, ApiError.commonMsg());
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Create Order error, code: " + error.code + ", message: " + error.message));
            Utils.remoteLog(logType, statusCode, error.message, params);
            return new Pair<Object, String>(null, error.getMsg());
        }
        Utils.remoteLog(logType, statusCode, "", params);
        return new Pair<Order, Object>(new Order(result), null);
    }

    public static Pair<Order, String> orderStatus(String orderID) {
        OrdStatus ordStatusEnum;
        String url = "orders/" + orderID;
        ArrayList<String> RESULT_FIELDS = new ArrayList<String>(Arrays.asList("orderID", "accountID", "userID", "cumQty", "accountNo", "comment", "commission", "createdByID", "createdWhen", "executedWhen", "execType", "grossTradeAmt", "instrumentID", "leavesQty", "orderNo", "orderQty", "ordStatus", "ordType", "side", "accountType", "autoStop", "ordRejReason", "isoTimeRestingOrderExpires", "price", "limitPrice", "timeInForce"));
        HttpRespond respond = Http.get(url, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            log.error((Object)"Order Status error - Http");
            return new Pair<Object, String>(null, ApiError.commonMsg());
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            if (error == null) {
                log.error((Object)("Order Status error [No Error code + message], status code: " + statusCode));
                return new Pair<Object, String>(null, ApiError.commonMsg());
            }
            log.error((Object)("Order Status error, code: " + error.code + ", message: " + error.message));
            String errMsg = error.getMsg();
            if (statusCode == 404) {
                errMsg = "404 " + errMsg;
            }
            return new Pair<Object, String>(null, errMsg);
        }
        double cumQty = 0.0;
        double leavesQty = 0.0;
        double orderQty = 0.0;
        String execType = "";
        String ordStatus = "";
        if (result.containsKey("cumQty")) {
            cumQty = (Double)result.get("cumQty");
        }
        if (result.containsKey("leavesQty")) {
            leavesQty = (Double)result.get("leavesQty");
        }
        if (result.containsKey("orderQty")) {
            orderQty = (Double)result.get("orderQty");
        }
        if (result.containsKey("execType")) {
            execType = result.get("execType").toString();
        }
        if (result.containsKey("ordStatus")) {
            ordStatus = result.get("ordStatus").toString();
        }
        String ordRejReason = "";
        if (orderQty == leavesQty && execType.equals("0") && ordStatus.equals("0")) {
            ordStatusEnum = OrdStatus.NEW;
        } else if (orderQty > cumQty && execType.equals("1") && ordStatus.equals("1")) {
            ordStatusEnum = OrdStatus.PARTIAL_FILLED;
        } else if (orderQty == cumQty && execType.equals("2") && ordStatus.equals("2")) {
            ordStatusEnum = OrdStatus.FILLED;
        } else if (leavesQty == 0.0 && execType.equals("4") && ordStatus.equals("4")) {
            ordStatusEnum = OrdStatus.CANCELED;
        } else if (leavesQty == 0.0 && execType.equals("8") && ordStatus.equals("8")) {
            ordStatusEnum = OrdStatus.REJECTED;
            ordRejReason = result.get("ordRejReason").toString();
        } else {
            log.warn((Object)("Unknown order status - Set as NEW / ACCEPTED, orderQty: " + orderQty + ", leavesQty: " + leavesQty + ", cumQty:" + cumQty + ", execType: " + execType + ", ordStatus: " + ordStatus));
            ordStatusEnum = OrdStatus.NEW;
        }
        result.put("ordStatusEnum", ordStatusEnum);
        log.info((Object)("Order Status, ID: " + orderID + ", status: " + ordStatusEnum.toString() + ", Reason: " + ordRejReason));
        return new Pair<Order, Object>(new Order(result), null);
    }

    public static Pair<Boolean, String> cancelOrder(String orderID) {
        String url = "orders/" + orderID;
        HttpRespond respond = Http.delete(url, SessionManager.getInstance().getSessionKey());
        String logType = "cancel_" + SessionManager.getInstance().getUser().getActiveAccount().accType.code.toLowerCase();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderID", orderID);
        params.put("userID", SessionManager.getInstance().getUser().userID);
        params.put("accountID", SessionManager.getInstance().getUser().getActiveAccount().accountID);
        params.put("accountNo", SessionManager.getInstance().getUser().getActiveAccount().accountNo);
        if (respond == null) {
            log.error((Object)"Cancel Order error - Http");
            Utils.remoteLog(logType, -1, "", params);
            return new Pair<Boolean, String>(false, ApiError.commonMsg());
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Cancel Order error, code: " + error.code + ", message: " + error.message));
            Utils.remoteLog(logType, statusCode, error.message, params);
            return new Pair<Boolean, String>(false, error.getMsg());
        }
        Utils.remoteLog(logType, statusCode, "", params);
        return new Pair<Boolean, Object>(true, null);
    }

    public static enum OrdStatus {
        NEW("0", "New"),
        PARTIAL_FILLED("1", "Partial_filled"),
        FILLED("2", "Filled"),
        CANCELED("4", "Canceled"),
        REJECTED("8", "Rejected");

        public final String value;
        public final String key;

        private OrdStatus(String value, String key) {
            this.value = value;
            this.key = key;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.key);
        }
    }

    public static enum OrderType {
        MARKET(1, "Market_order"),
        LIMIT(2, "Limit_order"),
        STOP(3, "Stop_order");

        public final int value;
        private final String key;

        private OrderType(int value, String key) {
            this.value = value;
            this.key = key;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.key);
        }
    }

    public static enum OrderSide {
        BUY("B", "Buy"),
        SELL("S", "Sell");

        public final String value;
        public final String key;

        private OrderSide(String value, String key) {
            this.value = value;
            this.key = key;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.key);
        }
    }
}

