/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.trading.api.DriveWealth;
import org.yccheok.jstock.trading.api.HttpRespond;

public class Http {
    private static final Log log = LogFactory.getLog(Http.class);
    private static final MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private static final HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);

    private Http() {
    }

    public static HttpMethod setJsonHeader(HttpMethod httpMethod, String sessionKey) {
        httpMethod.addRequestHeader("Accept", "application/json");
        httpMethod.addRequestHeader("Content-Type", "application/json");
        if (sessionKey != null) {
            httpMethod.addRequestHeader("x-mysolomeo-session-key", sessionKey);
        }
        return httpMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRespond executeCall(HttpMethod httpMethod) {
        int statusCode;
        try {
            statusCode = httpClient.executeMethod(httpMethod);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        String respond = null;
        try {
            StringBuilder resultStr = new StringBuilder();
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(httpMethod.getResponseBodyAsStream()));){
                String line;
                while ((line = rd.readLine()) != null) {
                    resultStr.append(line);
                }
                respond = resultStr.toString();
            }
            finally {
                httpMethod.releaseConnection();
            }
        }
        catch (Throwable ex) {
            return null;
        }
        return new HttpRespond(statusCode, respond);
    }

    public static HttpRespond get(String url, String sessionKey) {
        GetMethod getMethod = new GetMethod(DriveWealth.config.apiURL + url);
        getMethod = (GetMethod)Http.setJsonHeader((HttpMethod)getMethod, sessionKey);
        return Http.executeCall((HttpMethod)getMethod);
    }

    public static HttpRespond getPlainText(String url) {
        GetMethod getMethod = new GetMethod(DriveWealth.config.apiURL + url);
        getMethod.addRequestHeader("Accept", "text/plain");
        getMethod.addRequestHeader("Content-Type", "text/plain");
        return Http.executeCall((HttpMethod)getMethod);
    }

    public static HttpRespond post(String url, Map<String, Object> params, String sessionKey, String server) {
        String host;
        StringRequestEntity requestEntity;
        Gson gson = new Gson();
        String paramsJson = gson.toJson(params);
        try {
            requestEntity = new StringRequestEntity(paramsJson, "application/json", "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        switch (server) {
            case "apiServer": {
                host = DriveWealth.config.apiURL;
                break;
            }
            case "reportServer": {
                host = DriveWealth.config.reportURL;
                break;
            }
            default: {
                log.error((Object)("[Http.Post] unknown server: " + server));
                return null;
            }
        }
        PostMethod postMethod = new PostMethod(host + url);
        postMethod.setRequestEntity((RequestEntity)requestEntity);
        postMethod = (PostMethod)Http.setJsonHeader((HttpMethod)postMethod, sessionKey);
        return Http.executeCall((HttpMethod)postMethod);
    }

    public static HttpRespond post(String url, Map<String, Object> params, String sessionKey) {
        return Http.post(url, params, sessionKey, "apiServer");
    }

    public static HttpRespond put(String url, Map<String, Object> params, String sessionKey) {
        StringRequestEntity requestEntity;
        Gson gson = new Gson();
        String paramsJson = gson.toJson(params);
        try {
            requestEntity = new StringRequestEntity(paramsJson, "application/json", "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        PutMethod putMethod = new PutMethod(DriveWealth.config.apiURL + url);
        putMethod.setRequestEntity((RequestEntity)requestEntity);
        putMethod = (PutMethod)Http.setJsonHeader((HttpMethod)putMethod, sessionKey);
        return Http.executeCall((HttpMethod)putMethod);
    }

    public static HttpRespond delete(String url, String sessionKey) {
        DeleteMethod deleteMethod = new DeleteMethod(DriveWealth.config.apiURL + url);
        deleteMethod = (DeleteMethod)Http.setJsonHeader((HttpMethod)deleteMethod, sessionKey);
        return Http.executeCall((HttpMethod)deleteMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean postSaveReportToFile(String url, String filename, String sessionKey) {
        int statusCode;
        PostMethod postMethod = new PostMethod(DriveWealth.config.reportURL + url);
        postMethod = (PostMethod)Http.setJsonHeader((HttpMethod)postMethod, sessionKey);
        try {
            statusCode = httpClient.executeMethod((HttpMethod)postMethod);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        if (statusCode != 200) {
            log.error((Object)("HTTP status code error - " + statusCode));
            return null;
        }
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            in = new BufferedInputStream(postMethod.getResponseBodyAsStream());
            fout = new FileOutputStream(filename);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            Boolean bl = null;
            return bl;
        }
        finally {
            postMethod.releaseConnection();
            try {
                if (in != null) {
                    in.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        return true;
    }
}

