/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.util.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.trading.AccountSummary;
import org.yccheok.jstock.trading.OpenPosition;
import org.yccheok.jstock.trading.PendingOrder;
import org.yccheok.jstock.trading.Transaction;
import org.yccheok.jstock.trading.Utils;
import org.yccheok.jstock.trading.api.AccountBlotter;
import org.yccheok.jstock.trading.api.AccountManager;
import org.yccheok.jstock.trading.api.Instrument;
import org.yccheok.jstock.trading.api.InstrumentManager;
import org.yccheok.jstock.trading.api.MarketData;
import org.yccheok.jstock.trading.api.MarketDataManager;
import org.yccheok.jstock.trading.api.User;

public class PortfolioService
extends ScheduledService<Map<String, Object>> {
    private static final Log log = LogFactory.getLog(PortfolioService.class);
    private final User user;
    private List<OpenPosition> posList = null;
    private List<PendingOrder> ordList = null;
    private List<Transaction> txnList = null;
    private AccountSummary accModel = null;
    private Set symbolsSet = null;
    private final Map<String, Instrument> instruments = new HashMap<String, Instrument>();
    private TaskState taskState = TaskState.ACC_BLOTTER;
    public MarketDataManager.MarketState marketState = MarketDataManager.MarketState.OPEN;
    public long lastUpdateTimestamp;
    private static final int PRICE_REFRESH_PERIOD_HIGH = 30;
    private static final int PRICE_REFRESH_PERIOD_LOW = 5;
    private static final int ACC_BLOT_REFRESH_PERIOD_HIGH = 300;
    private static final int ACC_BLOT_REFRESH_PERIOD_LOW = 30;
    private int priceRefreshPeriod = 30;
    private int accBlotRefreshPeriod = 300;
    private long accBlotStartTime;
    private long accBlotElapsedTime = 0L;

    public PortfolioService(User user) {
        this.user = user;
        this.setPeriod(Duration.ZERO);
        this.setDelay(Duration.ZERO);
    }

    public void updateTaskState() {
        switch (this.taskState) {
            case ACC_BLOTTER: {
                this.taskState = TaskState.INSTRUMENTS;
                this.setPeriod(Duration.ZERO);
                this.accBlotStartTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
                break;
            }
            case INSTRUMENTS: {
                this.taskState = TaskState.PRICES;
                this.setPeriod(Duration.ZERO);
                break;
            }
            case PRICES: {
                this.updateRefreshPeriod();
                break;
            }
        }
    }

    private void updateRefreshPeriod() {
        this.priceRefreshPeriod = 30;
        this.accBlotRefreshPeriod = 300;
        if (this.marketState == MarketDataManager.MarketState.OPEN) {
            if (this.posList != null && !this.posList.isEmpty() || this.ordList != null && !this.ordList.isEmpty()) {
                this.priceRefreshPeriod = 5;
            }
            if (this.ordList != null && !this.ordList.isEmpty()) {
                this.accBlotRefreshPeriod = 30;
            }
        }
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        this.accBlotElapsedTime = now - this.accBlotStartTime;
        if (this.accBlotElapsedTime > (long)this.accBlotRefreshPeriod) {
            this.taskState = TaskState.ACC_BLOTTER;
            this.setPeriod(Duration.ZERO);
            return;
        }
        this.setPeriod(Duration.seconds((double)this.priceRefreshPeriod));
    }

    protected Task<Map<String, Object>> createTask() {
        return new PortfolioTask();
    }

    public void restart() {
        this.taskState = TaskState.ACC_BLOTTER;
        super.restart();
    }

    private class PortfolioTask
    extends Task<Map<String, Object>> {
        private void getAccBlotter() {
            AccountBlotter accBlot = AccountManager.accBlotter(((PortfolioService)PortfolioService.this).user.userID, ((PortfolioService)PortfolioService.this).user.getActiveAccount().accountID);
            if (accBlot == null) {
                log.error((Object)"[getAccBlotter] Error");
                return;
            }
            PortfolioService.this.posList = accBlot.getPositions();
            PortfolioService.this.ordList = accBlot.getOrders();
            PortfolioService.this.txnList = accBlot.getTransactions();
            PortfolioService.this.accModel = accBlot.getAccSummary();
            PortfolioService.this.symbolsSet = accBlot.getSymbols();
            log.info((Object)"[getAccBlotter] DONE calling AccountManager.accBlotter()");
        }

        private void getInstruments() {
            for (String symbol : PortfolioService.this.symbolsSet) {
                if (PortfolioService.this.instruments.containsKey(symbol)) continue;
                Map<String, Instrument> portIns = Portfolio.getInstance().getInstruments();
                if (portIns.containsKey(symbol)) {
                    PortfolioService.this.instruments.put(symbol, portIns.get(symbol));
                    continue;
                }
                List<Instrument> insList = InstrumentManager.searchExactSymbol(symbol);
                if (insList == null || insList.isEmpty()) continue;
                Instrument ins = insList.get(0);
                PortfolioService.this.instruments.put(symbol, ins);
            }
        }

        private Map<String, Double> getMarketPrices() {
            if (PortfolioService.this.symbolsSet == null || PortfolioService.this.symbolsSet.isEmpty()) {
                return new HashMap<String, Double>();
            }
            ArrayList<String> symbols = new ArrayList<String>(PortfolioService.this.symbolsSet);
            Map<String, Object> result = MarketDataManager.getMarketDataAsText(symbols, true);
            if (result == null || result.isEmpty()) {
                return new HashMap<String, Double>();
            }
            PortfolioService.this.marketState = (MarketDataManager.MarketState)((Object)result.get("marketState"));
            String datetime = (String)result.get("timestamp");
            List data = (List)result.get("data");
            PortfolioService.this.lastUpdateTimestamp = Utils.utcDateToTimestamp(datetime);
            HashMap<String, Double> prices = new HashMap<String, Double>();
            if (data != null) {
                for (MarketData marketData : data) {
                    prices.put(marketData.symbol, marketData.lastTrade);
                }
            }
            return prices;
        }

        protected Map<String, Object> call() throws Exception {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("state", (Object)PortfolioService.this.taskState);
            if (this.isCancelled()) {
                return null;
            }
            if (PortfolioService.this.taskState == TaskState.ACC_BLOTTER) {
                this.getAccBlotter();
                result.put("posList", PortfolioService.this.posList);
                result.put("ordList", PortfolioService.this.ordList);
                result.put("txnList", PortfolioService.this.txnList);
                result.put("accModel", PortfolioService.this.accModel);
                log.info((Object)"[Task] DONE calling getAccBlotter()");
            } else if (PortfolioService.this.taskState == TaskState.INSTRUMENTS) {
                this.getInstruments();
                result.put("instruments", PortfolioService.this.instruments);
                log.info((Object)"[Task] DONE calling getInstruments()");
            }
            if (this.isCancelled()) {
                return null;
            }
            Map<String, Double> prices = this.getMarketPrices();
            result.put("marketPrices", prices);
            result.put("marketState", (Object)PortfolioService.this.marketState);
            log.info((Object)"DONE calling get market prices...");
            if (this.isCancelled()) {
                return null;
            }
            return result;
        }
    }

    public static enum TaskState {
        ACC_BLOTTER,
        INSTRUMENTS,
        PRICES;

    }
}

