/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.treetable;

import java.util.Arrays;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.PortfolioManagementJPanel;
import org.yccheok.jstock.gui.treetable.AbstractPortfolioTreeTableModelEx;
import org.yccheok.jstock.gui.treetable.AbstractSortableTreeTableNode;
import org.yccheok.jstock.gui.treetable.DoubleWithCurrency;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.DecimalPlace;
import org.yccheok.jstock.portfolio.DoubleWrapper;
import org.yccheok.jstock.portfolio.Portfolio;
import org.yccheok.jstock.portfolio.PortfolioRealTimeInfo;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;
import org.yccheok.jstock.portfolio.Utils;

public class BuyPortfolioTreeTableModelEx
extends AbstractPortfolioTreeTableModelEx {
    private PortfolioRealTimeInfo portfolioRealTimeInfo = new PortfolioRealTimeInfo();
    private PortfolioManagementJPanel portfolioManagementJPanel = null;
    private static final String[] columnNames;
    private static final Class[] cTypes;

    public void bind(PortfolioRealTimeInfo portfolioRealTimeInfo) {
        this.portfolioRealTimeInfo = portfolioRealTimeInfo;
        Portfolio portfolio = (Portfolio)this.getRoot();
        portfolio.bind(portfolioRealTimeInfo);
    }

    public void bind(PortfolioManagementJPanel portfolioManagementJPanel) {
        this.portfolioManagementJPanel = portfolioManagementJPanel;
    }

    public BuyPortfolioTreeTableModelEx() {
        super(Arrays.asList(columnNames));
    }

    public boolean split(StockInfo stockInfo, double ratio) {
        boolean status = false;
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        TransactionSummary transactionSummary = null;
        for (int i = 0; i < count; ++i) {
            transactionSummary = (TransactionSummary)portfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            if (transaction.getStockInfo().code.equals(stockInfo.code)) break;
        }
        if (null == transactionSummary) {
            return status;
        }
        int num = transactionSummary.getChildCount();
        for (int i = 0; i < num; ++i) {
            Transaction transaction = (Transaction)transactionSummary.getChildAt(i);
            double quantity = transaction.getQuantity() * ratio;
            double price = transaction.getPrice() / ratio;
            this.editTransaction(transaction.deriveWithQuantity(quantity).deriveWithPrice(price), transaction);
            status = true;
        }
        return status;
    }

    public void refreshRoot() {
        this.fireTreeTableNodeChanged(this.getRoot());
    }

    public boolean refresh(Code code) {
        Transaction transaction;
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        AbstractSortableTreeTableNode transactionSummary = null;
        for (int i = 0; i < count; ++i) {
            TransactionSummary ts = (TransactionSummary)portfolio.getChildAt(i);
            assert (ts.getChildCount() > 0);
            transaction = (Transaction)ts.getChildAt(0);
            if (!transaction.getStockInfo().code.equals(code)) continue;
            transactionSummary = ts;
            break;
        }
        if (null == transactionSummary) {
            return false;
        }
        int num = transactionSummary.getChildCount();
        if (num == 0) {
            return false;
        }
        for (int i = 0; i < num; ++i) {
            transaction = (Transaction)transactionSummary.getChildAt(i);
            this.modelSupport.fireChildChanged(new TreePath(this.getPathToRoot((TreeTableNode)transaction)), i, (Object)transaction);
        }
        this.fireTreeTableNodeChanged((TreeTableNode)transactionSummary);
        this.fireTreeTableNodeChanged(this.getRoot());
        return true;
    }

    public double getCurrentValue(Transaction transaction) {
        Code code = transaction.getStockInfo().code;
        Double price = this.portfolioRealTimeInfo.stockPrices.get(code);
        if (price == null) {
            return 0.0;
        }
        return price * transaction.getQuantity();
    }

    public double getCurrentValue(TransactionSummary transactionSummary) {
        Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
        Code code = transaction.getStockInfo().code;
        Double price = this.portfolioRealTimeInfo.stockPrices.get(code);
        if (price == null) {
            return 0.0;
        }
        return price * transactionSummary.getQuantity();
    }

    public double getCurrentPrice(Transaction transaction) {
        Code code = transaction.getStockInfo().code;
        Double price = this.portfolioRealTimeInfo.stockPrices.get(code);
        if (price == null) {
            return 0.0;
        }
        return price;
    }

    public double getCurrentPrice(TransactionSummary transactionSummary) {
        Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
        Code code = transaction.getStockInfo().code;
        Double price = this.portfolioRealTimeInfo.stockPrices.get(code);
        if (price == null) {
            return 0.0;
        }
        return price;
    }

    public double getGainLossValue(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        return this.getCurrentValue(localCurrency) - portfolio.getTotal(localCurrency);
    }

    public double getGainLossPercentage(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        double total = portfolio.getTotal(localCurrency);
        if (total == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(localCurrency) - total) / total * 100.0;
    }

    public double getGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transactionSummary) - transactionSummary.getTotal()) / transactionSummary.getTotal() * 100.0;
    }

    public double getNetGainLossValue(TransactionSummary transactionSummary) {
        return this.getCurrentValue(transactionSummary) - transactionSummary.getNetTotal();
    }

    public double getNetGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transactionSummary) - transactionSummary.getNetTotal()) / transactionSummary.getNetTotal() * 100.0;
    }

    public double getGainLossPercentage(Transaction transaction) {
        if (transaction.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transaction) - transaction.getTotal()) / transaction.getTotal() * 100.0;
    }

    public double getNetGainLossValue(Transaction transaction) {
        return this.getCurrentValue(transaction) - transaction.getNetTotal();
    }

    public double getNetGainLossPercentage(Transaction transaction) {
        if (transaction.getNetTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transaction) - transaction.getNetTotal()) / transaction.getNetTotal() * 100.0;
    }

    public double getNetGainLossValue(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        return this.getCurrentValue(localCurrency) - portfolio.getNetTotal(localCurrency);
    }

    public double getNetGainLossPercentage(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        double netTotal = portfolio.getNetTotal(localCurrency);
        if (netTotal == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(localCurrency) - netTotal) / netTotal * 100.0;
    }

    public double getCurrentValue(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        double result = 0.0;
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = portfolio.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            assert (transactionSummary.getChildCount() > 0);
            double currentValue = this.getCurrentValue(transactionSummary);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            Code code = transaction.getStockInfo().code;
            double exchangeRate = Utils.getExchangeRate(this.portfolioRealTimeInfo, localCurrency, code);
            result += currentValue * exchangeRate;
        }
        return result;
    }

    public double getNetPurchaseValue(Currency localCurrency) {
        return ((Portfolio)this.getRoot()).getNetTotal(localCurrency);
    }

    public double getPurchaseValue(Currency localCurrency) {
        return ((Portfolio)this.getRoot()).getTotal(localCurrency);
    }

    public double getPurchasePrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return transactionSummary.getTotal() / transactionSummary.getQuantity();
    }

    public double getGainLossPrice(Transaction transaction) {
        return this.getCurrentPrice(transaction) - transaction.getPrice();
    }

    public double getGainLossPrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return this.getCurrentPrice(transactionSummary) - transactionSummary.getTotal() / transactionSummary.getQuantity();
    }

    public double getGainLossValue(TransactionSummary transactionSummary) {
        return this.getCurrentValue(transactionSummary) - transactionSummary.getTotal();
    }

    public double getGainLossValue(Transaction transaction) {
        return this.getCurrentValue(transaction) - transaction.getTotal();
    }

    @Override
    public int getColumnCount() {
        assert (columnNames.length == cTypes.length);
        return columnNames.length;
    }

    @Override
    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Currency stockCurrency;
        boolean shouldConvertPenceToPound;
        Code code;
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        DecimalPlace decimalPlace = JStock.instance().getJStockOptions().getDecimalPlace();
        if (node instanceof Portfolio) {
            Currency localCurrency = Utils.getLocalCurrency();
            Portfolio portfolio = (Portfolio)node;
            switch (column) {
                case 0: {
                    return GUIBundle.getString("PortfolioManagementJPanel_Buy");
                }
                case 6: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(decimalPlace, portfolio.getNetTotal(localCurrency));
                    }
                    return new DoubleWrapper(decimalPlace, portfolio.getTotal(localCurrency));
                }
                case 7: {
                    return new DoubleWrapper(decimalPlace, this.getCurrentValue(localCurrency));
                }
                case 8: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(decimalPlace, this.getNetGainLossValue(localCurrency));
                    }
                    return new DoubleWrapper(decimalPlace, this.getGainLossValue(localCurrency));
                }
                case 9: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlace.Two, this.getNetGainLossPercentage(localCurrency));
                    }
                    return new DoubleWrapper(DecimalPlace.Two, this.getGainLossPercentage(localCurrency));
                }
                case 10: {
                    return new DoubleWrapper(decimalPlace, portfolio.getBroker());
                }
                case 11: {
                    return new DoubleWrapper(decimalPlace, portfolio.getClearingFee());
                }
                case 12: {
                    return new DoubleWrapper(decimalPlace, portfolio.getStampDuty());
                }
                case 13: {
                    return portfolio.getComment();
                }
            }
        }
        if (node instanceof TransactionSummary) {
            TransactionSummary transactionSummary = (TransactionSummary)node;
            if (transactionSummary.getChildCount() <= 0) {
                return null;
            }
            code = ((Transaction)transactionSummary.getChildAt((int)0)).getStockInfo().code;
            shouldConvertPenceToPound = Utils.shouldConvertPenceToPound(this.portfolioRealTimeInfo, code);
            boolean shouldDisplayCurrencyForValue = this.portfolioManagementJPanel.shouldDisplayCurrencyForValue(code);
            stockCurrency = shouldDisplayCurrencyForValue ? Utils.getStockCurrency(this.portfolioRealTimeInfo, code) : null;
            switch (column) {
                case 0: {
                    return ((Transaction)transactionSummary.getChildAt((int)0)).getStockInfo().symbol;
                }
                case 1: {
                    return ((Transaction)transactionSummary.getChildAt((int)0)).getStockInfo().code;
                }
                case 3: {
                    return transactionSummary.getQuantity();
                }
                case 4: {
                    return new DoubleWrapper(decimalPlace, this.getPurchasePrice(transactionSummary));
                }
                case 5: {
                    return new DoubleWrapper(decimalPlace, this.getCurrentPrice(transactionSummary));
                }
                case 6: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getNetTotal());
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getTotal());
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getNetTotal() / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getTotal() / 100.0);
                }
                case 7: {
                    if (!shouldConvertPenceToPound) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getCurrentValue(transactionSummary));
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getCurrentValue(transactionSummary) / 100.0);
                }
                case 8: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getNetGainLossValue(transactionSummary));
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getGainLossValue(transactionSummary));
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getNetGainLossValue(transactionSummary) / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getGainLossValue(transactionSummary) / 100.0);
                }
                case 9: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlace.Two, this.getNetGainLossPercentage(transactionSummary));
                    }
                    return new DoubleWrapper(DecimalPlace.Two, this.getGainLossPercentage(transactionSummary));
                }
                case 10: {
                    return new DoubleWrapper(decimalPlace, transactionSummary.getBroker());
                }
                case 11: {
                    return new DoubleWrapper(decimalPlace, transactionSummary.getClearingFee());
                }
                case 12: {
                    return new DoubleWrapper(decimalPlace, transactionSummary.getStampDuty());
                }
                case 13: {
                    return transactionSummary.getComment();
                }
            }
        }
        if (node instanceof Transaction) {
            Transaction transaction = (Transaction)node;
            code = transaction.getStockInfo().code;
            shouldConvertPenceToPound = Utils.shouldConvertPenceToPound(this.portfolioRealTimeInfo, code);
            boolean shouldDisplayCurrencyInfoForValue = this.portfolioManagementJPanel.shouldDisplayCurrencyForValue(code);
            stockCurrency = shouldDisplayCurrencyInfoForValue ? Utils.getStockCurrency(this.portfolioRealTimeInfo, code) : null;
            switch (column) {
                case 0: {
                    return transaction.getStockInfo().symbol;
                }
                case 1: {
                    return transaction.getStockInfo().code;
                }
                case 2: {
                    return transaction.getDate();
                }
                case 3: {
                    return transaction.getQuantity();
                }
                case 4: {
                    return transaction.getPrice();
                }
                case 5: {
                    return this.getCurrentPrice(transaction);
                }
                case 6: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getNetTotal());
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getTotal());
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getNetTotal() / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getTotal() / 100.0);
                }
                case 7: {
                    if (!shouldConvertPenceToPound) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getCurrentValue(transaction));
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getCurrentValue(transaction) / 100.0);
                }
                case 8: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getNetGainLossValue(transaction));
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getGainLossValue(transaction));
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getNetGainLossValue(transaction) / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getGainLossValue(transaction) / 100.0);
                }
                case 9: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlace.Two, this.getNetGainLossPercentage(transaction));
                    }
                    return new DoubleWrapper(DecimalPlace.Two, this.getGainLossPercentage(transaction));
                }
                case 10: {
                    return new DoubleWrapper(decimalPlace, transaction.getBroker());
                }
                case 11: {
                    return new DoubleWrapper(decimalPlace, transaction.getClearingFee());
                }
                case 12: {
                    return new DoubleWrapper(decimalPlace, transaction.getStampDuty());
                }
                case 13: {
                    return transaction.getComment();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isValidTransaction(Transaction transaction) {
        return transaction.getType() == Contract.Type.Buy;
    }

    static {
        String[] tmp = new String[]{GUIBundle.getString("PortfolioManagementJPanel_Stock"), GUIBundle.getString("PortfolioManagementJPanel_Code"), GUIBundle.getString("PortfolioManagementJPanel_Date"), GUIBundle.getString("PortfolioManagementJPanel_Units"), GUIBundle.getString("PortfolioManagementJPanel_PurchasePrice"), GUIBundle.getString("PortfolioManagementJPanel_CurrentPrice"), GUIBundle.getString("PortfolioManagementJPanel_PurchaseValue"), GUIBundle.getString("PortfolioManagementJPanel_CurrentValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossPercentage"), GUIBundle.getString("PortfolioManagementJPanel_Broker"), GUIBundle.getString("PortfolioManagementJPanel_ClearingFee"), GUIBundle.getString("PortfolioManagementJPanel_StampDuty"), GUIBundle.getString("PortfolioManagementJPanel_Comment")};
        columnNames = tmp;
        cTypes = new Class[]{TreeTableModel.class, Code.class, SimpleDate.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, String.class};
    }
}

