/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.internationalization.DriveWealthBundle;

public class TnC {
    private static final TnC INSTANCE = new TnC();
    private static final Log log = LogFactory.getLog(TnC.class);
    private HBox hBox;
    private Hyperlink finra;
    private Hyperlink spic;
    private Hyperlink tnc;
    private Hyperlink privacy;
    private Hyperlink disclaimer;

    public static TnC getInstance() {
        return INSTANCE;
    }

    public HBox show() {
        this.initUI();
        return this.hBox;
    }

    public void initUI() {
        Label label1 = new Label(DriveWealthBundle.getString("Securities_through") + " DriveWealth, LLC \u2022 Member ");
        this.finra = new Hyperlink("FINRA");
        Label label2 = new Label(" / ");
        this.spic = new Hyperlink("SPIC");
        Label label3 = new Label(" \u2022 ");
        this.tnc = new Hyperlink(DriveWealthBundle.getString("Terms_of_use"));
        Label label4 = new Label(" \u2022 ");
        this.privacy = new Hyperlink(DriveWealthBundle.getString("Privacy_policy"));
        Label label5 = new Label(" \u2022 ");
        this.disclaimer = new Hyperlink(DriveWealthBundle.getString("Additional_disclaimers"));
        label1.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        label2.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        label3.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        label4.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        label5.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        this.finra.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        this.spic.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        this.tnc.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        this.privacy.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        this.disclaimer.getStyleClass().addAll((Object[])new String[]{"disclaimer"});
        this.hBox = new HBox();
        this.hBox.setAlignment(Pos.CENTER);
        this.hBox.getChildren().addAll((Object[])new Node[]{label1, this.finra, label2, this.spic, label3, this.tnc, label4, this.privacy, label5, this.disclaimer});
        TnC.setURLHandler(this.finra, "http://brokercheck.finra.org/Firm/Summary/165429");
        TnC.setURLHandler(this.spic, "http://sipc.org/");
        TnC.setURLHandler(this.tnc, "https://drivewealth.com/terms-of-use");
        TnC.setURLHandler(this.privacy, "https://drivewealth.com/privacy-policy");
        TnC.setURLHandler(this.disclaimer, "https://drivewealth.com/disclosures-disclaimers?lang=en_US");
    }

    private static void setURLHandler(Hyperlink link, String url) {
        link.setOnAction(e -> GUIUtils.openURLInBrowser(url));
    }
}

