/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.controlsfx.dialog.Wizard;
import org.controlsfx.dialog.WizardPane;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.TradingView;
import org.yccheok.jstock.gui.trading.UploadDoc;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.AccountManager;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.Country;
import org.yccheok.jstock.trading.api.CountryUtils;
import org.yccheok.jstock.trading.api.DriveWealth;
import org.yccheok.jstock.trading.api.SessionManager;
import org.yccheok.jstock.trading.api.User;

public class LiveAccSignUp
extends Wizard {
    private static final Log log = LogFactory.getLog(LiveAccSignUp.class);
    private WizardPage1 page1;
    private WizardPage2 page2;
    private WizardPage3 page3;
    private WizardPage4 page4;
    private WizardPage5 page5;
    private WizardPage6 page6;
    private WizardPage7 page7;
    private WizardPage8 page8;
    private WizardPage9 page9;

    public LiveAccSignUp() {
        super(null);
        this.setTitle(DriveWealthBundle.getString("Open_live_account"));
        this.page1 = new WizardPage1();
        this.page2 = new WizardPage2();
        this.page3 = new WizardPage3();
        this.page4 = new WizardPage4();
        this.page5 = new WizardPage5();
        this.page6 = new WizardPage6();
        this.page7 = new WizardPage7();
        this.page8 = new WizardPage8();
        this.page9 = new WizardPage9();
        Wizard.Flow branchingFlow = new Wizard.Flow(){

            public Optional<WizardPane> advance(WizardPane currentPage) {
                return Optional.of(this.getNext(currentPage));
            }

            public boolean canAdvance(WizardPane currentPage) {
                return currentPage != LiveAccSignUp.this.page9;
            }

            private WizardPane getNext(WizardPane currentPage) {
                if (currentPage == null) {
                    return LiveAccSignUp.this.page1;
                }
                if (currentPage == LiveAccSignUp.this.page1) {
                    return LiveAccSignUp.this.page2;
                }
                if (currentPage == LiveAccSignUp.this.page2) {
                    return LiveAccSignUp.this.page3;
                }
                if (currentPage == LiveAccSignUp.this.page3) {
                    if (((LiveAccSignUp)LiveAccSignUp.this).page1.jointAccYesRb.isSelected()) {
                        return LiveAccSignUp.this.page4;
                    }
                    return LiveAccSignUp.this.page5;
                }
                if (currentPage == LiveAccSignUp.this.page4) {
                    return LiveAccSignUp.this.page5;
                }
                if (currentPage == LiveAccSignUp.this.page5) {
                    return LiveAccSignUp.this.page6;
                }
                if (currentPage == LiveAccSignUp.this.page6) {
                    return LiveAccSignUp.this.page7;
                }
                if (currentPage == LiveAccSignUp.this.page7) {
                    return LiveAccSignUp.this.page8;
                }
                return LiveAccSignUp.this.page9;
            }
        };
        this.setFlow(branchingFlow);
    }

    public Boolean isJointAccount() {
        ObservableMap settings = this.getSettings();
        return (Boolean)settings.get((Object)"jointAcc_yes");
    }

    public Boolean isUSCitizen() {
        ObservableMap settings = this.getSettings();
        return (Boolean)settings.get((Object)"usCitizen_yes");
    }

    public String getCitizenCode() {
        ObservableMap settings = this.getSettings();
        String code3Letter = this.isUSCitizen() != false ? "USA" : ((Country)settings.get((Object)"citizenship")).code3Letter;
        return code3Letter;
    }

    private String getCountryCode() {
        ObservableMap settings = this.getSettings();
        return ((Country)settings.get((Object)"countryID")).code3Letter;
    }

    Map<String, Object> getParams() {
        ObservableMap settings = this.getSettings();
        Map<String, Object> param_1 = this.page1.getParams((ObservableMap<String, Object>)settings);
        Map<String, Object> param_2 = this.page2.getParams((ObservableMap<String, Object>)settings);
        Map<String, Object> param_3 = this.page3.getParams((ObservableMap<String, Object>)settings);
        Map<String, Object> param_4 = this.page4.getParams((ObservableMap<String, Object>)settings);
        Map<String, Object> param_5 = this.page5.getParams((ObservableMap<String, Object>)settings);
        Map<String, Object> param_6 = this.page6.getParams((ObservableMap<String, Object>)settings);
        Map<String, Object> param_7 = this.page7.getParams((ObservableMap<String, Object>)settings);
        Map<String, Object> param_8 = this.page8.getParams((ObservableMap<String, Object>)settings);
        Map<String, Object> param_9 = this.page9.getParams((ObservableMap<String, Object>)settings);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(param_1);
        params.putAll(param_2);
        params.putAll(param_3);
        params.putAll(param_4);
        params.putAll(param_5);
        params.putAll(param_6);
        params.putAll(param_7);
        params.putAll(param_8);
        params.putAll(param_9);
        User user = SessionManager.getInstance().getUser();
        Pair<String, String> login = SessionManager.getInstance().getUsernamePassword();
        String password = (String)login.second;
        params.put("userID", user.userID);
        params.put("emailAddress1", user.getEmailAddress1());
        params.put("firstName", user.firstName);
        params.put("lastName", user.lastName);
        params.put("username", user.username);
        params.put("password", password);
        params.put("accountMgmtType", 0);
        return params;
    }

    class WizardPage9
    extends AccWizardPane {
        public final TextField signature = new TextField();
        public final TextField jointSignature = new TextField();
        private VBox piBox;
        private Task task;
        private boolean firstTime = true;
        private WebEngine webEngine;
        private StackPane webViewStack;
        private ProgressBar webViewPb;
        private VBox webViewPbBox;

        public WizardPage9() {
            this.addTaxDisclosure();
            this.addSignature();
            this.headerLbl1.setText(DriveWealthBundle.getString("Digital_signature"));
            this.headerLbl2.setText(DriveWealthBundle.getString("Digital_signature_required_to_open_account"));
        }

        private void addTaxDisclosure() {
            this.webViewStack = new StackPane();
            WebView browser = new WebView();
            this.webEngine = browser.getEngine();
            browser.setPrefHeight(300.0);
            browser.setMaxHeight(300.0);
            this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                    if (newState == Worker.State.SUCCEEDED || newState == Worker.State.FAILED || newState == Worker.State.CANCELLED) {
                        WizardPage9.this.webViewStack.getChildren().remove((Object)WizardPage9.this.webViewPbBox);
                        if (newState == Worker.State.SUCCEEDED) {
                            WizardPage9.this.signature.setDisable(false);
                        }
                    }
                }
            });
            this.webViewStack.getChildren().add((Object)browser);
            this.grid.add((Node)this.webViewStack, 0, this.row++, 2, 1);
        }

        private void addSignature() {
            Label label = this.addQuestions(DriveWealthBundle.getString("Primary_account_signature"))[0];
            GridPane.setMargin((Node)label, (Insets)new Insets(30.0, 0.0, 0.0, 0.0));
            this.signature.setId("ackSignedBy");
            this.addAnswerRowSpan((Node)this.signature);
            Label label2 = this.addQuestions(DriveWealthBundle.getString("Joint_account_holder_signature"))[0];
            this.jointSignature.setId("ackJointSignedBy");
            this.addAnswerRowSpan((Node)this.jointSignature);
            label2.managedProperty().bind((ObservableValue)label2.visibleProperty());
            this.jointSignature.managedProperty().bind((ObservableValue)this.jointSignature.visibleProperty());
            label2.visibleProperty().bind((ObservableValue)this.jointSignature.visibleProperty());
            label.disableProperty().bind((ObservableValue)this.signature.disableProperty());
            label2.disableProperty().bind((ObservableValue)this.jointSignature.disableProperty());
            this.jointSignature.disableProperty().bind((ObservableValue)this.signature.disableProperty());
        }

        private void fieldsValidation() {
            this.vs = new ValidationSupport();
            this.vs.initInitialDecoration();
            Platform.runLater(() -> {
                this.vs.registerValidator((Control)this.signature, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Signature_required")));
                if (LiveAccSignUp.this.isJointAccount().booleanValue()) {
                    this.vs.registerValidator((Control)this.jointSignature, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Joint_account_signature_required")));
                }
            });
        }

        @Override
        public void onEnteringPage(Wizard wizard) {
            boolean showJoint = LiveAccSignUp.this.isJointAccount();
            this.jointSignature.setVisible(showJoint);
            this.fieldsValidation();
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)this.vs.invalidProperty());
            if (this.firstTime) {
                this.finishBtnHandler();
                this.firstTime = false;
            }
            this.loadDisclosure();
        }

        private void loadDisclosure() {
            String citizen = LiveAccSignUp.this.getCitizenCode();
            String country = LiveAccSignUp.this.getCountryCode();
            String type = LiveAccSignUp.this.isJointAccount() != false ? "Joint" : "Individual";
            String url = DriveWealth.disclosuresURL(citizen, country, type, true);
            this.webEngine.load(url);
            this.webViewPb = new ProgressBar();
            this.webViewPb.progressProperty().bind((ObservableValue)this.webEngine.getLoadWorker().progressProperty());
            this.webViewPbBox = new VBox();
            this.webViewPbBox.setAlignment(Pos.CENTER);
            this.webViewPbBox.setMaxHeight(30.0);
            this.webViewPbBox.getChildren().add((Object)this.webViewPb);
            this.webViewStack.getChildren().add((Object)this.webViewPbBox);
            this.signature.setDisable(true);
        }

        public Map<String, Object> getParams(ObservableMap<String, Object> settings) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String ackSignedBy = (String)settings.get((Object)"ackSignedBy");
            if (ackSignedBy == null || ackSignedBy.isEmpty()) {
                return params;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            String currTime = sdf.format(System.currentTimeMillis());
            Boolean isJointAcc = LiveAccSignUp.this.isJointAccount();
            if (isJointAcc.booleanValue()) {
                String ackJointSignedBy = (String)settings.get((Object)"ackJointSignedBy");
                if (ackJointSignedBy == null || ackJointSignedBy.isEmpty()) {
                    return params;
                }
                params.put("ackJointSignedBy", ackJointSignedBy);
                params.put("ackJointSignedWhen", currTime);
                params.put("ackJointSigned", true);
            }
            params.put("ackSignedBy", ackSignedBy);
            params.put("ackSignedWhen", currTime);
            params.put("ackSigned", true);
            return params;
        }

        private void finishBtnHandler() {
            final Button cancelBtn = (Button)this.lookupButton(ButtonType.CANCEL);
            Button finishBtn = (Button)this.lookupButton(ButtonType.FINISH);
            finishBtn.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent ev) {
                    ev.consume();
                    String ackSignedBy = WizardPage9.this.signature.getText().trim();
                    String ackJointSignedBy = WizardPage9.this.jointSignature.getText().trim();
                    ObservableMap settings = LiveAccSignUp.this.getSettings();
                    settings.put((Object)"ackSignedBy", (Object)ackSignedBy);
                    settings.put((Object)"ackJointSignedBy", (Object)ackJointSignedBy);
                    WizardPage9.this.task = (Task)new Task<Boolean>(){

                        protected Boolean call() throws Exception {
                            Boolean success = WizardPage9.this.createLiveAcc();
                            if (!success.booleanValue()) {
                                return false;
                            }
                            Pair<String, String> credential = SessionManager.getInstance().getUsernamePassword();
                            String username = (String)credential.first;
                            String password = (String)credential.second;
                            Pair<String, String> login = SessionManager.getInstance().login(username, password, null);
                            String error = (String)login.second;
                            return error == null;
                        }
                    };
                    Thread thread = new Thread((Runnable)WizardPage9.this.task);
                    thread.start();
                    WizardPage9.this.task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                        public void handle(WorkerStateEvent workerStateEvent) {
                            Boolean success = (Boolean)workerStateEvent.getSource().getValue();
                            if (!success.booleanValue()) {
                                log.error((Object)"Live Trading account Signup - Failed");
                                WizardPage9.this.showError();
                                return;
                            }
                            WizardPage9.this.showNotBusy();
                            cancelBtn.fire();
                            TradingView.getInstance().showPortfolio();
                            Platform.runLater(() -> {
                                UploadDoc uploadDoc = new UploadDoc();
                                uploadDoc.showAndWait();
                            });
                        }
                    });
                    WizardPage9.this.task.setOnCancelled(e -> {
                        log.error((Object)"Live Trading account Signup Task Cancelled");
                        WizardPage9.this.showError();
                    });
                    WizardPage9.this.task.setOnFailed(e -> {
                        log.error((Object)"Live Trading account Signup Task Failed");
                        WizardPage9.this.showError();
                    });
                    WizardPage9.this.showBusy();
                }
            });
        }

        private boolean createLiveAcc() {
            Map<String, Object> params = LiveAccSignUp.this.getParams();
            Map<String, Object> response = AccountManager.createLiveAccount(params);
            if (response == null || !response.containsKey("userID") || !response.containsKey("username")) {
                log.error((Object)"create Live trading a/c failed");
                return false;
            }
            String userID = response.get("userID").toString();
            String username = response.get("username").toString();
            log.info((Object)("Live a/c created, userID: " + userID + ", username: " + username));
            List<Map<String, Object>> accounts = AccountManager.listAllAccounts(userID);
            if (accounts == null || accounts.isEmpty()) {
                log.error((Object)"Create Live a/c error - List All Accounts API error");
                return false;
            }
            boolean found = false;
            for (Map<String, Object> acc : accounts) {
                double accType = (Double)acc.get("accountType");
                if (accType != SessionManager.AccType.LIVE.value) continue;
                found = true;
                break;
            }
            return found;
        }

        private void showBusy() {
            ProgressIndicator pi = new ProgressIndicator();
            pi.visibleProperty().bind((ObservableValue)this.task.runningProperty());
            this.piBox = new VBox();
            this.piBox.setAlignment(Pos.CENTER);
            this.piBox.getChildren().add((Object)pi);
            this.grid.setDisable(true);
            this.stack.getChildren().add((Object)this.piBox);
            int i = 0;
            while (i < this.getButtonTypes().size()) {
                Node btn = this.lookupButton((ButtonType)this.getButtonTypes().get(i++));
                btn.visibleProperty().unbind();
                btn.visibleProperty().bind((ObservableValue)this.task.runningProperty().not());
            }
        }

        private void showNotBusy() {
            this.grid.setDisable(false);
            this.stack.getChildren().remove((Object)this.piBox);
        }

        private void showError() {
            this.showNotBusy();
            Alert alert = GUIUtils.alertDlg(Alert.AlertType.ERROR, DriveWealthBundle.getString("Open_live_account_fail"), null, ApiError.commonMsg());
            alert.show();
        }
    }

    class WizardPage8
    extends AccWizardPane {
        public final CheckBox agreeCheckBox = new CheckBox();
        public final CheckBox jointAgreeCheckBox = new CheckBox();
        private HBox agreeBox;
        private HBox jointAgreeBox;
        private WebEngine webEngine;
        private StackPane webViewStack;
        private ProgressBar webViewPb;
        private VBox webViewPbBox;

        public WizardPage8() {
            this.addDisclosures();
            this.addAgree();
            this.headerLbl1.setText(DriveWealthBundle.getString("Digital_signature"));
            this.headerLbl2.setText(DriveWealthBundle.getString("Digital_signature_required_to_open_account"));
        }

        private void addDisclosures() {
            this.webViewStack = new StackPane();
            WebView browser = new WebView();
            this.webEngine = browser.getEngine();
            browser.setPrefHeight(300.0);
            browser.setMaxHeight(300.0);
            this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                    if (newState == Worker.State.SUCCEEDED || newState == Worker.State.FAILED || newState == Worker.State.CANCELLED) {
                        WizardPage8.this.webViewStack.getChildren().remove((Object)WizardPage8.this.webViewPbBox);
                        if (newState == Worker.State.SUCCEEDED) {
                            WizardPage8.this.agreeBox.setDisable(false);
                        }
                    }
                }
            });
            this.webViewStack.getChildren().add((Object)browser);
            this.grid.add((Node)this.webViewStack, 0, this.row++, 2, 1);
        }

        private void addAgree() {
            this.agreeCheckBox.setId("disclosureAck");
            this.agreeBox = this.addAgreeBox(this.agreeCheckBox, false);
            GridPane.setMargin((Node)this.agreeBox, (Insets)new Insets(30.0, 0.0, 0.0, 0.0));
            this.jointAgreeCheckBox.setId("jointDisclosureAck");
            this.jointAgreeBox = this.addAgreeBox(this.jointAgreeCheckBox, true);
            GridPane.setMargin((Node)this.jointAgreeBox, (Insets)new Insets(20.0, 0.0, 30.0, 0.0));
            this.jointAgreeBox.managedProperty().bind((ObservableValue)this.jointAgreeBox.visibleProperty());
            this.jointAgreeBox.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    if (newVal.booleanValue()) {
                        GridPane.setMargin((Node)WizardPage8.this.agreeBox, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
                        GridPane.setMargin((Node)WizardPage8.this.jointAgreeBox, (Insets)new Insets(10.0, 0.0, 30.0, 0.0));
                    } else {
                        GridPane.setMargin((Node)WizardPage8.this.agreeBox, (Insets)new Insets(10.0, 0.0, 30.0, 0.0));
                    }
                }
            });
            this.jointAgreeBox.disableProperty().bind((ObservableValue)this.agreeBox.disableProperty());
        }

        private HBox addAgreeBox(CheckBox checkBox, Boolean jointApplicant) {
            HBox hBox = new HBox();
            hBox.setSpacing(10.0);
            String labelTxt = jointApplicant == false ? DriveWealthBundle.getString("Agree_to_all") : DriveWealthBundle.getString("Joint_applicant_agree_to_all");
            Label label = new Label(labelTxt);
            hBox.getChildren().addAll((Object[])new Node[]{checkBox, label});
            this.grid.addRow(this.row++, new Node[]{hBox});
            return hBox;
        }

        private void fieldsValidation() {
            this.vs = new ValidationSupport();
            this.vs.initInitialDecoration();
            Platform.runLater(() -> {
                this.vs.registerValidator((Control)this.agreeCheckBox, (c, newVal) -> ValidationResult.fromErrorIf((Control)c, (String)DriveWealthBundle.getString("Required_to_agree_to_disclosures"), (newVal == false ? 1 : 0) != 0));
                if (LiveAccSignUp.this.isJointAccount().booleanValue()) {
                    this.vs.registerValidator((Control)this.jointAgreeCheckBox, (c, newVal) -> ValidationResult.fromErrorIf((Control)c, (String)DriveWealthBundle.getString("Joint_applicant_required_to_agree_to_disclosures"), (newVal == false ? 1 : 0) != 0));
                }
            });
        }

        @Override
        public void onEnteringPage(Wizard wizard) {
            boolean showJoint = LiveAccSignUp.this.isJointAccount();
            this.jointAgreeBox.setVisible(showJoint);
            this.fieldsValidation();
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)this.vs.invalidProperty());
            this.loadDisclosure();
        }

        private void loadDisclosure() {
            String citizen = LiveAccSignUp.this.getCitizenCode();
            String country = LiveAccSignUp.this.getCountryCode();
            String type = LiveAccSignUp.this.isJointAccount() != false ? "Joint" : "Individual";
            String url = DriveWealth.disclosuresURL(citizen, country, type, false);
            this.webEngine.load(url);
            this.webViewPb = new ProgressBar();
            this.webViewPb.progressProperty().bind((ObservableValue)this.webEngine.getLoadWorker().progressProperty());
            this.webViewPbBox = new VBox();
            this.webViewPbBox.setAlignment(Pos.CENTER);
            this.webViewPbBox.setMaxHeight(30.0);
            this.webViewPbBox.getChildren().add((Object)this.webViewPb);
            this.webViewStack.getChildren().add((Object)this.webViewPbBox);
            this.agreeBox.setDisable(true);
        }

        public Map<String, Object> getParams(ObservableMap<String, Object> settings) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Boolean disclosureAck = (Boolean)settings.get((Object)"disclosureAck");
            if (!disclosureAck.booleanValue()) {
                return params;
            }
            Boolean isJointAcc = LiveAccSignUp.this.isJointAccount();
            Boolean isUSCitizen = LiveAccSignUp.this.isUSCitizen();
            if (isJointAcc.booleanValue()) {
                Boolean jointDisclosureAck = (Boolean)settings.get((Object)"jointDisclosureAck");
                if (!jointDisclosureAck.booleanValue()) {
                    return params;
                }
                params.put("jointDisclosureAck", true);
                params.put("jointDisclosureRule14b", true);
                params.put("ackJointCustomerAgreement", true);
                params.put("ackJointSweep", true);
                params.put("ackJointMarketData", true);
                if (isUSCitizen.booleanValue()) {
                    params.put("ackJointFindersFee", true);
                } else {
                    params.put("ackJointForeignFindersFee", true);
                }
            }
            params.put("disclosureAck", true);
            params.put("disclosureRule14b", true);
            params.put("ackCustomerAgreement", true);
            params.put("ackSweep", true);
            params.put("ackMarketData", true);
            if (isUSCitizen.booleanValue()) {
                params.put("ackFindersFee", true);
            } else {
                params.put("ackForeignFindersFee", true);
            }
            return params;
        }
    }

    class WizardPage7
    extends AccWizardPane {
        private final ChoiceBox<InvestmentObjective> investObjective = new ChoiceBox();
        private final ChoiceBox<InvestmentExperience> investExperience = new ChoiceBox();
        private final ChoiceBox annualIncome = new ChoiceBox();
        private final ChoiceBox liquidNetWorth = new ChoiceBox();
        private final ChoiceBox totalNetWorth = new ChoiceBox();
        private final ChoiceBox<RiskTolerance> riskTolerance = new ChoiceBox();

        public WizardPage7() {
            this.investmentObjectiveExperience();
            this.annualIncomeLiquidNetWorth();
            this.totalNetWorthRiskTolerance();
            this.fieldsValidation();
            this.headerLbl1.setText(DriveWealthBundle.getString("Investment_profile"));
            this.headerLbl2.setText(DriveWealthBundle.getString("Investment_profile_description"));
        }

        public void addQuestionNote(String question, String note, int row, int column) {
            Label label = new Label(question);
            label.getStyleClass().add((Object)"question");
            this.grid.add((Node)label, column, row, 1, 1);
            Label label2 = new Label(note);
            label2.getStyleClass().add((Object)"grey");
            label2.setMaxWidth(400.0);
            label2.setWrapText(true);
            GridPane.setMargin((Node)label2, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
            this.grid.add((Node)label2, column, row + 1, 1, 1);
        }

        private void investmentObjectiveExperience() {
            this.addQuestionNote(DriveWealthBundle.getString("Investment_objective"), DriveWealthBundle.getString("Investment_goal"), this.row, 0);
            this.addQuestionNote(DriveWealthBundle.getString("Investment_experience"), DriveWealthBundle.getString("Describe_investing_experience"), this.row, 1);
            this.row += 2;
            this.investObjective.setId("investmentObjectives");
            this.investObjective.setItems(FXCollections.observableArrayList((Object[])InvestmentObjective.values()));
            this.investExperience.setId("investmentExperience");
            this.investExperience.setItems(FXCollections.observableArrayList((Object[])InvestmentExperience.values()));
            this.addAnswers(new Node[]{this.investObjective, this.investExperience});
        }

        private void annualIncomeLiquidNetWorth() {
            this.addQuestionNote(DriveWealthBundle.getString("Annual_income"), DriveWealthBundle.getString("Derived_from_income_source"), this.row, 0);
            this.addQuestionNote(DriveWealthBundle.getString("Liquid_net_worth"), DriveWealthBundle.getString("Liquid_net_worth_description"), this.row, 1);
            this.row += 2;
            this.annualIncome.setId("annualIncome");
            this.annualIncome.setItems(FXCollections.observableArrayList((Object[])new String[]{"$0 - $24,999", "$25,000 - $99,999", "$100,000 - $199,999", "$200,000+"}));
            this.liquidNetWorth.setId("networthLiquid");
            this.liquidNetWorth.setItems(FXCollections.observableArrayList((Object[])new String[]{"$0 - $4,999", "$5,000 - $99,999", "$100,000 - $199,999", "$200,000+"}));
            this.addAnswers(new Node[]{this.annualIncome, this.liquidNetWorth});
        }

        private void totalNetWorthRiskTolerance() {
            this.addQuestionNote(DriveWealthBundle.getString("Total_net_worth"), DriveWealthBundle.getString("Assets_minus_liabilities"), this.row, 0);
            this.addQuestionNote(DriveWealthBundle.getString("Risk_tolerance"), DriveWealthBundle.getString("Describe_risk_tolerance"), this.row, 1);
            this.row += 2;
            this.totalNetWorth.setId("networthTotal");
            this.totalNetWorth.setItems(FXCollections.observableArrayList((Object[])new String[]{"$0 - $24,999", "$25,000 - $99,999", "$100,000 - $199,999", "$200,000+"}));
            this.riskTolerance.setId("riskTolerance");
            this.riskTolerance.setItems(FXCollections.observableArrayList((Object[])RiskTolerance.values()));
            this.addAnswers(new Node[]{this.totalNetWorth, this.riskTolerance});
        }

        private void fieldsValidation() {
            this.vs = new ValidationSupport();
            this.vs.initInitialDecoration();
            Platform.runLater(() -> {
                this.vs.registerValidator(this.investObjective, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Investment_objective_required")));
                this.vs.registerValidator(this.investExperience, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Investment_experience_required")));
                this.vs.registerValidator((Control)this.annualIncome, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Annual_income_required")));
                this.vs.registerValidator((Control)this.liquidNetWorth, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Liquid_net_worth_required")));
                this.vs.registerValidator((Control)this.totalNetWorth, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Total_net_worth_required")));
                this.vs.registerValidator(this.riskTolerance, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Risk_tolerance_required")));
            });
        }

        public Map<String, Object> getParams(ObservableMap<String, Object> settings) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("investmentObjectives", ((InvestmentObjective)((Object)settings.get((Object)"investmentObjectives"))).value);
            params.put("investmentExperience", ((InvestmentExperience)((Object)settings.get((Object)"investmentExperience"))).value);
            params.put("annualIncome", (String)settings.get((Object)"annualIncome"));
            params.put("networthLiquid", (String)settings.get((Object)"networthLiquid"));
            params.put("networthTotal", (String)settings.get((Object)"networthTotal"));
            params.put("riskTolerance", ((RiskTolerance)((Object)settings.get((Object)"riskTolerance"))).value);
            return params;
        }
    }

    public static enum RiskTolerance {
        CONSERVATIVE("Conservative"),
        MODERATE("Moderate"),
        AGGRESSIVE("Aggressive");

        public final String value;

        private RiskTolerance(String value) {
            this.value = value;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.value);
        }
    }

    public static enum InvestmentExperience {
        NONE("None"),
        LIMITED("Limited"),
        GOOD("Good"),
        EXTENSIVE("Extensive");

        public final String value;

        private InvestmentExperience(String value) {
            this.value = value;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.value);
        }
    }

    public static enum InvestmentObjective {
        CAPITAL_PRESERVATION("Capital Preservation", "Capital_preservation"),
        GROWTH("Growth", "Growth"),
        INCOME("Income", "Income"),
        SPECULATION("Speculation", "Speculation");

        public final String value;
        private final String key;

        private InvestmentObjective(String value, String key) {
            this.value = value;
            this.key = key;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.key);
        }
    }

    class WizardPage6
    extends AccWizardPane {
        String yes = DriveWealthBundle.getString("Yes");
        String no = DriveWealthBundle.getString("No");
        private final RadioButton finraYesRb = new RadioButton(this.yes);
        private final RadioButton finraNoRb = new RadioButton(this.no);
        private final RadioButton directorYesRb = new RadioButton(this.yes);
        private final RadioButton directorNoRb = new RadioButton(this.no);
        private final TextField directorOf = new TextField();
        private final RadioButton politicYesRb = new RadioButton(this.yes);
        private final RadioButton politicNoRb = new RadioButton(this.no);
        private final TextField politicName = new TextField();
        private ToggleGroup finraGroup;
        private ToggleGroup directorGroup;
        private ToggleGroup politicGroup;
        private BooleanBinding finraValid;
        private BooleanBinding directorValid;
        private BooleanBinding politicValid;

        public WizardPage6() {
            this.addFinra();
            this.addDirector();
            this.addPoliticalExposed();
            this.fieldsValidation();
            this.radioBtnValidation();
            this.headerLbl1.setText(DriveWealthBundle.getString("Employment_status"));
            this.headerLbl2.setText(DriveWealthBundle.getString("Employment_info_secure"));
        }

        private void addQuestionNoteRowSpan(String question, String note) {
            this.addQuestionRowSpan(question);
            Label noteLbl = this.addQuestionRowSpan(note);
            noteLbl.getStyleClass().clear();
            noteLbl.getStyleClass().add((Object)"grey");
            GridPane.setMargin((Node)noteLbl, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        }

        private Pair<ToggleGroup, HBox> addRadioBtns(RadioButton rb1, RadioButton rb2) {
            ToggleGroup group = new ToggleGroup();
            rb1.setToggleGroup(group);
            rb2.setToggleGroup(group);
            HBox hBox = new HBox();
            hBox.setAlignment(Pos.CENTER_LEFT);
            hBox.setSpacing(20.0);
            hBox.getChildren().addAll((Object[])new Node[]{rb1, rb2});
            GridPane.setMargin((Node)hBox, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
            this.grid.addRow(this.row++, new Node[]{hBox});
            return new Pair<ToggleGroup, HBox>(group, hBox);
        }

        private VBox addInfoBox(String note, Node node) {
            VBox infoBox = new VBox();
            infoBox.setSpacing(5.0);
            infoBox.setPadding(new Insets(10.0, 10.0, 0.0, 20.0));
            Label noteLbl = new Label(note);
            noteLbl.getStyleClass().add((Object)"bold-italic");
            infoBox.getChildren().add((Object)noteLbl);
            if (node != null) {
                infoBox.getChildren().add((Object)node);
            }
            GridPane.setMargin((Node)infoBox, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
            this.grid.add((Node)infoBox, 0, this.row++, 2, 1);
            return infoBox;
        }

        private VBox addNoteBox(String note) {
            VBox infoBox = new VBox();
            infoBox.setSpacing(5.0);
            infoBox.setPadding(new Insets(10.0, 10.0, 0.0, 20.0));
            Label noteLbl = new Label(note);
            noteLbl.getStyleClass().addAll((Object[])new String[]{"bold-italic", "grey"});
            infoBox.getChildren().add((Object)noteLbl);
            GridPane.setMargin((Node)infoBox, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
            this.grid.add((Node)infoBox, 0, this.row++, 2, 1);
            return infoBox;
        }

        private void toggleShowInfo(ToggleGroup group, final HBox radioBtnBox, final VBox infoBox) {
            infoBox.managedProperty().bind((ObservableValue)infoBox.visibleProperty());
            infoBox.setVisible(false);
            group.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> ov, Toggle oldVal, Toggle newVal) {
                    if (((RadioButton)newVal).getText().equals(DriveWealthBundle.getString("Yes"))) {
                        infoBox.setVisible(true);
                        GridPane.setMargin((Node)radioBtnBox, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
                    } else {
                        infoBox.setVisible(false);
                        GridPane.setMargin((Node)radioBtnBox, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
                    }
                    Window window = WizardPage6.this.getScene().getWindow();
                    window.sizeToScene();
                    WizardPage6.this.fieldsValidation();
                    WizardPage6.this.wizardValidation(LiveAccSignUp.this);
                }
            });
        }

        private void addFinra() {
            this.addQuestionRowSpan(DriveWealthBundle.getString("Employer_is_broker"));
            this.finraYesRb.setId("employerIsBroker_yes");
            this.finraNoRb.setId("employerIsBroker_no");
            Pair<ToggleGroup, HBox> result = this.addRadioBtns(this.finraYesRb, this.finraNoRb);
            this.finraGroup = (ToggleGroup)result.first;
            HBox radioBtnBox = (HBox)result.second;
            VBox infoBox = this.addNoteBox(DriveWealthBundle.getString("Notify_employer"));
            this.toggleShowInfo(this.finraGroup, radioBtnBox, infoBox);
        }

        private void addDirector() {
            this.addQuestionNoteRowSpan(DriveWealthBundle.getString("Director_of_listed_company"), DriveWealthBundle.getString("Is_director"));
            this.directorYesRb.setId("director_yes");
            this.directorNoRb.setId("director_no");
            Pair<ToggleGroup, HBox> result = this.addRadioBtns(this.directorYesRb, this.directorNoRb);
            this.directorGroup = (ToggleGroup)result.first;
            HBox radioBtnBox = (HBox)result.second;
            this.directorOf.setId("directorOf");
            VBox infoBox = this.addInfoBox(DriveWealthBundle.getString("Company_name_symbol"), (Node)this.directorOf);
            this.toggleShowInfo(this.directorGroup, radioBtnBox, infoBox);
        }

        private void addPoliticalExposed() {
            this.addQuestionNoteRowSpan(DriveWealthBundle.getString("Political_exposed_person"), DriveWealthBundle.getString("Political_exposed_description"));
            this.politicYesRb.setId("politicallyExposed_yes");
            this.politicNoRb.setId("politicallyExposed_no");
            Pair<ToggleGroup, HBox> result = this.addRadioBtns(this.politicYesRb, this.politicNoRb);
            this.politicGroup = (ToggleGroup)result.first;
            HBox radioBtnBox = (HBox)result.second;
            this.politicName.setId("politicallyExposedNames");
            VBox infoBox = this.addInfoBox(DriveWealthBundle.getString("Provide_official_name"), (Node)this.politicName);
            this.toggleShowInfo(this.politicGroup, radioBtnBox, infoBox);
        }

        private void fieldsValidation() {
            this.vs = new ValidationSupport();
            this.vs.initInitialDecoration();
            Platform.runLater(() -> {
                if (this.directorYesRb.isSelected()) {
                    this.vs.registerValidator((Control)this.directorOf, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Company_name_symbol_required")));
                }
                if (this.politicYesRb.isSelected()) {
                    this.vs.registerValidator((Control)this.politicName, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Official_name_required")));
                }
            });
        }

        private void radioBtnValidation() {
            String yes = DriveWealthBundle.getString("Yes");
            String no = DriveWealthBundle.getString("No");
            this.finraValid = Bindings.createBooleanBinding(() -> {
                RadioButton rb = (RadioButton)this.finraGroup.getSelectedToggle();
                if (rb == null || rb.getText() == null) {
                    return false;
                }
                return rb.getText().equals(yes) || rb.getText().equals(no);
            }, (Observable[])new Observable[]{this.finraGroup.selectedToggleProperty()});
            this.directorValid = Bindings.createBooleanBinding(() -> {
                RadioButton rb = (RadioButton)this.directorGroup.getSelectedToggle();
                if (rb == null || rb.getText() == null) {
                    return false;
                }
                return rb.getText().equals(yes) || rb.getText().equals(no);
            }, (Observable[])new Observable[]{this.directorGroup.selectedToggleProperty()});
            this.politicValid = Bindings.createBooleanBinding(() -> {
                RadioButton rb = (RadioButton)this.politicGroup.getSelectedToggle();
                if (rb == null || rb.getText() == null) {
                    return false;
                }
                return rb.getText().equals(yes) || rb.getText().equals(no);
            }, (Observable[])new Observable[]{this.politicGroup.selectedToggleProperty()});
        }

        private void wizardValidation(Wizard wizard) {
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)this.finraValid.and((ObservableBooleanValue)this.directorValid).and((ObservableBooleanValue)this.politicValid).not().or((ObservableBooleanValue)this.vs.invalidProperty()));
        }

        @Override
        public void onEnteringPage(Wizard wizard) {
            this.wizardValidation(wizard);
        }

        public Map<String, Object> getParams(ObservableMap<String, Object> settings) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Boolean isBroker = (Boolean)settings.get((Object)"employerIsBroker_yes");
            params.put("employerIsBroker", isBroker);
            Boolean isDirector = (Boolean)settings.get((Object)"director_yes");
            params.put("director", isDirector);
            if (isDirector.booleanValue()) {
                params.put("directorOf", (String)settings.get((Object)"directorOf"));
            }
            Boolean isPolitic = (Boolean)settings.get((Object)"politicallyExposed_yes");
            params.put("politicallyExposed", isPolitic);
            if (isPolitic.booleanValue()) {
                params.put("politicallyExposedNames", (String)settings.get((Object)"politicallyExposedNames"));
            }
            return params;
        }
    }

    class WizardPage5
    extends AccWizardPane {
        private final ChoiceBox<EmploymentStatus> employmentStatus = new ChoiceBox();
        private final TextField employer = new TextField();
        private final ChoiceBox<EmployerBusiness> employerBusiness = new ChoiceBox();
        private final ComboBox<Country> employerCountryCombo = WizardPage5.getCountryCombo();
        private Label employerLbl;
        private Label employerBusinessLbl;
        private Label employerCountryLbl;

        public WizardPage5() {
            this.addEmployment();
            this.addEmployerBinding();
            this.headerLbl1.setText(DriveWealthBundle.getString("Employment_status"));
            this.headerLbl2.setText(DriveWealthBundle.getString("Employment_info_secure"));
        }

        private void addEmployment() {
            this.addQuestions(DriveWealthBundle.getString("Current_employment_status"));
            this.employmentStatus.setId("employmentStatus");
            this.employmentStatus.setItems(FXCollections.observableArrayList((Object[])EmploymentStatus.values()));
            this.addAnswers(new Node[]{this.employmentStatus});
            Label[] labels = this.addQuestions(DriveWealthBundle.getString("Employer"));
            this.employerLbl = labels[0];
            this.employer.setId("employerCompany");
            this.addAnswerRowSpan((Node)this.employer);
            Label[] labels2 = this.addQuestions(DriveWealthBundle.getString("Business_type"), DriveWealthBundle.getString("Employer_country"));
            this.employerBusinessLbl = labels2[0];
            this.employerCountryLbl = labels2[1];
            this.employerBusiness.setId("employerBusiness");
            this.employerBusiness.setItems(FXCollections.observableArrayList((Object[])EmployerBusiness.values()));
            this.employerCountryCombo.setId("employerCountryID");
            this.addAnswers(new Node[]{this.employerBusiness, this.employerCountryCombo});
        }

        private void addEmployerBinding() {
            this.employer.managedProperty().bind((ObservableValue)this.employer.visibleProperty());
            this.employerBusiness.managedProperty().bind((ObservableValue)this.employerBusiness.visibleProperty());
            this.employerCountryCombo.managedProperty().bind((ObservableValue)this.employerCountryCombo.visibleProperty());
            this.employerBusiness.visibleProperty().bind((ObservableValue)this.employer.visibleProperty());
            this.employerCountryCombo.visibleProperty().bind((ObservableValue)this.employer.visibleProperty());
            this.employerLbl.managedProperty().bind((ObservableValue)this.employerLbl.visibleProperty());
            this.employerBusinessLbl.managedProperty().bind((ObservableValue)this.employerBusinessLbl.visibleProperty());
            this.employerCountryLbl.managedProperty().bind((ObservableValue)this.employerCountryLbl.visibleProperty());
            this.employerLbl.visibleProperty().bind((ObservableValue)this.employer.visibleProperty());
            this.employerBusinessLbl.visibleProperty().bind((ObservableValue)this.employer.visibleProperty());
            this.employerCountryLbl.visibleProperty().bind((ObservableValue)this.employer.visibleProperty());
            this.employmentStatus.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<EmploymentStatus>(){

                public void changed(ObservableValue ov, EmploymentStatus oldVal, EmploymentStatus newVal) {
                    if (newVal == null) {
                        return;
                    }
                    boolean employed = false;
                    if (newVal == EmploymentStatus.EMPLOYED) {
                        employed = true;
                    }
                    WizardPage5.this.employer.setVisible(employed);
                    Window window = WizardPage5.this.getScene().getWindow();
                    window.sizeToScene();
                    WizardPage5.this.fieldsValidation(employed);
                    WizardPage5.this.wizardValidation(LiveAccSignUp.this);
                }
            });
            this.employer.setVisible(false);
            this.fieldsValidation(false);
        }

        private void fieldsValidation(boolean validateEmployer) {
            this.vs = new ValidationSupport();
            this.vs.initInitialDecoration();
            Platform.runLater(() -> {
                this.vs.registerValidator(this.employmentStatus, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Employment_status_required")));
                if (validateEmployer) {
                    this.vs.registerValidator((Control)this.employer, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Employer_required")));
                    this.vs.registerValidator(this.employerBusiness, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Employer_business_required")));
                    this.vs.registerValidator(this.employerCountryCombo, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Employer_country_required")));
                }
            });
        }

        private void wizardValidation(Wizard wizard) {
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)this.vs.invalidProperty());
        }

        @Override
        public void onEnteringPage(Wizard wizard) {
            this.wizardValidation(wizard);
            Country employerCountry = (Country)this.employerCountryCombo.getValue();
            if (employerCountry == null) {
                String countryCode = LiveAccSignUp.this.getCountryCode();
                for (Country item : this.employerCountryCombo.getItems()) {
                    if (!item.code3Letter.equals(countryCode)) continue;
                    this.employerCountryCombo.setValue((Object)item);
                    break;
                }
            }
        }

        public Map<String, Object> getParams(ObservableMap<String, Object> settings) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            EmploymentStatus status = (EmploymentStatus)((Object)settings.get((Object)"employmentStatus"));
            params.put("employmentStatus", status.value);
            if (status != EmploymentStatus.EMPLOYED) {
                return params;
            }
            params.put("employerCompany", (String)settings.get((Object)"employerCompany"));
            params.put("employerBusiness", ((EmployerBusiness)((Object)settings.get((Object)"employerBusiness"))).value);
            params.put("employerCountryID", ((Country)settings.get((Object)"employerCountryID")).code3Letter);
            return params;
        }
    }

    public static enum EmployerBusiness {
        AUTOMOBILES_COMPONENTS("Automobiles - Components", "Automobiles_components"),
        CAPITAL_GOODS("Capital Goods", "Capital_goods"),
        CONSTRUCTION("Construction", "Construction"),
        ENERGY("Energy", "Energy"),
        FINANCIAL_SERVICES("Financial Services", "Financial_services"),
        FOOD_AND_BEVERAGE("Food and Beverage", "Food_and_beverage"),
        GOVERNMENT("Government", "Government"),
        HOTELS_RESTAURANT_LEISURE("Hotels Restaurants - Leisure", "Hotels_restaurants_leisure"),
        HOUSEHOLD_PERSONAL_PRODUCTS("Household - Personal Products", "Household_personal_products"),
        HEALTH_CARE_EQUIPMENT("Health Care Equipment - Services", "Health_care_equipment_services"),
        MATERIALS("Materials", "Materials"),
        MEDIA("Media", "Media"),
        PHARMACEUTICALS_BIOTECHNOLOGY("Pharmaceuticals - Biotechnology", "Pharmaceuticals_biotechnology"),
        PROFESSIONAL_SERVICES("Professional Services", "Professional_services"),
        REAL_ESTATE("Real Estate", "Real_estate"),
        RETAILS_SHOPS_AND_SERVICES("Retail Shops and Services", "Retail_shops_and_services"),
        SOFTWARE_SERVICES("Software - Services", "Software_services"),
        TECHNOLOGY_HARDWARE("Technology Hardware - Equipment", "Technology_hardware_equipment"),
        TELECOMMUNICATION_SERVICES("Telecommunication Services", "Telecommunication_services"),
        TRANSPORTATION("Transportation", "Transportation"),
        UTILITIES("Utilities", "Utilities"),
        OTHER("Other", "Other");

        public final String value;
        private final String key;

        private EmployerBusiness(String value, String key) {
            this.value = value;
            this.key = key;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.key);
        }
    }

    public static enum EmploymentStatus {
        EMPLOYED("Employed / Self-Employed", "Employed_self_employed"),
        RETIRED("Retired", "Retired"),
        STUDENT("Student", "Student"),
        NOT_EMPLOYED("Not Employed", "Not_employed");

        public final String value;
        private final String key;

        private EmploymentStatus(String value, String key) {
            this.value = value;
            this.key = key;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.key);
        }
    }

    class WizardPage4
    extends AccWizardPane {
        private final CheckBox jointAddrSame = new CheckBox();
        private final TextField jointAddressLine1 = new TextField();
        private final TextField jointAddressLine2 = new TextField();
        private final TextField jointCity = new TextField();
        private final TextField jointState = new TextField();
        private final TextField jointPostalCode = new TextField();
        private final ComboBox<Country> jointCountryCombo = WizardPage4.getCountryCombo();
        private Label jointAddressLine1Lbl;
        private Label jointCityLbl;
        private Label jointStateLbl;
        private Label jointPostalbl;
        private Label jointCountryLbl;

        public WizardPage4() {
            this.isJointAddrSame();
            this.addJointAddress();
            this.addBinding();
        }

        private void isJointAddrSame() {
            HBox hBox = new HBox();
            hBox.setSpacing(10.0);
            this.jointAddrSame.setId("jointAddrSame");
            Label jointAddrSameLbl = new Label(DriveWealthBundle.getString("Joint_address_same"));
            hBox.getChildren().addAll((Object[])new Node[]{this.jointAddrSame, jointAddrSameLbl});
            this.grid.add((Node)hBox, 0, this.row++, 2, 1);
            GridPane.setMargin((Node)hBox, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
        }

        private void addJointAddress() {
            this.jointAddressLine1Lbl = this.addQuestions(DriveWealthBundle.getString("Joint_street_address"))[0];
            this.jointAddressLine1.setId("jointAddressLine1");
            this.jointAddressLine2.setId("jointAddressLine2");
            this.grid.add((Node)this.jointAddressLine1, 0, this.row++, 2, 1);
            GridPane.setMargin((Node)this.jointAddressLine1, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
            this.grid.add((Node)this.jointAddressLine2, 0, this.row++, 2, 1);
            GridPane.setMargin((Node)this.jointAddressLine2, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
            Label[] labels = this.addQuestions(DriveWealthBundle.getString("Joint_city"), DriveWealthBundle.getString("Joint_state"));
            this.jointCityLbl = labels[0];
            this.jointStateLbl = labels[1];
            this.jointCity.setId("jointCity");
            this.jointState.setId("jointStateProvince");
            this.addAnswers(new Node[]{this.jointCity, this.jointState});
            Label[] labels2 = this.addQuestions(DriveWealthBundle.getString("Joint_zip"), DriveWealthBundle.getString("Joint_country"));
            this.jointPostalbl = labels2[0];
            this.jointCountryLbl = labels2[1];
            this.jointPostalCode.setId("jointZipPostalCode");
            this.jointCountryCombo.setId("jointCountryID");
            this.addAnswers(new Node[]{this.jointPostalCode, this.jointCountryCombo});
        }

        private void addBinding() {
            this.jointAddressLine1.managedProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointAddressLine2.managedProperty().bind((ObservableValue)this.jointAddressLine2.visibleProperty());
            this.jointCity.managedProperty().bind((ObservableValue)this.jointCity.visibleProperty());
            this.jointState.managedProperty().bind((ObservableValue)this.jointState.visibleProperty());
            this.jointPostalCode.managedProperty().bind((ObservableValue)this.jointPostalCode.visibleProperty());
            this.jointCountryCombo.managedProperty().bind((ObservableValue)this.jointCountryCombo.visibleProperty());
            this.jointAddressLine2.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointCity.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointState.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointPostalCode.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointCountryCombo.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointAddressLine1Lbl.managedProperty().bind((ObservableValue)this.jointAddressLine1Lbl.visibleProperty());
            this.jointCityLbl.managedProperty().bind((ObservableValue)this.jointCityLbl.visibleProperty());
            this.jointStateLbl.managedProperty().bind((ObservableValue)this.jointStateLbl.visibleProperty());
            this.jointPostalbl.managedProperty().bind((ObservableValue)this.jointPostalbl.visibleProperty());
            this.jointCountryLbl.managedProperty().bind((ObservableValue)this.jointCountryLbl.visibleProperty());
            this.jointAddressLine1Lbl.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointCityLbl.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointStateLbl.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointPostalbl.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointCountryLbl.visibleProperty().bind((ObservableValue)this.jointAddressLine1.visibleProperty());
            this.jointAddressLine1.visibleProperty().bind((ObservableValue)this.jointAddrSame.selectedProperty().not());
            this.jointAddrSame.setSelected(true);
            this.fieldsValidation();
            this.jointAddrSame.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    Window window = WizardPage4.this.getScene().getWindow();
                    window.sizeToScene();
                    WizardPage4.this.fieldsValidation();
                    WizardPage4.this.wizardValidation(LiveAccSignUp.this);
                }
            });
        }

        private void fieldsValidation() {
            this.vs = new ValidationSupport();
            this.vs.initInitialDecoration();
            if (!this.jointAddrSame.isSelected()) {
                Platform.runLater(() -> {
                    this.vs.registerValidator((Control)this.jointAddressLine1, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Street_address_required")));
                    this.vs.registerValidator((Control)this.jointCity, Validator.createEmptyValidator((String)DriveWealthBundle.getString("City_required")));
                    this.vs.registerValidator((Control)this.jointState, Validator.createEmptyValidator((String)DriveWealthBundle.getString("State_required")));
                    this.vs.registerValidator((Control)this.jointPostalCode, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Zip_required")));
                    this.vs.registerValidator(this.jointCountryCombo, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Country_required")));
                });
            }
        }

        private void wizardValidation(Wizard wizard) {
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)this.vs.invalidProperty());
        }

        @Override
        public void onEnteringPage(Wizard wizard) {
            this.wizardValidation(wizard);
            Country jointCountry = (Country)this.jointCountryCombo.getValue();
            if (jointCountry == null) {
                String countryCode = LiveAccSignUp.this.getCountryCode();
                for (Country item : this.jointCountryCombo.getItems()) {
                    if (!item.code3Letter.equals(countryCode)) continue;
                    this.jointCountryCombo.setValue((Object)item);
                    break;
                }
            }
        }

        public Map<String, Object> getParams(ObservableMap<String, Object> settings) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Boolean isJointAcc = LiveAccSignUp.this.isJointAccount();
            if (!isJointAcc.booleanValue()) {
                return params;
            }
            if (!this.jointAddrSame.isSelected()) {
                params.put("jointAddressLine1", (String)settings.get((Object)"jointAddressLine1"));
                params.put("jointAddressLine2", (String)settings.get((Object)"jointAddressLine2"));
                params.put("jointCity", (String)settings.get((Object)"jointCity"));
                params.put("jointStateProvince", (String)settings.get((Object)"jointStateProvince"));
                params.put("jointZipPostalCode", (String)settings.get((Object)"jointZipPostalCode"));
                params.put("jointCountryID", ((Country)settings.get((Object)"jointCountryID")).code3Letter);
            } else {
                params.put("jointAddressLine1", (String)settings.get((Object)"addressLine1"));
                params.put("jointAddressLine2", (String)settings.get((Object)"addressLine2"));
                params.put("jointCity", (String)settings.get((Object)"city"));
                params.put("jointStateProvince", (String)settings.get((Object)"stateProvince"));
                params.put("jointZipPostalCode", (String)settings.get((Object)"zipPostalCode"));
                params.put("jointCountryID", ((Country)settings.get((Object)"countryID")).code3Letter);
            }
            return params;
        }
    }

    class WizardPage3
    extends AccWizardPane {
        private final TextField addressLine1 = new TextField();
        private final TextField addressLine2 = new TextField();
        private final TextField city = new TextField();
        private final TextField state = new TextField();
        private final ComboBox<Country> countryCombo = WizardPage3.getCountryCombo();
        private final TextField postalCode = new TextField();

        public WizardPage3() {
            this.addAddress();
            this.fieldsValidation();
        }

        private void addAddress() {
            this.addQuestions(DriveWealthBundle.getString("Street_address"));
            this.addressLine1.setId("addressLine1");
            this.addressLine2.setId("addressLine2");
            this.grid.add((Node)this.addressLine1, 0, this.row++, 2, 1);
            GridPane.setMargin((Node)this.addressLine1, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
            this.grid.add((Node)this.addressLine2, 0, this.row++, 2, 1);
            GridPane.setMargin((Node)this.addressLine2, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
            this.addQuestions(DriveWealthBundle.getString("City"), DriveWealthBundle.getString("State"));
            this.city.setId("city");
            this.state.setId("stateProvince");
            this.addAnswers(new Node[]{this.city, this.state});
            this.addQuestions(DriveWealthBundle.getString("Zip"), DriveWealthBundle.getString("Country"));
            this.postalCode.setId("zipPostalCode");
            this.countryCombo.setId("countryID");
            this.addAnswers(new Node[]{this.postalCode, this.countryCombo});
        }

        private void fieldsValidation() {
            Platform.runLater(() -> {
                this.vs.registerValidator((Control)this.addressLine1, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Street_address_required")));
                this.vs.registerValidator((Control)this.city, Validator.createEmptyValidator((String)DriveWealthBundle.getString("City_required")));
                this.vs.registerValidator((Control)this.state, Validator.createEmptyValidator((String)DriveWealthBundle.getString("State_required")));
                this.vs.registerValidator((Control)this.postalCode, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Zip_required")));
                this.vs.registerValidator(this.countryCombo, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Country_required")));
            });
        }

        @Override
        public void onEnteringPage(Wizard wizard) {
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)this.vs.invalidProperty());
            Country country = (Country)this.countryCombo.getValue();
            if (country == null) {
                String citizenCode = LiveAccSignUp.this.getCitizenCode();
                for (Country item : this.countryCombo.getItems()) {
                    if (!item.code3Letter.equals(citizenCode)) continue;
                    this.countryCombo.setValue((Object)item);
                    break;
                }
            }
        }

        public Map<String, Object> getParams(ObservableMap<String, Object> settings) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("addressLine1", (String)settings.get((Object)"addressLine1"));
            params.put("addressLine2", (String)settings.get((Object)"addressLine2"));
            params.put("city", (String)settings.get((Object)"city"));
            params.put("stateProvince", (String)settings.get((Object)"stateProvince"));
            params.put("zipPostalCode", (String)settings.get((Object)"zipPostalCode"));
            params.put("countryID", ((Country)settings.get((Object)"countryID")).code3Letter);
            return params;
        }
    }

    class WizardPage2
    extends AccWizardPane {
        private DatePicker dob = new DatePicker();
        private final TextField phone = new TextField();
        private final ToggleGroup genderGroup = new ToggleGroup();
        private final RadioButton maleRb = new RadioButton(DriveWealthBundle.getString("Male"));
        private final RadioButton femaleRb = new RadioButton(DriveWealthBundle.getString("Female"));
        private final ToggleGroup maritalGroup = new ToggleGroup();
        private final RadioButton singleRb = new RadioButton(DriveWealthBundle.getString("Single"));
        private final RadioButton marriedRb = new RadioButton(DriveWealthBundle.getString("Married"));
        private Label idNumLbl;
        private final TextField idNumber = new TextField();
        private BooleanBinding genderValid;
        private BooleanBinding maritalValid;
        private final BooleanProperty USCitizen = new SimpleBooleanProperty();

        public WizardPage2() {
            this.addDOBPhone();
            this.addGenderMaritalStatus();
            this.addIDNumber();
            this.fieldsValidation();
        }

        private void addDOBPhone() {
            this.addQuestions(DriveWealthBundle.getString("Date_of_birth"), DriveWealthBundle.getString("Phone_number"));
            this.dob.setId("dob");
            this.dob.setEditable(false);
            this.dob = GUIUtils.setDatePickerFormat(this.dob);
            final LocalDate latestDate = LocalDate.now().minusYears(18L);
            Callback dayCellFactory = dp -> new DateCell(){

                public void updateItem(LocalDate item, boolean empty) {
                    super.updateItem(item, empty);
                    if (item.isAfter(latestDate)) {
                        this.setStyle("-fx-background-color: #ffc0cb;");
                        Platform.runLater(() -> this.setDisable(true));
                    }
                }
            };
            this.dob.setDayCellFactory(dayCellFactory);
            this.dob.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    if (newVal.booleanValue() && WizardPage2.this.dob.getValue() == null) {
                        WizardPage2.this.dob.setValue((Object)latestDate);
                    }
                }
            });
            this.phone.setId("phoneHome");
            this.addAnswers(new Node[]{this.dob, this.phone});
        }

        private void addGenderMaritalStatus() {
            this.addQuestions(DriveWealthBundle.getString("Gender"), DriveWealthBundle.getString("Marital_status"));
            this.maleRb.setToggleGroup(this.genderGroup);
            this.femaleRb.setToggleGroup(this.genderGroup);
            this.maleRb.setId("gender_male");
            this.femaleRb.setId("gender_female");
            HBox genderBox = new HBox();
            genderBox.setAlignment(Pos.CENTER_LEFT);
            genderBox.setSpacing(20.0);
            genderBox.getChildren().addAll((Object[])new Node[]{this.maleRb, this.femaleRb});
            this.singleRb.setToggleGroup(this.maritalGroup);
            this.marriedRb.setToggleGroup(this.maritalGroup);
            this.singleRb.setId("maritalStatus_Single");
            this.marriedRb.setId("maritalStatus_Married");
            HBox maritalBox = new HBox();
            maritalBox.setAlignment(Pos.CENTER_LEFT);
            maritalBox.setSpacing(20.0);
            maritalBox.getChildren().addAll((Object[])new Node[]{this.singleRb, this.marriedRb});
            this.addAnswers(new Node[]{genderBox, maritalBox});
        }

        private void addIDNumber() {
            String passport_no = DriveWealthBundle.getString("Passport_government_id_no");
            this.idNumLbl = this.addQuestions(passport_no)[0];
            this.idNumLbl.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (this.USCitizen.getValue() != null && this.USCitizen.getValue().booleanValue()) {
                    return DriveWealthBundle.getString("Social_security_no");
                }
                return passport_no;
            }, (Observable[])new Observable[]{this.USCitizen}));
            this.idNumber.setId("idNo");
            this.addAnswers(new Node[]{this.idNumber});
        }

        private void fieldsValidation() {
            Platform.runLater(() -> {
                this.vs.registerValidator((Control)this.dob, Validator.createEmptyValidator((String)DriveWealthBundle.getString("DOB_required")));
                this.vs.registerValidator((Control)this.phone, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Phone_no_required")));
                String validationTxt = this.idNumLbl.getText().equals(DriveWealthBundle.getString("Passport_government_id_no")) ? DriveWealthBundle.getString("Passport_government_id_no_required") : DriveWealthBundle.getString("Social_security_no_required");
                this.vs.registerValidator((Control)this.idNumber, Validator.createEmptyValidator((String)validationTxt));
            });
            this.genderValid = Bindings.createBooleanBinding(() -> {
                RadioButton rb = (RadioButton)this.genderGroup.getSelectedToggle();
                if (rb == null || rb.getText() == null || rb.getText().isEmpty()) {
                    return false;
                }
                return rb.getText().equals(DriveWealthBundle.getString("Male")) || rb.getText().equals(DriveWealthBundle.getString("Female"));
            }, (Observable[])new Observable[]{this.genderGroup.selectedToggleProperty()});
            this.maritalValid = Bindings.createBooleanBinding(() -> {
                RadioButton rb = (RadioButton)this.maritalGroup.getSelectedToggle();
                if (rb == null || rb.getText() == null || rb.getText().isEmpty()) {
                    return false;
                }
                return rb.getText().equals(DriveWealthBundle.getString("Single")) || rb.getText().equals(DriveWealthBundle.getString("Married"));
            }, (Observable[])new Observable[]{this.maritalGroup.selectedToggleProperty()});
        }

        @Override
        public void onEnteringPage(Wizard wizard) {
            this.USCitizen.bind((ObservableValue)Bindings.createBooleanBinding(() -> (Boolean)wizard.getSettings().get((Object)"usCitizen_yes"), (Observable[])new Observable[]{wizard.getSettings()}));
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)this.vs.invalidProperty().or((ObservableBooleanValue)this.genderValid.and((ObservableBooleanValue)this.maritalValid).not()));
        }

        public Map<String, Object> getParams(ObservableMap<String, Object> settings) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("dob", settings.get((Object)"dob").toString());
            params.put("phoneHome", (String)settings.get((Object)"phoneHome"));
            String gender = "female";
            Boolean isMale = (Boolean)settings.get((Object)"gender_male");
            if (isMale.booleanValue()) {
                gender = "male";
            }
            params.put("gender", gender);
            String maritalStatus = "Single";
            Boolean isMarried = (Boolean)settings.get((Object)"maritalStatus_Married");
            if (isMarried.booleanValue()) {
                maritalStatus = "Married";
            }
            params.put("maritalStatus", maritalStatus);
            params.put("idNo", (String)settings.get((Object)"idNo"));
            return params;
        }
    }

    class WizardPage1
    extends AccWizardPane {
        private final ToggleGroup USCitizenGroup = new ToggleGroup();
        private final RadioButton USCitizenYesRb = new RadioButton(DriveWealthBundle.getString("Yes"));
        private final RadioButton USCitizenNoRb = new RadioButton(DriveWealthBundle.getString("No"));
        private final ComboBox citizenCombo = WizardPage1.getCountryCombo();
        private final ToggleGroup jointAccGroup = new ToggleGroup();
        public final RadioButton jointAccYesRb = new RadioButton(DriveWealthBundle.getString("Yes"));
        private final RadioButton jointAccNoRb = new RadioButton(DriveWealthBundle.getString("No"));
        private final TextField jointFirstName = new TextField();
        private final TextField jointLastName = new TextField();
        private BooleanBinding jointAccValid;
        private BooleanBinding citizenValid;

        public WizardPage1() {
            this.addCitizenFields();
            this.addJointAccFields();
            this.fieldsValidation();
            this.radioBtnValidation();
        }

        private void addCitizenFields() {
            this.addQuestions(DriveWealthBundle.getString("US_citizen_or_resident_alien"));
            this.USCitizenYesRb.setId("usCitizen_yes");
            this.USCitizenYesRb.setToggleGroup(this.USCitizenGroup);
            this.USCitizenNoRb.setId("usCitizen_no");
            this.USCitizenNoRb.setToggleGroup(this.USCitizenGroup);
            HBox ciBox = new HBox();
            ciBox.setAlignment(Pos.CENTER_LEFT);
            ciBox.setSpacing(20.0);
            ciBox.getChildren().addAll((Object[])new Node[]{this.USCitizenYesRb, this.USCitizenNoRb});
            this.addAnswers(new Node[]{ciBox});
            Label ciLabel = this.addQuestions(DriveWealthBundle.getString("Citizenship"))[0];
            this.citizenCombo.setId("citizenship");
            this.addAnswers(new Node[]{this.citizenCombo});
            this.citizenCombo.managedProperty().bind((ObservableValue)this.citizenCombo.visibleProperty());
            ciLabel.managedProperty().bind((ObservableValue)ciLabel.visibleProperty());
            ciLabel.visibleProperty().bind((ObservableValue)this.citizenCombo.visibleProperty());
            this.citizenCombo.setVisible(false);
            this.USCitizenGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> ov, Toggle oldVal, Toggle newVal) {
                    String selected = ((RadioButton)newVal).getText();
                    boolean show = false;
                    if (selected.equals(DriveWealthBundle.getString("Yes"))) {
                        show = false;
                    } else if (selected.equals(DriveWealthBundle.getString("No"))) {
                        show = true;
                    }
                    WizardPage1.this.citizenCombo.setVisible(show);
                    Window window = WizardPage1.this.getScene().getWindow();
                    window.sizeToScene();
                    WizardPage1.this.fieldsValidation();
                    WizardPage1.this.wizardValidation(LiveAccSignUp.this);
                }
            });
        }

        private void addJointAccFields() {
            this.addQuestions(DriveWealthBundle.getString("Is_joint_account"));
            this.jointAccYesRb.setId("jointAcc_yes");
            this.jointAccYesRb.setToggleGroup(this.jointAccGroup);
            this.jointAccNoRb.setId("jointAcc_no");
            this.jointAccNoRb.setToggleGroup(this.jointAccGroup);
            HBox joBox = new HBox();
            joBox.setAlignment(Pos.CENTER_LEFT);
            joBox.setSpacing(20.0);
            joBox.getChildren().addAll((Object[])new Node[]{this.jointAccYesRb, this.jointAccNoRb});
            this.addAnswers(new Node[]{joBox});
            Label[] labels = this.addQuestions(DriveWealthBundle.getString("Joint_first_name"), DriveWealthBundle.getString("Joint_last_name"));
            Label joName1Lbl = labels[0];
            Label joName2Lbl = labels[1];
            this.jointFirstName.setId("jointFirstName");
            this.jointLastName.setId("jointLastName");
            this.addAnswers(new Node[]{this.jointFirstName, this.jointLastName});
            this.jointFirstName.managedProperty().bind((ObservableValue)this.jointFirstName.visibleProperty());
            joName1Lbl.managedProperty().bind((ObservableValue)joName1Lbl.visibleProperty());
            joName1Lbl.visibleProperty().bind((ObservableValue)this.jointFirstName.visibleProperty());
            this.jointLastName.managedProperty().bind((ObservableValue)this.jointLastName.visibleProperty());
            joName2Lbl.managedProperty().bind((ObservableValue)joName2Lbl.visibleProperty());
            joName2Lbl.visibleProperty().bind((ObservableValue)this.jointLastName.visibleProperty());
            this.jointLastName.visibleProperty().bind((ObservableValue)this.jointFirstName.visibleProperty());
            this.jointFirstName.setVisible(false);
            this.jointAccGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> ov, Toggle oldVal, Toggle newVal) {
                    String selected = ((RadioButton)newVal).getText();
                    boolean show = false;
                    if (selected.equals(DriveWealthBundle.getString("Yes"))) {
                        show = true;
                    } else if (selected.equals(DriveWealthBundle.getString("No"))) {
                        show = false;
                    }
                    WizardPage1.this.jointFirstName.setVisible(show);
                    Window window = WizardPage1.this.getScene().getWindow();
                    window.sizeToScene();
                    WizardPage1.this.fieldsValidation();
                    WizardPage1.this.wizardValidation(LiveAccSignUp.this);
                }
            });
        }

        private void fieldsValidation() {
            this.vs = new ValidationSupport();
            this.vs.initInitialDecoration();
            Platform.runLater(() -> {
                if (this.USCitizenNoRb.isSelected()) {
                    this.vs.registerValidator((Control)this.citizenCombo, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Citizenship_required")));
                }
                if (this.jointAccYesRb.isSelected()) {
                    this.vs.registerValidator((Control)this.jointFirstName, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Joint_first_name_required")));
                    this.vs.registerValidator((Control)this.jointLastName, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Joint_last_name_required")));
                }
            });
        }

        private void radioBtnValidation() {
            String yes = DriveWealthBundle.getString("Yes");
            String no = DriveWealthBundle.getString("No");
            this.citizenValid = Bindings.createBooleanBinding(() -> {
                RadioButton rb = (RadioButton)this.USCitizenGroup.getSelectedToggle();
                if (rb == null || rb.getText() == null || rb.getText().isEmpty()) {
                    return false;
                }
                return rb.getText().equals(yes) || rb.getText().equals(no);
            }, (Observable[])new Observable[]{this.USCitizenGroup.selectedToggleProperty()});
            this.jointAccValid = Bindings.createBooleanBinding(() -> {
                RadioButton rb = (RadioButton)this.jointAccGroup.getSelectedToggle();
                if (rb == null || rb.getText() == null || rb.getText().isEmpty()) {
                    return false;
                }
                return rb.getText().equals(yes) || rb.getText().equals(no);
            }, (Observable[])new Observable[]{this.jointAccGroup.selectedToggleProperty()});
        }

        private void wizardValidation(Wizard wizard) {
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)this.citizenValid.and((ObservableBooleanValue)this.jointAccValid).not().or((ObservableBooleanValue)this.vs.invalidProperty()));
        }

        @Override
        public void onEnteringPage(Wizard wizard) {
            this.wizardValidation(wizard);
        }

        public Map<String, Object> getParams(ObservableMap<String, Object> settings) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("usCitizen", LiveAccSignUp.this.isUSCitizen());
            params.put("citizenship", LiveAccSignUp.this.getCitizenCode());
            String ownershipType = "Individual";
            Boolean isJointAcc = LiveAccSignUp.this.isJointAccount();
            if (isJointAcc.booleanValue()) {
                ownershipType = "Joint";
                params.put("jointFirstName", (String)settings.get((Object)"jointFirstName"));
                params.put("jointLastName", (String)settings.get((Object)"jointLastName"));
            }
            params.put("ownershipType", ownershipType);
            return params;
        }
    }

    static class AccWizardPane
    extends WizardPane {
        ValidationSupport vs = new ValidationSupport();
        int row = 0;
        final StackPane stack = new StackPane();
        final GridPane grid = new GridPane();
        final Label headerLbl1 = new Label();
        final Label headerLbl2 = new Label();

        public AccWizardPane() {
            this.vs.initInitialDecoration();
            this.getStylesheets().add((Object)LiveAccSignUp.class.getResource("/css/trading.css").toExternalForm());
            this.headerLbl1.setText(DriveWealthBundle.getString("Personal_info"));
            this.headerLbl1.getStyleClass().add((Object)"wizard-header1");
            this.headerLbl2.setText(DriveWealthBundle.getString("Open_account_data_encrypted"));
            this.headerLbl2.setMaxWidth(650.0);
            this.headerLbl2.setWrapText(true);
            this.headerLbl2.getStyleClass().add((Object)"wizard-header2");
            VBox headerBox = new VBox();
            headerBox.setAlignment(Pos.CENTER_LEFT);
            headerBox.setSpacing(10.0);
            headerBox.getChildren().addAll((Object[])new Node[]{this.headerLbl1, this.headerLbl2});
            headerBox.getStyleClass().add((Object)"header-panel");
            this.setHeader((Node)headerBox);
            this.row = 0;
            this.grid.setPadding(new Insets(20.0, 20.0, 20.0, 20.0));
            this.grid.setVgap(0.0);
            this.grid.setHgap(30.0);
            ColumnConstraints col1 = new ColumnConstraints();
            col1.setPercentWidth(50.0);
            col1.setHgrow(Priority.ALWAYS);
            ColumnConstraints col2 = new ColumnConstraints();
            col2.setPercentWidth(50.0);
            col2.setHgrow(Priority.ALWAYS);
            this.grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
            this.stack.getChildren().add((Object)this.grid);
            this.setContent((Node)this.stack);
            this.sceneProperty().addListener((obs, oldScene, newScene) -> {
                if (newScene != null) {
                    GUIUtils.setDlgIcon(newScene);
                }
            });
        }

        public Label[] addQuestions(String ... questions) {
            int size = questions.length;
            Label[] labels = new Label[size];
            for (int i = 0; i < size; ++i) {
                Label label = new Label(questions[i]);
                label.getStyleClass().add((Object)"question");
                labels[i] = label;
            }
            this.grid.addRow(this.row++, (Node[])labels);
            return labels;
        }

        public Label addQuestionRowSpan(String question) {
            Label label = new Label(question);
            label.getStyleClass().add((Object)"question");
            this.grid.add((Node)label, 0, this.row++, 2, 1);
            return label;
        }

        public void addAnswers(Node ... answers) {
            this.grid.addRow(this.row++, answers);
            for (Node i : answers) {
                GridPane.setMargin((Node)i, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
            }
        }

        public void addAnswerRowSpan(Node answer) {
            this.grid.add(answer, 0, this.row++, 2, 1);
            GridPane.setMargin((Node)answer, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
        }

        public void onEnteringPage(Wizard wizard) {
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)this.vs.invalidProperty());
        }

        public static ComboBox<Country> getCountryCombo() {
            List<Country> countries = CountryUtils.getInstance().getCountryList();
            ObservableList options = FXCollections.observableArrayList(countries);
            ComboBox combo = new ComboBox(options);
            return combo;
        }
    }
}

