/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.text.MessageFormat;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.PendingOrder;
import org.yccheok.jstock.trading.Utils;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.Instrument;
import org.yccheok.jstock.trading.api.OrderManager;

public class CancelOrderDlg {
    private static final Log log = LogFactory.getLog(CancelOrderDlg.class);
    private final Alert cancelDlg = new Alert(Alert.AlertType.CONFIRMATION);
    private Alert alert = null;
    private final PendingOrder ord;
    private final String symbol;
    private String name;
    private String urlImage;
    private final ButtonType yesButtonType = new ButtonType(DriveWealthBundle.getString("Yes"), ButtonBar.ButtonData.OK_DONE);
    private final ButtonType noButtonType = new ButtonType(DriveWealthBundle.getString("No"), ButtonBar.ButtonData.CANCEL_CLOSE);

    public CancelOrderDlg(PendingOrder ord) {
        this.ord = ord;
        this.symbol = ord.getSymbol();
        this.urlImage = ord.getUrlImage();
        this.name = ord.getName();
    }

    private String stockName() {
        String stockName = this.symbol;
        if (this.name != null && !this.name.isEmpty()) {
            stockName = stockName + " - " + this.name;
        }
        return stockName;
    }

    public static String orderDescription(String side, String type, Double ordQty, Double ordPrice, Double cashAmt) {
        String msg;
        String price = "";
        if (ordPrice != null) {
            price = Utils.monetaryFormat(ordPrice);
        }
        String qty = Utils.formatNumber(ordQty, 4);
        if (side.equals(OrderManager.OrderSide.BUY.toString())) {
            if (type.equals(OrderManager.OrderType.LIMIT.toString())) {
                String template = DriveWealthBundle.getString("Buy_share_at_or_below");
                msg = MessageFormat.format(template, qty, price);
            } else if (type.equals(OrderManager.OrderType.STOP.toString())) {
                String template = DriveWealthBundle.getString("Buy_share_at_or_above");
                msg = MessageFormat.format(template, qty, price);
            } else if (Double.compare(cashAmt, 0.0) > 0) {
                String template = DriveWealthBundle.getString("Buy_amount_at_market_price");
                msg = MessageFormat.format(template, Utils.monetaryFormat(cashAmt));
            } else {
                String template = DriveWealthBundle.getString("Buy_qty_at_market_price");
                msg = MessageFormat.format(template, qty);
            }
        } else if (type.equals(OrderManager.OrderType.LIMIT.toString())) {
            String template = DriveWealthBundle.getString("Sell_share_at_or_above");
            msg = MessageFormat.format(template, qty, price);
        } else if (type.equals(OrderManager.OrderType.STOP.toString())) {
            String template = DriveWealthBundle.getString("Sell_share_at_or_below");
            msg = MessageFormat.format(template, qty, price);
        } else if (Double.compare(cashAmt, 0.0) > 0) {
            String template = DriveWealthBundle.getString("Sell_amount_at_market_price");
            msg = MessageFormat.format(template, Utils.monetaryFormat(cashAmt));
        } else {
            String template = DriveWealthBundle.getString("Sell_qty_at_market_price");
            msg = MessageFormat.format(template, qty);
        }
        return msg;
    }

    public void initDlgAndWait() {
        this.startInstrumentTaskIfNeeded();
        GUIUtils.setDlgTitleHeaderLogo((Dialog)this.cancelDlg, DriveWealthBundle.getString("Cancel_order"), this.stockName(), this.urlImage);
        Label orderMsg = new Label(CancelOrderDlg.orderDescription(this.ord.getSide(), this.ord.getType(), this.ord.getOrderQty(), this.ord.getOrderPrice(), this.ord.getOrderCashAmt()));
        orderMsg.setId("order-msg");
        orderMsg.setPrefWidth(450.0);
        GUIUtils.setDlgContent((Dialog)this.cancelDlg, (Node)orderMsg, null, DriveWealthBundle.getString("Confirm_cancel_order"));
        this.cancelDlg.getButtonTypes().setAll((Object[])new ButtonType[]{this.yesButtonType, this.noButtonType});
        this.cancelOrdHandler();
        this.cancelDlg.showAndWait();
    }

    private void cancelOrdHandler() {
        Node yesButton = this.cancelDlg.getDialogPane().lookupButton(this.yesButtonType);
        yesButton.addEventFilter(ActionEvent.ACTION, event -> {
            event.consume();
            Portfolio.getInstance().cancelService();
            GUIUtils.dlgShowProgressIn((Dialog)this.cancelDlg);
            Task<Pair<Boolean, String>> task = new Task<Pair<Boolean, String>>(){

                protected Pair<Boolean, String> call() throws Exception {
                    String orderID = CancelOrderDlg.this.ord.getOrderID();
                    log.info((Object)("Cancel OrderID :" + orderID));
                    Pair<Boolean, String> result = OrderManager.cancelOrder(orderID);
                    Boolean status = (Boolean)result.first;
                    String error = (String)result.second;
                    if (error == null) {
                        error = "";
                    }
                    log.info((Object)("Cancel Order, status : " + status + ", error: " + error));
                    return result;
                }
            };
            Thread thread = new Thread((Runnable)task);
            thread.start();
            task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent workerStateEvent) {
                    Pair result = (Pair)workerStateEvent.getSource().getValue();
                    Boolean success = (Boolean)result.first;
                    String error = (String)result.second;
                    if (!success.booleanValue()) {
                        CancelOrderDlg.this.failedAction(error);
                        return;
                    }
                    CancelOrderDlg.this.cancelDlg.close();
                    CancelOrderDlg.this.alert = new Alert(Alert.AlertType.INFORMATION);
                    GUIUtils.setDlgTitleHeaderLogo((Dialog)CancelOrderDlg.this.alert, DriveWealthBundle.getString("Cancel_order"), CancelOrderDlg.this.stockName(), CancelOrderDlg.this.urlImage);
                    CancelOrderDlg.this.alert.setContentText(DriveWealthBundle.getString("Order_cancelled"));
                    CancelOrderDlg.this.alert.setOnCloseRequest(event -> {
                        log.info((Object)"Cancel Order success Dlg OnCloseRequest - restart Portfolio");
                        Portfolio.getInstance().restartService();
                    });
                    CancelOrderDlg.this.alert.show();
                }
            });
            task.setOnCancelled(ev -> {
                log.error((Object)"Cancel Order task is cancelled");
                this.failedAction(null);
            });
            task.setOnFailed(ev -> {
                log.error((Object)"Cancel Order task has failed");
                this.failedAction(null);
            });
        });
    }

    private void failedAction(String error) {
        this.cancelDlg.close();
        String errMsg = error != null ? error : ApiError.commonMsg();
        this.alert = GUIUtils.alertDlg(Alert.AlertType.ERROR, DriveWealthBundle.getString("Cancel_order_error"), this.stockName(), errMsg);
        GUIUtils.setDlgGraphic((Dialog)this.alert, this.urlImage);
        this.alert.setOnCloseRequest(event -> {
            log.info((Object)"Cancel Order failed Dlg OnCloseRequest - restart Portfolio");
            Portfolio.getInstance().restartService();
        });
        this.alert.show();
    }

    public void startInstrumentTaskIfNeeded() {
        if (this.name == null || this.name.isEmpty()) {
            Task<Instrument> task = GUIUtils.startInstrumentTask(this.symbol);
            task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent workerStateEvent) {
                    Instrument ins = (Instrument)workerStateEvent.getSource().getValue();
                    CancelOrderDlg.this.name = ins.name;
                    CancelOrderDlg.this.urlImage = ins.urlImage;
                    if (CancelOrderDlg.this.cancelDlg.isShowing()) {
                        CancelOrderDlg.this.cancelDlg.setHeaderText(CancelOrderDlg.this.symbol + " - " + CancelOrderDlg.this.name);
                        GUIUtils.setDlgGraphic((Dialog)CancelOrderDlg.this.cancelDlg, CancelOrderDlg.this.urlImage);
                    }
                    if (CancelOrderDlg.this.alert != null && CancelOrderDlg.this.alert.isShowing()) {
                        CancelOrderDlg.this.alert.setHeaderText(CancelOrderDlg.this.symbol + " - " + CancelOrderDlg.this.name);
                        GUIUtils.setDlgGraphic((Dialog)CancelOrderDlg.this.alert, CancelOrderDlg.this.urlImage);
                    }
                }
            });
            task.setOnFailed(ev -> log.error((Object)("Cancel Order Dialog - Get Instrument Task failed: " + ev.toString())));
            task.setOnCancelled(ev -> log.error((Object)("Cancel Order Dialog - Get Instrument Task cancelled: " + ev.toString())));
        }
    }
}

