/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.util.Locale;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.trading.AccountMenu;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.AccountSummary;
import org.yccheok.jstock.trading.OpenPosition;
import org.yccheok.jstock.trading.api.DriveWealth;
import org.yccheok.jstock.trading.api.SessionManager;
import org.yccheok.jstock.trading.api.User;

public class AccountSummaryHeader {
    private static final AccountSummaryHeader INSTANCE = new AccountSummaryHeader();
    private static final Log log = LogFactory.getLog(AccountSummaryHeader.class);
    private Label activeAccLbl;
    private ComboBox<Object> accCombo;
    private HBox headerBox;
    private Label shareAmount;
    private Label profitAmount;
    private Label cashAmount;
    private Label totalAmount;
    private Circle avatarCircle;
    private Button fundBtn;
    private Button openLiveAccBtn;
    private AccountSummary acc;

    private AccountSummaryHeader() {
    }

    public static AccountSummaryHeader getInstance() {
        return INSTANCE;
    }

    public Node show() {
        Image image = new Image(AccountSummaryHeader.class.getResourceAsStream("/images/trading/drivewealth-logo-2.png"));
        ImageView dwLogo = new ImageView();
        dwLogo.setImage(image);
        HBox dwBox = new HBox();
        dwBox.setPrefWidth(300.0);
        dwBox.getChildren().add((Object)dwLogo);
        dwBox.setAlignment(Pos.CENTER);
        this.shareAmount = new Label();
        this.profitAmount = new Label();
        this.cashAmount = new Label();
        this.totalAmount = new Label();
        this.cashAmount.getStyleClass().clear();
        this.shareAmount.getStyleClass().clear();
        this.totalAmount.getStyleClass().clear();
        this.profitAmount.getStyleClass().clear();
        this.cashAmount.getStyleClass().add((Object)"big-font");
        this.shareAmount.getStyleClass().add((Object)"big-font");
        this.totalAmount.getStyleClass().addAll((Object[])new String[]{"big-font", "bold"});
        this.profitAmount.getStyleClass().add((Object)"big-font");
        VBox cashBox = new VBox();
        cashBox.setAlignment(Pos.CENTER_LEFT);
        cashBox.setSpacing(5.0);
        Label cashLabel = new Label(DriveWealthBundle.getString("Header_CASH_TO_INVEST"));
        cashLabel.getStyleClass().addAll((Object[])new String[]{"small-font", "underline", "grey"});
        cashBox.getChildren().addAll((Object[])new Node[]{cashLabel, this.cashAmount});
        VBox shareBox = new VBox();
        shareBox.setAlignment(Pos.CENTER_LEFT);
        shareBox.setSpacing(5.0);
        Label shareLabel = new Label(DriveWealthBundle.getString("Header_INVESTMENTS"));
        shareLabel.getStyleClass().addAll((Object[])new String[]{"small-font", "underline", "grey"});
        shareBox.getChildren().addAll((Object[])new Node[]{shareLabel, this.shareAmount});
        VBox totalBox = new VBox();
        totalBox.setAlignment(Pos.CENTER_LEFT);
        totalBox.setSpacing(5.0);
        Label totalLabel = new Label(DriveWealthBundle.getString("Header_TOTAL"));
        totalLabel.getStyleClass().addAll((Object[])new String[]{"small-font", "underline", "grey"});
        totalBox.getChildren().addAll((Object[])new Node[]{totalLabel, this.totalAmount});
        VBox profitBox = new VBox();
        profitBox.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        profitBox.setAlignment(Pos.BOTTOM_LEFT);
        this.profitAmount.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        profitBox.getChildren().addAll((Object[])new Node[]{this.profitAmount});
        HBox summaryBox = new HBox();
        summaryBox.setAlignment(Pos.CENTER);
        summaryBox.setId("acc-summary-box");
        summaryBox.setPrefWidth(600.0);
        summaryBox.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        summaryBox.setSpacing(15.0);
        summaryBox.getChildren().addAll((Object[])new Node[]{cashBox, shareBox, totalBox, profitBox});
        this.activeAccLbl = new Label();
        this.updateActiveAccLabel();
        this.accCombo = AccountMenu.getInstance().show();
        VBox accBox = new VBox();
        accBox.setSpacing(5.0);
        accBox.setPrefWidth(220.0);
        accBox.setMaxWidth(220.0);
        accBox.getChildren().addAll((Object[])new Node[]{this.activeAccLbl, this.accCombo});
        this.fundBtn = new Button(DriveWealthBundle.getString("Fund_account"));
        this.fundBtn.getStyleClass().add((Object)"green-btn-small-font");
        GUIUtils.browserURLHandler((ButtonBase)this.fundBtn, DriveWealth.fundsInURL());
        this.openLiveAccBtn = new Button(DriveWealthBundle.getString("Open_live_account"));
        this.openLiveAccBtn.getStyleClass().add((Object)"green-btn-small-font");
        GUIUtils.openLiveAccHandler(this.openLiveAccBtn);
        StackPane btnStack = new StackPane();
        btnStack.getChildren().addAll((Object[])new Node[]{this.fundBtn, this.openLiveAccBtn});
        btnStack.setAlignment(Pos.BOTTOM_RIGHT);
        btnStack.setPrefWidth(180.0);
        btnStack.setMaxWidth(180.0);
        this.showHideFundBtn();
        this.showHideOpenLiveAccBtn();
        this.avatarCircle = new Circle(25.0);
        this.updateAvatar();
        HBox userBox = new HBox();
        userBox.setPrefWidth(500.0);
        userBox.setAlignment(Pos.BOTTOM_RIGHT);
        userBox.setSpacing(10.0);
        userBox.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        userBox.getChildren().addAll((Object[])new Node[]{this.avatarCircle, accBox, btnStack});
        this.headerBox = new HBox();
        this.headerBox.setId("acc-header");
        this.headerBox.getChildren().clear();
        this.headerBox.getChildren().addAll((Object[])new Node[]{dwBox, summaryBox, userBox});
        return this.headerBox;
    }

    public void updateActiveAccLabel() {
        this.activeAccLbl.setText(SessionManager.getInstance().getUser().getActiveAccount().nickname);
    }

    public void showHideFundBtn() {
        boolean show = false;
        if (SessionManager.getInstance().getUser().getActiveAccount().accType == SessionManager.AccType.LIVE) {
            show = true;
        }
        this.fundBtn.setVisible(show);
    }

    public void showHideOpenLiveAccBtn() {
        boolean show = false;
        User user = SessionManager.getInstance().getUser();
        if (user.getActiveAccount().accType == SessionManager.AccType.PRACTICE && user.getLiveAccounts().isEmpty()) {
            show = true;
        }
        this.openLiveAccBtn.setVisible(show);
    }

    public void updateAvatar() {
        String url = SessionManager.getInstance().getUser().getAvatarUrl();
        if (url == null || url.isEmpty()) {
            this.avatarCircle.setFill(null);
            return;
        }
        Image img = new Image(url, false);
        ImagePattern pattern = new ImagePattern(img);
        this.avatarCircle.setFill((Paint)pattern);
    }

    public void initData(AccountSummary accModel) {
        this.resetData();
        this.acc = accModel;
        Locale locale = new Locale("en", "US");
        this.shareAmount.textProperty().bind((ObservableValue)Bindings.format((Locale)locale, (String)"$%,.2f", (Object[])new Object[]{this.acc.equityProperty()}));
        this.profitAmount.textProperty().bind((ObservableValue)Bindings.format((Locale)locale, (String)"$%,.2f (%,.2f%%)", (Object[])new Object[]{this.acc.totalUnrealizedPLProperty(), this.acc.totalUnrealizedPLPercentProperty()}));
        this.cashAmount.textProperty().bind((ObservableValue)Bindings.format((Locale)locale, (String)"$%,.2f", (Object[])new Object[]{this.acc.cashForTradeProperty()}));
        this.totalAmount.textProperty().bind((ObservableValue)Bindings.format((Locale)locale, (String)"$%,.2f", (Object[])new Object[]{this.acc.accountTotalProperty()}));
        this.profitAmount.getStyleClass().add((Object)this.acc.unrealizedPLCss());
    }

    public void resetData() {
        this.profitAmount.textProperty().unbind();
        this.shareAmount.textProperty().unbind();
        this.cashAmount.textProperty().unbind();
        this.totalAmount.textProperty().unbind();
        this.profitAmount.setText("");
        this.shareAmount.setText("");
        this.cashAmount.setText("");
        this.totalAmount.setText("");
        this.profitAmount.getStyleClass().clear();
    }

    public void update(ObservableList<OpenPosition> posList) {
        this.acc.update(posList);
        this.profitAmount.getStyleClass().clear();
        this.profitAmount.getStyleClass().addAll((Object[])new String[]{"header", this.acc.unrealizedPLCss()});
    }
}

