/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.trading.AccountMenu;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.gui.trading.TradingView;
import org.yccheok.jstock.gui.trading.UploadDoc;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.Account;
import org.yccheok.jstock.trading.api.AccountManager;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.DriveWealth;
import org.yccheok.jstock.trading.api.SessionManager;
import org.yccheok.jstock.trading.api.User;
import org.yccheok.jstock.trading.api.UserManager;

public class AccApplicationIncomplete {
    private static final Log log = LogFactory.getLog(AccApplicationIncomplete.class);
    private static final AccApplicationIncomplete INSTANCE = new AccApplicationIncomplete();
    private VBox vBox = null;
    private VBox innerBox;
    private Label title;
    private Label status;
    private Label notice;
    private Label fundIn;
    private Button fundBtn;
    private Button openLiveAccBtn;
    private Hyperlink practiceLink;

    public static AccApplicationIncomplete getInstance() {
        return INSTANCE;
    }

    public Node show() {
        User user = SessionManager.getInstance().getUser();
        if (user.getActiveAccount().accType == SessionManager.AccType.PRACTICE) {
            if (user.getLiveAccounts().isEmpty()) {
                return this.openLiveAccMsg();
            }
            return null;
        }
        return this.liveAccStatus();
    }

    private Node openLiveAccMsg() {
        this.initUI();
        this.title.setText(DriveWealthBundle.getString("Home_Welcome_to_your_practice_account"));
        this.status.setText(DriveWealthBundle.getString("Home_This_is_a_virtual_money_practice_account"));
        this.notice.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        this.notice.setText(DriveWealthBundle.getString("Home_Start_live_trading_now_by_opening_live_trading_account"));
        this.openLiveAccBtn = new Button(DriveWealthBundle.getString("Open_live_account"));
        this.openLiveAccBtn.getStyleClass().add((Object)"green-btn");
        GUIUtils.openLiveAccHandler(this.openLiveAccBtn);
        this.practiceLink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Portfolio.getInstance().removeAccStatusIfExist();
            }
        });
        this.innerBox.getChildren().addAll((Object[])new Node[]{this.title, this.status, this.notice, this.openLiveAccBtn, this.practiceLink});
        this.vBox.getChildren().add((Object)this.innerBox);
        return this.vBox;
    }

    private void initUI() {
        this.vBox = new VBox();
        this.vBox.getStyleClass().add((Object)"border-box");
        this.vBox.setPrefHeight(500.0);
        this.vBox.setPadding(new Insets(50.0, 0.0, 0.0, 0.0));
        this.vBox.setAlignment(Pos.TOP_CENTER);
        this.innerBox = new VBox();
        this.innerBox.getStyleClass().add((Object)"rounded-white-box");
        this.innerBox.setMaxWidth(600.0);
        this.innerBox.setAlignment(Pos.CENTER);
        this.innerBox.setSpacing(10.0);
        this.innerBox.setPadding(new Insets(30.0, 20.0, 30.0, 20.0));
        this.title = new Label();
        this.title.getStyleClass().add((Object)"title");
        this.status = new Label();
        this.status.getStyleClass().addAll((Object[])new String[]{"big-font", "italic"});
        this.status.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        this.notice = new Label();
        this.fundIn = new Label();
        this.fundIn.getStyleClass().add((Object)"big-font");
        this.fundIn.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        this.fundBtn = new Button(DriveWealthBundle.getString("Fund_account"));
        this.fundBtn.getStyleClass().add((Object)"green-btn");
        GUIUtils.browserURLHandler((ButtonBase)this.fundBtn, DriveWealth.fundsInURL());
        this.practiceLink = new Hyperlink(DriveWealthBundle.getString("Home_Practice_trading_with_practice_account"));
        this.practiceLink.setPadding(new Insets(40.0, 0.0, 0.0, 0.0));
        this.setPracticeUrlHandler(this.practiceLink);
    }

    private Node liveAccStatus() {
        this.initUI();
        User user = SessionManager.getInstance().getUser();
        Account active = user.getActiveAccount();
        SessionManager.AccStatus accStatus = active.accStatus;
        if (null != accStatus) {
            block0 : switch (accStatus) {
                case PENDING: {
                    UserManager.VerificationStatus userStatus = UserManager.userStatus(user.userID);
                    if (userStatus == null) break;
                    switch (userStatus) {
                        case NOT_SUBMITTED: {
                            this.accPendingDocMsg();
                            break block0;
                        }
                        case PENDING: {
                            this.accPendingApprovalMsg();
                            break block0;
                        }
                    }
                    break;
                }
                case OPEN: 
                case OPEN_NO_NEW_TRADES: {
                    if (active.cash != 0.0) break;
                    this.accPendingDepositMsg();
                    break;
                }
                case CLOSED: {
                    this.accClosedMsg();
                    break;
                }
            }
        }
        if (this.innerBox.getChildren().isEmpty()) {
            return null;
        }
        this.innerBox.getChildren().add((Object)this.practiceLink);
        this.vBox.getChildren().add((Object)this.innerBox);
        return this.vBox;
    }

    private void setPracticeUrlHandler(Hyperlink link) {
        link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                User user = SessionManager.getInstance().getUser();
                if (!user.getPracticeAccounts().isEmpty()) {
                    Account practice = SessionManager.getInstance().getUser().getPracticeAccounts().get(0);
                    AccountMenu.getInstance().manualSelectAcc(practice);
                } else {
                    TradingView.getInstance().showProgIndicator();
                    AccApplicationIncomplete.this.createPacticeAccTask();
                }
            }
        });
    }

    private void createPacticeAccTask() {
        Task<String> task = new Task<String>(){

            protected String call() {
                String accID = AccountManager.createPracticeAccFromUser(SessionManager.getInstance().getUser().userID);
                if (accID == null) {
                    return null;
                }
                Pair<String, String> login = SessionManager.getInstance().relogin(accID);
                String error = (String)login.second;
                if (error != null) {
                    return null;
                }
                return accID;
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>((Task)task){
            final /* synthetic */ Task val$task;
            {
                this.val$task = task;
            }

            public void handle(WorkerStateEvent t) {
                String accID = (String)this.val$task.getValue();
                if (accID == null) {
                    log.error((Object)"Create practice a/c Task Error - No practice a/c created");
                    AccApplicationIncomplete.this.showCreatePracticeAccError();
                    return;
                }
                TradingView.getInstance().showPortfolio();
            }
        });
        task.setOnFailed(ev -> {
            log.error((Object)("Create practice a/c Task failed ... " + ev.toString()));
            this.showCreatePracticeAccError();
        });
        task.setOnCancelled(ev -> {
            log.error((Object)("Create practice a/c Task cancelled ... " + ev.toString()));
            this.showCreatePracticeAccError();
        });
        new Thread((Runnable)task).start();
    }

    private void showCreatePracticeAccError() {
        TradingView.getInstance().removeProgIndicator();
        Alert dlg = GUIUtils.alertDlg(Alert.AlertType.ERROR, DriveWealthBundle.getString("Home_Create_practice_account"), null, ApiError.commonMsg());
        dlg.show();
    }

    private void accPendingDocMsg() {
        this.title.setText(DriveWealthBundle.getString("Home_Account_application_status"));
        this.status.setText(DriveWealthBundle.getString("Home_Not_yet_complete"));
        Button uploadDocBtn = new Button();
        uploadDocBtn.getStyleClass().add((Object)"green-btn");
        uploadDocBtn.setText(DriveWealthBundle.getString("Home_Finish_application"));
        uploadDocBtn.setOnAction(e -> {
            UploadDoc uploadDoc = new UploadDoc();
            uploadDoc.showAndWait();
        });
        this.innerBox.getChildren().addAll((Object[])new Node[]{this.title, this.status, uploadDocBtn});
    }

    private void accPendingApprovalMsg() {
        this.title.setText(DriveWealthBundle.getString("Home_Account_application_status"));
        this.status.setText(DriveWealthBundle.getString("Home_Pending_approval"));
        this.notice.setText(DriveWealthBundle.getString("Home_We_will_send_you_email_once_can_start_investing"));
        this.fundIn.setText(DriveWealthBundle.getString("Home_Fund_account_to_start_investing_once_approved"));
        this.innerBox.getChildren().addAll((Object[])new Node[]{this.title, this.status, this.notice, this.fundIn, this.fundBtn});
    }

    private void accPendingDepositMsg() {
        this.title.setText(DriveWealthBundle.getString("Home_Account_application_status"));
        this.status.setText(DriveWealthBundle.getString("Home_Completed"));
        this.fundIn.setText(DriveWealthBundle.getString("Home_Fund_account_to_start_investing"));
        this.innerBox.getChildren().addAll((Object[])new Node[]{this.title, this.status, this.fundIn, this.fundBtn});
    }

    private void accClosedMsg() {
        this.title.setText(DriveWealthBundle.getString("Home_Account_status"));
        this.status.setText(DriveWealthBundle.getString("Home_Closed"));
        this.innerBox.getChildren().addAll((Object[])new Node[]{this.title, this.status});
    }
}

