/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import com.google.api.client.auth.oauth2.Credential;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.file.UserDataDirectory;
import org.yccheok.jstock.file.UserDataFile;
import org.yccheok.jstock.gui.Icons;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.LoadFromCloudJDialog;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.analysis.MemoryLogJDialog;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.Utils;

public class SaveToCloudJDialog
extends JDialog {
    private final Pair<Credential, String> credentialEx;
    private volatile SwingWorker<Boolean, Status> saveToCloudTask = null;
    private final List<String> memoryLog = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(LoadFromCloudJDialog.class);
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel10;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JXHeader jXHeader1;

    public SaveToCloudJDialog(Frame parent, boolean modal, Pair<Credential, String> credentialEx, boolean credentialFromDisk) {
        super(parent, modal);
        this.initComponents();
        this.pack();
        Dimension dimension = JStock.instance().getUIOptions().getDimension("SAVE_TO_CLOUD_JDIALOG");
        if (dimension != null) {
            this.setSize(dimension);
        } else {
            this.setSize(new Dimension(487, 313));
        }
        this.setLocationRelativeTo(null);
        this.credentialEx = credentialEx;
        this.jLabel10.setText((String)credentialEx.second);
        this.jLabel4.setVisible(false);
        this.jLabel5.setVisible(false);
        if (!credentialFromDisk) {
            this.jButton1.doClick();
        }
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jXHeader1 = new JXHeader();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jPanel8 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("SaveToCloudJDialog_Title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                SaveToCloudJDialog.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)this.jPanel5, "West");
        this.getContentPane().add((Component)this.jPanel6, "East");
        this.jXHeader1.setDescription(bundle.getString("SaveToCloudJDialog_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/upload_to_cloud.png")));
        this.jXHeader1.setTitle(bundle.getString("SaveToCloudJDialog_Title"));
        this.getContentPane().add((Component)this.jXHeader1, "North");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("SaveToCloudJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveToCloudJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("SaveToCloudJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveToCloudJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel3, "Last");
        this.jPanel1.setLayout(new BorderLayout(5, 5));
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jLabel5.setText(bundle.getString("WizardDownloadlIndicatorJPanel_ViewLog"));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel5MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel5MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel5MouseExited(evt);
            }
        });
        this.jPanel4.add(this.jLabel5);
        this.jLabel3.setForeground(new Color(0, 0, 255));
        this.jLabel3.setText(" ");
        this.jLabel3.setToolTipText("");
        this.jPanel4.add(this.jLabel3);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jPanel4.add(this.jLabel4);
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("SaveToCloudJDialog_GoogleAccount")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new FlowLayout(0));
        this.jLabel7.setText(bundle.getString("SaveToCloudJDialog_ViewPrivacyInformation"));
        this.jLabel7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel7MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel7MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel7MouseExited(evt);
            }
        });
        this.jPanel7.add(this.jLabel7);
        this.jLabel8.setText(bundle.getString("SaveToCloudJDialog_Or"));
        this.jPanel7.add(this.jLabel8);
        this.jLabel9.setText(bundle.getString("SaveToCloudJDialog_DownloadJStockAndroid"));
        this.jLabel9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel9MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel9MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel9MouseExited(evt);
            }
        });
        this.jPanel7.add(this.jLabel9);
        this.jPanel2.add((Component)this.jPanel7, "South");
        this.jLabel10.setBackground(new Color(140, 196, 116));
        this.jLabel10.setFont(this.jLabel10.getFont().deriveFont(this.jLabel10.getFont().getStyle() | 1, this.jLabel10.getFont().getSize() + 1));
        this.jLabel10.setForeground(new Color(255, 255, 255));
        this.jLabel10.setText("username@email.com");
        this.jLabel10.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jLabel10.setOpaque(true);
        this.jPanel8.add(this.jLabel10);
        this.jButton3.setText(bundle.getString("SaveToCloudJDialog_SignOut"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveToCloudJDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jButton3);
        this.jPanel2.add((Component)this.jPanel8, "Center");
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.setSize(new Dimension(487, 313));
        this.setLocationRelativeTo(null);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.cancel();
        JStock.instance().getUIOptions().setDimension("SAVE_TO_CLOUD_JDIALOG", this.getSize());
    }

    private void cancel() {
        if (this.saveToCloudTask != null) {
            this.saveToCloudTask.cancel(true);
            this.saveToCloudTask = null;
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jLabel5MouseClicked(MouseEvent evt) {
        MemoryLogJDialog memoryLogJDialog = new MemoryLogJDialog((Frame)JStock.instance(), true);
        memoryLogJDialog.setLocationRelativeTo(this);
        memoryLogJDialog.setLog(this.memoryLog);
        memoryLogJDialog.setVisible(true);
    }

    private void jLabel5MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel5MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jButton1.setEnabled(false);
        this.jLabel3.setText(GUIBundle.getString("SaveToCloudJDialog_PreparingData..."));
        this.jLabel4.setIcon(Icons.BUSY);
        this.jLabel3.setVisible(true);
        this.jLabel4.setVisible(true);
        this.saveToCloudTask = this.getSaveToCloudTask("");
        this.saveToCloudTask.execute();
    }

    private void jLabel7MouseClicked(MouseEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.PRIVACY_HTML));
    }

    private void jLabel7MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel7MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jLabel9MouseClicked(MouseEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.ANDROID_HTML));
    }

    private void jLabel9MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel9MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        org.yccheok.jstock.google.Utils.logoutDrive();
        this.setVisible(false);
        this.dispose();
        JStock.instance().saveToCloud();
    }

    private SwingWorker<Boolean, Status> getSaveToCloudTask(String username) {
        SwingWorker<Boolean, Status> worker = new SwingWorker<Boolean, Status>(){

            @Override
            protected void done() {
                boolean result = false;
                if (!this.isCancelled()) {
                    try {
                        result = (Boolean)this.get();
                    }
                    catch (InterruptedException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    catch (CancellationException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
                SaveToCloudJDialog.this.jButton1.setEnabled(true);
                if (result) {
                    JOptionPane.showMessageDialog(SaveToCloudJDialog.this, GUIBundle.getString("SaveToCloudJDialog_Success"));
                    SaveToCloudJDialog.this.setVisible(false);
                    SaveToCloudJDialog.this.dispose();
                }
            }

            @Override
            protected void process(List<Status> statuses) {
                for (Status status : statuses) {
                    SaveToCloudJDialog.this.writeToMemoryLog(status.message);
                    SaveToCloudJDialog.this.jLabel3.setText(status.message);
                    SaveToCloudJDialog.this.jLabel4.setIcon(status.icon);
                    SaveToCloudJDialog.this.jLabel3.setVisible(true);
                    SaveToCloudJDialog.this.jLabel4.setVisible(true);
                    if (status.icon == Icons.ERROR || status.icon == Icons.WARNING) {
                        SaveToCloudJDialog.this.jLabel3.setForeground(Color.RED);
                        SaveToCloudJDialog.this.jLabel5.setVisible(true);
                        continue;
                    }
                    SaveToCloudJDialog.this.jLabel3.setForeground(Color.BLUE);
                    SaveToCloudJDialog.this.jLabel5.setVisible(false);
                }
            }

            @Override
            protected Boolean doInBackground() {
                if (this.isCancelled()) {
                    return false;
                }
                SaveToCloudJDialog.this.memoryLog.clear();
                this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_PreparingData..."), Icons.BUSY));
                JStock.instance().commitBeforeSaveToCloud();
                File zipFile = SaveToCloudJDialog.getJStockZipFile(null);
                if (this.isCancelled()) {
                    return false;
                }
                if (zipFile == null) {
                    this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_PreparingDataFail"), Icons.ERROR));
                    return false;
                }
                this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_VerifyGoogleAccount..."), Icons.BUSY));
                if (!Utils.saveToGoogleDrive((Credential)((SaveToCloudJDialog)SaveToCloudJDialog.this).credentialEx.first, zipFile)) {
                    this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_VerifyGoogleAccountFail"), Icons.ERROR));
                    return false;
                }
                this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_Success"), Icons.OK));
                return true;
            }
        };
        return worker;
    }

    private static List<FileEx> getFileEx(List<FileEx> fileExs, String name, List<String> extensions) {
        return SaveToCloudJDialog.getFileEx(fileExs, name, extensions, null);
    }

    private static boolean hasExtensions(String filename, List<String> extensions) {
        for (String extension : extensions) {
            if (!filename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private static List<FileEx> getFileEx(List<FileEx> fileExs, String name, List<String> extensions, LastErrorCode lastErrorCode) {
        File dir = new File(Utils.getUserDataDirectory() + name);
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                SaveToCloudJDialog.getFileEx(fileExs, name + File.separator + child, extensions, lastErrorCode);
            }
        } else if (!name.equalsIgnoreCase(UserDataDirectory.Config.directory + File.separator + UserDataFile.OptionsXml.get())) {
            if (name.contains("watchlist") && name.endsWith("realtimestock.csv")) {
                if (dir.length() < 0x1800000L) {
                    if (extensions == null || SaveToCloudJDialog.hasExtensions(name, extensions)) {
                        fileExs.add(FileEx.newInstance(dir, name));
                    }
                } else if (lastErrorCode != null) {
                    lastErrorCode.flag = true;
                }
            } else if (extensions == null || SaveToCloudJDialog.hasExtensions(name, extensions)) {
                fileExs.add(FileEx.newInstance(dir, name));
            }
        }
        return fileExs;
    }

    private static boolean promptUserToContinue(List<Country> countryWithWatchlistFilesBeingIgnored) {
        String title;
        String message;
        if (countryWithWatchlistFilesBeingIgnored.isEmpty()) {
            return true;
        }
        int size = countryWithWatchlistFilesBeingIgnored.size();
        if (size == 1) {
            message = MessageFormat.format(MessagesBundle.getString("question_message_too_many_stocks_during_save_to_cloud_template"), new Object[]{countryWithWatchlistFilesBeingIgnored.get(0)});
            title = MessagesBundle.getString("question_title_too_many_stocks_during_save_to_cloud");
        } else {
            message = MessageFormat.format(MessagesBundle.getString("question_message_too_many_stocks_in_multiple_countries_during_save_to_cloud_template"), size);
            title = MessagesBundle.getString("question_title_too_many_stocks_in_multiple_countries_during_save_to_cloud");
        }
        final int[] choice = new int[]{1};
        if (SwingUtilities.isEventDispatchThread()) {
            choice[0] = JOptionPane.showConfirmDialog(JStock.instance(), message, title, 0);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        choice[0] = JOptionPane.showConfirmDialog(JStock.instance(), message, title, 0);
                    }
                });
            }
            catch (InterruptedException ex) {
                log.error(null, (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        return choice[0] == 0;
    }

    private static List<String> getExtensions(String name) {
        ArrayList<String> extensions = new ArrayList<String>();
        if (name.equals(UserDataDirectory.Config.directory)) {
            extensions.add(".xml");
        } else if (name.equals("indicator")) {
            extensions.add(".xml");
        } else if (name.equals("logos")) {
            extensions.add(".jpg");
            extensions.add(".jpeg");
            extensions.add(".gif");
            extensions.add(".png");
            extensions.add(".bmp");
        } else if (name.equals("portfolios")) {
            extensions.add(".csv");
            extensions.add(".json");
        } else if (name.equals("watchlist")) {
            extensions.add(".csv");
        } else if (name.equals("android")) {
            extensions.add(".csv");
            extensions.add(".json");
        } else if (name.equals("databases")) {
            extensions.add(".db");
        } else {
            assert (false);
            throw new IllegalArgumentException(name);
        }
        return Collections.unmodifiableList(extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getJStockZipFile(String filename) {
        File temp;
        block18: {
            List<File> files = SaveToCloudJDialog.getUserDefinedDatabaseFiles();
            ArrayList<FileEx> fileExs = new ArrayList<FileEx>();
            for (File file : files) {
                String absolutePath = file.getAbsolutePath();
                int index = absolutePath.indexOf(Utils.getApplicationVersionString());
                if (index < 0) continue;
                String output = absolutePath.substring(index + Utils.getApplicationVersionString().length() + File.separator.length());
                fileExs.add(FileEx.newInstance(file, output));
            }
            JStockOptions jStockOptions = JStock.instance().getJStockOptions();
            JStockOptions insensitiveJStockOptions = jStockOptions.insensitiveClone();
            try {
                File tempJStockOptions = File.createTempFile(Utils.getJStockUUID(), ".xml");
                tempJStockOptions.deleteOnExit();
                Utils.toXML((Object)insensitiveJStockOptions, tempJStockOptions);
                fileExs.add(FileEx.newInstance(tempJStockOptions, UserDataDirectory.Config.directory + File.separator + UserDataFile.OptionsXml.get()));
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
            ArrayList<Country> countryWithWatchlistFilesBeingIgnored = new ArrayList<Country>();
            SaveToCloudJDialog.getFileEx(fileExs, UserDataDirectory.Config.directory, SaveToCloudJDialog.getExtensions(UserDataDirectory.Config.directory));
            SaveToCloudJDialog.getFileEx(fileExs, "indicator", SaveToCloudJDialog.getExtensions("indicator"));
            SaveToCloudJDialog.getFileEx(fileExs, "logos", SaveToCloudJDialog.getExtensions("logos"));
            SaveToCloudJDialog.getFileEx(fileExs, "android", SaveToCloudJDialog.getExtensions("android"));
            for (Country country : Country.values()) {
                SaveToCloudJDialog.getFileEx(fileExs, (Object)((Object)country) + File.separator + "portfolios", SaveToCloudJDialog.getExtensions("portfolios"));
                LastErrorCode lastErrorCode = new LastErrorCode();
                SaveToCloudJDialog.getFileEx(fileExs, (Object)((Object)country) + File.separator + "watchlist", SaveToCloudJDialog.getExtensions("watchlist"), lastErrorCode);
                if (!lastErrorCode.flag) continue;
                countryWithWatchlistFilesBeingIgnored.add(country);
            }
            SaveToCloudJDialog.getFileEx(fileExs, "databases", SaveToCloudJDialog.getExtensions("databases"));
            if (!SaveToCloudJDialog.promptUserToContinue(countryWithWatchlistFilesBeingIgnored)) {
                return null;
            }
            byte[] buf = new byte[1024];
            ZipOutputStream out = null;
            temp = null;
            boolean exceptionOccur = false;
            try {
                if (Utils.isNullOrEmpty(filename)) {
                    temp = File.createTempFile(Utils.getJStockUUID(), ".zip");
                    temp.deleteOnExit();
                } else {
                    temp = new File(filename);
                }
                out = new ZipOutputStream(new FileOutputStream(temp));
                for (FileEx fileEx : fileExs) {
                    FileInputStream in = null;
                    try {
                        int len;
                        in = new FileInputStream(fileEx.input);
                        String zipEntryName = fileEx.output;
                        out.putNextEntry(Utils.getZipEntry(zipEntryName));
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    finally {
                        org.yccheok.jstock.file.Utils.closeEntry(out);
                        org.yccheok.jstock.file.Utils.close(in);
                    }
                }
                org.yccheok.jstock.file.Utils.close(out);
                if (!exceptionOccur || temp == null) break block18;
                temp.delete();
            }
            catch (IOException exp) {
                log.error(null, (Throwable)exp);
                exceptionOccur = true;
                File file = null;
                return file;
            }
            finally {
                org.yccheok.jstock.file.Utils.close(out);
                if (exceptionOccur && temp != null) {
                    temp.delete();
                }
            }
        }
        return temp;
    }

    private static List<File> getUserDefinedDatabaseFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (Country country : Country.values()) {
            File file = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.csv");
            if (!file.exists()) continue;
            files.add(file);
        }
        return files;
    }

    private void writeToMemoryLog(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
        String s = dateFormat.format(new Date()) + "\n" + message;
        this.memoryLog.add(s);
    }

    private static class LastErrorCode {
        boolean flag = false;

        private LastErrorCode() {
        }
    }

    private static class FileEx {
        final File input;
        final String output;

        private FileEx(File input, String output) {
            this.input = input;
            this.output = output;
        }

        public static FileEx newInstance(File input, String output) {
            return new FileEx(input, output);
        }
    }

    private static class Status {
        public final String message;
        public final Icon icon;

        private Status(String message, Icon icon) {
            if (message == null || icon == null) {
                throw new IllegalArgumentException("Method arguments cannot be null");
            }
            this.message = message;
            this.icon = icon;
        }

        public static Status newInstance(String message, Icon icon) {
            return new Status(message, icon);
        }
    }
}

