/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.io.File;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.Utils;

public class BackwardCompatible {
    public static String toGoogleCodeIfPossible(String code) {
        String s;
        String newString;
        String string = code.toString().trim().toUpperCase();
        int string_length = string.length();
        if (string.endsWith(".NS") && string_length > ".NS".length() && (newString = org.yccheok.jstock.engine.Utils.toGoogleFormatThroughAutoComplete(s = string.substring(0, string_length - ".NS".length()), "NSE")) != null) {
            return newString + ".N";
        }
        if (string.endsWith(".FI") && string_length > ".FI".length()) {
            s = string.substring(0, string_length - ".FI".length());
            return s + ".HE";
        }
        if (string.endsWith(".RU") && string_length > ".RU".length()) {
            s = string.substring(0, string_length - ".ME".length());
            return s + ".ME";
        }
        return code;
    }

    public static boolean needToPerformBackwardCompatible(File file) {
        String name = file.getName();
        return name.contains("realtimestock.csv") || name.contains("buyportfolio.csv") || name.contains("sellportfolio.csv") || name.contains("dividendsummary.csv");
    }

    public static boolean needToHandleMetadata(File file) {
        String name = file.getName();
        return name.contains("buyportfolio.csv") || name.contains("sellportfolio.csv");
    }

    public static void removeGoogleCodeDatabaseIfNecessary() {
        int versionCode = JStock.instance().getJStockOptions().getApplicationVersionID();
        if (versionCode <= 0) {
            return;
        }
        if (versionCode >= 1164) {
            return;
        }
        new File(Utils.getUserDataDirectory() + "google_code.db").delete();
        JStock.instance().getJStockOptions().setGoogleCodeDatabaseMetaTimestamp(Country.Malaysia, 0L);
    }
}

