/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.file.Atom;
import org.yccheok.jstock.file.GUIBundleWrapper;

public class Statement {
    private final GUIBundleWrapper guiBundleWrapper;
    private final Type type;
    private final List<Atom> atoms;
    private final Map<String, Object> typeToValue = new HashMap<String, Object>();
    private static final Log log = LogFactory.getLog(Statement.class);

    public Statement(List<Atom> atoms) {
        this.atoms = new ArrayList<Atom>(atoms);
        What what = Statement.whatAsAtoms(atoms);
        this.type = what.type;
        this.guiBundleWrapper = what.guiBundleWrapper;
        for (Atom atom : atoms) {
            Object oldObject = this.typeToValue.put(atom.getType(), atom.getValue());
            if (null == oldObject) continue;
            log.error((Object)(oldObject + " is being replaced by " + atom.getValue() + " with type " + atom.getType()));
        }
    }

    public Object getValue(String type) {
        return this.typeToValue.get(type);
    }

    public String getValueAsString(String type) {
        Object o = this.typeToValue.get(type);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public Double getValueAsDouble(String type) {
        Object o = this.typeToValue.get(type);
        if (o instanceof String) {
            String s = (String)o;
            if (!s.isEmpty()) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
        } else {
            String s;
            if (o instanceof Double) {
                return (Double)o;
            }
            if (o instanceof Integer) {
                Integer i = (Integer)o;
                Double d = (double)i;
                return d;
            }
            if (o != null && !(s = o.toString()).isEmpty()) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    private static What whatAsAtoms(List<Atom> atoms) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Atom atom : atoms) {
            strings.add(atom.getType());
        }
        return Statement.what(strings);
    }

    public static What what(List<String> strings) {
        GUIBundleWrapper.Language language;
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (String string : strings) {
            Atom atom = new Atom("", string);
            atoms.add(atom);
        }
        Type t = Type.Unknown;
        GUIBundleWrapper r = null;
        GUIBundleWrapper.Language[] languageArray = GUIBundleWrapper.Language.values();
        int n = languageArray.length;
        for (int i = 0; i < n && (t = Statement.whatType(atoms, r = GUIBundleWrapper.newInstance(language = languageArray[i]))) == Type.Unknown; ++i) {
        }
        return What.newInstance(t, r);
    }

    public static List<String> typeToStrings(Type type, GUIBundleWrapper guiBundleWrapper) {
        ArrayList<String> strings = new ArrayList<String>();
        if (type == Type.RealtimeInfo) {
            strings.add(guiBundleWrapper.getString("MainFrame_Code"));
            strings.add(guiBundleWrapper.getString("MainFrame_Symbol"));
            strings.add(guiBundleWrapper.getString("MainFrame_Prev"));
            strings.add(guiBundleWrapper.getString("MainFrame_Open"));
            strings.add(guiBundleWrapper.getString("MainFrame_Last"));
            strings.add(guiBundleWrapper.getString("MainFrame_High"));
            strings.add(guiBundleWrapper.getString("MainFrame_Low"));
            strings.add(guiBundleWrapper.getString("MainFrame_Vol"));
            strings.add(guiBundleWrapper.getString("MainFrame_Chg"));
            strings.add(guiBundleWrapper.getString("MainFrame_ChgPercentage"));
            strings.add(guiBundleWrapper.getString("MainFrame_LVol"));
            strings.add(guiBundleWrapper.getString("MainFrame_Buy"));
            strings.add(guiBundleWrapper.getString("MainFrame_BQty"));
            strings.add(guiBundleWrapper.getString("MainFrame_Sell"));
            strings.add(guiBundleWrapper.getString("MainFrame_SQty"));
            strings.add(guiBundleWrapper.getString("MainFrame_FallBelow"));
            strings.add(guiBundleWrapper.getString("MainFrame_RiseAbove"));
        } else if (type == Type.PortfolioManagementBuy) {
            strings.add(guiBundleWrapper.getString("MainFrame_Code"));
            strings.add(guiBundleWrapper.getString("MainFrame_Symbol"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Units"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_CurrentPrice"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_CurrentValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPrice"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPercentage"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_NetPurchaseValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossPercentage"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
        } else if (type == Type.PortfolioManagementSell) {
            strings.add(guiBundleWrapper.getString("MainFrame_Code"));
            strings.add(guiBundleWrapper.getString("MainFrame_Symbol"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_ReferenceDate"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Units"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingPrice"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseBroker"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseClearingFee"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseStampDuty"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPrice"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPercentage"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_NetSellingValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossValue"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossPercentage"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
        } else if (type == Type.PortfolioManagementDeposit) {
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Cash"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
        } else if (type == Type.PortfolioManagementDividend) {
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
            strings.add(guiBundleWrapper.getString("MainFrame_Code"));
            strings.add(guiBundleWrapper.getString("MainFrame_Symbol"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Dividend"));
            strings.add(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
        } else if (type == Type.StockIndicatorScanner) {
            strings.add(guiBundleWrapper.getString("IndicatorScannerJPanel_Indicator"));
            strings.add(guiBundleWrapper.getString("MainFrame_Code"));
            strings.add(guiBundleWrapper.getString("MainFrame_Symbol"));
            strings.add(guiBundleWrapper.getString("MainFrame_Prev"));
            strings.add(guiBundleWrapper.getString("MainFrame_Open"));
            strings.add(guiBundleWrapper.getString("MainFrame_Last"));
            strings.add(guiBundleWrapper.getString("MainFrame_High"));
            strings.add(guiBundleWrapper.getString("MainFrame_Low"));
            strings.add(guiBundleWrapper.getString("MainFrame_Vol"));
            strings.add(guiBundleWrapper.getString("MainFrame_Chg"));
            strings.add(guiBundleWrapper.getString("MainFrame_ChgPercentage"));
            strings.add(guiBundleWrapper.getString("MainFrame_LVol"));
            strings.add(guiBundleWrapper.getString("MainFrame_Buy"));
            strings.add(guiBundleWrapper.getString("MainFrame_BQty"));
            strings.add(guiBundleWrapper.getString("MainFrame_Sell"));
            strings.add(guiBundleWrapper.getString("MainFrame_SQty"));
            strings.add(guiBundleWrapper.getString("IndicatorScannerJPanel_MCapital"));
            strings.add(guiBundleWrapper.getString("IndicatorScannerJPanel_SIssued"));
        } else if (type == Type.StockHistory) {
            strings.add(guiBundleWrapper.getString("StockHistory_Date"));
            strings.add(guiBundleWrapper.getString("StockHistory_Open"));
            strings.add(guiBundleWrapper.getString("StockHistory_High"));
            strings.add(guiBundleWrapper.getString("StockHistory_Low"));
            strings.add(guiBundleWrapper.getString("StockHistory_Close"));
            strings.add(guiBundleWrapper.getString("StockHistory_Volume"));
        } else if (type == Type.StockPrice) {
            strings.add(guiBundleWrapper.getString("MainFrame_Code"));
            strings.add(guiBundleWrapper.getString("MainFrame_Last"));
        } else if (type == Type.StockInfoDatabase) {
            strings.add(guiBundleWrapper.getString("MainFrame_Code"));
            strings.add(guiBundleWrapper.getString("MainFrame_Symbol"));
            strings.add(guiBundleWrapper.getString("MainFrame_Industry"));
            strings.add(guiBundleWrapper.getString("MainFrame_Board"));
        } else if (type == Type.UserDefinedDatabase) {
            strings.add(guiBundleWrapper.getString("MainFrame_Code"));
            strings.add(guiBundleWrapper.getString("MainFrame_Symbol"));
        } else if (type == Type.StockNameDatabase) {
            strings.add(guiBundleWrapper.getString("MainFrame_Code"));
            strings.add(guiBundleWrapper.getString("MainFrame_Name"));
        } else if (type == Type.WatchlistInfos) {
            strings.add(guiBundleWrapper.getString("WatchlistInfo_Country"));
            strings.add(guiBundleWrapper.getString("WatchlistInfo_Name"));
            strings.add(guiBundleWrapper.getString("WatchlistInfo_Size"));
        } else if (type == Type.PortfolioInfos) {
            strings.add(guiBundleWrapper.getString("PortfolioInfo_Country"));
            strings.add(guiBundleWrapper.getString("PortfolioInfo_Name"));
            strings.add(guiBundleWrapper.getString("PortfolioInfo_Size"));
        } else assert (false);
        return strings;
    }

    private static Type whatType(List<Atom> atoms, GUIBundleWrapper guiBundleWrapper) {
        int size = atoms.size();
        if (size == 17 && atoms.get(0).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("MainFrame_Prev")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("MainFrame_Open")) && atoms.get(4).getType().equals(guiBundleWrapper.getString("MainFrame_Last")) && atoms.get(5).getType().equals(guiBundleWrapper.getString("MainFrame_High")) && atoms.get(6).getType().equals(guiBundleWrapper.getString("MainFrame_Low")) && atoms.get(7).getType().equals(guiBundleWrapper.getString("MainFrame_Vol")) && atoms.get(8).getType().equals(guiBundleWrapper.getString("MainFrame_Chg")) && atoms.get(9).getType().equals(guiBundleWrapper.getString("MainFrame_ChgPercentage")) && atoms.get(10).getType().equals(guiBundleWrapper.getString("MainFrame_LVol")) && atoms.get(11).getType().equals(guiBundleWrapper.getString("MainFrame_Buy")) && atoms.get(12).getType().equals(guiBundleWrapper.getString("MainFrame_BQty")) && atoms.get(13).getType().equals(guiBundleWrapper.getString("MainFrame_Sell")) && atoms.get(14).getType().equals(guiBundleWrapper.getString("MainFrame_SQty")) && atoms.get(15).getType().equals(guiBundleWrapper.getString("MainFrame_FallBelow")) && atoms.get(16).getType().equals(guiBundleWrapper.getString("MainFrame_RiseAbove"))) {
            return Type.RealtimeInfo;
        }
        if (size == 18 && atoms.get(0).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Date")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Units")) && atoms.get(4).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice")) && atoms.get(5).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_CurrentPrice")) && atoms.get(6).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseValue")) && atoms.get(7).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_CurrentValue")) && atoms.get(8).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPrice")) && atoms.get(9).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossValue")) && atoms.get(10).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPercentage")) && atoms.get(11).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker")) && atoms.get(12).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee")) && atoms.get(13).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty")) && atoms.get(14).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetPurchaseValue")) && atoms.get(15).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossValue")) && atoms.get(16).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossPercentage")) && atoms.get(17).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"))) {
            return Type.PortfolioManagementBuy;
        }
        if (size == 19 && atoms.get(0).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_ReferenceDate")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Date")) && atoms.get(4).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Units")) && atoms.get(5).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingPrice")) && atoms.get(6).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice")) && atoms.get(7).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingValue")) && atoms.get(8).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseValue")) && atoms.get(9).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPrice")) && atoms.get(10).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossValue")) && atoms.get(11).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPercentage")) && atoms.get(12).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker")) && atoms.get(13).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee")) && atoms.get(14).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty")) && atoms.get(15).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetSellingValue")) && atoms.get(16).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossValue")) && atoms.get(17).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossPercentage")) && atoms.get(18).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"))) {
            return Type.PortfolioManagementSell;
        }
        if (size == 20 && atoms.get(0).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_ReferenceDate")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Date")) && atoms.get(4).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Units")) && atoms.get(5).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingPrice")) && atoms.get(6).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice")) && atoms.get(7).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingValue")) && atoms.get(8).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseValue")) && atoms.get(9).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseFee")) && atoms.get(10).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPrice")) && atoms.get(11).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossValue")) && atoms.get(12).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPercentage")) && atoms.get(13).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker")) && atoms.get(14).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee")) && atoms.get(15).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty")) && atoms.get(16).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetSellingValue")) && atoms.get(17).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossValue")) && atoms.get(18).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossPercentage")) && atoms.get(19).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"))) {
            return Type.PortfolioManagementSell;
        }
        if (size == 22 && atoms.get(0).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_ReferenceDate")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Date")) && atoms.get(4).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Units")) && atoms.get(5).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingPrice")) && atoms.get(6).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice")) && atoms.get(7).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingValue")) && atoms.get(8).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseValue")) && atoms.get(9).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseBroker")) && atoms.get(10).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseClearingFee")) && atoms.get(11).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseStampDuty")) && atoms.get(12).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPrice")) && atoms.get(13).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossValue")) && atoms.get(14).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPercentage")) && atoms.get(15).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker")) && atoms.get(16).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee")) && atoms.get(17).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty")) && atoms.get(18).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetSellingValue")) && atoms.get(19).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossValue")) && atoms.get(20).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossPercentage")) && atoms.get(21).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"))) {
            return Type.PortfolioManagementSell;
        }
        if (size == 2 && atoms.get(0).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Date")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Cash"))) {
            return Type.PortfolioManagementDeposit;
        }
        if (size == 3 && atoms.get(0).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Date")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Cash")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"))) {
            return Type.PortfolioManagementDeposit;
        }
        if (size == 4 && atoms.get(0).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Date")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Dividend"))) {
            return Type.PortfolioManagementDividend;
        }
        if (size == 5 && atoms.get(0).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Date")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Dividend")) && atoms.get(4).getType().equals(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"))) {
            return Type.PortfolioManagementDividend;
        }
        if (size == 18 && atoms.get(0).getType().equals(guiBundleWrapper.getString("IndicatorScannerJPanel_Indicator")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("MainFrame_Prev")) && atoms.get(4).getType().equals(guiBundleWrapper.getString("MainFrame_Open")) && atoms.get(5).getType().equals(guiBundleWrapper.getString("MainFrame_Last")) && atoms.get(6).getType().equals(guiBundleWrapper.getString("MainFrame_High")) && atoms.get(7).getType().equals(guiBundleWrapper.getString("MainFrame_Low")) && atoms.get(8).getType().equals(guiBundleWrapper.getString("MainFrame_Vol")) && atoms.get(9).getType().equals(guiBundleWrapper.getString("MainFrame_Chg")) && atoms.get(10).getType().equals(guiBundleWrapper.getString("MainFrame_ChgPercentage")) && atoms.get(11).getType().equals(guiBundleWrapper.getString("MainFrame_LVol")) && atoms.get(12).getType().equals(guiBundleWrapper.getString("MainFrame_Buy")) && atoms.get(13).getType().equals(guiBundleWrapper.getString("MainFrame_BQty")) && atoms.get(14).getType().equals(guiBundleWrapper.getString("MainFrame_Sell")) && atoms.get(15).getType().equals(guiBundleWrapper.getString("MainFrame_SQty")) && atoms.get(16).getType().equals(guiBundleWrapper.getString("IndicatorScannerJPanel_MCapital")) && atoms.get(17).getType().equals(guiBundleWrapper.getString("IndicatorScannerJPanel_SIssued"))) {
            return Type.StockIndicatorScanner;
        }
        if (size == 6 && atoms.get(0).getType().equals(guiBundleWrapper.getString("StockHistory_Date")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("StockHistory_Open")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("StockHistory_High")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("StockHistory_Low")) && atoms.get(4).getType().equals(guiBundleWrapper.getString("StockHistory_Close")) && atoms.get(5).getType().equals(guiBundleWrapper.getString("StockHistory_Volume"))) {
            return Type.StockHistory;
        }
        if (size == 2 && atoms.get(0).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Last"))) {
            return Type.StockPrice;
        }
        if (size == 4 && atoms.get(0).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("MainFrame_Industry")) && atoms.get(3).getType().equals(guiBundleWrapper.getString("MainFrame_Board"))) {
            return Type.StockInfoDatabase;
        }
        if (size == 2 && atoms.get(0).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Symbol"))) {
            return Type.UserDefinedDatabase;
        }
        if (size == 2 && atoms.get(0).getType().equals(guiBundleWrapper.getString("MainFrame_Code")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("MainFrame_Name"))) {
            return Type.StockNameDatabase;
        }
        if (size == 3 && atoms.get(0).getType().equals(guiBundleWrapper.getString("WatchlistInfo_Country")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("WatchlistInfo_Name")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("WatchlistInfo_Size"))) {
            return Type.WatchlistInfos;
        }
        if (size == 3 && atoms.get(0).getType().equals(guiBundleWrapper.getString("PortfolioInfo_Country")) && atoms.get(1).getType().equals(guiBundleWrapper.getString("PortfolioInfo_Name")) && atoms.get(2).getType().equals(guiBundleWrapper.getString("PortfolioInfo_Size"))) {
            return Type.PortfolioInfos;
        }
        return Type.Unknown;
    }

    public int size() {
        return this.atoms.size();
    }

    public Atom getAtom(int index) {
        return this.atoms.get(index);
    }

    public GUIBundleWrapper getGUIBundleWrapper() {
        return this.guiBundleWrapper;
    }

    public static final class What {
        public final Type type;
        public final GUIBundleWrapper guiBundleWrapper;

        private What(Type type, GUIBundleWrapper guiBundleWrapper) {
            this.type = type;
            this.guiBundleWrapper = guiBundleWrapper;
        }

        public static What newInstance(Type type, GUIBundleWrapper guiBundleWrapper) {
            return new What(type, guiBundleWrapper);
        }
    }

    public static enum Type {
        RealtimeInfo,
        PortfolioManagementBuy,
        PortfolioManagementSell,
        PortfolioManagementDeposit,
        PortfolioManagementDividend,
        StockIndicatorScanner,
        StockHistory,
        StockPrice,
        StockInfoDatabase,
        UserDefinedDatabase,
        StockNameDatabase,
        WatchlistInfos,
        PortfolioInfos,
        Unknown;

    }
}

