/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.file;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class GUIBundleWrapper {
    private final ResourceBundle guiBundleWrapper;
    private static volatile Map<String, String> map = null;

    public static GUIBundleWrapper newInstance(Language language) {
        return new GUIBundleWrapper(language);
    }

    private GUIBundleWrapper(Language type) {
        if (type == Language.INDEPENDENT) {
            this.guiBundleWrapper = null;
        } else if (type == Language.ENGLISH) {
            this.guiBundleWrapper = ResourceBundle.getBundle("org.yccheok.jstock.data.gui", Locale.ENGLISH);
        } else if (type == Language.SIMPLIFIED_CHINESE) {
            this.guiBundleWrapper = ResourceBundle.getBundle("org.yccheok.jstock.data.gui", Locale.SIMPLIFIED_CHINESE);
        } else if (type == Language.GERMAN) {
            this.guiBundleWrapper = ResourceBundle.getBundle("org.yccheok.jstock.data.gui", Locale.GERMAN);
        } else if (type == Language.TRADITIONAL_CHINESE) {
            this.guiBundleWrapper = ResourceBundle.getBundle("org.yccheok.jstock.data.gui", Locale.TRADITIONAL_CHINESE);
        } else if (type == Language.ITALIAN) {
            this.guiBundleWrapper = ResourceBundle.getBundle("org.yccheok.jstock.data.gui", Locale.ITALIAN);
        } else {
            assert (type == Language.DEFAULT);
            this.guiBundleWrapper = ResourceBundle.getBundle("org.yccheok.jstock.data.gui");
        }
    }

    public String getString(String key) {
        if (this.guiBundleWrapper == null) {
            return GUIBundleWrapper.getLanguageIndependentString(key);
        }
        return this.guiBundleWrapper.getString(key);
    }

    private static void initMap() {
        if (map != null) {
            return;
        }
        HashMap<String, String> _map = new HashMap<String, String>();
        _map.put("MainFrame_Stock", "Stock");
        _map.put("MainFrame_Code", "Code");
        _map.put("MainFrame_Symbol", "Symbol");
        _map.put("MainFrame_Prev", "Prev");
        _map.put("MainFrame_Open", "Open");
        _map.put("MainFrame_Last", "Last");
        _map.put("MainFrame_High", "High");
        _map.put("MainFrame_Low", "Low");
        _map.put("MainFrame_Vol", "Vol");
        _map.put("MainFrame_Chg", "Chg");
        _map.put("MainFrame_ChgPercentage", "Chg (%)");
        _map.put("MainFrame_LVol", "L.Vol");
        _map.put("MainFrame_Buy", "Buy");
        _map.put("MainFrame_BQty", "B.Qty");
        _map.put("MainFrame_Sell", "Sell");
        _map.put("MainFrame_SQty", "S.Qty");
        _map.put("MainFrame_FallBelow", "Fall Below");
        _map.put("MainFrame_RiseAbove", "Rise Above");
        _map.put("MainFrame_Industry", "Industry");
        _map.put("MainFrame_Board", "Board");
        _map.put("MainFrame_Name", "Name");
        _map.put("PortfolioManagementJPanel_Stock", "Stock");
        _map.put("PortfolioManagementJPanel_Date", "Date");
        _map.put("PortfolioManagementJPanel_Units", "Units");
        _map.put("PortfolioManagementJPanel_PurchasePrice", "Purchase Price");
        _map.put("PortfolioManagementJPanel_CurrentPrice", "Current Price");
        _map.put("PortfolioManagementJPanel_PurchaseValue", "Purchase Value");
        _map.put("PortfolioManagementJPanel_PurchaseFee", "Purchase Fee");
        _map.put("PortfolioManagementJPanel_PurchaseBroker", "Purchase Broker");
        _map.put("PortfolioManagementJPanel_PurchaseClearingFee", "Purchase Clearing Fee");
        _map.put("PortfolioManagementJPanel_PurchaseStampDuty", "Purchase Stamp Duty");
        _map.put("PortfolioManagementJPanel_CurrentValue", "Current Value");
        _map.put("PortfolioManagementJPanel_GainLossPrice", "Gain/Loss Price");
        _map.put("PortfolioManagementJPanel_GainLossValue", "Gain/Loss Value");
        _map.put("PortfolioManagementJPanel_GainLossPercentage", "Gain/Loss %");
        _map.put("PortfolioManagementJPanel_Broker", "Broker");
        _map.put("PortfolioManagementJPanel_ClearingFee", "Clearing Fee");
        _map.put("PortfolioManagementJPanel_StampDuty", "Stamp Duty");
        _map.put("PortfolioManagementJPanel_NetPurchaseValue", "Net Purchase Value");
        _map.put("PortfolioManagementJPanel_NetGainLossValue", "Net Gain/Loss Value");
        _map.put("PortfolioManagementJPanel_NetGainLossPercentage", "Net Gain/Loss %");
        _map.put("PortfolioManagementJPanel_Comment", "Comment");
        _map.put("PortfolioManagementJPanel_ReferenceDate", "Purchase Date");
        _map.put("PortfolioManagementJPanel_SellingPrice", "Selling Price");
        _map.put("PortfolioManagementJPanel_SellingValue", "Selling Value");
        _map.put("PortfolioManagementJPanel_NetSellingValue", "Net Selling Value");
        _map.put("PortfolioManagementJPanel_Cash", "Cash");
        _map.put("PortfolioManagementJPanel_Dividend", "Dividend");
        _map.put("IndicatorScannerJPanel_Indicator", "Indicator");
        _map.put("IndicatorScannerJPanel_MCapital", "M.Capital");
        _map.put("IndicatorScannerJPanel_SIssued", "S.Issued");
        _map.put("StockHistory_Date", "Date");
        _map.put("StockHistory_Open", "Open");
        _map.put("StockHistory_High", "High");
        _map.put("StockHistory_Low", "Low");
        _map.put("StockHistory_Close", "Close");
        _map.put("StockHistory_Volume", "Volume");
        _map.put("WatchlistInfo_Country", "Country");
        _map.put("WatchlistInfo_Name", "Watchlist Name");
        _map.put("WatchlistInfo_Size", "Size");
        _map.put("PortfolioInfo_Country", "Country");
        _map.put("PortfolioInfo_Name", "Portfolio Name");
        _map.put("PortfolioInfo_Size", "Size");
        map = _map;
    }

    private static String getLanguageIndependentString(String key) {
        GUIBundleWrapper.initMap();
        assert (map.containsKey(key));
        String s = map.get(key);
        if (s == null) {
            throw new IllegalArgumentException(key);
        }
        return s;
    }

    public static enum Language {
        INDEPENDENT,
        ENGLISH,
        SIMPLIFIED_CHINESE,
        GERMAN,
        TRADITIONAL_CHINESE,
        ITALIAN,
        DEFAULT;

    }
}

