/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.PinyinTSTSearchEngine;
import org.yccheok.jstock.engine.SearchEngine;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.TSTSearchEngine;
import org.yccheok.jstock.engine.Utils;

public class StockInfoDatabase {
    private final List<StockInfo> stockInfos = new ArrayList<StockInfo>();
    private final Map<Industry, List<StockInfo>> industryToStockInfos = new HashMap<Industry, List<StockInfo>>();
    private final Map<Board, List<StockInfo>> boardToStockInfos = new HashMap<Board, List<StockInfo>>();
    private transient Map<Symbol, List<StockInfo>> symbolToStockInfos = new HashMap<Symbol, List<StockInfo>>();
    private transient Map<Code, StockInfo> codeToStockInfos = new HashMap<Code, StockInfo>();
    private transient SearchEngine<StockInfo> symbolSearchEngine;
    private transient SearchEngine<StockInfo> symbolPinyinSearchEngine;
    private transient SearchEngine<StockInfo> codeSearchEngine;
    private transient Lock reader;
    private transient Lock writer;

    public StockInfoDatabase(List<Stock> stocks) {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.reader = readWriteLock.readLock();
        this.writer = readWriteLock.writeLock();
        this.init(stocks);
    }

    private void init(List<Stock> stocks) {
        ArrayList<StockInfoWithSymbolAsString> stockInfosWithSymbolAsString = new ArrayList<StockInfoWithSymbolAsString>();
        for (Stock stock : stocks) {
            Code code = stock.code;
            Symbol symbol = stock.symbol;
            Industry industry = stock.getIndustry();
            Board board = stock.getBoard();
            StockInfo stockInfo = StockInfo.newInstance(code, symbol);
            StockInfoWithSymbolAsString stockInfoWithSymbolAsString = new StockInfoWithSymbolAsString(code, symbol);
            this.stockInfos.add(stockInfo);
            stockInfosWithSymbolAsString.add(stockInfoWithSymbolAsString);
            List<StockInfo> _stockInfos = this.industryToStockInfos.get(industry);
            if (_stockInfos == null) {
                _stockInfos = new ArrayList<StockInfo>();
                this.industryToStockInfos.put(industry, _stockInfos);
            }
            _stockInfos.add(stockInfo);
            _stockInfos = this.boardToStockInfos.get(board);
            if (_stockInfos == null) {
                _stockInfos = new ArrayList<StockInfo>();
                this.boardToStockInfos.put(board, _stockInfos);
            }
            _stockInfos.add(stockInfo);
            this.codeToStockInfos.put(stockInfo.code, stockInfo);
            List<StockInfo> s = this.symbolToStockInfos.get(stockInfo.symbol);
            if (s == null) {
                s = new ArrayList<StockInfo>();
                this.symbolToStockInfos.put(stockInfo.symbol, s);
            }
            s.add(stockInfo);
        }
        this.symbolPinyinSearchEngine = Utils.isPinyinTSTSearchEngineRequiredForSymbol() ? new PinyinTSTSearchEngine(stockInfosWithSymbolAsString) : null;
        this.symbolSearchEngine = new TSTSearchEngine<StockInfo>(stockInfosWithSymbolAsString);
        this.codeSearchEngine = new TSTSearchEngine<StockInfo>(this.stockInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StockInfo> searchStockInfos(String string) {
        this.reader.lock();
        try {
            List<StockInfo> _stockInfos = this.codeSearchEngine.searchAll(string);
            if (_stockInfos.isEmpty()) {
                if (this.symbolPinyinSearchEngine != null) {
                    _stockInfos = this.symbolPinyinSearchEngine.searchAll(string);
                    if (_stockInfos.isEmpty()) {
                        _stockInfos = this.symbolSearchEngine.searchAll(string);
                    }
                } else {
                    _stockInfos = this.symbolSearchEngine.searchAll(string);
                }
            }
            List<StockInfo> list = _stockInfos;
            return list;
        }
        finally {
            this.reader.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StockInfo> greedySearchStockInfos(String string) {
        this.reader.lock();
        try {
            List<StockInfo> _stockInfos = this.codeSearchEngine.searchAll(string);
            if (_stockInfos.isEmpty() && this.symbolPinyinSearchEngine != null) {
                _stockInfos = this.symbolPinyinSearchEngine.searchAll(string);
            }
            _stockInfos.addAll(this.symbolSearchEngine.searchAll(string));
            LinkedHashSet<StockInfo> hs = new LinkedHashSet<StockInfo>();
            hs.addAll(_stockInfos);
            _stockInfos.clear();
            _stockInfos.addAll(hs);
            List<StockInfo> list = _stockInfos;
            return list;
        }
        finally {
            this.reader.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StockInfo searchStockInfo(String string) {
        this.reader.lock();
        try {
            StockInfo stockInfo = this.codeSearchEngine.search(string);
            if (null == stockInfo) {
                if (this.symbolPinyinSearchEngine != null) {
                    stockInfo = this.symbolPinyinSearchEngine.search(string);
                    if (null == stockInfo) {
                        stockInfo = this.symbolSearchEngine.search(string);
                    }
                } else {
                    stockInfo = this.symbolSearchEngine.search(string);
                }
            }
            StockInfo stockInfo2 = stockInfo;
            return stockInfo2;
        }
        finally {
            this.reader.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StockInfo> getStockInfos(Industry industry) {
        this.reader.lock();
        try {
            List<StockInfo> list = this.industryToStockInfos.get(industry);
            if (list == null) {
                List<StockInfo> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<StockInfo> arrayList = new ArrayList<StockInfo>(list);
            return arrayList;
        }
        finally {
            this.reader.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StockInfo> getStockInfos(Board board) {
        this.reader.lock();
        try {
            List<StockInfo> list = this.boardToStockInfos.get(board);
            if (list == null) {
                List<StockInfo> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<StockInfo> arrayList = new ArrayList<StockInfo>(list);
            return arrayList;
        }
        finally {
            this.reader.unlock();
        }
    }

    public List<StockInfo> getStockInfos() {
        this.reader.lock();
        try {
            ArrayList<StockInfo> arrayList = new ArrayList<StockInfo>(this.stockInfos);
            return arrayList;
        }
        finally {
            this.reader.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllUserDefinedStockInfos() {
        this.writer.lock();
        try {
            List<StockInfo> _stockInfos = this.industryToStockInfos.get(Industry.UserDefined);
            if (_stockInfos == null) {
                boolean bl = false;
                return bl;
            }
            _stockInfos = new ArrayList<StockInfo>(_stockInfos);
            boolean result = true;
            for (StockInfo stockInfo : _stockInfos) {
                result &= this.removeUserDefinedStockInfo(stockInfo);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.writer.unlock();
        }
    }

    private boolean removeUserDefinedStockInfo(StockInfo stockInfo) {
        if (stockInfo == null) {
            throw new IllegalArgumentException("Stock info cannot be null");
        }
        if (stockInfo.code.toString().trim().length() <= 0 || stockInfo.symbol.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("Stock info length cannot be 0");
        }
        Industry industry = Industry.UserDefined;
        Board board = Board.UserDefined;
        List<StockInfo> iStockInfos = this.industryToStockInfos.get(industry);
        List<StockInfo> bStockInfos = this.boardToStockInfos.get(board);
        List<StockInfo> sStockInfos = this.symbolToStockInfos.get(stockInfo.symbol);
        if (iStockInfos == null || !iStockInfos.contains(stockInfo)) {
            return false;
        }
        if (bStockInfos == null || !bStockInfos.contains(stockInfo)) {
            return false;
        }
        if (sStockInfos == null || !sStockInfos.contains(stockInfo)) {
            return false;
        }
        if (!(this.symbolSearchEngine instanceof TSTSearchEngine) || !(this.codeSearchEngine instanceof TSTSearchEngine)) {
            return false;
        }
        if (this.symbolPinyinSearchEngine != null && !(this.symbolPinyinSearchEngine instanceof PinyinTSTSearchEngine)) {
            return false;
        }
        this.stockInfos.remove(stockInfo);
        StockInfoWithSymbolAsString stockInfoWithSymbolAsString = new StockInfoWithSymbolAsString(stockInfo.code, stockInfo.symbol);
        if (this.symbolPinyinSearchEngine != null) {
            ((PinyinTSTSearchEngine)this.symbolPinyinSearchEngine).remove(stockInfoWithSymbolAsString);
        }
        ((TSTSearchEngine)this.symbolSearchEngine).remove(stockInfoWithSymbolAsString);
        ((TSTSearchEngine)this.codeSearchEngine).remove(stockInfo);
        iStockInfos.remove(stockInfo);
        if (iStockInfos.isEmpty()) {
            this.industryToStockInfos.remove(industry);
        }
        bStockInfos.remove(stockInfo);
        if (bStockInfos.isEmpty()) {
            this.boardToStockInfos.remove(board);
        }
        sStockInfos.remove(stockInfo);
        if (sStockInfos.isEmpty()) {
            this.symbolToStockInfos.remove(stockInfo.symbol);
        }
        this.codeToStockInfos.remove(stockInfo.code);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StockInfo> getNonUserDefinedStockInfos() {
        this.reader.lock();
        try {
            ArrayList<StockInfo> _stockInfos = new ArrayList<StockInfo>(this.stockInfos);
            List<StockInfo> userDefinedStockInfos = this.industryToStockInfos.get(Industry.UserDefined);
            if (userDefinedStockInfos != null) {
                _stockInfos.removeAll(userDefinedStockInfos);
            }
            ArrayList<StockInfo> arrayList = _stockInfos;
            return arrayList;
        }
        finally {
            this.reader.unlock();
        }
    }

    public List<StockInfo> getUserDefinedStockInfos() {
        this.reader.lock();
        try {
            List<StockInfo> _stockInfos = this.industryToStockInfos.get(Industry.UserDefined);
            if (_stockInfos == null) {
                ArrayList<StockInfo> arrayList = new ArrayList<StockInfo>();
                return arrayList;
            }
            ArrayList<StockInfo> arrayList = new ArrayList<StockInfo>(_stockInfos);
            return arrayList;
        }
        finally {
            this.reader.unlock();
        }
    }

    public boolean addUserDefinedStockInfo(StockInfo stockInfo) {
        this.writer.lock();
        try {
            boolean bl = this._addUserDefinedStockInfo(stockInfo);
            return bl;
        }
        finally {
            this.writer.unlock();
        }
    }

    private boolean _addUserDefinedStockInfo(StockInfo stockInfo) {
        if (stockInfo == null) {
            throw new IllegalArgumentException("Stock info cannot be null");
        }
        if (stockInfo.code.toString().trim().length() <= 0 || stockInfo.symbol.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("Stock info length cannot be 0");
        }
        if (this.codeToStockInfos.containsKey(stockInfo.code)) {
            return false;
        }
        if (!(this.symbolSearchEngine instanceof TSTSearchEngine) || !(this.codeSearchEngine instanceof TSTSearchEngine)) {
            return false;
        }
        if (this.symbolPinyinSearchEngine != null && !(this.symbolPinyinSearchEngine instanceof PinyinTSTSearchEngine)) {
            return false;
        }
        this.stockInfos.add(stockInfo);
        StockInfoWithSymbolAsString stockInfoWithSymbolAsString = new StockInfoWithSymbolAsString(stockInfo.code, stockInfo.symbol);
        if (this.symbolPinyinSearchEngine != null) {
            ((PinyinTSTSearchEngine)this.symbolPinyinSearchEngine).put(stockInfoWithSymbolAsString);
        }
        ((TSTSearchEngine)this.symbolSearchEngine).put(stockInfoWithSymbolAsString);
        ((TSTSearchEngine)this.codeSearchEngine).put(stockInfo);
        Industry industry = Industry.UserDefined;
        Board board = Board.UserDefined;
        List<StockInfo> _stockInfos = this.industryToStockInfos.get(industry);
        if (_stockInfos == null) {
            _stockInfos = new ArrayList<StockInfo>();
            this.industryToStockInfos.put(industry, _stockInfos);
        }
        _stockInfos.add(stockInfo);
        _stockInfos = this.boardToStockInfos.get(board);
        if (_stockInfos == null) {
            _stockInfos = new ArrayList<StockInfo>();
            this.boardToStockInfos.put(board, _stockInfos);
        }
        _stockInfos.add(stockInfo);
        this.codeToStockInfos.put(stockInfo.code, stockInfo);
        List<StockInfo> s = this.symbolToStockInfos.get(stockInfo.symbol);
        if (s == null) {
            s = new ArrayList<StockInfo>();
            this.symbolToStockInfos.put(stockInfo.symbol, s);
        }
        s.add(stockInfo);
        return true;
    }

    public boolean isEmpty() {
        this.reader.lock();
        try {
            boolean bl = this.stockInfos.isEmpty();
            return bl;
        }
        finally {
            this.reader.unlock();
        }
    }

    public int size() {
        this.reader.lock();
        try {
            int n = this.stockInfos.size();
            return n;
        }
        finally {
            this.reader.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol codeToSymbol(Code code) {
        this.reader.lock();
        try {
            StockInfo stockInfo = this.codeToStockInfo(code);
            Symbol symbol = stockInfo != null ? stockInfo.symbol : null;
            return symbol;
        }
        finally {
            this.reader.unlock();
        }
    }

    public StockInfo codeToStockInfo(Code code) {
        this.reader.lock();
        try {
            StockInfo stockInfo = this.codeToStockInfos.get(code);
            return stockInfo;
        }
        finally {
            this.reader.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StockInfo> symbolToStockInfos(Symbol symbol) {
        this.reader.lock();
        try {
            List<StockInfo> _stockInfos = this.symbolToStockInfos.get(symbol);
            if (_stockInfos == null) {
                List<StockInfo> list = Collections.emptyList();
                return list;
            }
            List<StockInfo> list = _stockInfos;
            return list;
        }
        finally {
            this.reader.unlock();
        }
    }

    public List<Board> getBoards() {
        this.reader.lock();
        try {
            ArrayList<Board> arrayList = new ArrayList<Board>(this.boardToStockInfos.keySet());
            return arrayList;
        }
        finally {
            this.reader.unlock();
        }
    }

    public List<Industry> getIndustries() {
        this.reader.lock();
        try {
            ArrayList<Industry> arrayList = new ArrayList<Industry>(this.industryToStockInfos.keySet());
            return arrayList;
        }
        finally {
            this.reader.unlock();
        }
    }

    private static final class StockInfoWithSymbolAsString
    extends StockInfo {
        public StockInfoWithSymbolAsString(Code code, Symbol symbol) {
            super(code, symbol);
        }

        @Override
        public String toString() {
            return this.symbol.toString();
        }
    }
}

