/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.Symbol;

public class StockInfo {
    public final Code code;
    public final Symbol symbol;

    public static StockInfo newInstance(Stock stock) {
        return new StockInfo(stock.code, stock.symbol);
    }

    public static StockInfo newInstance(Code code, Symbol symbol) {
        return new StockInfo(code, symbol);
    }

    public StockInfo(Code code, Symbol symbol) {
        if (code == null) {
            throw new IllegalArgumentException("code cannot be null");
        }
        if (symbol == null) {
            throw new IllegalArgumentException("symbol cannot be null");
        }
        this.code = code;
        this.symbol = symbol;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockInfo)) {
            return false;
        }
        StockInfo stockInfo = (StockInfo)o;
        return this.code.equals(stockInfo.code) && this.symbol.equals(stockInfo.symbol);
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + this.code.hashCode();
        hash = 43 * hash + this.symbol.hashCode();
        return hash;
    }

    public String toString() {
        return this.code.toString();
    }
}

