/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.concurrent.ConcurrentHashMap;

public class Industry
implements Comparable<Industry> {
    private final String industry;
    private static final ConcurrentHashMap<String, Industry> map = new ConcurrentHashMap();
    public static final Industry Unknown = Industry.valueOf("Unknown");
    public static final Industry UserDefined = Industry.valueOf("UserDefined");

    private Industry(String industry) {
        assert (industry != null);
        this.industry = industry;
    }

    public static Industry valueOf(String industry) {
        Industry instance;
        if (industry == null) {
            throw new IllegalArgumentException("industry cannot be null");
        }
        if ((industry = industry.trim()).isEmpty()) {
            throw new IllegalArgumentException("industry cannot be empty");
        }
        Industry result = map.get(industry);
        if (result == null && (result = map.putIfAbsent(industry, instance = new Industry(industry))) == null) {
            result = instance;
        }
        assert (result != null);
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.industry.hashCode();
        return result;
    }

    @Override
    public int compareTo(Industry o) {
        return this.industry.compareTo(o.industry);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Industry)) {
            return false;
        }
        return this.industry.equals(((Industry)o).industry);
    }

    public String toString() {
        return this.industry;
    }

    public String name() {
        return this.industry;
    }
}

