/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.SearchEngine;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.gui.JStock;

public class AjaxStockInfoSearchEngine
implements SearchEngine<StockInfo> {
    @Override
    public List<StockInfo> searchAll(String prefix) {
        Code code = Code.newInstance(prefix.toUpperCase());
        Country country = Utils.toCountry(code);
        boolean searchRequired = false;
        if (this.isSupported(country)) {
            searchRequired = true;
        } else {
            country = JStock.instance().getJStockOptions().getCountry();
            if (this.isSupported(country)) {
                boolean bl = searchRequired = (code = this.toDeepSearchCode(code, country)) != null;
            }
        }
        if (searchRequired) {
            assert (code != null);
            Stock stock = Utils.getStock(code);
            if (stock != null) {
                StockInfo stockInfo = StockInfo.newInstance(stock.code, stock.symbol);
                ArrayList<StockInfo> stockInfos = new ArrayList<StockInfo>();
                stockInfos.add(stockInfo);
                return stockInfos;
            }
        }
        return Collections.emptyList();
    }

    private Code toDeepSearchCode(Code code, Country country) {
        String s = code.toString().toUpperCase();
        switch (country) {
            case Malaysia: {
                if (s.endsWith(".KL")) {
                    return code;
                }
                if (s.endsWith(".K")) {
                    s = s + "L";
                } else if (s.endsWith(".")) {
                    s = s + "KL";
                } else if (s.matches("^[0-9]{4}[0-9A-Z]{2}$")) {
                    s = s + ".KL";
                } else {
                    return null;
                }
                return Code.newInstance(s);
            }
        }
        return null;
    }

    @Override
    public StockInfo search(String prefix) {
        List<StockInfo> list = this.searchAll(prefix);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private boolean isSupported(Country country) {
        return true;
    }
}

