/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import org.yccheok.jstock.analysis.AbstractBean;
import org.yccheok.jstock.analysis.Connection;
import org.yccheok.jstock.analysis.Connector;
import org.yccheok.jstock.analysis.ConnectorEvent;
import org.yccheok.jstock.analysis.Operator;
import org.yccheok.jstock.analysis.Utils;

public abstract class AbstractOperator
extends AbstractBean
implements Operator {
    protected Connector[] outputs = new Connector[this.getNumOfOutputConnector()];
    protected Connector[] inputs = new Connector[this.getNumOfInputConnector()];
    protected Connection[] outputConnections = new Connection[this.getNumOfOutputConnector()];
    protected Connection[] inputConnections = new Connection[this.getNumOfInputConnector()];
    protected int outputConnectionSize = 0;
    protected int inputConnectionSize = 0;
    private boolean loopbackflag;

    public AbstractOperator() {
        int i;
        for (i = 0; i < this.getNumOfOutputConnector(); ++i) {
            this.outputs[i] = new Connector(this, i);
            this.outputConnections[i] = null;
        }
        for (i = 0; i < this.getNumOfInputConnector(); ++i) {
            this.inputs[i] = new Connector(this, i);
            this.inputs[i].addConnectorValueChangeListener(this);
            this.inputConnections[i] = null;
        }
        this.loopbackflag = false;
    }

    @Override
    public void connectorValueChange(ConnectorEvent evt) {
        if (!this.isInputReady()) {
            for (Connector output : this.outputs) {
                Object old = output.getValue();
                output.setValue(null);
                if (Utils.equals(old, output.getValue())) continue;
                this.firePropertyChange("value", old, output.getValue());
            }
            return;
        }
        Object newValue = this.calculate();
        for (Connector output : this.outputs) {
            Object old = output.getValue();
            output.setValue(newValue);
            if (Utils.equals(old, output.getValue())) continue;
            this.firePropertyChange("value", old, output.getValue());
        }
    }

    @Override
    public int getNumOfOutputConnector() {
        return 1;
    }

    @Override
    public int getNumOfOutputConnection() {
        return this.outputConnectionSize;
    }

    @Override
    public int getNumOfInputConnection() {
        return this.inputConnectionSize;
    }

    @Override
    public boolean addInputConnection(Connection connection, int index) {
        if (index >= this.inputConnections.length) {
            return false;
        }
        if (this.inputConnections[index] != null) {
            return false;
        }
        this.inputConnections[index] = connection;
        this.inputConnections[index].setOutputConnector(this.inputs[index]);
        ++this.inputConnectionSize;
        return true;
    }

    @Override
    public boolean removeInputConnection(int index) {
        this.inputConnections[index].setOutputConnector(null);
        this.inputConnections[index] = null;
        --this.inputConnectionSize;
        return true;
    }

    @Override
    public boolean removeOutputConnection(int index) {
        this.outputConnections[index].setInputConnector(null);
        this.outputConnections[index] = null;
        --this.outputConnectionSize;
        this.outputs[index].removeConnectorValueChangeListener(this.outputConnections[index]);
        return true;
    }

    @Override
    public boolean removeInputConnection(Connection connection) {
        int length = this.inputConnections.length;
        for (int i = 0; i < length; ++i) {
            if (this.inputConnections[i] != connection) continue;
            return this.removeInputConnection(i);
        }
        return false;
    }

    @Override
    public boolean addOutputConnection(Connection connection, int index) {
        if (index >= this.outputConnections.length) {
            return false;
        }
        if (this.outputConnections[index] != null) {
            return false;
        }
        this.outputConnections[index] = connection;
        this.outputConnections[index].setInputConnector(this.outputs[index]);
        ++this.outputConnectionSize;
        this.outputs[index].addConnectorValueChangeListener(this.outputConnections[index]);
        return true;
    }

    @Override
    public boolean removeOutputConnection(Connection connection) {
        int length = this.outputConnections.length;
        for (int i = 0; i < length; ++i) {
            if (this.outputConnections[i] != connection) continue;
            return this.removeOutputConnection(i);
        }
        return false;
    }

    @Override
    public boolean pull() {
        if (this.loopbackflag) {
            return false;
        }
        if (this.inputs.length == 0) {
            this.outputs[0].setValue(this.calculate());
            return true;
        }
        int length = this.inputs.length;
        boolean status = true;
        for (int i = 0; i < length; ++i) {
            if (this.inputConnections[i] == null) {
                status = false;
                break;
            }
            if (this.inputConnections[i].getInputConnector() == null) {
                status = false;
                break;
            }
            this.loopbackflag = true;
            if (this.inputConnections[i].getInputConnector().getOperator().pull()) continue;
            status = false;
            break;
        }
        this.loopbackflag = false;
        return status;
    }

    @Override
    public void clear() {
        for (Connector input : this.inputs) {
            input.setValue(null);
        }
        for (Connector output : this.outputs) {
            output.setValue(null);
        }
    }

    private boolean isInputReady() {
        for (Connector input : this.inputs) {
            if (input.getValue() != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName() + " [ input = ");
        for (Connector input : this.inputs) {
            builder.append(input.getValue() + " ");
        }
        builder.append("] [ output = ");
        for (Connector output : this.outputs) {
            builder.append(output.getValue() + " ");
        }
        builder.append("] [ inputConnectionSize = " + this.inputConnectionSize + " ]");
        builder.append(" [ outputConnectionSize = " + this.outputConnectionSize + " ]");
        return builder.toString();
    }

    protected abstract Object calculate();
}

