/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

class Util {
    private static final Image ICON16 = new ImageIcon(Util.class.getResource("/images/tomato.png")).getImage();
    private static final Image ICON32 = new ImageIcon(Util.class.getResource("/images/tomato32.png")).getImage();
    private static final List<Image> ICONS = new ArrayList<Image>();

    Util() {
    }

    private static void center(Window w) {
        Dimension windowSize = w.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - windowSize.width) / 2;
        int y = (screenSize.height - windowSize.height) / 2;
        w.setLocation(x, y);
    }

    private static void setIcon(Window w) {
        w.setIconImages(ICONS);
    }

    public static void decorate(Window w) {
        Util.center(w);
        Util.setIcon(w);
    }

    public static void addEscapeListener(final JDialog d) {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                d.setVisible(false);
            }
        };
        d.getRootPane().registerKeyboardAction(al, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public static void decorate(JDialog d, boolean closeOnEscape) {
        Util.center(d);
        Util.setIcon(d);
        if (closeOnEscape) {
            Util.addEscapeListener(d);
        }
    }

    static {
        ICONS.add(ICON16);
        ICONS.add(ICON32);
    }
}

