/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.transport.socket.AbstractSocketSessionConfig;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioSocketSession
extends NioSession {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("nio", "socket", false, true, InetSocketAddress.class, SocketSessionConfig.class, IoBuffer.class, FileRegion.class);

    private Socket getSocket() {
        return ((SocketChannel)this.channel).socket();
    }

    public NioSocketSession(IoService ioService, IoProcessor<NioSession> ioProcessor, SocketChannel socketChannel) {
        super(ioProcessor, ioService, socketChannel);
        this.config = new SessionConfigImpl();
        this.config.setAll(ioService.getSessionConfig());
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    @Override
    public SocketSessionConfig getConfig() {
        return (SocketSessionConfig)this.config;
    }

    @Override
    SocketChannel getChannel() {
        return (SocketChannel)this.channel;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (this.channel == null) {
            return null;
        }
        Socket socket = this.getSocket();
        if (socket == null) {
            return null;
        }
        return (InetSocketAddress)socket.getRemoteSocketAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (this.channel == null) {
            return null;
        }
        Socket socket = this.getSocket();
        if (socket == null) {
            return null;
        }
        return (InetSocketAddress)socket.getLocalSocketAddress();
    }

    private class SessionConfigImpl
    extends AbstractSocketSessionConfig {
        private SessionConfigImpl() {
        }

        public boolean isKeepAlive() {
            try {
                return NioSocketSession.this.getSocket().getKeepAlive();
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public void setKeepAlive(boolean bl) {
            try {
                NioSocketSession.this.getSocket().setKeepAlive(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public boolean isOobInline() {
            try {
                return NioSocketSession.this.getSocket().getOOBInline();
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public void setOobInline(boolean bl) {
            try {
                NioSocketSession.this.getSocket().setOOBInline(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public boolean isReuseAddress() {
            try {
                return NioSocketSession.this.getSocket().getReuseAddress();
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public void setReuseAddress(boolean bl) {
            try {
                NioSocketSession.this.getSocket().setReuseAddress(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public int getSoLinger() {
            try {
                return NioSocketSession.this.getSocket().getSoLinger();
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public void setSoLinger(int n) {
            try {
                if (n < 0) {
                    NioSocketSession.this.getSocket().setSoLinger(false, 0);
                } else {
                    NioSocketSession.this.getSocket().setSoLinger(true, n);
                }
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public boolean isTcpNoDelay() {
            if (!NioSocketSession.this.isConnected()) {
                return false;
            }
            try {
                return NioSocketSession.this.getSocket().getTcpNoDelay();
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public void setTcpNoDelay(boolean bl) {
            try {
                NioSocketSession.this.getSocket().setTcpNoDelay(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public int getTrafficClass() {
            try {
                return NioSocketSession.this.getSocket().getTrafficClass();
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public void setTrafficClass(int n) {
            try {
                NioSocketSession.this.getSocket().setTrafficClass(n);
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public int getSendBufferSize() {
            try {
                return NioSocketSession.this.getSocket().getSendBufferSize();
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public void setSendBufferSize(int n) {
            try {
                NioSocketSession.this.getSocket().setSendBufferSize(n);
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public int getReceiveBufferSize() {
            try {
                return NioSocketSession.this.getSocket().getReceiveBufferSize();
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }

        public void setReceiveBufferSize(int n) {
            try {
                NioSocketSession.this.getSocket().setReceiveBufferSize(n);
            }
            catch (SocketException socketException) {
                throw new RuntimeIoException(socketException);
            }
        }
    }
}

