/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import jlibs.core.io.IOUtil;

public enum BOM {
    UTF8(IOUtil.UTF_8.name(), new int[]{239, 187, 191}, null),
    UCS4_LE("UCS-4LE", new int[]{255, 254, 0, 0}, new int[]{60, 0, 0, 0}),
    UCS4_BE("UCS-4BE", new int[]{0, 0, 254, 255}, new int[]{0, 0, 0, 60}),
    UCS4_2143("UCS-4-2143", new int[]{0, 0, 255, 254}, new int[]{0, 0, 60, 0}),
    UCS4_3412("UCS-4-3412", new int[]{254, 255, 0, 0}, new int[]{0, 60, 0, 0}),
    UTF16_LE(IOUtil.UTF_16LE.name(), new int[]{255, 254}, new int[]{60, 0, 63, 0}),
    UTF16_BE(IOUtil.UTF_16BE.name(), new int[]{254, 255}, new int[]{0, 60, 0, 63}),
    ASCII(IOUtil.UTF_8.name(), null, new int[]{60, 63, 120, 109}),
    EBCDIC("Cp037", null, new int[]{76, 111, 167, 148});

    private String encoding;
    private byte[] with;
    private byte[] without;

    private BOM(String encoding, int[] with, int[] without) {
        this.encoding = encoding;
        this.with = BOM.toBytes(with);
        this.without = BOM.toBytes(without);
    }

    private static byte[] toBytes(int[] arr) {
        if (arr == null) {
            return null;
        }
        byte[] b = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            b[i] = (byte)arr[i];
        }
        return b;
    }

    public String encoding() {
        return this.encoding;
    }

    public byte[] with() {
        return this.with;
    }

    public byte[] without() {
        return this.without;
    }

    public static BOM get(byte[] b, boolean with) {
        for (BOM bom : BOM.values()) {
            byte[] expected;
            byte[] byArray = expected = with ? bom.with() : bom.without();
            if (expected == null || b.length < expected.length) continue;
            boolean matched = true;
            for (int i = 0; i < expected.length; ++i) {
                if (expected[i] == b[i]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return bom;
        }
        return null;
    }
}

