/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceToolTipUI
extends BasicToolTipUI {
    protected Set lafWidgets;

    public void __org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__installListeners(JComponent jComponent) {
        super.installListeners(jComponent);
    }

    @Override
    protected void installListeners(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__installListeners(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__installDefaults(JComponent jComponent) {
        super.installDefaults(jComponent);
    }

    @Override
    protected void installDefaults(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__installDefaults(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__uninstallListeners(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__uninstallDefaults(JComponent jComponent) {
        super.uninstallDefaults(jComponent);
    }

    @Override
    protected void uninstallDefaults(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__uninstallDefaults(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceToolTipUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceToolTipUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        Dimension size = c.getSize();
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        g.setColor(c.getForeground());
        g.setFont(font);
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        Insets insets = c.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left + 3, insets.top, size.width - (insets.left + insets.right + 6), size.height - (insets.top + insets.bottom + 2));
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g, paintTextR);
        } else {
            SubstanceTextUtilities.paintText(g, c, paintTextR, tipText, -1, font, c.getForeground(), null);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        Insets insets = c.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String text = ((JToolTip)c).getTipText();
        if (text == null || text.equals("")) {
            text = "";
        } else {
            View v;
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                prefSize.width += (int)(v.getPreferredSpan(0) + 6.0f);
                prefSize.height += (int)(v.getPreferredSpan(1) + 2.0f);
            } else {
                FontMetrics fm = c.getFontMetrics(font);
                prefSize.width += fm.stringWidth(text) + 6;
                prefSize.height += fm.getHeight() + 2;
            }
        }
        return prefSize;
    }
}

