/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.binding.impl.processor;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.xml.namespace.QName;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.annotation.processing.AnnotationProcessor;
import jlibs.core.annotation.processing.Printer;
import jlibs.core.graph.Visitor;
import jlibs.core.lang.model.ModelUtil;
import jlibs.xml.sax.binding.SAXContext;
import jlibs.xml.sax.binding.impl.Delegate;
import jlibs.xml.sax.binding.impl.processor.Binding;
import jlibs.xml.sax.binding.impl.processor.BindingAnnotation;
import jlibs.xml.sax.binding.impl.processor.BindingFinishAnnotation;
import jlibs.xml.sax.binding.impl.processor.BindingRelation;
import jlibs.xml.sax.binding.impl.processor.BindingStartAnnotation;
import jlibs.xml.sax.binding.impl.processor.BindingTextAnnotation;
import jlibs.xml.sax.binding.impl.processor.ElementAnnotation;
import jlibs.xml.sax.binding.impl.processor.RelationAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@SupportedAnnotationTypes(value={"jlibs.xml.sax.binding.Binding"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class BindingAnnotationProcessor
extends AnnotationProcessor {
    private static final String SUFFIX = "Impl";
    public static final String FORMAT = "${package}.${class}Impl";
    private static final BindingAnnotation BINDING_ELEMENT = new ElementAnnotation();
    private static final BindingAnnotation BINDING_START = new BindingStartAnnotation();
    private static final BindingAnnotation BINDING_TEXT = new BindingTextAnnotation();
    private static final BindingAnnotation BINDING_FINISH = new BindingFinishAnnotation();
    private static final BindingAnnotation RELATION_START = new RelationAnnotation(true);
    private static final BindingAnnotation RELATION_FINISH = new RelationAnnotation(false);

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                Binding binding = new Binding();
                try {
                    TypeElement c = (TypeElement)element;
                    if (c.getModifiers().contains((Object)Modifier.FINAL)) {
                        throw new AnnotationError((Element)c, ModelUtil.getAnnotationMirror((Element)c, Visitor.Implement.class), "final class can't be annotated with " + jlibs.xml.sax.binding.Binding.class.getName());
                    }
                    while (c != null && !c.getQualifiedName().contentEquals(Object.class.getName())) {
                        this.process(binding, c);
                        c = ModelUtil.getSuper((TypeElement)c);
                    }
                    binding.handleStar();
                    binding.initID(0);
                    Printer pw = null;
                    try {
                        pw = Printer.get((TypeElement)((TypeElement)element), jlibs.xml.sax.binding.Binding.class, (String)FORMAT);
                        this.generateClass(binding, pw);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    finally {
                        if (pw == null) continue;
                        pw.close();
                    }
                }
                catch (AnnotationError error) {
                    error.report();
                }
            }
        }
        return true;
    }

    private void process(Binding binding, TypeElement c) {
        for (ExecutableElement method : ElementFilter.methodsIn(c.getEnclosedElements())) {
            for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                if (BINDING_ELEMENT.matches(annotationMirror)) {
                    BINDING_ELEMENT.consume(binding, method, annotationMirror);
                    continue;
                }
                if (BINDING_START.matches(annotationMirror)) {
                    BINDING_START.consume(binding, method, annotationMirror);
                    continue;
                }
                if (BINDING_TEXT.matches(annotationMirror)) {
                    BINDING_TEXT.consume(binding, method, annotationMirror);
                    continue;
                }
                if (BINDING_FINISH.matches(annotationMirror)) {
                    BINDING_FINISH.consume(binding, method, annotationMirror);
                    continue;
                }
                if (RELATION_START.matches(annotationMirror)) {
                    RELATION_START.consume(binding, method, annotationMirror);
                    continue;
                }
                if (!RELATION_FINISH.matches(annotationMirror)) continue;
                RELATION_FINISH.consume(binding, method, annotationMirror);
            }
        }
    }

    private void generateClass(Binding binding, Printer pw) throws IOException {
        TypeElement clazz = pw.clazz;
        pw.printPackage();
        pw.importPackage(Delegate.class);
        pw.importClass(SAXContext.class);
        pw.importClass(Attributes.class);
        pw.importClass(SAXException.class);
        pw.importClass(QName.class);
        pw.println();
        pw.printClassDoc();
        pw.printlns(new String[]{"@SuppressWarnings({\"unchecked\"})", "public class " + pw.generatedClazz + " extends BindingCumRelation{", "indent++", "public static final " + pw.generatedClazz + " INSTANCE = new " + pw.generatedClazz + "(new " + clazz.getSimpleName() + "());", "static{", "indent++", "INSTANCE.init();", "indent--", "}"});
        pw.emptyLine(true);
        pw.print("public static final QName ELEMENT = ");
        AnnotationMirror bindingMirror = ModelUtil.getAnnotationMirror((Element)clazz, jlibs.xml.sax.binding.Binding.class);
        if (bindingMirror == null) {
            pw.println("null;");
        } else {
            String element = (String)ModelUtil.getAnnotationValue((Element)clazz, (AnnotationMirror)bindingMirror, (String)"value");
            if (element.indexOf(47) != -1) {
                throw new AnnotationError((Element)clazz, bindingMirror, "value of " + jlibs.xml.sax.binding.Binding.class + " should be single element, but not element path");
            }
            pw.println(Binding.toJava(Binding.toQName(clazz, bindingMirror, element)) + ";");
        }
        pw.emptyLine(true);
        pw.printlns(new String[]{"private final " + clazz.getSimpleName() + " handler;", "private " + pw.generatedClazz + "(" + clazz.getSimpleName() + " handler){", "indent++", "this.handler = handler;", "indent--", "}"});
        pw.emptyLine(true);
        pw.print("private void init()");
        if (binding.registry.size() > 0) {
            this.generateInitMethod(binding, pw);
        } else {
            pw.println("{}");
            pw.emptyLine(true);
        }
        BINDING_START.printMethod(pw, binding);
        BINDING_TEXT.printMethod(pw, binding);
        BINDING_FINISH.printMethod(pw, binding);
        RELATION_START.printMethod(pw, binding);
        RELATION_FINISH.printMethod(pw, binding);
        --pw.indent;
        pw.emptyLine(false);
        pw.println("}");
    }

    private void generateInitMethod(Binding binding, Printer pw) {
        if (binding.registry.size() > 0) {
            pw.println("{");
            ++pw.indent;
            if (binding.id == 0) {
                pw.println("Delegate leaf = new Delegate(this);");
            }
            for (Map.Entry<QName, BindingRelation> entry : binding.registry.entrySet()) {
                boolean useDelegate;
                QName qname = entry.getKey();
                BindingRelation bindingRelation = entry.getValue();
                Binding childBinding = bindingRelation.binding;
                boolean bl = useDelegate = childBinding.registry.size() > 0;
                if (useDelegate) {
                    pw.print("Registry registry" + childBinding.id + " = ");
                }
                pw.print("registry" + (binding.id > 0 ? Integer.valueOf(binding.id) : "") + ".register(");
                if (childBinding.element != null) {
                    pw.print(Binding.toJava(qname) + ", 0, ");
                    String className = ModelUtil.getPackage((Element)childBinding.element).equals(ModelUtil.getPackage((Element)pw.clazz)) ? childBinding.element.getSimpleName().toString() : childBinding.element.getQualifiedName().toString();
                    pw.println(className + SUFFIX + ".INSTANCE, " + childBinding.id + ", this);");
                    continue;
                }
                pw.print(Binding.toJava(qname) + ", " + childBinding.id + ", " + (useDelegate ? "new Delegate(this)" : "leaf") + ", ");
                pw.println(childBinding.id + ", this);");
                this.generateInitMethod(childBinding, pw);
            }
            --pw.indent;
            pw.println("}");
            pw.emptyLine(true);
        }
    }
}

