/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jlibs.nbp.Chars;
import jlibs.nbp.NBChannel;
import jlibs.nbp.NBHandler;
import jlibs.nbp.ReadableCharChannel;
import jlibs.xml.sax.AbstractXMLReader;
import jlibs.xml.sax.async.AttributeType;
import jlibs.xml.sax.async.AttributeValueType;
import jlibs.xml.sax.async.Attributes;
import jlibs.xml.sax.async.DTD;
import jlibs.xml.sax.async.DTDAttribute;
import jlibs.xml.sax.async.Elements;
import jlibs.xml.sax.async.Namespaces;
import jlibs.xml.sax.async.QName;
import jlibs.xml.sax.async.QNamePool;
import jlibs.xml.sax.async.SpaceWrappedReader;
import jlibs.xml.sax.async.XMLFeeder;
import jlibs.xml.sax.async.XMLScanner;
import org.apache.xerces.util.XMLChar;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Locator2;

public class AsyncXMLReader
extends AbstractXMLReader
implements NBHandler<SAXException>,
Locator2 {
    private static Map<String, char[]> defaultEntities = new HashMap<String, char[]>();
    private XMLScanner xmlScanner = new XMLScanner(this, 54);
    private XMLScanner declScanner = new XMLScanner(this, 21);
    private XMLFeeder xmlFeeder;
    private XMLFeeder feeder;
    String encoding;
    private Boolean standalone;
    private QNamePool QNamePool = new QNamePool();
    private QName curQName;
    private int prefixLength = 0;
    private StringBuilder value = new StringBuilder();
    private boolean valueStarted = true;
    private boolean entityValue = false;
    private int radix;
    private ArrayDeque<String> entityStack = new ArrayDeque();
    private ArrayDeque<String> paramEntityStack = new ArrayDeque();
    private boolean peReferenceOutsideMarkup = false;
    private final Namespaces namespaces = new Namespaces(this.handler);
    private final DTD _dtd = new DTD(this.namespaces);
    private DTD dtd;
    private final Attributes attributes = new Attributes(this.namespaces);
    private final Elements elements = new Elements(this, this.handler, this.namespaces, this.attributes);
    private String piTarget;
    private String systemID;
    private String publicID;
    private String notationName;
    private String dtdElement;
    private String entityName;
    private boolean unparsedEntity;
    private Map<String, EntityValue> entities = new HashMap<String, EntityValue>();
    private char[] externalEntityValue;
    private String paramEntityName;
    private Map<String, EntityValue> paramEntities = new HashMap<String, EntityValue>();
    private Map<String, DTDAttribute> attributeList;
    private DTDAttribute dtdAttribute;

    public AsyncXMLReader() {
        this.xmlScanner.coelsceNewLines = true;
        this.encoding = null;
    }

    void setFeeder(XMLFeeder feeder) throws IOException {
        if (this.feeder.getParent() == feeder && this.feeder.postAction != null) {
            try {
                this.feeder.postAction.run();
            }
            catch (Exception ex) {
                this.feeder.parser.ioError(ex.getMessage());
            }
        }
        this.feeder = feeder;
        this.elements.freeLock = feeder.elemDepth;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
        try {
            super.setFeature(name, value);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
    }

    public XMLFeeder createFeeder(InputSource inputSource) throws IOException, SAXException {
        this.xmlScanner.reset();
        this.declScanner.reset(21);
        if (this.xmlFeeder == null) {
            this.xmlFeeder = new XMLFeeder(this, this.xmlScanner, inputSource, this.declScanner);
        } else {
            this.xmlFeeder.init(inputSource, this.declScanner);
        }
        this.feeder = this.xmlFeeder;
        this.documentStart();
        return this.feeder;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        if (this.createFeeder(input).feed() != null) {
            throw new IOException("parse(...) shouldn't be used on non-blocking IO");
        }
    }

    @Override
    public void parse(String systemID) throws IOException, SAXException {
        this.parse(new InputSource(systemID));
    }

    @Override
    public String getPublicId() {
        return this.feeder.publicID;
    }

    @Override
    public String getSystemId() {
        return this.feeder.systemID;
    }

    @Override
    public int getLineNumber() {
        return this.feeder.parser.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.feeder.parser.getColumnNumber();
    }

    public int getCharacterOffset() {
        return this.feeder.parser.getCharacterOffset();
    }

    @Override
    public String getXMLVersion() {
        return "1.0";
    }

    @Override
    public String getEncoding() {
        NBChannel nbChannel;
        ReadableCharChannel channel = this.feeder.channel();
        if (channel instanceof NBChannel && (nbChannel = (NBChannel)channel).decoder() != null) {
            return nbChannel.decoder().charset().name();
        }
        return "UTF-8";
    }

    void documentStart() throws SAXException {
        this.encoding = null;
        this.standalone = null;
        this.prefixLength = 0;
        this.value.setLength(0);
        this.valueStarted = false;
        this.entityValue = false;
        this.namespaces.reset();
        this.attributes.reset();
        this.elements.reset();
        this.piTarget = null;
        this.systemID = null;
        this.publicID = null;
        this.notationName = null;
        this.entityName = null;
        this.entities.clear();
        this.entityStack.clear();
        this.paramEntityName = null;
        this.paramEntities.clear();
        this.paramEntityStack.clear();
        this.peReferenceOutsideMarkup = false;
        this.dtd = null;
        this.attributes.dtd = null;
        this._dtd.reset();
        this.dtdElement = null;
        this.attributeList = null;
        this.dtdAttribute = null;
        this.handler.setDocumentLocator(this);
        this.handler.startDocument();
    }

    void version(Chars data) throws SAXException {
        if (!"1.0".contentEquals((CharSequence)data)) {
            this.fatalError("Unsupported XML Version: " + data);
        }
    }

    void encoding(Chars data) throws SAXException {
        this.encoding = data.toString();
    }

    void standalone(Chars data) {
        this.standalone = "yes".contentEquals((CharSequence)data);
    }

    void xdeclEnd() {
        this.feeder.setDeclaredEncoding(this.encoding);
        this.encoding = null;
    }

    void prefix(Chars data) {
        this.prefixLength = data.length();
    }

    void qname(Chars data) throws SAXException {
        this.curQName = this.QNamePool.add(this.prefixLength, data.array(), data.offset(), data.length());
        this.prefixLength = 0;
    }

    void valueStart() {
        this.value.setLength(0);
        this.valueStarted = true;
        this.entityValue = false;
    }

    void entityValue() {
        this.entityValue = true;
    }

    void rawValue(Chars data) {
        if (this.entityValue) {
            this.value.append((CharSequence)data);
        } else {
            char[] chars = data.array();
            int offset = data.offset();
            int length = data.length();
            for (int i = offset + length - 1; i >= 0; --i) {
                char ch = chars[i];
                if (ch != '\n' && ch != '\r' && ch != '\t') continue;
                chars[i] = 32;
            }
            this.value.append(chars, offset, length);
        }
    }

    void hexCode() throws SAXException {
        this.radix = 16;
    }

    void asciiCode() throws SAXException {
        this.radix = 10;
    }

    void charReference(Chars data) throws SAXException {
        int cp = Integer.parseInt(data.toString(), this.radix);
        if (XMLChar.isValid((int)cp)) {
            if (this.valueStarted) {
                this.value.appendCodePoint(cp);
            } else {
                char[] chars = Character.toChars(cp);
                this.handler.characters(chars, 0, chars.length);
            }
        } else {
            this.fatalError("invalid xml character");
        }
    }

    void entityReference(Chars data) throws SAXException, IOException {
        if (this.entityValue) {
            this.value.append('&').append((CharSequence)data).append(';');
            return;
        }
        String entity = data.toString();
        char[] entityContent = defaultEntities.get(entity);
        if (entityContent != null) {
            if (this.valueStarted) {
                this.value.append(entityContent);
            } else {
                this.handler.characters(entityContent, 0, entityContent.length);
            }
        } else {
            int rule;
            EntityValue entityValue = this.entities.get(entity);
            if (entityValue == null) {
                this.fatalError("The entity \"" + entity + "\" was referenced, but not declared.");
            }
            if (entityValue.unparsed) {
                this.fatalError("The unparsed entity reference \"&" + entity + ";\" is not permitted");
            }
            if (this.standalone == Boolean.TRUE && entityValue.externalDefinition) {
                this.fatalError("The external entity reference \"&" + entity + ";\" is not permitted in standalone document");
            }
            if (this.standalone == Boolean.TRUE && entityValue.externalValue) {
                this.fatalError("The reference to entity \"" + entity + "\" declared in an external parsed entity is not permitted in a standalone document");
            }
            this.checkRecursion(this.entityStack, entity, "entity");
            if (this.valueStarted) {
                if (entityValue.externalValue) {
                    this.fatalError("The external entity reference \"&" + this.entityName + ";\" is not permitted in an attribute value.");
                }
                rule = 63;
            } else {
                rule = 56;
            }
            this.entityStack.push(entity);
            try {
                XMLFeeder childFeeder = entityValue.parse(rule);
                childFeeder.elemDepth = this.elements.free;
                childFeeder.postAction = new Runnable(){

                    @Override
                    public void run() {
                        AsyncXMLReader.this.entityStack.pop();
                        if (((AsyncXMLReader)AsyncXMLReader.this).elements.free > ((AsyncXMLReader)AsyncXMLReader.this).feeder.elemDepth) {
                            throw new RuntimeException("expected </" + AsyncXMLReader.this.elements.currentElementName() + ">");
                        }
                    }
                };
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    void peReferenceOutsideMarkup() {
        this.peReferenceOutsideMarkup = true;
    }

    void peReference(Chars data) throws Exception {
        String param = data.toString();
        EntityValue entityValue = this.paramEntities.get(param);
        if (entityValue == null) {
            this.fatalError("The param entity \"" + param + "\" was referenced, but not declared.");
        }
        if (this.standalone == Boolean.TRUE && entityValue.externalValue) {
            this.fatalError("The reference to param entity \"" + param + "\" declared in an external parsed entity is not permitted in a standalone document");
        }
        this.checkRecursion(this.paramEntityStack, param, "parameter entity");
        if (this.valueStarted) {
            if (this.feeder.parser == this.xmlScanner && this.feeder.getParent() == null) {
                this.fatalError("The parameter entity reference \"%" + data + ";\" cannot occur within markup in the internal subset of the DTD.");
            }
            if (entityValue.content != null) {
                this.value.append(entityValue.content);
            } else {
                entityValue.parse((int)62).postAction = new Runnable(){

                    @Override
                    public void run() {
                        AsyncXMLReader.this.value.append(AsyncXMLReader.this.externalEntityValue);
                    }
                };
            }
        } else if (this.peReferenceOutsideMarkup) {
            this.peReferenceOutsideMarkup = false;
            this.paramEntityStack.push(param);
            try {
                entityValue.parse((int)59).postAction = new Runnable(){

                    @Override
                    public void run() {
                        AsyncXMLReader.this.paramEntityStack.pop();
                    }
                };
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            if (this.feeder.parser == this.xmlScanner && this.feeder.getParent() == null) {
                this.fatalError("The parameter entity reference \"%" + data + ";\" cannot occur within markup in the internal subset of the DTD.");
            }
            this.feeder.setChild(new XMLFeeder(this, this.feeder.parser, entityValue.inputSource(true), entityValue.prologParser()));
        }
    }

    void valueEnd() {
        this.valueStarted = false;
        this.entityValue = false;
    }

    void attributesStart() {
        this.elements.push1(this.curQName);
    }

    void attributeEnd() throws SAXException {
        String error = this.attributes.addAttribute(this.elements.currentElementName(), this.curQName, this.value);
        if (error != null) {
            this.fatalError(error);
        }
    }

    void attributesEnd() throws SAXException {
        this.elements.push2();
    }

    void endingElem() {
        this.feeder.parser.dynamicStringToBeMatched = this.elements.currentElementNameAsCharArray();
    }

    void elementEnd() throws SAXException {
        if (this.elements.pop()) {
            this.feeder.parser.stop = true;
            this.feeder.parser.pop = true;
        }
    }

    void rootElementEnd() throws SAXException {
        if (this.elements.free > 0) {
            this.fatalError("expected </" + this.elements.currentElementName() + ">");
        }
    }

    void piTarget(Chars data) {
        this.piTarget = data.toString();
    }

    void piData(Chars piData) throws SAXException {
        this.handler.processingInstruction(this.piTarget, piData.length() > 0 ? piData.toString() : "");
    }

    void piData() throws SAXException {
        this.handler.processingInstruction(this.piTarget, "");
    }

    private boolean isWhitespace(Chars data) {
        char[] chars = data.array();
        int end = data.offset() + data.length();
        for (int i = data.offset(); i < end; ++i) {
            if (XMLChar.isSpace((int)chars[i])) continue;
            return false;
        }
        return true;
    }

    void characters(Chars data) throws SAXException {
        int len = data.length();
        if (len > 0) {
            if (this.dtd != null && this.dtd.nonMixedElements.contains(this.elements.currentElementName()) && this.isWhitespace(data)) {
                this.handler.ignorableWhitespace(data.array(), data.offset(), data.length());
            } else {
                this.handler.characters(data.array(), data.offset(), data.length());
            }
        }
    }

    void cdata(Chars data) throws SAXException {
        this.handler.startCDATA();
        this.handler.characters(data.array(), data.offset(), data.length());
        this.handler.endCDATA();
    }

    void comment(Chars data) throws SAXException {
        this.handler.comment(data.array(), data.offset(), data.length());
    }

    public void fatalError(String message) throws SAXException {
        this.fatalError(new SAXParseException(message, this));
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        try {
            this.handler.fatalError(ex);
            throw ex;
        }
        catch (Throwable throwable) {
            this.handler.endDocument();
            throw throwable;
        }
    }

    public void onSuccessful() throws SAXException {
        if (this.feeder.getParent() == null) {
            this.handler.endDocument();
        }
    }

    void dtdRoot(Chars data) {
        this.attributes.dtd = this.dtd = this._dtd;
        this.dtd.root = data.toString();
    }

    void systemID(Chars data) {
        this.systemID = data.toString();
    }

    void publicID(Chars data) {
        this.publicID = AttributeType.toPublicID(data.toString());
    }

    void dtdStart() throws SAXException, IOException {
        this.handler.startDTD(this.dtd.root, this.publicID, this.systemID);
        if (this.publicID != null || this.systemID != null) {
            this.dtd.externalDTD = this.feeder.resolve(this.publicID, this.systemID);
            this.systemID = null;
            this.publicID = null;
        }
    }

    void notationName(Chars data) {
        this.notationName = data.toString();
    }

    void notationEnd() throws SAXException, IOException {
        this.systemID = this.feeder.resolve(this.systemID);
        this.handler.notationDecl(this.notationName, this.publicID, this.systemID);
        this.notationName = null;
        this.systemID = null;
        this.publicID = null;
    }

    void dtdElement(Chars data) {
        this.dtdElement = data.toString();
    }

    void notMixed() {
        this.dtd.nonMixedElements.add(this.dtdElement);
    }

    public void dtdEnd() throws SAXException, IOException {
        if (this.dtd.externalDTD != null) {
            InputSource inputSource = this.dtd.externalDTD;
            this.dtd.externalDTD = null;
            InputSource is = this.handler.resolveEntity(inputSource.getPublicId(), inputSource.getSystemId());
            XMLScanner dtdScanner = new XMLScanner(this, 59);
            dtdScanner.coelsceNewLines = true;
            this.encoding = null;
            this.declScanner.reset(57);
            this.feeder.setChild(new XMLFeeder(this, dtdScanner, is == null ? inputSource : is, this.declScanner));
        }
        this.handler.endDTD();
    }

    void entityName(Chars data) {
        this.entityName = data.toString();
    }

    void notationReference(Chars data) throws IOException, SAXException {
        this.handler.unparsedEntityDecl(this.entityName, this.publicID, this.feeder.resolve(this.systemID), data.toString());
        this.unparsedEntity = true;
    }

    void entityEnd() throws SAXException, IOException {
        if (!this.entities.containsKey(this.entityName)) {
            this.entities.put(this.entityName, new EntityValue());
        }
        this.unparsedEntity = false;
        this.value.setLength(0);
        this.systemID = null;
        this.publicID = null;
    }

    void externalEntityValue(Chars data) {
        this.externalEntityValue = Arrays.copyOfRange(data.array(), data.offset(), data.offset() + data.length());
    }

    public void checkRecursion(Deque<String> stack, String current, String type) throws SAXException {
        if (stack.contains(current)) {
            StringBuilder message = new StringBuilder("Recursive ").append(type).append(" reference ");
            message.append('\"').append(current).append('\"').append(". (Reference path: ");
            boolean first = true;
            Iterator<String> iter = stack.descendingIterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    message.append(" -> ");
                }
                message.append(iter.next());
            }
            message.append(" -> ").append(current);
            message.append(')');
            this.fatalError(message.toString());
        }
    }

    void paramEntityName(Chars data) {
        this.paramEntityName = data.toString();
    }

    void paramEntityEnd() throws SAXException, IOException {
        if (!this.paramEntities.containsKey(this.paramEntityName)) {
            this.paramEntities.put(this.paramEntityName, new EntityValue());
        }
        this.unparsedEntity = false;
        this.value.setLength(0);
        this.systemID = null;
        this.publicID = null;
    }

    void dtdAttributesStart(Chars data) {
        String dtdElementName = data.toString();
        this.attributeList = this.dtd.attributes.get(dtdElementName);
        if (this.attributeList == null) {
            this.attributeList = new HashMap<String, DTDAttribute>();
            this.dtd.attributes.put(dtdElementName, this.attributeList);
        }
    }

    void dtdAttribute(Chars data) {
        String attributeName = data.toString();
        if (this.attributeList.get(attributeName) == null) {
            this.dtdAttribute = new DTDAttribute();
            this.dtdAttribute.name = attributeName;
            this.attributeList.put(attributeName, this.dtdAttribute);
        } else {
            this.dtdAttribute = null;
        }
    }

    void cdataAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.CDATA;
        }
    }

    void idAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.ID;
        }
    }

    void idRefAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.IDREF;
        }
    }

    void idRefsAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.IDREFS;
        }
    }

    void nmtokenAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.NMTOKEN;
        }
    }

    void nmtokensAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.NMTOKENS;
        }
    }

    void entityAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.ENTITY;
        }
    }

    void entitiesAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.ENTITIES;
        }
    }

    void enumerationAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.ENUMERATION;
            this.dtdAttribute.validValues = new ArrayList<String>();
        }
    }

    void notationAttribute() {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.type = AttributeType.NOTATION;
            this.dtdAttribute.validValues = new ArrayList<String>();
        }
    }

    void attributeEnumValue(Chars data) {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.validValues.add(data.toString());
        }
    }

    void attributeNotationValue(Chars data) {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.validValues.add(data.toString());
        }
    }

    void attributeDefaultValue() throws SAXException {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.valueType = AttributeValueType.DEFAULT;
            this.dtdAttribute.value = this.dtdAttribute.type.normalize(this.value.toString());
            this.dtdAttribute.fire(this.handler);
        }
        this.value.setLength(0);
    }

    void attributeRequired() throws SAXException {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.valueType = AttributeValueType.REQUIRED;
            this.dtdAttribute.fire(this.handler);
        }
    }

    void attributeImplied() throws SAXException {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.valueType = AttributeValueType.IMPLIED;
            this.dtdAttribute.fire(this.handler);
        }
    }

    void attributeFixedValue() throws SAXException {
        if (this.dtdAttribute != null) {
            this.dtdAttribute.valueType = AttributeValueType.FIXED;
            this.dtdAttribute.value = this.dtdAttribute.type.normalize(this.value.toString());
            this.dtdAttribute.fire(this.handler);
        }
        this.value.setLength(0);
    }

    void dtdAttributesEnd() {
    }

    static {
        defaultEntities.put("amp", new char[]{'&'});
        defaultEntities.put("lt", new char[]{'<'});
        defaultEntities.put("gt", new char[]{'>'});
        defaultEntities.put("apos", new char[]{'\''});
        defaultEntities.put("quot", new char[]{'\"'});
    }

    class EntityValue {
        String entityName;
        char[] content;
        boolean externalDefinition;
        boolean unparsed;
        boolean externalValue;
        InputSource inputSource;

        public EntityValue() throws IOException, SAXException {
            this.entityName = AsyncXMLReader.this.entityName;
            this.externalDefinition = AsyncXMLReader.this.feeder.getParent() != null;
            this.unparsed = AsyncXMLReader.this.unparsedEntity;
            if (AsyncXMLReader.this.systemID == null && AsyncXMLReader.this.publicID == null) {
                this.content = AsyncXMLReader.this.value.toString().toCharArray();
            } else {
                this.externalValue = true;
                this.inputSource = AsyncXMLReader.this.feeder.resolve(AsyncXMLReader.this.publicID, AsyncXMLReader.this.systemID);
            }
        }

        public InputSource inputSource(boolean wrapWithSpace) throws IOException, SAXException {
            if (this.inputSource == null) {
                InputSource is = new InputSource(AsyncXMLReader.this.getSystemId());
                is.setPublicId(AsyncXMLReader.this.getPublicId());
                is.setCharacterStream(wrapWithSpace ? new SpaceWrappedReader(this.content) : new CharArrayReader(this.content));
                return is;
            }
            InputSource is = AsyncXMLReader.this.handler.resolveEntity(this.inputSource.getPublicId(), this.inputSource.getSystemId());
            return is != null ? is : this.inputSource;
        }

        public XMLScanner prologParser() {
            XMLScanner prologParser = null;
            if (this.externalValue) {
                prologParser = AsyncXMLReader.this.declScanner;
                prologParser.reset(57);
                AsyncXMLReader.this.encoding = null;
            }
            return prologParser;
        }

        public XMLFeeder parse(int rule) throws IOException, SAXException {
            XMLScanner scanner = new XMLScanner(AsyncXMLReader.this, rule);
            XMLScanner prologParser = this.prologParser();
            scanner.coelsceNewLines = this.externalValue;
            XMLFeeder childFeeder = new XMLFeeder(AsyncXMLReader.this, scanner, this.inputSource(false), prologParser);
            AsyncXMLReader.this.feeder.setChild(childFeeder);
            return childFeeder;
        }
    }
}

