/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.commandline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.commandline.CommandLineImpl;
import org.apache.commons.cli2.option.PropertyOption;
import org.apache.commons.cli2.resource.ResourceHelper;

public class WriteableCommandLineImpl
extends CommandLineImpl
implements WriteableCommandLine {
    private final Map optionToProperties = new HashMap();
    private final List options = new ArrayList();
    private final Map nameToOption = new HashMap();
    private final Map values = new HashMap();
    private final Map switches = new HashMap();
    private final Map defaultValues = new HashMap();
    private final Map defaultSwitches = new HashMap();
    private final List normalised;
    private final Set prefixes;
    private Option currentOption;
    private String checkForOption;

    public WriteableCommandLineImpl(Option rootOption, List arguments) {
        this.prefixes = rootOption.getPrefixes();
        this.normalised = arguments;
        this.setCurrentOption(rootOption);
    }

    @Override
    public Option getCurrentOption() {
        return this.currentOption;
    }

    @Override
    public void setCurrentOption(Option currentOption) {
        this.currentOption = currentOption;
    }

    @Override
    public void addOption(Option option) {
        this.options.add(option);
        this.nameToOption.put(option.getPreferredName(), option);
        Iterator i = option.getTriggers().iterator();
        while (i.hasNext()) {
            this.nameToOption.put(i.next(), option);
        }
        for (Option parent = option.getParent(); parent != null && !this.options.contains(parent); parent = parent.getParent()) {
            this.options.add(parent);
        }
    }

    @Override
    public void addValue(Option option, Object value) {
        ArrayList<Object> valueList;
        if (option instanceof Argument) {
            this.addOption(option);
        }
        if ((valueList = (ArrayList<Object>)this.values.get(option)) == null) {
            valueList = new ArrayList<Object>();
            this.values.put(option, valueList);
        }
        valueList.add(value);
    }

    @Override
    public void addSwitch(Option option, boolean value) {
        this.addOption(option);
        if (this.switches.containsKey(option)) {
            throw new IllegalStateException(ResourceHelper.getResourceHelper().getMessage("Switch.already.set"));
        }
        this.switches.put(option, value ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public boolean hasOption(Option option) {
        boolean present = this.options.contains(option);
        return present;
    }

    @Override
    public Option getOption(String trigger) {
        return (Option)this.nameToOption.get(trigger);
    }

    @Override
    public List getValues(Option option, List defaultValues) {
        ArrayList valueList = (ArrayList)this.values.get(option);
        if (defaultValues == null || defaultValues.isEmpty()) {
            defaultValues = (List)this.defaultValues.get(option);
        }
        if (defaultValues != null && !defaultValues.isEmpty()) {
            if (valueList == null || valueList.isEmpty()) {
                valueList = defaultValues;
            } else if (defaultValues.size() > valueList.size()) {
                valueList = new ArrayList(valueList);
                for (int i = valueList.size(); i < defaultValues.size(); ++i) {
                    valueList.add(defaultValues.get(i));
                }
            }
        }
        return valueList == null ? Collections.EMPTY_LIST : valueList;
    }

    @Override
    public List getUndefaultedValues(Option option) {
        List valueList = (List)this.values.get(option);
        if (valueList == null) {
            valueList = Collections.EMPTY_LIST;
        }
        return valueList;
    }

    @Override
    public Boolean getSwitch(Option option, Boolean defaultValue) {
        Boolean bool = (Boolean)this.switches.get(option);
        if (bool == null) {
            bool = defaultValue;
        }
        if (bool == null) {
            bool = (Boolean)this.defaultSwitches.get(option);
        }
        return bool;
    }

    @Override
    public String getProperty(String property) {
        return this.getProperty(new PropertyOption(), property);
    }

    @Override
    public void addProperty(Option option, String property, String value) {
        Properties properties = (Properties)this.optionToProperties.get(option);
        if (properties == null) {
            properties = new Properties();
            this.optionToProperties.put(option, properties);
        }
        properties.setProperty(property, value);
    }

    @Override
    public void addProperty(String property, String value) {
        this.addProperty(new PropertyOption(), property, value);
    }

    @Override
    public String getProperty(Option option, String property, String defaultValue) {
        Properties properties = (Properties)this.optionToProperties.get(option);
        if (properties == null) {
            return defaultValue;
        }
        return properties.getProperty(property, defaultValue);
    }

    @Override
    public Set getProperties(Option option) {
        Properties properties = (Properties)this.optionToProperties.get(option);
        if (properties == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(properties.keySet());
    }

    @Override
    public Set getProperties() {
        return this.getProperties(new PropertyOption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean looksLikeOption(String trigger) {
        if (this.checkForOption != null) {
            return !this.checkForOption.equals(trigger);
        }
        this.checkForOption = trigger;
        try {
            for (String prefix : this.prefixes) {
                if (!trigger.startsWith(prefix) || !this.getCurrentOption().canProcess((WriteableCommandLine)this, trigger) && this.getCurrentOption().findOption(trigger) == null) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.checkForOption = null;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.normalised.iterator();
        while (i.hasNext()) {
            String arg = (String)i.next();
            if (arg.indexOf(32) >= 0) {
                buffer.append("\"").append(arg).append("\"");
            } else {
                buffer.append(arg);
            }
            if (!i.hasNext()) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    @Override
    public List getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    @Override
    public Set getOptionTriggers() {
        return Collections.unmodifiableSet(this.nameToOption.keySet());
    }

    @Override
    public void setDefaultValues(Option option, List defaults) {
        if (defaults == null) {
            this.defaultValues.remove(option);
        } else {
            this.defaultValues.put(option, defaults);
        }
    }

    @Override
    public void setDefaultSwitch(Option option, Boolean defaultSwitch) {
        if (defaultSwitch == null) {
            this.defaultSwitches.remove(option);
        } else {
            this.defaultSwitches.put(option, defaultSwitch);
        }
    }

    public List getNormalised() {
        return Collections.unmodifiableList(this.normalised);
    }
}

