/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.commandline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.commandline.CommandLineImpl;
import org.apache.commons.cli2.option.PropertyOption;

public class DefaultingCommandLine
extends CommandLineImpl {
    private final List commandLines = new ArrayList();

    public void appendCommandLine(CommandLine commandLine) {
        this.commandLines.add(commandLine);
    }

    public void insertCommandLine(int index, CommandLine commandLine) {
        this.commandLines.add(index, commandLine);
    }

    public Iterator commandLines() {
        return Collections.unmodifiableList(this.commandLines).iterator();
    }

    @Override
    public Option getOption(String trigger) {
        for (CommandLine commandLine : this.commandLines) {
            Option actual = commandLine.getOption(trigger);
            if (actual == null) continue;
            return actual;
        }
        return null;
    }

    @Override
    public List getOptions() {
        ArrayList options = new ArrayList();
        ArrayList temp = new ArrayList();
        for (CommandLine commandLine : this.commandLines) {
            temp.clear();
            temp.addAll(commandLine.getOptions());
            temp.removeAll(options);
            options.addAll(temp);
        }
        return Collections.unmodifiableList(options);
    }

    @Override
    public Set getOptionTriggers() {
        HashSet all = new HashSet();
        for (CommandLine commandLine : this.commandLines) {
            all.addAll(commandLine.getOptionTriggers());
        }
        return Collections.unmodifiableSet(all);
    }

    @Override
    public boolean hasOption(Option option) {
        for (CommandLine commandLine : this.commandLines) {
            if (!commandLine.hasOption(option)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getValues(Option option, List defaultValues) {
        for (CommandLine commandLine : this.commandLines) {
            List actual = commandLine.getValues(option);
            if (actual == null || actual.isEmpty()) continue;
            return actual;
        }
        if (defaultValues == null) {
            return Collections.EMPTY_LIST;
        }
        return defaultValues;
    }

    @Override
    public Boolean getSwitch(Option option, Boolean defaultValue) {
        for (CommandLine commandLine : this.commandLines) {
            Boolean actual = commandLine.getSwitch(option);
            if (actual == null) continue;
            return actual;
        }
        return defaultValue;
    }

    @Override
    public String getProperty(String property) {
        return this.getProperty(new PropertyOption(), property);
    }

    @Override
    public String getProperty(Option option, String property, String defaultValue) {
        for (CommandLine commandLine : this.commandLines) {
            String actual = commandLine.getProperty(option, property);
            if (actual == null) continue;
            return actual;
        }
        return defaultValue;
    }

    @Override
    public Set getProperties(Option option) {
        HashSet all = new HashSet();
        for (CommandLine commandLine : this.commandLines) {
            all.addAll(commandLine.getProperties(option));
        }
        return Collections.unmodifiableSet(all);
    }

    @Override
    public Set getProperties() {
        return this.getProperties(new PropertyOption());
    }
}

