/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.appframework.swingx;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.jdesktop.appframework.swingx.XProperties;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.SessionStorage;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTable;

public abstract class SingleXFrameApplication
extends SingleFrameApplication {
    private static final Logger logger = Logger.getLogger(SingleXFrameApplication.class.getName());
    private boolean started = false;

    @Override
    protected void initialize(String[] args) {
        this.injectSessionProperties();
        this.setMainFrame(this.createXMainFrame());
    }

    public void prepareDialog(JDialog c, boolean visible) {
        if (c == null) {
            throw new IllegalArgumentException("null JDialog");
        }
        if (!this.hadBeenPrepared(c)) {
            this.prepareWindow(c);
        }
        if (visible) {
            c.setVisible(true);
        }
    }

    private boolean hadBeenPrepared(RootPaneContainer c) {
        String k;
        JRootPane rootPane = c.getRootPane();
        boolean prepared = Boolean.TRUE.equals(rootPane.getClientProperty(k = "SingleFrameApplication.initRootPaneContainer"));
        if (!prepared) {
            rootPane.putClientProperty(k, Boolean.TRUE);
        }
        return prepared;
    }

    @Override
    protected void startup() {
        this.started = true;
    }

    protected void prepareWindow(Window root) {
        boolean invalidHeight;
        String filename;
        this.configureWindow(root);
        if (root.getWidth() < 150 || root.getHeight() < 20) {
            root.pack();
            if (!root.isLocationByPlatform()) {
                JFrame owner = root != this.getMainFrame() ? this.getMainFrame() : null;
                root.setLocationRelativeTo(owner);
            }
        }
        if ((filename = this.sessionFilename(root)) != null) {
            try {
                ApplicationContext ac = this.getContext();
                ac.getSessionStorage().restore(root, filename);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "couldn't restore sesssion", e);
            }
        }
        Dimension size = root.getPreferredSize();
        boolean invalidWidth = root.getWidth() < size.width;
        boolean bl = invalidHeight = root.getHeight() < size.height;
        if (invalidWidth || invalidHeight) {
            if (invalidWidth && invalidHeight) {
                root.pack();
            } else {
                root.setSize(invalidWidth ? size.width : root.getWidth(), invalidHeight ? size.height : root.getHeight());
            }
            if (!root.isLocationByPlatform()) {
                JFrame owner = root != this.getMainFrame() ? this.getMainFrame() : null;
                root.setLocationRelativeTo(owner);
            }
        }
        root.addWindowListener(this.getDialogListener());
    }

    private WindowListener getDialogListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SingleXFrameApplication.this.saveSession(e.getWindow());
            }

            @Override
            public void windowClosed(WindowEvent e) {
                SingleXFrameApplication.this.saveSession(e.getWindow());
            }
        };
    }

    @Override
    protected void shutdown() {
        if (!this.started) {
            return;
        }
        ArrayList<Window> windows = new ArrayList<Window>();
        JFrame mainFrame = this.getMainFrame();
        if (mainFrame instanceof JXFrame) {
            windows.add(mainFrame);
            for (int i = 0; i < this.getMainFrame().getOwnedWindows().length; ++i) {
                windows.add(this.getMainFrame().getOwnedWindows()[i]);
            }
        }
        for (Window window : windows) {
            JFrame f;
            Object init;
            if (window.isShowing() || window.isValid()) {
                this.saveSession(window);
                continue;
            }
            if (!(window instanceof JFrame) || !Boolean.TRUE.equals(init = (f = (JFrame)window).getRootPane().getClientProperty("initialized"))) continue;
            this.saveSession(window);
        }
    }

    private String sessionFilename(Window window) {
        if (window == null) {
            return null;
        }
        String name = window.getName();
        return name == null ? null : name + ".session.xml";
    }

    private void saveSession(Window window) {
        String filename = this.sessionFilename(window);
        if (filename != null) {
            ApplicationContext appContext = this.getContext();
            try {
                appContext.getSessionStorage().save(window, filename);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "couldn't save session", e);
            }
            catch (SecurityException e) {
                logger.log(Level.WARNING, "couldn't save session", e);
            }
        }
    }

    @Override
    public void show(JFrame c) {
        super.show(c);
        Point onScreen = c.getLocationOnScreen();
        int x = Math.max(0, onScreen.x);
        int y = Math.max(0, onScreen.y);
        if (c.getWidth() < 150 || c.getHeight() < 20) {
            c.pack();
        }
        if (!(onScreen.x == x && onScreen.y == y || c.isLocationByPlatform())) {
            JFrame owner = c != this.getMainFrame() ? this.getMainFrame() : null;
            c.setLocationRelativeTo(owner);
        }
        c.getRootPane().putClientProperty("initialized", Boolean.TRUE);
    }

    protected void deleteSessionState() {
        ApplicationContext context = this.getContext();
        try {
            context.getLocalStorage().deleteFile("mainFrame.session.xml");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "couldn't delete sesssion", e);
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "couldn't delete sesssion", e);
        }
    }

    protected JXFrame createXMainFrame() {
        JXFrame xFrame = new JXFrame();
        ApplicationContext appContext = this.getContext();
        String title = appContext.getResourceMap().getString("Application.title", new Object[0]);
        xFrame.setStartPosition(JXFrame.StartPosition.Manual);
        xFrame.setTitle(title);
        xFrame.setName("mainFrame");
        return xFrame;
    }

    protected void injectSessionProperties() {
        SessionStorage storage = this.getContext().getSessionStorage();
        storage.putProperty(JXTable.class, new XProperties.XTableProperty());
        new XProperties().registerPersistenceDelegates(this.getContext());
    }
}

