/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.model;

import com.objectdb.spi.OMember;
import com.objectdb.spi.OReader;
import com.objectdb.spi.OType;
import com.objectdb.spi.OWriter;
import com.objectdb.spi.TrackableUserType;
import com.objectdb.spi.Tracker;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.FileTypeIconProvider;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.managers.interfaces.Identifiable;
import cz.vity.freerapid.plugins.container.FileInfo;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.jdesktop.application.AbstractBean;

@Entity
public class DownloadFile
extends AbstractBean
implements Identifiable,
PropertyChangeListener,
HttpFile,
TrackableUserType {
    private static final Logger logger = Logger.getLogger(DownloadFile.class.getName());
    @Id
    @GeneratedValue
    private Long dbId;
    private volatile long fileSize;
    private volatile DownloadState state;
    private volatile File storeFile;
    private String fileName;
    private volatile long downloaded;
    private int sleep;
    private float averageSpeed;
    private volatile String errorMessage;
    private volatile URL fileUrl;
    private volatile File saveToDirectory;
    private volatile String description;
    private volatile String fileType;
    private volatile int timeToQueued;
    private volatile int timeToQueuedMax;
    private long completeTaskDuration;
    private volatile int errorAttemptsCount;
    private volatile String shareDownloadServiceID;
    private volatile String serviceName;
    private volatile FileState fileState;
    private volatile Map<String, Object> properties;
    private int speedLimit;
    private volatile long realDownload;
    private volatile boolean resumeSupported;
    private int listOrder;
    private Date dateInserted;
    @Transient
    private volatile DownloadTask task;
    @Transient
    private volatile ConnectionSettings connectionSettings;
    @Transient
    private float shortTimeAvgSpeed;
    @Transient
    private long speed;
    @Transient
    private volatile int tokens;
    @Transient
    private int takenTokens;
    protected transient /* synthetic */ Tracker __odbTracker;
    public static final /* synthetic */ long __odbVersionCrc = -2130724217717717010L;

    public DownloadFile() {
        DownloadFile.__odbSet_state(this, DownloadState.PAUSED);
        DownloadFile.__odbSet_downloaded(this, 0L);
        DownloadFile.__odbSet_fileUrl(this, null);
        DownloadFile.__odbSet_timeToQueued(this, -1);
        DownloadFile.__odbSet_timeToQueuedMax(this, -1);
        DownloadFile.__odbSet_completeTaskDuration(this, -1L);
        DownloadFile.__odbSet_serviceName(this, null);
        DownloadFile.__odbSet_fileState(this, FileState.NOT_CHECKED);
        DownloadFile.__odbSet_properties(this, new Hashtable());
        DownloadFile.__odbSet_speedLimit(this, -1);
        DownloadFile.__odbSet_resumeSupported(this, true);
        this.task = null;
    }

    public DownloadFile(URL fileUrl, File saveToDirectory, String description) {
        DownloadFile.__odbSet_state(this, DownloadState.PAUSED);
        DownloadFile.__odbSet_downloaded(this, 0L);
        DownloadFile.__odbSet_fileUrl(this, null);
        DownloadFile.__odbSet_timeToQueued(this, -1);
        DownloadFile.__odbSet_timeToQueuedMax(this, -1);
        DownloadFile.__odbSet_completeTaskDuration(this, -1L);
        DownloadFile.__odbSet_serviceName(this, null);
        DownloadFile.__odbSet_fileState(this, FileState.NOT_CHECKED);
        DownloadFile.__odbSet_properties(this, new Hashtable());
        DownloadFile.__odbSet_speedLimit(this, -1);
        DownloadFile.__odbSet_resumeSupported(this, true);
        this.task = null;
        DownloadFile.__odbSet_fileUrl(this, fileUrl);
        DownloadFile.__odbSet_saveToDirectory(this, saveToDirectory);
        DownloadFile.__odbSet_description(this, description);
        this.setNewURL(fileUrl);
    }

    public DownloadFile(FileInfo info, File saveToDirectory) {
        DownloadFile.__odbSet_state(this, DownloadState.PAUSED);
        DownloadFile.__odbSet_downloaded(this, 0L);
        DownloadFile.__odbSet_fileUrl(this, null);
        DownloadFile.__odbSet_timeToQueued(this, -1);
        DownloadFile.__odbSet_timeToQueuedMax(this, -1);
        DownloadFile.__odbSet_completeTaskDuration(this, -1L);
        DownloadFile.__odbSet_serviceName(this, null);
        DownloadFile.__odbSet_fileState(this, FileState.NOT_CHECKED);
        DownloadFile.__odbSet_properties(this, new Hashtable());
        DownloadFile.__odbSet_speedLimit(this, -1);
        DownloadFile.__odbSet_resumeSupported(this, true);
        this.task = null;
        this.setNewURL(info.getFileUrl());
        if (info.getFileName() != null) {
            DownloadFile.__odbSet_fileName(this, info.getFileName());
        }
        DownloadFile.__odbSet_fileSize(this, info.getFileSize());
        DownloadFile.__odbSet_description(this, info.getDescription());
        DownloadFile.__odbSet_saveToDirectory(this, saveToDirectory);
    }

    public FileInfo toFileInfo() {
        FileInfo info = new FileInfo(DownloadFile.__odbGet_fileUrl(this));
        info.setFileName(DownloadFile.__odbGet_fileName(this));
        info.setFileSize(DownloadFile.__odbGet_fileSize(this));
        info.setDescription(DownloadFile.__odbGet_description(this));
        return info;
    }

    @Override
    public void setNewURL(URL fileUrl) {
        this.setFileUrl(fileUrl);
        DownloadFile.__odbSet_fileSize(this, -1L);
        String urlStr = fileUrl.toExternalForm();
        DownloadFile.__odbSet_fileName(this, FileTypeIconProvider.identifyFileName(urlStr));
        this.resetErrorAttempts();
        DownloadFile.__odbSet_sleep(this, -1);
        DownloadFile.__odbSet_averageSpeed(this, 0.0f);
        this.speed = 0L;
        DownloadFile.__odbSet_resumeSupported(this, true);
        DownloadFile.__odbSet_fileState(this, FileState.NOT_CHECKED);
        DownloadFile.__odbSet_timeToQueued(this, -1);
        this.setFileType(FileTypeIconProvider.identifyFileType(DownloadFile.__odbGet_fileName(this)));
    }

    @Override
    public File getSaveToDirectory() {
        return DownloadFile.__odbGet_saveToDirectory(this);
    }

    @Override
    public long getFileSize() {
        return DownloadFile.__odbGet_fileSize(this);
    }

    @Override
    public void setFileSize(long fileSize) {
        long oldValue = DownloadFile.__odbGet_fileSize(this);
        DownloadFile.__odbSet_fileSize(this, fileSize);
        this.firePropertyChange("fileSize", oldValue, DownloadFile.__odbGet_fileSize(this));
    }

    public DownloadTask getTask() {
        return this.task;
    }

    public void setTask(DownloadTask task) {
        if (task == null) {
            if (this.task != null) {
                this.task.removePropertyChangeListener(this);
            }
        } else {
            task.addPropertyChangeListener(this);
        }
        this.task = task;
    }

    @Override
    public DownloadState getState() {
        return DownloadFile.__odbGet_state(this);
    }

    @Override
    public void setState(DownloadState state) {
        if (DownloadFile.__odbGet_state(this) == DownloadState.DELETED) {
            return;
        }
        DownloadState oldValue = DownloadFile.__odbGet_state(this);
        DownloadFile.__odbSet_state(this, state);
        if (oldValue != state) {
            logger.info("Setting state to " + state.toString());
        }
        this.firePropertyChange("state", (Object)oldValue, (Object)DownloadFile.__odbGet_state(this));
    }

    @Override
    public URL getFileUrl() {
        return DownloadFile.__odbGet_fileUrl(this);
    }

    @Override
    public String getFileName() {
        return DownloadFile.__odbGet_fileName(this);
    }

    @Override
    public void setFileName(String fileName) {
        String oldValue = DownloadFile.__odbGet_fileName(this);
        DownloadFile.__odbSet_fileName(this, fileName);
        this.setFileType(FileTypeIconProvider.identifyFileType(DownloadFile.__odbGet_fileName(this)));
        this.firePropertyChange("fileName", oldValue, DownloadFile.__odbGet_fileName(this));
    }

    public String toString() {
        return DownloadFile.__odbGet_fileUrl(this).toString();
    }

    @Override
    public long getDownloaded() {
        return DownloadFile.__odbGet_downloaded(this);
    }

    @Override
    public void setDownloaded(long downloaded) {
        long oldValue = DownloadFile.__odbGet_downloaded(this);
        DownloadFile.__odbSet_downloaded(this, downloaded);
        logger.fine("setting downloaded to " + downloaded);
        this.firePropertyChange("downloaded", oldValue, DownloadFile.__odbGet_downloaded(this));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("sleep".equals(evt.getPropertyName())) {
            this.setSleep((Integer)evt.getNewValue());
        }
    }

    public void setSpeed(long speed) {
        long oldValue = this.speed;
        this.speed = speed;
        this.firePropertyChange("speed", oldValue, this.speed);
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSleep(int sleep) {
        int oldValue = DownloadFile.__odbGet_sleep(this);
        DownloadFile.__odbSet_sleep(this, sleep);
        this.firePropertyChange("sleep", oldValue, DownloadFile.__odbGet_sleep(this));
    }

    public void setAverageSpeed(float averageSpeed) {
        float oldValue = DownloadFile.__odbGet_averageSpeed(this);
        DownloadFile.__odbSet_averageSpeed(this, averageSpeed);
        this.firePropertyChange("averageSpeed", Float.valueOf(oldValue), Float.valueOf(DownloadFile.__odbGet_averageSpeed(this)));
    }

    public void setErrorMessage(String errorMessage) {
        DownloadFile.__odbSet_errorMessage(this, errorMessage);
    }

    public int getSleep() {
        return DownloadFile.__odbGet_sleep(this);
    }

    public float getAverageSpeed() {
        return DownloadFile.__odbGet_averageSpeed(this);
    }

    public String getServiceName() {
        if (DownloadFile.__odbGet_serviceName(this) == null) {
            return "";
        }
        return DownloadFile.__odbGet_serviceName(this);
    }

    public void setServiceName(String serviceName) {
        DownloadFile.__odbSet_serviceName(this, serviceName);
    }

    public String getErrorMessage() {
        return DownloadFile.__odbGet_errorMessage(this);
    }

    public File getOutputFile() {
        return new File(this.getSaveToDirectory(), DownloadFile.__odbGet_fileName(this));
    }

    public void setFileUrl(URL fileUrl) {
        DownloadFile.__odbSet_fileUrl(this, fileUrl);
    }

    public void setSaveToDirectory(File saveToDirectory) {
        DownloadFile.__odbSet_saveToDirectory(this, saveToDirectory);
    }

    @Override
    public String getDescription() {
        return DownloadFile.__odbGet_description(this);
    }

    @Override
    public void setDescription(String description) {
        String oldValue = DownloadFile.__odbGet_description(this);
        DownloadFile.__odbSet_description(this, description);
        this.firePropertyChange("description", oldValue, DownloadFile.__odbGet_description(this));
    }

    public String getFileType() {
        return DownloadFile.__odbGet_fileType(this);
    }

    public void setFileType(String fileType) {
        DownloadFile.__odbSet_fileType(this, fileType);
    }

    @Deprecated
    public String getShareDownloadServiceID() {
        return DownloadFile.__odbGet_shareDownloadServiceID(this);
    }

    public void setTimeToQueued(int i) {
        int oldValue = DownloadFile.__odbGet_timeToQueued(this);
        DownloadFile.__odbSet_timeToQueued(this, i);
        this.firePropertyChange("timeToQueued", oldValue, DownloadFile.__odbGet_timeToQueued(this));
    }

    public int getTimeToQueued() {
        return DownloadFile.__odbGet_timeToQueued(this);
    }

    public void setErrorAttemptsCount(int errorAttemptsCount) {
        DownloadFile.__odbSet_errorAttemptsCount(this, errorAttemptsCount);
    }

    public int getErrorAttemptsCount() {
        return DownloadFile.__odbGet_errorAttemptsCount(this);
    }

    public void resetErrorAttempts() {
        DownloadFile.__odbSet_errorAttemptsCount(this, AppPrefs.getProperty("errorAttemptsCount", 5));
    }

    @Deprecated
    public void setShareDownloadServiceID(String shareDownloadServiceID) {
        this.setPluginID(shareDownloadServiceID);
    }

    public int getTimeToQueuedMax() {
        return DownloadFile.__odbGet_timeToQueuedMax(this);
    }

    public void setTimeToQueuedMax(int timeToQueuedMax) {
        DownloadFile.__odbSet_timeToQueuedMax(this, timeToQueuedMax);
    }

    public void resetSpeed() {
        this.setSpeed(0L);
        this.setAverageSpeed(0.0f);
    }

    public long getCompleteTaskDuration() {
        return DownloadFile.__odbGet_completeTaskDuration(this);
    }

    public void setCompleteTaskDuration(long completeTaskDuration) {
        DownloadFile.__odbSet_completeTaskDuration(this, completeTaskDuration);
    }

    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public void setConnectionSettings(ConnectionSettings connectionSettings) {
        ConnectionSettings oldValue = this.connectionSettings;
        this.connectionSettings = connectionSettings;
        this.firePropertyChange("connectionSettings", oldValue, connectionSettings);
    }

    @Override
    public FileState getFileState() {
        return DownloadFile.__odbGet_fileState(this);
    }

    @Override
    public void setFileState(FileState fileState) {
        FileState oldValue = DownloadFile.__odbGet_fileState(this);
        DownloadFile.__odbSet_fileState(this, fileState);
        this.firePropertyChange("fileState", (Object)oldValue, (Object)fileState);
    }

    @Override
    public Map<String, Object> getProperties() {
        assert (DownloadFile.__odbGet_properties(this) != null);
        if (DownloadFile.__odbGet_properties(this) == null) {
            DownloadFile.__odbSet_properties(this, new Hashtable());
        }
        return DownloadFile.__odbGet_properties(this);
    }

    public void setProperties(Map<String, Object> properties) {
        DownloadFile.__odbSet_properties(this, properties);
    }

    @Override
    public void setPluginID(String pluginID) {
        DownloadFile.__odbSet_shareDownloadServiceID(this, pluginID);
        DownloadFile.__odbSet_serviceName(this, DownloadFile.__odbGet_shareDownloadServiceID(this).toLowerCase().replace('_', ' '));
    }

    @Override
    public String getPluginID() {
        return DownloadFile.__odbGet_shareDownloadServiceID(this);
    }

    public float getShortTimeAvgSpeed() {
        return this.shortTimeAvgSpeed;
    }

    public void setShortTimeAvgSpeed(float shortTimeAvgSpeed) {
        float oldValue = this.shortTimeAvgSpeed;
        this.shortTimeAvgSpeed = shortTimeAvgSpeed;
        this.firePropertyChange("shortTimeAvgSpeed", Float.valueOf(oldValue), Float.valueOf(shortTimeAvgSpeed));
    }

    public int getSpeedLimit() {
        return DownloadFile.__odbGet_speedLimit(this);
    }

    public void setSpeedLimit(int speedLimit) {
        int oldValue = DownloadFile.__odbGet_speedLimit(this);
        DownloadFile.__odbSet_speedLimit(this, speedLimit);
        this.firePropertyChange("speedLimit", oldValue, speedLimit);
    }

    public boolean hasSpeedLimit() {
        return DownloadFile.__odbGet_speedLimit(this) > 0;
    }

    public void setTokensLimit(int tokens) {
        this.tokens = tokens;
    }

    public int getTokensLimit() {
        return this.tokens;
    }

    public int getTakenTokens() {
        return this.takenTokens;
    }

    public void setTakenTokens(int takenTokens) {
        this.takenTokens = takenTokens;
    }

    @Override
    public File getStoreFile() {
        return DownloadFile.__odbGet_storeFile(this);
    }

    @Override
    public void setStoreFile(File storeFile) {
        DownloadFile.__odbSet_storeFile(this, storeFile);
    }

    @Override
    public long getRealDownload() {
        return DownloadFile.__odbGet_realDownload(this);
    }

    public void setRealDownload(long realDownload) {
        DownloadFile.__odbSet_realDownload(this, realDownload);
    }

    @Override
    public boolean isResumeSupported() {
        return DownloadFile.__odbGet_resumeSupported(this);
    }

    public Date getDateInserted() {
        return DownloadFile.__odbGet_dateInserted(this);
    }

    public void setDateInserted(Date dateInserted) {
        DownloadFile.__odbSet_dateInserted(this, dateInserted);
    }

    @Override
    public void setResumeSupported(boolean resumeSupported) {
        boolean oldValue = DownloadFile.__odbGet_resumeSupported(this);
        DownloadFile.__odbSet_resumeSupported(this, resumeSupported);
        this.firePropertyChange("resumeSupported", oldValue, DownloadFile.__odbGet_resumeSupported(this));
    }

    public Object getIdentificator() {
        return DownloadFile.__odbGet_dbId(this);
    }

    public int getListOrder() {
        return DownloadFile.__odbGet_listOrder(this);
    }

    public void setListOrder(int listOrder) {
        int oldValue = DownloadFile.__odbGet_listOrder(this);
        DownloadFile.__odbSet_listOrder(this, listOrder);
        this.firePropertyChange("listOrder", oldValue, DownloadFile.__odbGet_listOrder(this));
    }

    @Override
    public void __odbSetTracker(Tracker tracker) {
        this.__odbTracker = tracker;
    }

    @Override
    public Tracker __odbGetTracker() {
        return this.__odbTracker;
    }

    @Override
    public TrackableUserType __odbNewInstance() {
        return new DownloadFile();
    }

    public static void __odbSet_dbId(DownloadFile downloadFile, Long l) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(0)) {
            downloadFile.dbId = l;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.dbId = l;
        }
    }

    public static Long __odbGet_dbId(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(0);
        }
        return downloadFile.dbId;
    }

    public static void __odbSet_fileSize(DownloadFile downloadFile, long l) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(1)) {
            downloadFile.fileSize = l;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.fileSize = l;
        }
    }

    public static long __odbGet_fileSize(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(1);
        }
        return downloadFile.fileSize;
    }

    public static void __odbSet_state(DownloadFile downloadFile, DownloadState downloadState) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(2)) {
            downloadFile.state = downloadState;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.state = downloadState;
        }
    }

    public static DownloadState __odbGet_state(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(2);
        }
        return downloadFile.state;
    }

    public static void __odbSet_storeFile(DownloadFile downloadFile, File file) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(3)) {
            downloadFile.storeFile = file;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.storeFile = file;
        }
    }

    public static File __odbGet_storeFile(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(3);
        }
        return downloadFile.storeFile;
    }

    public static void __odbSet_fileName(DownloadFile downloadFile, String string) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(4)) {
            downloadFile.fileName = string;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.fileName = string;
        }
    }

    public static String __odbGet_fileName(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(4);
        }
        return downloadFile.fileName;
    }

    public static void __odbSet_downloaded(DownloadFile downloadFile, long l) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(5)) {
            downloadFile.downloaded = l;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.downloaded = l;
        }
    }

    public static long __odbGet_downloaded(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(5);
        }
        return downloadFile.downloaded;
    }

    public static void __odbSet_sleep(DownloadFile downloadFile, int n) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(6)) {
            downloadFile.sleep = n;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.sleep = n;
        }
    }

    public static int __odbGet_sleep(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(6);
        }
        return downloadFile.sleep;
    }

    public static void __odbSet_averageSpeed(DownloadFile downloadFile, float f) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(7)) {
            downloadFile.averageSpeed = f;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.averageSpeed = f;
        }
    }

    public static float __odbGet_averageSpeed(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(7);
        }
        return downloadFile.averageSpeed;
    }

    public static void __odbSet_errorMessage(DownloadFile downloadFile, String string) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(8)) {
            downloadFile.errorMessage = string;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.errorMessage = string;
        }
    }

    public static String __odbGet_errorMessage(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(8);
        }
        return downloadFile.errorMessage;
    }

    public static void __odbSet_fileUrl(DownloadFile downloadFile, URL uRL) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(9)) {
            downloadFile.fileUrl = uRL;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.fileUrl = uRL;
        }
    }

    public static URL __odbGet_fileUrl(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(9);
        }
        return downloadFile.fileUrl;
    }

    public static void __odbSet_saveToDirectory(DownloadFile downloadFile, File file) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(10)) {
            downloadFile.saveToDirectory = file;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.saveToDirectory = file;
        }
    }

    public static File __odbGet_saveToDirectory(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(10);
        }
        return downloadFile.saveToDirectory;
    }

    public static void __odbSet_description(DownloadFile downloadFile, String string) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(11)) {
            downloadFile.description = string;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.description = string;
        }
    }

    public static String __odbGet_description(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(11);
        }
        return downloadFile.description;
    }

    public static void __odbSet_fileType(DownloadFile downloadFile, String string) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(12)) {
            downloadFile.fileType = string;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.fileType = string;
        }
    }

    public static String __odbGet_fileType(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(12);
        }
        return downloadFile.fileType;
    }

    public static void __odbSet_timeToQueued(DownloadFile downloadFile, int n) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(13)) {
            downloadFile.timeToQueued = n;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.timeToQueued = n;
        }
    }

    public static int __odbGet_timeToQueued(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(13);
        }
        return downloadFile.timeToQueued;
    }

    public static void __odbSet_timeToQueuedMax(DownloadFile downloadFile, int n) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(14)) {
            downloadFile.timeToQueuedMax = n;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.timeToQueuedMax = n;
        }
    }

    public static int __odbGet_timeToQueuedMax(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(14);
        }
        return downloadFile.timeToQueuedMax;
    }

    public static void __odbSet_completeTaskDuration(DownloadFile downloadFile, long l) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(15)) {
            downloadFile.completeTaskDuration = l;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.completeTaskDuration = l;
        }
    }

    public static long __odbGet_completeTaskDuration(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(15);
        }
        return downloadFile.completeTaskDuration;
    }

    public static void __odbSet_errorAttemptsCount(DownloadFile downloadFile, int n) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(16)) {
            downloadFile.errorAttemptsCount = n;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.errorAttemptsCount = n;
        }
    }

    public static int __odbGet_errorAttemptsCount(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(16);
        }
        return downloadFile.errorAttemptsCount;
    }

    public static void __odbSet_shareDownloadServiceID(DownloadFile downloadFile, String string) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(17)) {
            downloadFile.shareDownloadServiceID = string;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.shareDownloadServiceID = string;
        }
    }

    public static String __odbGet_shareDownloadServiceID(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(17);
        }
        return downloadFile.shareDownloadServiceID;
    }

    public static void __odbSet_serviceName(DownloadFile downloadFile, String string) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(18)) {
            downloadFile.serviceName = string;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.serviceName = string;
        }
    }

    public static String __odbGet_serviceName(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(18);
        }
        return downloadFile.serviceName;
    }

    public static void __odbSet_fileState(DownloadFile downloadFile, FileState fileState) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(19)) {
            downloadFile.fileState = fileState;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.fileState = fileState;
        }
    }

    public static FileState __odbGet_fileState(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(19);
        }
        return downloadFile.fileState;
    }

    public static void __odbSet_properties(DownloadFile downloadFile, Map map) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(20)) {
            downloadFile.properties = map;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.properties = map;
        }
    }

    public static Map __odbGet_properties(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(20);
        }
        return downloadFile.properties;
    }

    public static void __odbSet_speedLimit(DownloadFile downloadFile, int n) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(21)) {
            downloadFile.speedLimit = n;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.speedLimit = n;
        }
    }

    public static int __odbGet_speedLimit(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(21);
        }
        return downloadFile.speedLimit;
    }

    public static void __odbSet_realDownload(DownloadFile downloadFile, long l) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(22)) {
            downloadFile.realDownload = l;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.realDownload = l;
        }
    }

    public static long __odbGet_realDownload(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(22);
        }
        return downloadFile.realDownload;
    }

    public static void __odbSet_resumeSupported(DownloadFile downloadFile, boolean bl) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(23)) {
            downloadFile.resumeSupported = bl;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.resumeSupported = bl;
        }
    }

    public static boolean __odbGet_resumeSupported(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(23);
        }
        return downloadFile.resumeSupported;
    }

    public static void __odbSet_listOrder(DownloadFile downloadFile, int n) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(24)) {
            downloadFile.listOrder = n;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.listOrder = n;
        }
    }

    public static int __odbGet_listOrder(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(24);
        }
        return downloadFile.listOrder;
    }

    public static void __odbSet_dateInserted(DownloadFile downloadFile, Date date) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(25)) {
            downloadFile.dateInserted = date;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.dateInserted = date;
        }
    }

    public static Date __odbGet_dateInserted(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(25);
        }
        return downloadFile.dateInserted;
    }

    public static void __odbSet_task(DownloadFile downloadFile, DownloadTask downloadTask) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(26)) {
            downloadFile.task = downloadTask;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.task = downloadTask;
        }
    }

    public static DownloadTask __odbGet_task(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(26);
        }
        return downloadFile.task;
    }

    public static void __odbSet_connectionSettings(DownloadFile downloadFile, ConnectionSettings connectionSettings) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(27)) {
            downloadFile.connectionSettings = connectionSettings;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.connectionSettings = connectionSettings;
        }
    }

    public static ConnectionSettings __odbGet_connectionSettings(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(27);
        }
        return downloadFile.connectionSettings;
    }

    public static void __odbSet_shortTimeAvgSpeed(DownloadFile downloadFile, float f) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(28)) {
            downloadFile.shortTimeAvgSpeed = f;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.shortTimeAvgSpeed = f;
        }
    }

    public static float __odbGet_shortTimeAvgSpeed(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(28);
        }
        return downloadFile.shortTimeAvgSpeed;
    }

    public static void __odbSet_speed(DownloadFile downloadFile, long l) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(29)) {
            downloadFile.speed = l;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.speed = l;
        }
    }

    public static long __odbGet_speed(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(29);
        }
        return downloadFile.speed;
    }

    public static void __odbSet_tokens(DownloadFile downloadFile, int n) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(30)) {
            downloadFile.tokens = n;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.tokens = n;
        }
    }

    public static int __odbGet_tokens(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(30);
        }
        return downloadFile.tokens;
    }

    public static void __odbSet_takenTokens(DownloadFile downloadFile, int n) {
        if (downloadFile.__odbTracker != null && downloadFile.__odbTracker.beforeModifyMember(31)) {
            downloadFile.takenTokens = n;
            downloadFile.__odbTracker.afterModify();
        } else {
            downloadFile.takenTokens = n;
        }
    }

    public static int __odbGet_takenTokens(DownloadFile downloadFile) {
        if (downloadFile.__odbTracker != null) {
            downloadFile.__odbTracker.beforeAccess(31);
        }
        return downloadFile.takenTokens;
    }

    public static int __odbGetMemberCount() {
        return 32;
    }

    @Override
    public void __odbClear() {
        this.fileSize = 0L;
        this.state = null;
        this.storeFile = null;
        this.fileName = null;
        this.downloaded = 0L;
        this.sleep = 0;
        this.averageSpeed = 0.0f;
        this.errorMessage = null;
        this.fileUrl = null;
        this.saveToDirectory = null;
        this.description = null;
        this.fileType = null;
        this.timeToQueued = 0;
        this.timeToQueuedMax = 0;
        this.completeTaskDuration = 0L;
        this.errorAttemptsCount = 0;
        this.shareDownloadServiceID = null;
        this.serviceName = null;
        this.fileState = null;
        this.properties = null;
        this.speedLimit = 0;
        this.realDownload = 0L;
        this.resumeSupported = (byte)0;
        this.listOrder = 0;
        this.dateInserted = null;
    }

    @Override
    public void __odbWriteContent(OType[] oTypeArray, OWriter oWriter) {
        oWriter.writeSInt64Value(this.fileSize);
        oWriter.writeElement(oTypeArray[2], (Object)this.state);
        oWriter.writeElement(oTypeArray[3], this.storeFile);
        oWriter.writeStringValue(this.fileName);
        oWriter.writeSInt64Value(this.downloaded);
        oWriter.writeSInt32Value(this.sleep);
        oWriter.writeFloatValue(this.averageSpeed);
        oWriter.writeStringValue(this.errorMessage);
        oWriter.writeElement(oTypeArray[9], this.fileUrl);
        oWriter.writeElement(oTypeArray[10], this.saveToDirectory);
        oWriter.writeStringValue(this.description);
        oWriter.writeStringValue(this.fileType);
        oWriter.writeSInt32Value(this.timeToQueued);
        oWriter.writeSInt32Value(this.timeToQueuedMax);
        oWriter.writeSInt64Value(this.completeTaskDuration);
        oWriter.writeSInt32Value(this.errorAttemptsCount);
        oWriter.writeStringValue(this.shareDownloadServiceID);
        oWriter.writeStringValue(this.serviceName);
        oWriter.writeElement(oTypeArray[19], (Object)this.fileState);
        oWriter.writeElement(oTypeArray[20], this.properties);
        oWriter.writeSInt32Value(this.speedLimit);
        oWriter.writeSInt64Value(this.realDownload);
        oWriter.writeBooleanValue(this.resumeSupported);
        oWriter.writeSInt32Value(this.listOrder);
        oWriter.writeElement(oTypeArray[25], this.dateInserted);
    }

    @Override
    public void __odbReadContent(OMember[] oMemberArray, OReader oReader) {
        this.fileSize = oReader.readSInt64Value();
        this.state = (DownloadState)((Object)oMemberArray[2].readAndAdjust(oReader));
        this.storeFile = (File)oMemberArray[3].readAndAdjust(oReader);
        this.fileName = oReader.readStringValue();
        this.downloaded = oReader.readSInt64Value();
        this.sleep = oReader.readSInt32Value();
        this.averageSpeed = oReader.readFloatValue();
        this.errorMessage = oReader.readStringValue();
        this.fileUrl = (URL)oMemberArray[9].readAndAdjust(oReader);
        this.saveToDirectory = (File)oMemberArray[10].readAndAdjust(oReader);
        this.description = oReader.readStringValue();
        this.fileType = oReader.readStringValue();
        this.timeToQueued = oReader.readSInt32Value();
        this.timeToQueuedMax = oReader.readSInt32Value();
        this.completeTaskDuration = oReader.readSInt64Value();
        this.errorAttemptsCount = oReader.readSInt32Value();
        this.shareDownloadServiceID = oReader.readStringValue();
        this.serviceName = oReader.readStringValue();
        this.fileState = (FileState)((Object)oMemberArray[19].readAndAdjust(oReader));
        this.properties = (Map)oMemberArray[20].readAndAdjust(oReader);
        this.speedLimit = oReader.readSInt32Value();
        this.realDownload = oReader.readSInt64Value();
        this.resumeSupported = oReader.readBooleanValue();
        this.listOrder = oReader.readSInt32Value();
        this.dateInserted = (Date)oMemberArray[25].readAndAdjust(oReader);
    }

    @Override
    public void __odbWriteMember(OMember oMember, OWriter oWriter) {
        switch (oMember.getMemberIx()) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
        }
        oWriter.writeElement(oMember.getType(), this.dbId);
    }

    @Override
    public void __odbReadMember(OMember oMember, OReader oReader) {
        switch (oMember.getMemberIx()) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                this.dbId = (Long)oMember.readAndAdjust(oReader);
                return;
            }
            case 1: {
                this.fileSize = oReader.readSInt64Value();
                return;
            }
            case 2: {
                this.state = (DownloadState)((Object)oMember.readAndAdjust(oReader));
                return;
            }
            case 3: {
                this.storeFile = (File)oMember.readAndAdjust(oReader);
                return;
            }
            case 4: {
                this.fileName = oReader.readStringValue();
                return;
            }
            case 5: {
                this.downloaded = oReader.readSInt64Value();
                return;
            }
            case 6: {
                this.sleep = oReader.readSInt32Value();
                return;
            }
            case 7: {
                this.averageSpeed = oReader.readFloatValue();
                return;
            }
            case 8: {
                this.errorMessage = oReader.readStringValue();
                return;
            }
            case 9: {
                this.fileUrl = (URL)oMember.readAndAdjust(oReader);
                return;
            }
            case 10: {
                this.saveToDirectory = (File)oMember.readAndAdjust(oReader);
                return;
            }
            case 11: {
                this.description = oReader.readStringValue();
                return;
            }
            case 12: {
                this.fileType = oReader.readStringValue();
                return;
            }
            case 13: {
                this.timeToQueued = oReader.readSInt32Value();
                return;
            }
            case 14: {
                this.timeToQueuedMax = oReader.readSInt32Value();
                return;
            }
            case 15: {
                this.completeTaskDuration = oReader.readSInt64Value();
                return;
            }
            case 16: {
                this.errorAttemptsCount = oReader.readSInt32Value();
                return;
            }
            case 17: {
                this.shareDownloadServiceID = oReader.readStringValue();
                return;
            }
            case 18: {
                this.serviceName = oReader.readStringValue();
                return;
            }
            case 19: {
                this.fileState = (FileState)((Object)oMember.readAndAdjust(oReader));
                return;
            }
            case 20: {
                this.properties = (Map)oMember.readAndAdjust(oReader);
                return;
            }
            case 21: {
                this.speedLimit = oReader.readSInt32Value();
                return;
            }
            case 22: {
                this.realDownload = oReader.readSInt64Value();
                return;
            }
            case 23: {
                this.resumeSupported = oReader.readBooleanValue();
                return;
            }
            case 24: {
                this.listOrder = oReader.readSInt32Value();
                return;
            }
            case 25: 
        }
        this.dateInserted = (Date)oMember.readAndAdjust(oReader);
    }

    @Override
    public void __odbSetMember(int n, Object object) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                this.dbId = (Long)object;
                return;
            }
            case 1: {
                this.fileSize = (Long)object;
                return;
            }
            case 2: {
                this.state = (DownloadState)((Object)object);
                return;
            }
            case 3: {
                this.storeFile = (File)object;
                return;
            }
            case 4: {
                this.fileName = (String)object;
                return;
            }
            case 5: {
                this.downloaded = (Long)object;
                return;
            }
            case 6: {
                this.sleep = (Integer)object;
                return;
            }
            case 7: {
                this.averageSpeed = ((Float)object).floatValue();
                return;
            }
            case 8: {
                this.errorMessage = (String)object;
                return;
            }
            case 9: {
                this.fileUrl = (URL)object;
                return;
            }
            case 10: {
                this.saveToDirectory = (File)object;
                return;
            }
            case 11: {
                this.description = (String)object;
                return;
            }
            case 12: {
                this.fileType = (String)object;
                return;
            }
            case 13: {
                this.timeToQueued = (Integer)object;
                return;
            }
            case 14: {
                this.timeToQueuedMax = (Integer)object;
                return;
            }
            case 15: {
                this.completeTaskDuration = (Long)object;
                return;
            }
            case 16: {
                this.errorAttemptsCount = (Integer)object;
                return;
            }
            case 17: {
                this.shareDownloadServiceID = (String)object;
                return;
            }
            case 18: {
                this.serviceName = (String)object;
                return;
            }
            case 19: {
                this.fileState = (FileState)((Object)object);
                return;
            }
            case 20: {
                this.properties = (Map)object;
                return;
            }
            case 21: {
                this.speedLimit = (Integer)object;
                return;
            }
            case 22: {
                this.realDownload = (Long)object;
                return;
            }
            case 23: {
                this.resumeSupported = (Boolean)object;
                return;
            }
            case 24: {
                this.listOrder = (Integer)object;
                return;
            }
            case 25: {
                this.dateInserted = (Date)object;
                return;
            }
            case 26: {
                this.task = (DownloadTask)object;
                return;
            }
            case 27: {
                this.connectionSettings = (ConnectionSettings)object;
                return;
            }
            case 28: {
                this.shortTimeAvgSpeed = ((Float)object).floatValue();
                return;
            }
            case 29: {
                this.speed = (Long)object;
                return;
            }
            case 30: {
                this.tokens = (Integer)object;
                return;
            }
            case 31: 
        }
        this.takenTokens = (Integer)object;
    }

    @Override
    public Object __odbGetMember(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                return this.dbId;
            }
            case 1: {
                return this.fileSize;
            }
            case 2: {
                return this.state;
            }
            case 3: {
                return this.storeFile;
            }
            case 4: {
                return this.fileName;
            }
            case 5: {
                return this.downloaded;
            }
            case 6: {
                return this.sleep;
            }
            case 7: {
                return Float.valueOf(this.averageSpeed);
            }
            case 8: {
                return this.errorMessage;
            }
            case 9: {
                return this.fileUrl;
            }
            case 10: {
                return this.saveToDirectory;
            }
            case 11: {
                return this.description;
            }
            case 12: {
                return this.fileType;
            }
            case 13: {
                return this.timeToQueued;
            }
            case 14: {
                return this.timeToQueuedMax;
            }
            case 15: {
                return this.completeTaskDuration;
            }
            case 16: {
                return this.errorAttemptsCount;
            }
            case 17: {
                return this.shareDownloadServiceID;
            }
            case 18: {
                return this.serviceName;
            }
            case 19: {
                return this.fileState;
            }
            case 20: {
                return this.properties;
            }
            case 21: {
                return this.speedLimit;
            }
            case 22: {
                return this.realDownload;
            }
            case 23: {
                return this.resumeSupported;
            }
            case 24: {
                return this.listOrder;
            }
            case 25: {
                return this.dateInserted;
            }
            case 26: {
                return this.task;
            }
            case 27: {
                return this.connectionSettings;
            }
            case 28: {
                return Float.valueOf(this.shortTimeAvgSpeed);
            }
            case 29: {
                return this.speed;
            }
            case 30: {
                return this.tokens;
            }
            case 31: 
        }
        return this.takenTokens;
    }

    @Override
    public void __odbSetNumMember(int n, long l) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
        }
        this.dbId = l;
    }

    @Override
    public long __odbGetNumMember(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                return this.dbId;
            }
            case 1: {
                return this.fileSize;
            }
            case 5: {
                return this.downloaded;
            }
            case 6: {
                return this.sleep;
            }
            case 7: {
                return (long)this.averageSpeed;
            }
            case 13: {
                return this.timeToQueued;
            }
            case 14: {
                return this.timeToQueuedMax;
            }
            case 15: {
                return this.completeTaskDuration;
            }
            case 16: {
                return this.errorAttemptsCount;
            }
            case 21: {
                return this.speedLimit;
            }
            case 22: {
                return this.realDownload;
            }
            case 24: {
                return this.listOrder;
            }
            case 28: {
                return (long)this.shortTimeAvgSpeed;
            }
            case 29: {
                return this.speed;
            }
            case 30: {
                return this.tokens;
            }
            case 31: 
        }
        return this.takenTokens;
    }

    @Override
    public void __odbClearMember(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                this.dbId = null;
                return;
            }
            case 1: {
                this.fileSize = 0L;
                return;
            }
            case 2: {
                this.state = null;
                return;
            }
            case 3: {
                this.storeFile = null;
                return;
            }
            case 4: {
                this.fileName = null;
                return;
            }
            case 5: {
                this.downloaded = 0L;
                return;
            }
            case 6: {
                this.sleep = 0;
                return;
            }
            case 7: {
                this.averageSpeed = 0.0f;
                return;
            }
            case 8: {
                this.errorMessage = null;
                return;
            }
            case 9: {
                this.fileUrl = null;
                return;
            }
            case 10: {
                this.saveToDirectory = null;
                return;
            }
            case 11: {
                this.description = null;
                return;
            }
            case 12: {
                this.fileType = null;
                return;
            }
            case 13: {
                this.timeToQueued = 0;
                return;
            }
            case 14: {
                this.timeToQueuedMax = 0;
                return;
            }
            case 15: {
                this.completeTaskDuration = 0L;
                return;
            }
            case 16: {
                this.errorAttemptsCount = 0;
                return;
            }
            case 17: {
                this.shareDownloadServiceID = null;
                return;
            }
            case 18: {
                this.serviceName = null;
                return;
            }
            case 19: {
                this.fileState = null;
                return;
            }
            case 20: {
                this.properties = null;
                return;
            }
            case 21: {
                this.speedLimit = 0;
                return;
            }
            case 22: {
                this.realDownload = 0L;
                return;
            }
            case 23: {
                this.resumeSupported = (byte)0;
                return;
            }
            case 24: {
                this.listOrder = 0;
                return;
            }
            case 25: {
                this.dateInserted = null;
                return;
            }
            case 26: {
                this.task = null;
                return;
            }
            case 27: {
                this.connectionSettings = null;
                return;
            }
            case 28: {
                this.shortTimeAvgSpeed = 0.0f;
                return;
            }
            case 29: {
                this.speed = 0L;
                return;
            }
            case 30: {
                this.tokens = 0;
                return;
            }
            case 31: 
        }
        this.takenTokens = 0;
    }

    @Override
    public long __odbGetVersionCrc() {
        return -2130724217717717010L;
    }

    public Object __odbsuperClone() throws CloneNotSupportedException {
        return Tracker.fixClone(super.clone());
    }
}

