/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.FileTypeIconProvider;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.utils.HttpUtils;
import cz.vity.freerapid.swing.Swinger;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RenameFileNameEditor
extends DefaultCellEditor {
    private JPanel component;
    private final JLabel iconLabel;

    public RenameFileNameEditor(final FileTypeIconProvider fileTypeIconProvider) {
        super(new JTextField());
        final JTextField field = (JTextField)this.editorComponent;
        this.component = new JPanel(new BorderLayout(0, 0));
        this.component.setBorder(null);
        this.iconLabel = new JLabel();
        this.component.add((Component)this.iconLabel, "West");
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 6));
        this.component.add((Component)field, "Center");
        this.editorComponent = this.component;
        field.removeActionListener(this.delegate);
        this.setClickCountToStart(1000);
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private DownloadFile downloadFile;

            @Override
            public void setValue(Object value) {
                this.downloadFile = (DownloadFile)value;
                String fileName = this.downloadFile.getFileName();
                RenameFileNameEditor.this.iconLabel.setIcon(fileTypeIconProvider.getIconImageByFileType(this.downloadFile.getFileType(), false));
                field.setText(fileName != null ? fileName : "");
                Swinger.inputFocus(field);
                if (AppPrefs.getProperty("renameFileActionSelectWithoutExtension", true)) {
                    int extIndex = field.getText().lastIndexOf(46);
                    if (extIndex > -1) {
                        field.setCaretPosition(0);
                        field.moveCaretPosition(extIndex);
                    } else {
                        field.selectAll();
                    }
                } else {
                    field.selectAll();
                }
            }

            @Override
            public Object getCellEditorValue() {
                String text = field.getText();
                if (text.isEmpty()) {
                    return this.downloadFile;
                }
                text = HttpUtils.replaceInvalidCharsForFileSystem(text, "_");
                this.downloadFile.setFileName(text);
                return this.downloadFile;
            }
        };
        field.addActionListener(this.delegate);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }
}

