/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.dav;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exception.HttpNotFoundException;
import davmail.exception.HttpPreconditionFailedException;
import davmail.exception.InsufficientStorageException;
import davmail.exception.LoginTimeoutException;
import davmail.exception.WebdavNotAvailableException;
import davmail.exchange.ExchangeSession;
import davmail.exchange.VCalendar;
import davmail.exchange.VObject;
import davmail.exchange.VProperty;
import davmail.exchange.XMLStreamUtil;
import davmail.exchange.dav.DavExchangeSession;
import davmail.exchange.dav.Field;
import davmail.exchange.dav.PropertyValue;
import davmail.http.HttpClientAdapter;
import davmail.http.URIUtil;
import davmail.http.request.ExchangePropPatchRequest;
import davmail.ui.tray.DavGatewayTray;
import davmail.util.IOUtil;
import davmail.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.SharedByteArrayInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.HttpCopy;
import org.apache.jackrabbit.webdav.client.methods.HttpMove;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.client.methods.HttpProppatch;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.w3c.dom.Node;

public class HC4DavExchangeSession
extends ExchangeSession {
    protected static final DavPropertyNameSet WELL_KNOWN_FOLDERS = new DavPropertyNameSet();
    static final Map<String, String> vTodoToTaskStatusMap;
    static final Map<String, String> taskTovTodoStatusMap;
    private HttpClientAdapter httpClientAdapter;
    protected String inboxUrl;
    protected String deleteditemsUrl;
    protected String sentitemsUrl;
    protected String sendmsgUrl;
    protected String draftsUrl;
    protected String calendarUrl;
    protected String tasksUrl;
    protected String contactsUrl;
    protected String outboxUrl;
    protected String inboxName;
    protected String deleteditemsName;
    protected String sentitemsName;
    protected String sendmsgName;
    protected String draftsName;
    protected String calendarName;
    protected String tasksName;
    protected String contactsName;
    protected String outboxName;
    protected static final String USERS = "/users/";
    static final HashMap<String, String> GALFIND_CRITERIA_MAP;
    static final HashSet<String> GALLOOKUP_ATTRIBUTES;
    static final HashMap<String, String> GALFIND_ATTRIBUTE_MAP;
    boolean disableGalFind;
    private boolean disableGalLookup;
    static final String BASE_HREF = "<base href=\"";
    static final Map<ExchangeSession.Operator, String> OPERATOR_MAP;
    protected static final Set<String> FOLDER_PROPERTIES;
    protected static final DavPropertyNameSet FOLDER_PROPERTIES_NAME_SET;
    protected static final Set<String> ITEM_PROPERTIES;
    protected static final Set<String> EVENT_REQUEST_PROPERTIES;
    protected static final DavPropertyNameSet EVENT_REQUEST_PROPERTIES_NAME_SET;
    protected static final long ENCODING_PREFERENCE = 131072L;
    protected static final long ENCODING_MIME = 262144L;
    protected static final long BODY_ENCODING_TEXT_AND_HTML = 0x100000L;
    protected boolean restoreHostName;
    protected static final Map<String, String> importanceToPriorityMap;
    protected static final Map<String, String> priorityToImportanceMap;

    protected void getEmailAndAliasFromOptions() {
        HttpGet optionsMethod = new HttpGet("/owa/?ae=Options&t=About");
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)optionsMethod, this.cloneContext());
             InputStream inputStream = response.getEntity().getContent();
             BufferedReader optionsPageReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while (!((line = optionsPageReader.readLine()) == null || line.indexOf(91) != -1 && line.indexOf(64) != -1 && line.indexOf(93) != -1 && line.toLowerCase().contains("/cn="))) {
            }
            if (line != null) {
                int start = line.toLowerCase().lastIndexOf("/cn=") + "/cn=".length();
                int end = line.indexOf(60, start);
                this.alias = line.substring(start, end);
                end = line.lastIndexOf(93);
                start = line.lastIndexOf(91, end) + 1;
                this.email = line.substring(start, end);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error parsing options page at " + optionsMethod.getURI()));
        }
    }

    private HttpClientContext cloneContext() {
        BasicCookieStore cookieStore = new BasicCookieStore();
        cookieStore.addCookies(this.httpClientAdapter.getCookies().toArray(new Cookie[0]));
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        return context;
    }

    @Override
    public boolean isExpired() throws NoRouteToHostException, UnknownHostException {
        if ("Exchange2007".equals(this.serverVersion)) {
            HttpGet getMethod = new HttpGet("/owa/");
            try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)getMethod);){
                LOGGER.debug((Object)(response.getStatusLine().getStatusCode() + " at /owa/"));
            }
            catch (IOException e) {
                LOGGER.warn((Object)e.getMessage());
            }
        }
        return super.isExpired();
    }

    public String getFolderPath(String folderPath) {
        String exchangeFolderPath;
        if (folderPath.startsWith("INBOX")) {
            exchangeFolderPath = this.mailPath + this.inboxName + folderPath.substring("INBOX".length());
        } else if (folderPath.startsWith("Trash")) {
            exchangeFolderPath = this.mailPath + this.deleteditemsName + folderPath.substring("Trash".length());
        } else if (folderPath.startsWith("Drafts")) {
            exchangeFolderPath = this.mailPath + this.draftsName + folderPath.substring("Drafts".length());
        } else if (folderPath.startsWith("Sent")) {
            exchangeFolderPath = this.mailPath + this.sentitemsName + folderPath.substring("Sent".length());
        } else if (folderPath.startsWith("##DavMailSubmissionURI##")) {
            exchangeFolderPath = this.mailPath + this.sendmsgName + folderPath.substring("##DavMailSubmissionURI##".length());
        } else if (folderPath.startsWith("contacts")) {
            exchangeFolderPath = this.mailPath + this.contactsName + folderPath.substring("contacts".length());
        } else if (folderPath.startsWith("calendar")) {
            exchangeFolderPath = this.mailPath + this.calendarName + folderPath.substring("calendar".length());
        } else if (folderPath.startsWith("tasks")) {
            exchangeFolderPath = this.mailPath + this.tasksName + folderPath.substring("tasks".length());
        } else if (folderPath.startsWith("public")) {
            exchangeFolderPath = this.publicFolderUrl + folderPath.substring("public".length());
        } else if (folderPath.startsWith(USERS)) {
            String localPath;
            String principal;
            int principalIndex = folderPath.indexOf(47, USERS.length());
            if (principalIndex >= 0) {
                principal = folderPath.substring(USERS.length(), principalIndex);
                localPath = folderPath.substring(USERS.length() + principal.length() + 1);
                if (localPath.startsWith("inbox") || localPath.startsWith("INBOX") || localPath.startsWith("Inbox")) {
                    localPath = this.inboxName + localPath.substring("inbox".length());
                } else if (localPath.startsWith("calendar")) {
                    localPath = this.calendarName + localPath.substring("calendar".length());
                } else if (localPath.startsWith("tasks")) {
                    localPath = this.tasksName + localPath.substring("tasks".length());
                } else if (localPath.startsWith("contacts")) {
                    localPath = this.contactsName + localPath.substring("contacts".length());
                } else if (localPath.startsWith("addressbook")) {
                    localPath = this.contactsName + localPath.substring("addressbook".length());
                }
            } else {
                principal = folderPath.substring(USERS.length());
                localPath = "";
            }
            if (principal.length() == 0) {
                exchangeFolderPath = this.rootPath;
            } else if (this.alias.equalsIgnoreCase(principal) || this.email != null && this.email.equalsIgnoreCase(principal)) {
                exchangeFolderPath = this.mailPath + localPath;
            } else {
                LOGGER.debug((Object)("Detected shared path for principal " + principal + ", user principal is " + this.email));
                exchangeFolderPath = this.rootPath + principal + '/' + localPath;
            }
        } else {
            exchangeFolderPath = folderPath.startsWith("/") ? folderPath : this.mailPath + folderPath;
        }
        return exchangeFolderPath;
    }

    @Override
    public boolean isSharedFolder(String folderPath) {
        return !this.getFolderPath(folderPath).toLowerCase().startsWith(this.mailPath.toLowerCase());
    }

    @Override
    public boolean isMainCalendar(String folderPath) {
        return this.getFolderPath(folderPath).equalsIgnoreCase(this.getFolderPath("calendar"));
    }

    public String getCmdBasePath() {
        if (("Exchange2003".equals(this.serverVersion) || "/public/".equals(this.publicFolderUrl)) && this.mailPath != null) {
            return this.mailPath;
        }
        return this.publicFolderUrl;
    }

    protected Map<String, Map<String, String>> galFind(String query) throws IOException {
        Map<String, Map<String, String>> results;
        String path = this.getCmdBasePath() + "?Cmd=galfind" + query;
        HttpGet httpGet = new HttpGet(path);
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpGet);){
            results = XMLStreamUtil.getElementContentsAsMap(response.getEntity().getContent(), "item", "AN");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(path + ": " + results.size() + " result(s)"));
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)("GET " + path + " failed: " + e + ' ' + e.getMessage()));
            this.disableGalFind = true;
            throw e;
        }
        return results;
    }

    @Override
    public Map<String, ExchangeSession.Contact> galFind(ExchangeSession.Condition condition, Set<String> returningAttributes, int sizeLimit) throws IOException {
        HashMap<String, ExchangeSession.Contact> contacts;
        block12: {
            String searchAttributeName;
            String searchAttribute;
            block13: {
                ExchangeSession.Operator operator;
                List<ExchangeSession.Condition> conditions;
                block14: {
                    contacts = new HashMap<String, ExchangeSession.Contact>();
                    if (this.disableGalFind) break block12;
                    if (!(condition instanceof MultiCondition)) break block13;
                    conditions = ((ExchangeSession.MultiCondition)condition).getConditions();
                    operator = ((ExchangeSession.MultiCondition)condition).getOperator();
                    if (operator != ExchangeSession.Operator.Or) break block14;
                    for (ExchangeSession.Condition innerCondition : conditions) {
                        contacts.putAll(this.galFind(innerCondition, returningAttributes, sizeLimit));
                    }
                    break block12;
                }
                if (operator != ExchangeSession.Operator.And || conditions.isEmpty()) break block12;
                Map<String, ExchangeSession.Contact> innerContacts = this.galFind(conditions.get(0), returningAttributes, sizeLimit);
                for (ExchangeSession.Contact contact : innerContacts.values()) {
                    if (!condition.isMatch(contact)) continue;
                    contacts.put(contact.getName().toLowerCase(), contact);
                }
                break block12;
            }
            if (condition instanceof AttributeCondition && (searchAttribute = GALFIND_CRITERIA_MAP.get(searchAttributeName = ((ExchangeSession.AttributeCondition)condition).getAttributeName())) != null) {
                String searchValue = ((ExchangeSession.AttributeCondition)condition).getValue();
                StringBuilder query = new StringBuilder();
                if ("EM".equals(searchAttribute)) {
                    int dotIndex;
                    int atIndex = searchValue.indexOf(64);
                    if (atIndex >= 0) {
                        searchValue = searchValue.substring(0, atIndex);
                    }
                    if ((dotIndex = searchValue.indexOf(46)) >= 0) {
                        query.append("&FN=").append(URIUtil.encodeWithinQuery(searchValue.substring(0, dotIndex)));
                        query.append("&LN=").append(URIUtil.encodeWithinQuery(searchValue.substring(dotIndex + 1)));
                    } else {
                        query.append("&FN=").append(URIUtil.encodeWithinQuery(searchValue));
                    }
                } else {
                    query.append('&').append(searchAttribute).append('=').append(URIUtil.encodeWithinQuery(searchValue));
                }
                Map<String, Map<String, String>> results = this.galFind(query.toString());
                for (Map<String, String> result : results.values()) {
                    Contact contact = new Contact();
                    contact.setName(result.get("AN"));
                    contact.put("imapUid", result.get("AN"));
                    this.buildGalfindContact(contact, result);
                    if (this.needGalLookup(searchAttributeName, returningAttributes)) {
                        this.galLookup(contact);
                    } else if (returningAttributes.contains("apple-serviceslocator") && contact.get("cn") != null && returningAttributes.contains("sn")) {
                        contact.put("sn", contact.get("cn"));
                        contact.remove("cn");
                    }
                    if (!condition.isMatch(contact)) continue;
                    contacts.put(contact.getName().toLowerCase(), contact);
                }
            }
        }
        return contacts;
    }

    protected boolean needGalLookup(String searchAttributeName, Set<String> returningAttributes) {
        if (returningAttributes == null || returningAttributes.isEmpty()) {
            return true;
        }
        if (returningAttributes.contains("apple-serviceslocator")) {
            return false;
        }
        if ("sn".equals(searchAttributeName)) {
            return returningAttributes.contains("sn");
        }
        if (GALLOOKUP_ATTRIBUTES.contains(searchAttributeName)) {
            return true;
        }
        for (String attributeName : GALLOOKUP_ATTRIBUTES) {
            if (!returningAttributes.contains(attributeName)) continue;
            return true;
        }
        return false;
    }

    public void galLookup(Contact contact) {
        if (!this.disableGalLookup) {
            LOGGER.debug((Object)("galLookup(" + (String)contact.get("smtpemail1") + ')'));
            HttpGet httpGet = new HttpGet(URIUtil.encodePathQuery(this.getCmdBasePath() + "?Cmd=gallookup&ADDR=" + (String)contact.get("smtpemail1")));
            try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpGet);){
                Map<String, String> personGalLookupDetails;
                Map<String, Map<String, String>> results = XMLStreamUtil.getElementContentsAsMap(response.getEntity().getContent(), "person", "alias");
                if (!results.isEmpty() && (personGalLookupDetails = results.get(((String)contact.get("uid")).toLowerCase())) != null) {
                    this.buildGalfindContact(contact, personGalLookupDetails);
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Unable to gallookup person: " + contact + ", disable GalLookup"));
                this.disableGalLookup = true;
            }
        }
    }

    protected void buildGalfindContact(Contact contact, Map<String, String> response) {
        for (Map.Entry<String, String> entry : GALFIND_ATTRIBUTE_MAP.entrySet()) {
            String attributeValue = response.get(entry.getValue());
            if (attributeValue == null) continue;
            contact.put(entry.getKey(), attributeValue);
        }
    }

    @Override
    protected String getFreeBusyData(String attendee, String start, String end, int interval) throws IOException {
        String fbdata;
        String freebusyUrl = this.publicFolderUrl + "/?cmd=freebusy&start=" + start + "&end=" + end + "&interval=" + interval + "&u=SMTP:" + attendee;
        HttpGet httpGet = new HttpGet(freebusyUrl);
        httpGet.setHeader("Content-Type", "text/xml");
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpGet);){
            fbdata = StringUtil.getLastToken(new BasicResponseHandler().handleResponse((HttpResponse)response), "<a:fbdata>", "</a:fbdata>");
        }
        return fbdata;
    }

    public HC4DavExchangeSession(HttpClientAdapter httpClientAdapter, URI uri, String userName) throws IOException {
        this.httpClientAdapter = httpClientAdapter;
        this.userName = userName;
        this.buildSessionInfo(uri);
    }

    @Override
    public void buildSessionInfo(URI uri) throws DavMailException {
        this.buildMailPath(uri);
        this.getWellKnownFolders();
    }

    protected String getMailpathFromWelcomePage(URI uri) {
        String welcomePageMailPath = null;
        HttpGet method = new HttpGet(uri.toString());
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)method);
             InputStream inputStream = response.getEntity().getContent();
             BufferedReader mainPageReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = mainPageReader.readLine()) != null && !line.toLowerCase().contains(BASE_HREF)) {
            }
            if (line != null) {
                int start = line.toLowerCase().indexOf(BASE_HREF) + BASE_HREF.length();
                int end = line.indexOf(34, start);
                String mailBoxBaseHref = line.substring(start, end);
                URL baseURL = new URL(mailBoxBaseHref);
                welcomePageMailPath = URIUtil.decode(baseURL.getPath());
                LOGGER.debug((Object)("Base href found in body, mailPath is " + welcomePageMailPath));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error parsing main page at " + method.getURI()), (Throwable)e);
        }
        return welcomePageMailPath;
    }

    protected void buildMailPath(URI uri) throws DavMailAuthenticationException {
        this.mailPath = this.getMailpathFromWelcomePage(uri);
        if (this.mailPath != null) {
            this.serverVersion = "Exchange2003";
            this.fixClientHost(uri);
            this.checkPublicFolder();
            this.buildEmail(uri.getHost());
        } else {
            this.serverVersion = "Exchange2007";
            this.disableGalLookup = true;
            this.fixClientHost(uri);
            this.getEmailAndAliasFromOptions();
            this.checkPublicFolder();
            if (this.alias == null || this.email == null) {
                this.buildEmail(uri.getHost());
            }
            this.mailPath = "/exchange/" + this.email + '/';
        }
        if (this.mailPath == null || this.email == null) {
            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED_PASSWORD_EXPIRED");
        }
        LOGGER.debug((Object)("Current user email is " + this.email + ", alias is " + this.alias + ", mailPath is " + this.mailPath + " on " + this.serverVersion));
        this.rootPath = this.mailPath.substring(0, this.mailPath.lastIndexOf(47, this.mailPath.length() - 2) + 1);
    }

    public void buildEmail(String hostName) {
        String mailBoxPath = this.getMailboxPath();
        if (mailBoxPath != null && mailBoxPath.indexOf(64) >= 0) {
            this.email = mailBoxPath;
            this.alias = this.getAliasFromMailboxDisplayName();
            if (this.alias == null) {
                this.alias = this.getAliasFromLogin();
            }
        } else {
            this.alias = mailBoxPath;
            this.email = this.getEmail(this.alias);
            if (this.email == null) {
                this.alias = this.getAliasFromLogin();
                this.email = this.getEmail(this.alias);
            }
            if (this.email == null) {
                this.alias = this.getAliasFromMailboxDisplayName();
                this.email = this.getEmail(this.alias);
            }
            if (this.email == null) {
                LOGGER.debug((Object)("Unable to get user email with alias " + mailBoxPath + " or " + this.getAliasFromLogin() + " or " + this.alias));
                StringBuilder buffer = new StringBuilder();
                this.alias = mailBoxPath != null ? mailBoxPath : this.getAliasFromLogin();
                if (this.alias == null) {
                    this.alias = "unknown";
                }
                buffer.append(this.alias);
                if (this.alias.indexOf(64) < 0) {
                    int dotIndex;
                    buffer.append('@');
                    if (hostName == null) {
                        hostName = "mail.unknown.com";
                    }
                    if ((dotIndex = hostName.indexOf(46)) >= 0) {
                        buffer.append(hostName.substring(dotIndex + 1));
                    }
                }
                this.email = buffer.toString();
            }
        }
    }

    public String getAliasFromMailboxDisplayName() {
        if (this.mailPath == null) {
            return null;
        }
        String displayName = null;
        try {
            ExchangeSession.Folder rootFolder = this.getFolder("");
            if (rootFolder == null) {
                LOGGER.warn((Object)new BundleMessage("EXCEPTION_UNABLE_TO_GET_MAIL_FOLDER", this.mailPath));
            } else {
                displayName = rootFolder.displayName;
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)new BundleMessage("EXCEPTION_UNABLE_TO_GET_MAIL_FOLDER", this.mailPath));
        }
        return displayName;
    }

    protected String getMailboxPath() {
        if (this.mailPath == null) {
            return null;
        }
        int index = this.mailPath.lastIndexOf(47, this.mailPath.length() - 2);
        if (index >= 0 && this.mailPath.endsWith("/")) {
            return this.mailPath.substring(index + 1, this.mailPath.length() - 1);
        }
        LOGGER.warn((Object)new BundleMessage("EXCEPTION_INVALID_MAIL_PATH", this.mailPath));
        return null;
    }

    public String getEmail(String alias) {
        String emailResult = null;
        if (alias != null && !this.disableGalFind) {
            try {
                Map<String, Map<String, String>> results = this.galFind("&AN=" + URIUtil.encodeWithinQuery(alias));
                Map<String, String> result = results.get(alias.toLowerCase());
                if (result != null) {
                    emailResult = result.get("EM");
                }
            }
            catch (IOException e) {
                this.disableGalFind = true;
                LOGGER.debug((Object)("getEmail(" + alias + ") failed"));
            }
        }
        return emailResult;
    }

    protected String getURIPropertyIfExists(DavPropertySet properties, String alias) throws IOException {
        DavProperty property = properties.get(Field.getPropertyName(alias));
        if (property == null) {
            return null;
        }
        return URIUtil.decode((String)property.getValue());
    }

    protected String getFolderName(String url) {
        if (url != null) {
            if (url.endsWith("/")) {
                return url.substring(url.lastIndexOf(47, url.length() - 2) + 1, url.length() - 1);
            }
            if (url.indexOf(47) > 0) {
                return url.substring(url.lastIndexOf(47) + 1);
            }
            return null;
        }
        return null;
    }

    protected void fixClientHost(URI currentUri) {
        if (currentUri != null && currentUri.getHost() != null && currentUri.getScheme() != null) {
            this.httpClientAdapter.setUri(currentUri);
        }
    }

    protected void checkPublicFolder() {
        try {
            this.publicFolderUrl = URIUtils.resolve((URI)this.httpClientAdapter.getUri(), (String)"/public/").toString();
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            davPropertyNameSet.add(Field.getPropertyName("displayname"));
            HttpPropfind httpPropfind = new HttpPropfind(this.publicFolderUrl, davPropertyNameSet, 0);
            this.httpClientAdapter.executeDavRequest((BaseDavRequest)httpPropfind);
            this.publicFolderUrl = httpPropfind.getURI().toString();
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Public folders not available: " + (e.getMessage() == null ? e : e.getMessage())));
            this.publicFolderUrl = "/public/";
        }
    }

    protected void getWellKnownFolders() throws DavMailException {
        try {
            MultiStatus multiStatus;
            HttpPropfind httpPropfind = new HttpPropfind(this.mailPath, WELL_KNOWN_FOLDERS, 0);
            try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpPropfind);){
                multiStatus = httpPropfind.getResponseBodyAsMultiStatus((HttpResponse)response);
            }
            MultiStatusResponse[] responses = multiStatus.getResponses();
            if (responses.length == 0) {
                throw new WebdavNotAvailableException("EXCEPTION_UNABLE_TO_GET_MAIL_FOLDER", this.mailPath);
            }
            DavPropertySet properties = responses[0].getProperties(200);
            this.inboxUrl = this.getURIPropertyIfExists(properties, "inbox");
            this.inboxName = this.getFolderName(this.inboxUrl);
            this.deleteditemsUrl = this.getURIPropertyIfExists(properties, "deleteditems");
            this.deleteditemsName = this.getFolderName(this.deleteditemsUrl);
            this.sentitemsUrl = this.getURIPropertyIfExists(properties, "sentitems");
            this.sentitemsName = this.getFolderName(this.sentitemsUrl);
            this.sendmsgUrl = this.getURIPropertyIfExists(properties, "sendmsg");
            this.sendmsgName = this.getFolderName(this.sendmsgUrl);
            this.draftsUrl = this.getURIPropertyIfExists(properties, "drafts");
            this.draftsName = this.getFolderName(this.draftsUrl);
            this.calendarUrl = this.getURIPropertyIfExists(properties, "calendar");
            this.calendarName = this.getFolderName(this.calendarUrl);
            this.tasksUrl = this.getURIPropertyIfExists(properties, "tasks");
            this.tasksName = this.getFolderName(this.tasksUrl);
            this.contactsUrl = this.getURIPropertyIfExists(properties, "contacts");
            this.contactsName = this.getFolderName(this.contactsUrl);
            this.outboxUrl = this.getURIPropertyIfExists(properties, "outbox");
            this.outboxName = this.getFolderName(this.outboxUrl);
            LOGGER.debug((Object)("Inbox URL: " + this.inboxUrl + " Trash URL: " + this.deleteditemsUrl + " Sent URL: " + this.sentitemsUrl + " Send URL: " + this.sendmsgUrl + " Drafts URL: " + this.draftsUrl + " Calendar URL: " + this.calendarUrl + " Tasks URL: " + this.tasksUrl + " Contacts URL: " + this.contactsUrl + " Outbox URL: " + this.outboxUrl + " Public folder URL: " + this.publicFolderUrl));
        }
        catch (IOException | DavException e) {
            LOGGER.error((Object)e.getMessage());
            throw new WebdavNotAvailableException("EXCEPTION_UNABLE_TO_GET_MAIL_FOLDER", this.mailPath);
        }
    }

    @Override
    public ExchangeSession.MultiCondition and(ExchangeSession.Condition ... condition) {
        return new MultiCondition(ExchangeSession.Operator.And, condition);
    }

    @Override
    public ExchangeSession.MultiCondition or(ExchangeSession.Condition ... condition) {
        return new MultiCondition(ExchangeSession.Operator.Or, condition);
    }

    @Override
    public ExchangeSession.Condition not(ExchangeSession.Condition condition) {
        if (condition == null) {
            return null;
        }
        return new NotCondition(condition);
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, int value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition headerIsEqualTo(String headerName, String value) {
        return new HeaderCondition(headerName, ExchangeSession.Operator.IsEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition gte(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsGreaterThanOrEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition lte(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsLessThanOrEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition lt(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsLessThan, value);
    }

    @Override
    public ExchangeSession.Condition gt(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsGreaterThan, value);
    }

    @Override
    public ExchangeSession.Condition contains(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.Like, value);
    }

    @Override
    public ExchangeSession.Condition startsWith(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.StartsWith, value);
    }

    @Override
    public ExchangeSession.Condition isNull(String attributeName) {
        return new MonoCondition(attributeName, ExchangeSession.Operator.IsNull);
    }

    @Override
    public ExchangeSession.Condition exists(String attributeName) {
        return this.not(new MonoCondition(attributeName, ExchangeSession.Operator.IsNull));
    }

    @Override
    public ExchangeSession.Condition isTrue(String attributeName) {
        if ("Exchange2003".equals(this.serverVersion) && "deleted".equals(attributeName)) {
            return this.isEqualTo(attributeName, "1");
        }
        return new MonoCondition(attributeName, ExchangeSession.Operator.IsTrue);
    }

    @Override
    public ExchangeSession.Condition isFalse(String attributeName) {
        if ("Exchange2003".equals(this.serverVersion) && "deleted".equals(attributeName)) {
            return this.or(this.isEqualTo(attributeName, "0"), this.isNull(attributeName));
        }
        return new MonoCondition(attributeName, ExchangeSession.Operator.IsFalse);
    }

    protected ExchangeSession.Folder buildFolder(MultiStatusResponse entity) throws IOException {
        String href = URIUtil.decode(entity.getHref());
        ExchangeSession.Folder folder = new ExchangeSession.Folder();
        DavPropertySet properties = entity.getProperties(200);
        folder.displayName = this.getPropertyIfExists(properties, "displayname");
        folder.folderClass = this.getPropertyIfExists(properties, "folderclass");
        folder.hasChildren = "1".equals(this.getPropertyIfExists(properties, "hassubs"));
        folder.noInferiors = "1".equals(this.getPropertyIfExists(properties, "nosubs"));
        folder.count = this.getIntPropertyIfExists(properties, "count");
        folder.recent = folder.unreadCount = this.getIntPropertyIfExists(properties, "unreadcount");
        folder.ctag = this.getPropertyIfExists(properties, "contenttag");
        folder.etag = this.getPropertyIfExists(properties, "lastmodified");
        folder.uidNext = this.getIntPropertyIfExists(properties, "uidNext");
        if (this.inboxUrl != null && href.startsWith(this.inboxUrl)) {
            folder.folderPath = href.replaceFirst(this.inboxUrl, "INBOX");
        } else if (this.sentitemsUrl != null && href.startsWith(this.sentitemsUrl)) {
            folder.folderPath = href.replaceFirst(this.sentitemsUrl, "Sent");
        } else if (this.draftsUrl != null && href.startsWith(this.draftsUrl)) {
            folder.folderPath = href.replaceFirst(this.draftsUrl, "Drafts");
        } else if (this.deleteditemsUrl != null && href.startsWith(this.deleteditemsUrl)) {
            folder.folderPath = href.replaceFirst(this.deleteditemsUrl, "Trash");
        } else if (this.calendarUrl != null && href.startsWith(this.calendarUrl)) {
            folder.folderPath = href.replaceFirst(this.calendarUrl, "calendar");
        } else if (this.contactsUrl != null && href.startsWith(this.contactsUrl)) {
            folder.folderPath = href.replaceFirst(this.contactsUrl, "contacts");
        } else {
            int index = href.indexOf(this.mailPath.substring(0, this.mailPath.length() - 1));
            if (index >= 0) {
                folder.folderPath = index + this.mailPath.length() > href.length() ? "" : href.substring(index + this.mailPath.length());
            } else {
                try {
                    URI folderURI = new URI(href);
                    folder.folderPath = folderURI.getPath();
                    if (folder.folderPath == null) {
                        throw new DavMailException("EXCEPTION_INVALID_FOLDER_URL", href);
                    }
                }
                catch (URISyntaxException e) {
                    throw new DavMailException("EXCEPTION_INVALID_FOLDER_URL", href);
                }
            }
        }
        if (folder.folderPath.endsWith("/")) {
            folder.folderPath = folder.folderPath.substring(0, folder.folderPath.length() - 1);
        }
        return folder;
    }

    @Override
    protected ExchangeSession.Folder internalGetFolder(String folderPath) throws IOException {
        MultiStatus multiStatus = this.httpClientAdapter.executeDavRequest((BaseDavRequest)new HttpPropfind(URIUtil.encodePath(this.getFolderPath(folderPath)), FOLDER_PROPERTIES_NAME_SET, 0));
        MultiStatusResponse[] responses = multiStatus.getResponses();
        ExchangeSession.Folder folder = null;
        if (responses.length > 0) {
            folder = this.buildFolder(responses[0]);
            folder.folderPath = folderPath;
        }
        return folder;
    }

    @Override
    public List<ExchangeSession.Folder> getSubFolders(String folderPath, ExchangeSession.Condition condition, boolean recursive) throws IOException {
        MultiStatusResponse[] responses;
        boolean isPublic = folderPath.startsWith("/public");
        FolderQueryTraversal mode = !isPublic && recursive ? FolderQueryTraversal.Deep : FolderQueryTraversal.Shallow;
        ArrayList<ExchangeSession.Folder> folders = new ArrayList<ExchangeSession.Folder>();
        for (MultiStatusResponse response : responses = this.searchItems(folderPath, FOLDER_PROPERTIES, this.and(this.isTrue("isfolder"), this.isFalse("ishidden"), condition), mode, 0)) {
            ExchangeSession.Folder folder = this.buildFolder(response);
            folders.add(this.buildFolder(response));
            if (!isPublic || !recursive) continue;
            this.getSubFolders(folder.folderPath, condition, recursive);
        }
        return folders;
    }

    @Override
    public int createFolder(String folderPath, String folderClass, Map<String, String> properties) throws IOException {
        int status;
        HashSet<PropertyValue> propertyValues = new HashSet<PropertyValue>();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                propertyValues.add(Field.createPropertyValue(entry.getKey(), entry.getValue()));
            }
        }
        propertyValues.add(Field.createPropertyValue("folderclass", folderClass));
        ExchangePropPatchRequest propPatchRequest = new ExchangePropPatchRequest(URIUtil.encodePath(this.getFolderPath(folderPath)), propertyValues){

            @Override
            public String getMethod() {
                return "MKCOL";
            }
        };
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)propPatchRequest);){
            propPatchRequest.handleResponse((HttpResponse)response);
            status = response.getStatusLine().getStatusCode();
            if (status == 207) {
                status = propPatchRequest.getResponseStatusCode();
            } else if (status == 405) {
                LOGGER.info((Object)("Folder " + folderPath + " already exists"));
            }
        }
        catch (HttpResponseException e) {
            throw new IOException(e.getMessage(), e);
        }
        LOGGER.debug((Object)("Create folder " + folderPath + " returned " + status));
        return status;
    }

    @Override
    public int updateFolder(String folderPath, Map<String, String> properties) throws IOException {
        HashSet<PropertyValue> propertyValues = new HashSet<PropertyValue>();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                propertyValues.add(Field.createPropertyValue(entry.getKey(), entry.getValue()));
            }
        }
        ExchangePropPatchRequest propPatchRequest = new ExchangePropPatchRequest(URIUtil.encodePath(this.getFolderPath(folderPath)), propertyValues);
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)propPatchRequest);){
            propPatchRequest.handleResponse((HttpResponse)response);
            int status = response.getStatusLine().getStatusCode();
            if (status == 207) {
                try {
                    status = propPatchRequest.getResponseStatusCode();
                }
                catch (HttpResponseException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            int n = status;
            return n;
        }
    }

    @Override
    public void deleteFolder(String folderPath) throws IOException {
        HttpDelete httpDelete = new HttpDelete(URIUtil.encodePath(this.getFolderPath(folderPath)));
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpDelete);){
            int status = response.getStatusLine().getStatusCode();
            if (status != 200 && status != 404) {
                throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)httpDelete, (HttpResponse)response);
            }
        }
    }

    @Override
    public void moveFolder(String folderPath, String targetPath) throws IOException {
        HttpMove httpMove = new HttpMove(URIUtil.encodePath(this.getFolderPath(folderPath)), URIUtil.encodePath(this.getFolderPath(targetPath)), false);
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpMove);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 412) {
                throw new HttpPreconditionFailedException(BundleMessage.format("EXCEPTION_UNABLE_TO_MOVE_FOLDER", new Object[0]));
            }
            if (statusCode != 201) {
                throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)httpMove, (HttpResponse)response);
            }
            if (folderPath.equalsIgnoreCase(USERS + this.getEmail() + "/calendar")) {
                this.getWellKnownFolders();
            }
        }
    }

    @Override
    public void moveItem(String sourcePath, String targetPath) throws IOException {
        HttpMove httpMove = new HttpMove(URIUtil.encodePath(this.getFolderPath(sourcePath)), URIUtil.encodePath(this.getFolderPath(targetPath)), false);
        this.moveItem(httpMove);
    }

    protected void moveItem(HttpMove httpMove) throws IOException {
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpMove);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 412) {
                throw new DavMailException("EXCEPTION_UNABLE_TO_MOVE_ITEM", new Object[0]);
            }
            if (statusCode != 201 && statusCode != 200) {
                throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)httpMove, (HttpResponse)response);
            }
        }
    }

    protected String getPropertyIfExists(DavPropertySet properties, String alias) {
        DavProperty property = properties.get(Field.getResponsePropertyName(alias));
        if (property == null) {
            return null;
        }
        Object value = property.getValue();
        if (value instanceof Node) {
            return ((Node)value).getTextContent();
        }
        if (value instanceof List) {
            StringBuilder buffer = new StringBuilder();
            for (Object node : (List)value) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                if (node instanceof Node) {
                    buffer.append(((Node)node).getTextContent());
                    continue;
                }
                buffer.append(node);
            }
            return buffer.toString();
        }
        return (String)value;
    }

    protected String getURLPropertyIfExists(DavPropertySet properties, String alias) throws IOException {
        String result = this.getPropertyIfExists(properties, alias);
        if (result != null) {
            result = URIUtil.decode(result);
        }
        return result;
    }

    protected int getIntPropertyIfExists(DavPropertySet properties, String alias) {
        DavProperty property = properties.get(Field.getPropertyName(alias));
        if (property == null) {
            return 0;
        }
        return Integer.parseInt((String)property.getValue());
    }

    protected long getLongPropertyIfExists(DavPropertySet properties, String alias) {
        DavProperty property = properties.get(Field.getPropertyName(alias));
        if (property == null) {
            return 0L;
        }
        return Long.parseLong((String)property.getValue());
    }

    protected double getDoublePropertyIfExists(DavPropertySet properties, String alias) {
        DavProperty property = properties.get(Field.getResponsePropertyName(alias));
        if (property == null) {
            return 0.0;
        }
        return Double.parseDouble((String)property.getValue());
    }

    protected byte[] getBinaryPropertyIfExists(DavPropertySet properties, String alias) {
        byte[] property = null;
        String base64Property = this.getPropertyIfExists(properties, alias);
        if (base64Property != null) {
            property = IOUtil.decodeBase64(base64Property);
        }
        return property;
    }

    protected Message buildMessage(MultiStatusResponse responseEntity) throws IOException {
        Message message = new Message();
        message.messageUrl = URIUtil.decode(responseEntity.getHref());
        DavPropertySet properties = responseEntity.getProperties(200);
        message.permanentUrl = this.getURLPropertyIfExists(properties, "permanenturl");
        message.size = this.getIntPropertyIfExists(properties, "messageSize");
        message.uid = this.getPropertyIfExists(properties, "uid");
        message.contentClass = this.getPropertyIfExists(properties, "contentclass");
        message.imapUid = this.getLongPropertyIfExists(properties, "imapUid");
        message.read = "1".equals(this.getPropertyIfExists(properties, "read"));
        message.junk = "1".equals(this.getPropertyIfExists(properties, "junk"));
        message.flagged = "2".equals(this.getPropertyIfExists(properties, "flagStatus"));
        message.draft = (this.getIntPropertyIfExists(properties, "messageFlags") & 8) != 0;
        String lastVerbExecuted = this.getPropertyIfExists(properties, "lastVerbExecuted");
        message.answered = "102".equals(lastVerbExecuted) || "103".equals(lastVerbExecuted);
        message.forwarded = "104".equals(lastVerbExecuted);
        message.date = this.convertDateFromExchange(this.getPropertyIfExists(properties, "date"));
        message.deleted = "1".equals(this.getPropertyIfExists(properties, "deleted"));
        String lastmodified = this.convertDateFromExchange(this.getPropertyIfExists(properties, "lastmodified"));
        message.recent = !message.read && lastmodified != null && lastmodified.equals(message.date);
        message.keywords = this.getPropertyIfExists(properties, "keywords");
        if (LOGGER.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Message");
            if (message.imapUid != 0L) {
                buffer.append(" IMAP uid: ").append(message.imapUid);
            }
            if (message.uid != null) {
                buffer.append(" uid: ").append(message.uid);
            }
            buffer.append(" href: ").append(responseEntity.getHref()).append(" permanenturl:").append(message.permanentUrl);
            LOGGER.debug((Object)buffer.toString());
        }
        return message;
    }

    @Override
    public ExchangeSession.MessageList searchMessages(String folderPath, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        MultiStatusResponse[] responses;
        ExchangeSession.MessageList messages = new ExchangeSession.MessageList();
        int maxCount = Settings.getIntProperty("davmail.folderSizeLimit", 0);
        for (MultiStatusResponse response : responses = this.searchItems(folderPath, attributes, this.and(this.isFalse("isfolder"), this.isFalse("ishidden"), condition), FolderQueryTraversal.Shallow, maxCount)) {
            Message message = this.buildMessage(response);
            message.messageList = messages;
            messages.add(message);
        }
        Collections.sort(messages);
        return messages;
    }

    @Override
    public List<ExchangeSession.Contact> searchContacts(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, int maxCount) throws IOException {
        MultiStatusResponse[] responses;
        ArrayList<ExchangeSession.Contact> contacts = new ArrayList<ExchangeSession.Contact>();
        for (MultiStatusResponse response : responses = this.searchItems(folderPath, attributes, this.and(this.isEqualTo("outlookmessageclass", "IPM.Contact"), this.isFalse("isfolder"), this.isFalse("ishidden"), condition), FolderQueryTraversal.Shallow, maxCount)) {
            contacts.add(new Contact(response));
        }
        return contacts;
    }

    @Override
    protected Set<String> getItemProperties() {
        return ITEM_PROPERTIES;
    }

    @Override
    public List<ExchangeSession.Event> getEventMessages(String folderPath) throws IOException {
        return this.searchEvents(folderPath, ITEM_PROPERTIES, this.and(this.isEqualTo("contentclass", "urn:content-classes:calendarmessage"), this.or(this.isNull("processed"), this.isFalse("processed"))));
    }

    @Override
    public List<ExchangeSession.Event> searchEvents(String folderPath, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        MultiStatusResponse[] responses;
        ArrayList<ExchangeSession.Event> events = new ArrayList<ExchangeSession.Event>();
        for (MultiStatusResponse response : responses = this.searchItems(folderPath, attributes, this.and(this.isFalse("isfolder"), this.isFalse("ishidden"), condition), FolderQueryTraversal.Shallow, 0)) {
            String instancetype = this.getPropertyIfExists(response.getProperties(200), "instancetype");
            Event event = new Event(response);
            if (instancetype == null) {
                try {
                    event.getBody();
                    events.add(event);
                }
                catch (IOException e) {
                    LOGGER.warn((Object)("Invalid event " + event.displayName + " found at " + response.getHref()), (Throwable)e);
                }
                continue;
            }
            events.add(event);
        }
        return events;
    }

    @Override
    protected ExchangeSession.Condition getCalendarItemCondition(ExchangeSession.Condition dateCondition) {
        boolean caldavEnableLegacyTasks = Settings.getBooleanProperty("davmail.caldavEnableLegacyTasks", false);
        if (caldavEnableLegacyTasks) {
            return this.or(this.isNull("instancetype"), this.isEqualTo("instancetype", 1), this.and(this.isEqualTo("instancetype", 0), dateCondition));
        }
        return this.and(this.or(this.isEqualTo("outlookmessageclass", "IPM.Appointment"), this.isEqualTo("outlookmessageclass", "IPM.Appointment.MeetingEvent")), this.or(this.isEqualTo("instancetype", 1), this.and(this.isEqualTo("instancetype", 0), dateCondition)));
    }

    protected MultiStatusResponse[] searchItems(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, FolderQueryTraversal folderQueryTraversal, int maxCount) throws IOException {
        String folderUrl = folderPath.startsWith("http") ? folderPath : this.getFolderPath(folderPath);
        StringBuilder searchRequest = new StringBuilder();
        searchRequest.append("SELECT ").append(Field.getRequestPropertyString("permanenturl"));
        if (attributes != null) {
            for (String attribute : attributes) {
                searchRequest.append(',').append(Field.getRequestPropertyString(attribute));
            }
        }
        searchRequest.append(" FROM SCOPE('").append((Object)folderQueryTraversal).append(" TRAVERSAL OF \"").append(folderUrl).append("\"')");
        if (condition != null) {
            searchRequest.append(" WHERE ");
            condition.appendTo(searchRequest);
        }
        searchRequest.append(" ORDER BY ").append(Field.getRequestPropertyString("imapUid")).append(" DESC");
        DavGatewayTray.debug(new BundleMessage("LOG_SEARCH_QUERY", searchRequest));
        MultiStatusResponse[] responses = this.httpClientAdapter.executeSearchRequest(this.encodeAndFixUrl(folderUrl), searchRequest.toString(), maxCount);
        DavGatewayTray.debug(new BundleMessage("LOG_SEARCH_RESULT", responses.length));
        return responses;
    }

    @Override
    public ExchangeSession.Item getItem(String folderPath, String itemName) throws IOException {
        String emlItemName = this.convertItemNameToEML(itemName);
        String itemPath = this.getFolderPath(folderPath) + '/' + emlItemName;
        MultiStatusResponse[] responses = null;
        try {
            HttpPropfind httpPropfind = new HttpPropfind(URIUtil.encodePath(itemPath), EVENT_REQUEST_PROPERTIES_NAME_SET, 0);
            try (CloseableHttpResponse response2 = this.httpClientAdapter.execute((HttpRequestBase)httpPropfind);){
                responses = httpPropfind.getResponseBodyAsMultiStatus((HttpResponse)response2).getResponses();
            }
            catch (HttpNotFoundException | DavException response2) {
                // empty catch block
            }
            if (responses == null || responses.length == 0 && this.isMainCalendar(folderPath)) {
                if (itemName.endsWith(".ics")) {
                    itemName = itemName.substring(0, itemName.length() - 3) + "EML";
                }
                HttpPropfind taskHttpPropfind = new HttpPropfind(URIUtil.encodePath(this.getFolderPath("tasks") + '/' + emlItemName), EVENT_REQUEST_PROPERTIES_NAME_SET, 0);
                try (CloseableHttpResponse response3 = this.httpClientAdapter.execute((HttpRequestBase)taskHttpPropfind);){
                    responses = taskHttpPropfind.getResponseBodyAsMultiStatus((HttpResponse)response3).getResponses();
                }
                catch (HttpNotFoundException | DavException response3) {
                    // empty catch block
                }
            }
            if (responses == null || responses.length == 0) {
                throw new HttpNotFoundException(itemPath + " not found");
            }
        }
        catch (HttpNotFoundException e) {
            try {
                LOGGER.debug((Object)(itemPath + " not found, searching by urlcompname"));
                responses = this.searchItems(folderPath, EVENT_REQUEST_PROPERTIES, this.isEqualTo("urlcompname", emlItemName), FolderQueryTraversal.Shallow, 1);
                if (responses.length == 0 && this.isMainCalendar(folderPath)) {
                    responses = this.searchItems("tasks", EVENT_REQUEST_PROPERTIES, this.isEqualTo("urlcompname", emlItemName), FolderQueryTraversal.Shallow, 1);
                }
                if (responses.length == 0) {
                    throw new HttpNotFoundException(itemPath + " not found");
                }
            }
            catch (HttpNotFoundException e2) {
                LOGGER.debug((Object)"last failover: search all items");
                List<ExchangeSession.Event> events = this.getAllEvents(folderPath);
                for (ExchangeSession.Event event : events) {
                    if (!itemName.equals(event.getName())) continue;
                    HttpPropfind permanentHttpPropfind = new HttpPropfind(this.encodeAndFixUrl(((DavExchangeSession.Event)event).getPermanentUrl()), EVENT_REQUEST_PROPERTIES_NAME_SET, 0);
                    try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)permanentHttpPropfind);){
                        responses = permanentHttpPropfind.getResponseBodyAsMultiStatus((HttpResponse)response).getResponses();
                    }
                    catch (DavException davException) {}
                    break;
                }
                if (responses == null || responses.length == 0) {
                    throw new HttpNotFoundException(itemPath + " not found");
                }
                LOGGER.warn((Object)("search by urlcompname failed, actual value is " + this.getPropertyIfExists(responses[0].getProperties(200), "urlcompname")));
            }
        }
        String contentClass = this.getPropertyIfExists(responses[0].getProperties(200), "contentclass");
        String urlcompname = this.getPropertyIfExists(responses[0].getProperties(200), "urlcompname");
        if ("urn:content-classes:person".equals(contentClass)) {
            List<ExchangeSession.Contact> contacts = this.searchContacts(folderPath, CONTACT_ATTRIBUTES, this.isEqualTo("urlcompname", StringUtil.decodeUrlcompname(urlcompname)), 1);
            if (contacts.isEmpty()) {
                LOGGER.warn((Object)"Item found, but unable to build contact");
                throw new HttpNotFoundException(itemPath + " not found");
            }
            return contacts.get(0);
        }
        if ("urn:content-classes:appointment".equals(contentClass) || "urn:content-classes:calendarmessage".equals(contentClass) || "urn:content-classes:task".equals(contentClass)) {
            return new Event(responses[0]);
        }
        LOGGER.warn((Object)("wrong contentclass on item " + itemPath + ": " + contentClass));
        return new Event(responses[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExchangeSession.ContactPhoto getContactPhoto(ExchangeSession.Contact contact) throws IOException {
        ExchangeSession.ContactPhoto contactPhoto;
        HttpGet httpGet = new HttpGet(URIUtil.encodePath(contact.getHref()) + "/ContactPicture.jpg");
        httpGet.setHeader("Translate", "f");
        httpGet.setHeader("Accept-Encoding", "gzip");
        InputStream inputStream = null;
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpGet);){
            inputStream = HttpClientAdapter.isGzipEncoded((HttpResponse)response) ? new GZIPInputStream(response.getEntity().getContent()) : response.getEntity().getContent();
            contactPhoto = new ExchangeSession.ContactPhoto();
            contactPhoto.contentType = "image/jpeg";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream partInputStream = inputStream;
            IOUtil.write(partInputStream, baos);
            contactPhoto.content = IOUtil.encodeBase64AsString(baos.toByteArray());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug((Object)e);
                }
            }
        }
        return contactPhoto;
    }

    @Override
    public int sendEvent(String icsBody) throws IOException {
        String itemName = UUID.randomUUID().toString() + ".EML";
        byte[] mimeContent = new Event(this.getFolderPath("Drafts"), itemName, "urn:content-classes:calendarmessage", icsBody, null, null).createMimeContent();
        if (mimeContent == null) {
            return 204;
        }
        this.sendMessage(mimeContent);
        return 200;
    }

    @Override
    public void deleteItem(String folderPath, String itemName) throws IOException {
        int status;
        String eventPath = URIUtil.encodePath(this.getFolderPath(folderPath) + '/' + this.convertItemNameToEML(itemName));
        HttpDelete httpDelete = new HttpDelete(eventPath);
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpDelete);){
            status = response.getStatusLine().getStatusCode();
        }
        if (status == 404 && this.isMainCalendar(folderPath)) {
            eventPath = URIUtil.encodePath(this.getFolderPath("tasks") + '/' + this.convertItemNameToEML(itemName));
            httpDelete = new HttpDelete(eventPath);
            response = this.httpClientAdapter.execute((HttpRequestBase)httpDelete);
            var7_6 = null;
            try {
                status = response.getStatusLine().getStatusCode();
            }
            catch (Throwable throwable) {
                var7_6 = throwable;
                throw throwable;
            }
            finally {
                if (response != null) {
                    if (var7_6 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            var7_6.addSuppressed(throwable);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        if (status == 404) {
            LOGGER.debug((Object)("Unable to delete " + itemName + ": item not found"));
        }
    }

    @Override
    public void processItem(String folderPath, String itemName) throws IOException {
        String eventPath = URIUtil.encodePath(this.getFolderPath(folderPath) + '/' + this.convertItemNameToEML(itemName));
        ArrayList<PropEntry> list = new ArrayList<PropEntry>();
        list.add(Field.createDavProperty("processed", "true"));
        list.add(Field.createDavProperty("read", "1"));
        HttpProppatch patchMethod = new HttpProppatch(eventPath, list);
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)patchMethod);){
            LOGGER.debug((Object)("Processed " + itemName + " " + response.getStatusLine().getStatusCode()));
        }
    }

    @Override
    public ExchangeSession.ItemResult internalCreateOrUpdateEvent(String folderPath, String itemName, String contentClass, String icsBody, String etag, String noneMatch) throws IOException {
        return new Event(this.getFolderPath(folderPath), itemName, contentClass, icsBody, etag, noneMatch).createOrUpdate();
    }

    @Override
    protected void loadVtimezone() {
        try {
            String folderPath = this.getFolderPath("davmailtemp");
            this.createCalendarFolder(folderPath, null);
            String fakeEventUrl = null;
            if ("Exchange2003".equals(this.serverVersion)) {
                HttpPost httpPost = new HttpPost(URIUtil.encodePath(folderPath));
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                parameters.add(new BasicNameValuePair("Cmd", "saveappt"));
                parameters.add(new BasicNameValuePair("FORMTYPE", "appointment"));
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, Consts.UTF_8));
                try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpPost);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200 && (fakeEventUrl = StringUtil.getToken(new BasicResponseHandler().handleResponse((HttpResponse)response), "<span id=\"itemHREF\">", "</span>")) != null) {
                        fakeEventUrl = URIUtil.decode(fakeEventUrl);
                    }
                }
            }
            if (fakeEventUrl == null) {
                ArrayList<PropEntry> propertyList = new ArrayList<PropEntry>();
                propertyList.add(Field.createDavProperty("contentclass", "urn:content-classes:appointment"));
                propertyList.add(Field.createDavProperty("outlookmessageclass", "IPM.Appointment"));
                propertyList.add(Field.createDavProperty("instancetype", "0"));
                String timezoneId = Settings.getProperty("davmail.timezoneId");
                if (timezoneId == null) {
                    timezoneId = this.getTimezoneIdFromExchange();
                }
                if (timezoneId != null) {
                    propertyList.add(Field.createDavProperty("timezoneid", timezoneId));
                }
                String patchMethodUrl = folderPath + '/' + UUID.randomUUID().toString() + ".EML";
                HttpProppatch patchMethod = new HttpProppatch(URIUtil.encodePath(patchMethodUrl), propertyList);
                try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)patchMethod);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 207) {
                        fakeEventUrl = patchMethodUrl;
                    }
                }
            }
            if (fakeEventUrl != null) {
                HttpGet httpGet = new HttpGet(URIUtil.encodePath(fakeEventUrl));
                httpGet.setHeader("Translate", "f");
                try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpGet);){
                    this.vTimezone = new VObject("BEGIN:VTIMEZONE" + StringUtil.getToken(new BasicResponseHandler().handleResponse((HttpResponse)response), "BEGIN:VTIMEZONE", "END:VTIMEZONE") + "END:VTIMEZONE\r\n");
                }
            }
            this.deleteFolder("davmailtemp");
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Unable to get VTIMEZONE info: " + e), (Throwable)e);
        }
    }

    protected String getTimezoneIdFromExchange() {
        String timezoneId = null;
        String timezoneName = null;
        try {
            byte[] roamingdictionary;
            HashSet<String> attributes = new HashSet<String>();
            attributes.add("roamingdictionary");
            MultiStatusResponse[] responses = this.searchItems(USERS + this.getEmail() + "/NON_IPM_SUBTREE", attributes, this.isEqualTo("messageclass", "IPM.Configuration.OWA.UserOptions"), FolderQueryTraversal.Deep, 1);
            if (responses.length == 1 && (roamingdictionary = this.getBinaryPropertyIfExists(responses[0].getProperties(200), "roamingdictionary")) != null && (timezoneName = this.getTimezoneNameFromRoamingDictionary(roamingdictionary)) != null) {
                timezoneId = ResourceBundle.getBundle("timezoneids").getString(timezoneName);
            }
        }
        catch (MissingResourceException e) {
            LOGGER.warn((Object)("Unable to retrieve Exchange timezone id for name " + timezoneName));
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Unable to retrieve Exchange timezone id: " + e.getMessage()), (Throwable)e);
        }
        return timezoneId;
    }

    protected String getTimezoneNameFromRoamingDictionary(byte[] roamingdictionary) {
        String timezoneName = null;
        try {
            XMLStreamReader reader = XMLStreamUtil.createXMLStreamReader(roamingdictionary);
            while (reader.hasNext()) {
                String value;
                reader.next();
                if (!XMLStreamUtil.isStartTag(reader, "e") || !"18-timezone".equals(reader.getAttributeValue(null, "k")) || (value = reader.getAttributeValue(null, "v")) == null || !value.startsWith("18-")) continue;
                timezoneName = value.substring(3);
            }
        }
        catch (XMLStreamException e) {
            LOGGER.error((Object)("Error while parsing RoamingDictionary: " + e), (Throwable)e);
        }
        return timezoneName;
    }

    @Override
    protected Contact buildContact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) {
        return new Contact(this.getFolderPath(folderPath), itemName, properties, etag, noneMatch);
    }

    protected List<PropEntry> buildProperties(Map<String, String> properties) {
        ArrayList<PropEntry> list = new ArrayList<PropEntry>();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if ("read".equals(entry.getKey())) {
                    list.add(Field.createDavProperty("read", entry.getValue()));
                    continue;
                }
                if ("junk".equals(entry.getKey())) {
                    list.add(Field.createDavProperty("junk", entry.getValue()));
                    continue;
                }
                if ("flagged".equals(entry.getKey())) {
                    list.add(Field.createDavProperty("flagStatus", entry.getValue()));
                    continue;
                }
                if ("answered".equals(entry.getKey())) {
                    list.add(Field.createDavProperty("lastVerbExecuted", entry.getValue()));
                    if (!"102".equals(entry.getValue())) continue;
                    list.add(Field.createDavProperty("iconIndex", "261"));
                    continue;
                }
                if ("forwarded".equals(entry.getKey())) {
                    list.add(Field.createDavProperty("lastVerbExecuted", entry.getValue()));
                    if (!"104".equals(entry.getValue())) continue;
                    list.add(Field.createDavProperty("iconIndex", "262"));
                    continue;
                }
                if ("bcc".equals(entry.getKey())) {
                    list.add(Field.createDavProperty("bcc", entry.getValue()));
                    continue;
                }
                if ("deleted".equals(entry.getKey())) {
                    list.add(Field.createDavProperty("deleted", entry.getValue()));
                    continue;
                }
                if ("datereceived".equals(entry.getKey())) {
                    list.add(Field.createDavProperty("datereceived", entry.getValue()));
                    continue;
                }
                if (!"keywords".equals(entry.getKey())) continue;
                list.add(Field.createDavProperty("keywords", entry.getValue()));
            }
        }
        return list;
    }

    @Override
    public void createMessage(String folderPath, String messageName, HashMap<String, String> properties, MimeMessage mimeMessage) throws IOException {
        block91: {
            List<PropEntry> davProperties;
            String messageUrl;
            block89: {
                messageUrl = URIUtil.encodePathQuery(this.getFolderPath(folderPath) + '/' + messageName);
                davProperties = this.buildProperties(properties);
                if (properties != null && properties.containsKey("draft")) {
                    davProperties.add(Field.createDavProperty("messageFlags", properties.get("draft")));
                }
                if (properties != null && properties.containsKey("mailOverrideFormat")) {
                    davProperties.add(Field.createDavProperty("mailOverrideFormat", properties.get("mailOverrideFormat")));
                }
                if (properties != null && properties.containsKey("messageFormat")) {
                    davProperties.add(Field.createDavProperty("messageFormat", properties.get("messageFormat")));
                }
                if (!davProperties.isEmpty()) {
                    HttpProppatch httpProppatch = new HttpProppatch(messageUrl, davProperties);
                    try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpProppatch);){
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode != 207) {
                            throw new DavMailException("EXCEPTION_UNABLE_TO_CREATE_MESSAGE", messageUrl, statusCode, Character.valueOf(' '), response.getStatusLine().getReasonPhrase());
                        }
                    }
                }
                HttpPut putmethod = new HttpPut(messageUrl);
                putmethod.setHeader("Translate", "f");
                putmethod.setHeader("Content-Type", "message/rfc822");
                try {
                    String reasonPhrase;
                    int code;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    mimeMessage.writeTo((OutputStream)baos);
                    baos.close();
                    putmethod.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray()));
                    try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)putmethod);){
                        code = response.getStatusLine().getStatusCode();
                        reasonPhrase = response.getStatusLine().getReasonPhrase();
                    }
                    if (code == 406) {
                        String contentType;
                        LOGGER.warn((Object)"Draft message creation failed, failover to property update. Note: attachments are lost");
                        ArrayList<PropEntry> propertyList = new ArrayList<PropEntry>();
                        propertyList.add(Field.createDavProperty("to", mimeMessage.getHeader("to", ",")));
                        propertyList.add(Field.createDavProperty("cc", mimeMessage.getHeader("cc", ",")));
                        propertyList.add(Field.createDavProperty("message-id", mimeMessage.getHeader("message-id", ",")));
                        MimeMessage mimePart = mimeMessage;
                        if (mimeMessage.getContent() instanceof MimeMultipart) {
                            MimeMultipart multiPart = (MimeMultipart)mimeMessage.getContent();
                            for (int i = 0; i < multiPart.getCount(); ++i) {
                                String contentType2 = multiPart.getBodyPart(i).getContentType();
                                if (!contentType2.startsWith("text/")) continue;
                                mimePart = (MimePart)multiPart.getBodyPart(i);
                                break;
                            }
                        }
                        if ((contentType = mimePart.getContentType()).startsWith("text/plain")) {
                            propertyList.add(Field.createDavProperty("description", (String)mimePart.getContent()));
                        } else if (contentType.startsWith("text/html")) {
                            propertyList.add(Field.createDavProperty("htmldescription", (String)mimePart.getContent()));
                        } else {
                            LOGGER.warn((Object)("Unsupported content type: " + contentType.replaceAll("[\n\r\t]", "_") + " message body will be empty"));
                        }
                        propertyList.add(Field.createDavProperty("subject", mimeMessage.getHeader("subject", ",")));
                        HttpProppatch propPatchMethod = new HttpProppatch(messageUrl, propertyList);
                        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)propPatchMethod);){
                            int patchStatus = response.getStatusLine().getStatusCode();
                            if (patchStatus == 207) {
                                code = 200;
                            }
                        }
                    }
                    if (code == 200 || code == 201) break block89;
                    if (!davProperties.isEmpty()) {
                        HttpDelete httpDelete = new HttpDelete(messageUrl);
                        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpDelete);){
                            int status = response.getStatusLine().getStatusCode();
                            if (status != 200 && status != 404) {
                                throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)httpDelete, (HttpResponse)response);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.warn((Object)"Unable to delete draft message");
                        }
                    }
                    if (code == 507) {
                        throw new InsufficientStorageException(reasonPhrase);
                    }
                    throw new DavMailException("EXCEPTION_UNABLE_TO_CREATE_MESSAGE", messageUrl, code, Character.valueOf(' '), reasonPhrase);
                }
                catch (MessagingException e) {
                    throw new IOException(e.getMessage());
                }
                finally {
                    putmethod.releaseConnection();
                }
            }
            try {
                if (mimeMessage.getHeader("Bcc") == null) break block91;
                davProperties = new ArrayList<PropEntry>();
                davProperties.add(Field.createDavProperty("bcc", mimeMessage.getHeader("Bcc", ",")));
                HttpProppatch httpProppatch = new HttpProppatch(messageUrl, davProperties);
                try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpProppatch);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 207) {
                        throw new DavMailException("EXCEPTION_UNABLE_TO_CREATE_MESSAGE", messageUrl, statusCode, Character.valueOf(' '), response.getStatusLine().getReasonPhrase());
                    }
                }
            }
            catch (MessagingException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public void updateMessage(ExchangeSession.Message message, Map<String, String> properties) throws IOException {
        HttpProppatch patchMethod = new HttpProppatch(this.encodeAndFixUrl(message.permanentUrl), this.buildProperties(properties)){

            public MultiStatus getResponseBodyAsMultiStatus(HttpResponse response) {
                throw new UnsupportedOperationException();
            }
        };
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)patchMethod);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 207) {
                throw new DavMailException("EXCEPTION_UNABLE_TO_UPDATE_MESSAGE", new Object[0]);
            }
        }
    }

    @Override
    public void deleteMessage(ExchangeSession.Message message) throws IOException {
        LOGGER.debug((Object)("Delete " + message.permanentUrl + " (" + message.messageUrl + ')'));
        HttpDelete httpDelete = new HttpDelete(this.encodeAndFixUrl(message.permanentUrl));
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpDelete);){
            int status = response.getStatusLine().getStatusCode();
            if (status != 200 && status != 404) {
                throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)httpDelete, (HttpResponse)response);
            }
        }
    }

    public void sendMessage(byte[] messageBody) throws IOException {
        try {
            this.sendMessage(new MimeMessage(null, (InputStream)new SharedByteArrayInputStream(messageBody)));
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void sendMessage(MimeMessage mimeMessage) throws IOException {
        try {
            String itemName = UUID.randomUUID().toString() + ".EML";
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("draft", "9");
            String contentType = mimeMessage.getContentType();
            if (contentType != null && contentType.startsWith("text/plain")) {
                properties.put("messageFormat", "1");
            } else {
                properties.put("mailOverrideFormat", String.valueOf(0x160000L));
                properties.put("messageFormat", "2");
            }
            this.createMessage("Drafts", itemName, properties, mimeMessage);
            HttpMove httpMove = new HttpMove(URIUtil.encodePath(this.getFolderPath("Drafts/" + itemName)), URIUtil.encodePath(this.getFolderPath("##DavMailSubmissionURI##")), false);
            if (!Settings.getBooleanProperty("davmail.smtpSaveInSent", true)) {
                httpMove.setHeader("Saveinsent", "f");
            }
            this.moveItem(httpMove);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] getContent(ExchangeSession.Message message) throws IOException {
        ByteArrayOutputStream baos;
        block37: {
            baos = new ByteArrayOutputStream();
            try {
                InputStream contentInputStream;
                try {
                    try {
                        contentInputStream = this.getContentInputStream(message.messageUrl);
                    }
                    catch (UnknownHostException e) {
                        this.restoreHostName = true;
                        contentInputStream = this.getContentInputStream(message.messageUrl);
                    }
                }
                catch (HttpNotFoundException e) {
                    LOGGER.debug((Object)("Message not found at: " + message.messageUrl + ", retrying with permanenturl"));
                    contentInputStream = this.getContentInputStream(message.permanentUrl);
                }
                try {
                    IOUtil.write(contentInputStream, baos);
                }
                finally {
                    contentInputStream.close();
                }
            }
            catch (LoginTimeoutException | SocketException e) {
                LOGGER.warn((Object)((Throwable)e).getMessage());
                throw e;
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Broken message at: " + message.messageUrl + " permanentUrl: " + message.permanentUrl + ", trying to rebuild from properties"));
                try {
                    DavPropertyNameSet messageProperties = new DavPropertyNameSet();
                    messageProperties.add(Field.getPropertyName("contentclass"));
                    messageProperties.add(Field.getPropertyName("message-id"));
                    messageProperties.add(Field.getPropertyName("from"));
                    messageProperties.add(Field.getPropertyName("to"));
                    messageProperties.add(Field.getPropertyName("cc"));
                    messageProperties.add(Field.getPropertyName("subject"));
                    messageProperties.add(Field.getPropertyName("date"));
                    messageProperties.add(Field.getPropertyName("htmldescription"));
                    messageProperties.add(Field.getPropertyName("body"));
                    HttpPropfind httpPropfind = new HttpPropfind(this.encodeAndFixUrl(message.permanentUrl), messageProperties, 0);
                    try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpPropfind);){
                        MultiStatus responses = httpPropfind.getResponseBodyAsMultiStatus((HttpResponse)response);
                        if (responses.getResponses().length > 0) {
                            MimeMessage mimeMessage = new MimeMessage((Session)null);
                            DavPropertySet properties = responses.getResponses()[0].getProperties(200);
                            String propertyValue = this.getPropertyIfExists(properties, "contentclass");
                            if (propertyValue != null) {
                                mimeMessage.addHeader("Content-class", propertyValue);
                            }
                            if ((propertyValue = this.getPropertyIfExists(properties, "date")) != null) {
                                mimeMessage.setSentDate(this.parseDateFromExchange(propertyValue));
                            }
                            if ((propertyValue = this.getPropertyIfExists(properties, "from")) != null) {
                                mimeMessage.addHeader("From", propertyValue);
                            }
                            if ((propertyValue = this.getPropertyIfExists(properties, "to")) != null) {
                                mimeMessage.addHeader("To", propertyValue);
                            }
                            if ((propertyValue = this.getPropertyIfExists(properties, "cc")) != null) {
                                mimeMessage.addHeader("Cc", propertyValue);
                            }
                            if ((propertyValue = this.getPropertyIfExists(properties, "subject")) != null) {
                                mimeMessage.setSubject(propertyValue);
                            }
                            if ((propertyValue = this.getPropertyIfExists(properties, "htmldescription")) != null) {
                                mimeMessage.setContent((Object)propertyValue, "text/html; charset=UTF-8");
                            } else {
                                propertyValue = this.getPropertyIfExists(properties, "body");
                                if (propertyValue != null) {
                                    mimeMessage.setText(propertyValue);
                                }
                            }
                            mimeMessage.writeTo((OutputStream)baos);
                        }
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Rebuilt message content: " + new String(baos.toByteArray(), StandardCharsets.UTF_8)));
                    }
                }
                catch (IOException | MessagingException | DavException e2) {
                    LOGGER.warn((Object)e2);
                }
                if (baos.size() != 0 || !Settings.getBooleanProperty("davmail.deleteBroken")) break block37;
                LOGGER.warn((Object)("Deleting broken message at: " + message.messageUrl + " permanentUrl: " + message.permanentUrl));
                try {
                    message.delete();
                }
                catch (IOException ioe) {
                    LOGGER.warn((Object)("Unable to delete broken message at: " + message.permanentUrl));
                }
                throw e;
            }
        }
        return baos.toByteArray();
    }

    protected String encodeAndFixUrl(String url) throws IOException {
        String fixedurl = URIUtil.encodePath(url);
        if (this.restoreHostName && fixedurl.startsWith("http")) {
            try {
                return URIUtils.rewriteURI((URI)new URI(fixedurl), (HttpHost)URIUtils.extractHost((URI)this.httpClientAdapter.getUri())).toString();
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return fixedurl;
    }

    protected InputStream getContentInputStream(String url) throws IOException {
        InputStream inputStream;
        String encodedUrl = this.encodeAndFixUrl(url);
        final HttpGet httpGet = new HttpGet(encodedUrl);
        httpGet.setHeader("Content-Type", "text/xml; charset=utf-8");
        httpGet.setHeader("Translate", "f");
        httpGet.setHeader("Accept-Encoding", "gzip");
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpGet);){
            inputStream = HttpClientAdapter.isGzipEncoded((HttpResponse)response) ? new GZIPInputStream(response.getEntity().getContent()) : response.getEntity().getContent();
            inputStream = new FilterInputStream(inputStream){
                int totalCount;
                int lastLogCount;

                @Override
                public int read(byte[] buffer, int offset, int length) throws IOException {
                    int count = super.read(buffer, offset, length);
                    this.totalCount += count;
                    if (this.totalCount - this.lastLogCount > 131072) {
                        DavGatewayTray.debug(new BundleMessage("LOG_DOWNLOAD_PROGRESS", String.valueOf(this.totalCount / 1024), httpGet.getURI()));
                        DavGatewayTray.switchIcon();
                        this.lastLogCount = this.totalCount;
                    }
                    return count;
                }

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        httpGet.releaseConnection();
                    }
                }
            };
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Unable to retrieve message at: " + url));
            throw e;
        }
        return inputStream;
    }

    @Override
    public void moveMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
        try {
            this.moveMessage(message.permanentUrl, targetFolder);
        }
        catch (HttpNotFoundException e) {
            LOGGER.debug((Object)("404 not found at permanenturl: " + message.permanentUrl + ", retry with messageurl"));
            this.moveMessage(message.messageUrl, targetFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveMessage(String sourceUrl, String targetFolder) throws IOException {
        String targetPath = URIUtil.encodePath(this.getFolderPath(targetFolder)) + '/' + UUID.randomUUID().toString();
        HttpMove method = new HttpMove(URIUtil.encodePath(sourceUrl), targetPath, false);
        method.setHeader("Allow-Rename", "t");
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)method);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 412 || statusCode == 409) {
                throw new DavMailException("EXCEPTION_UNABLE_TO_MOVE_MESSAGE", new Object[0]);
            }
            if (statusCode != 201) {
                throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)method, (HttpResponse)response);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public void copyMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
        try {
            this.copyMessage(message.permanentUrl, targetFolder);
        }
        catch (HttpNotFoundException e) {
            LOGGER.debug((Object)("404 not found at permanenturl: " + message.permanentUrl + ", retry with messageurl"));
            this.copyMessage(message.messageUrl, targetFolder);
        }
    }

    protected void copyMessage(String sourceUrl, String targetFolder) throws IOException {
        String targetPath = URIUtil.encodePath(this.getFolderPath(targetFolder)) + '/' + UUID.randomUUID().toString();
        HttpCopy httpCopy = new HttpCopy(URIUtil.encodePath(sourceUrl), targetPath, false, false);
        httpCopy.addHeader("Allow-Rename", "t");
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)httpCopy);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 412) {
                throw new DavMailException("EXCEPTION_UNABLE_TO_COPY_MESSAGE", new Object[0]);
            }
            if (statusCode != 201) {
                throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)httpCopy, (HttpResponse)response);
            }
        }
    }

    @Override
    protected void moveToTrash(ExchangeSession.Message message) throws IOException {
        String destination = URIUtil.encodePath(this.deleteditemsUrl) + '/' + UUID.randomUUID().toString();
        LOGGER.debug((Object)("Deleting : " + message.permanentUrl + " to " + destination));
        HttpMove method = new HttpMove(this.encodeAndFixUrl(message.permanentUrl), destination, false);
        method.addHeader("Allow-rename", "t");
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)method);){
            int status = response.getStatusLine().getStatusCode();
            if (status != 201 && status != 404) {
                throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)method, (HttpResponse)response);
            }
            if (response.getFirstHeader("Location") != null) {
                destination = method.getFirstHeader("Location").getValue();
            }
        }
        LOGGER.debug((Object)("Deleted to :" + destination));
    }

    protected String getItemProperty(String permanentUrl, String propertyName) throws IOException, DavException {
        MultiStatus responses;
        String result = null;
        DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
        davPropertyNameSet.add(Field.getPropertyName(propertyName));
        HttpPropfind propFindMethod = new HttpPropfind(this.encodeAndFixUrl(permanentUrl), davPropertyNameSet, 0);
        try (CloseableHttpResponse response = this.httpClientAdapter.execute((HttpRequestBase)propFindMethod);){
            responses = propFindMethod.getResponseBodyAsMultiStatus((HttpResponse)response);
        }
        catch (UnknownHostException e) {
            this.restoreHostName = true;
            propFindMethod = new HttpPropfind(this.encodeAndFixUrl(permanentUrl), davPropertyNameSet, 0);
            try (CloseableHttpResponse response2 = this.httpClientAdapter.execute((HttpRequestBase)propFindMethod);){
                responses = propFindMethod.getResponseBodyAsMultiStatus((HttpResponse)response2);
            }
        }
        if (responses.getResponses().length > 0) {
            DavPropertySet properties = responses.getResponses()[0].getProperties(200);
            result = this.getPropertyIfExists(properties, propertyName);
        }
        return result;
    }

    protected String convertDateFromExchange(String exchangeDateValue) throws DavMailException {
        String zuluDateValue = null;
        if (exchangeDateValue != null) {
            try {
                zuluDateValue = HC4DavExchangeSession.getZuluDateFormat().format(HC4DavExchangeSession.getExchangeZuluDateFormatMillisecond().parse(exchangeDateValue));
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
            }
        }
        return zuluDateValue;
    }

    protected String convertPriorityFromExchange(String exchangeImportanceValue) {
        String value = null;
        if (exchangeImportanceValue != null) {
            value = importanceToPriorityMap.get(exchangeImportanceValue);
        }
        return value;
    }

    protected String convertPriorityToExchange(String vTodoPriorityValue) {
        String value = null;
        if (vTodoPriorityValue != null) {
            value = priorityToImportanceMap.get(vTodoPriorityValue);
        }
        return value;
    }

    @Override
    public void close() {
        this.httpClientAdapter.close();
    }

    @Override
    public String formatSearchDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.ENGLISH);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        return dateFormatter.format(date);
    }

    protected String convertTaskDateToZulu(String value) {
        String result = null;
        if (value != null && value.length() > 0) {
            try {
                SimpleDateFormat parser = ExchangeSession.getExchangeDateFormat(value);
                Calendar calendarValue = Calendar.getInstance(GMT_TIMEZONE);
                calendarValue.setTime(parser.parse(value));
                if (value.length() == 16) {
                    calendarValue.add(10, 12);
                }
                calendarValue.set(10, 0);
                calendarValue.set(12, 0);
                calendarValue.set(13, 0);
                result = ExchangeSession.getExchangeZuluDateFormatMillisecond().format(calendarValue.getTime());
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Invalid date: " + value));
            }
        }
        return result;
    }

    protected String convertDateFromExchangeToTaskDate(String exchangeDateValue) throws DavMailException {
        String result = null;
        if (exchangeDateValue != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
                dateFormat.setTimeZone(GMT_TIMEZONE);
                result = dateFormat.format(HC4DavExchangeSession.getExchangeZuluDateFormatMillisecond().parse(exchangeDateValue));
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
            }
        }
        return result;
    }

    protected Date parseDateFromExchange(String exchangeDateValue) throws DavMailException {
        Date result = null;
        if (exchangeDateValue != null) {
            try {
                result = HC4DavExchangeSession.getExchangeZuluDateFormatMillisecond().parse(exchangeDateValue);
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
            }
        }
        return result;
    }

    static {
        WELL_KNOWN_FOLDERS.add(Field.getPropertyName("inbox"));
        WELL_KNOWN_FOLDERS.add(Field.getPropertyName("deleteditems"));
        WELL_KNOWN_FOLDERS.add(Field.getPropertyName("sentitems"));
        WELL_KNOWN_FOLDERS.add(Field.getPropertyName("sendmsg"));
        WELL_KNOWN_FOLDERS.add(Field.getPropertyName("drafts"));
        WELL_KNOWN_FOLDERS.add(Field.getPropertyName("calendar"));
        WELL_KNOWN_FOLDERS.add(Field.getPropertyName("tasks"));
        WELL_KNOWN_FOLDERS.add(Field.getPropertyName("contacts"));
        WELL_KNOWN_FOLDERS.add(Field.getPropertyName("outbox"));
        vTodoToTaskStatusMap = new HashMap<String, String>();
        taskTovTodoStatusMap = new HashMap<String, String>();
        taskTovTodoStatusMap.put("1", "IN-PROCESS");
        taskTovTodoStatusMap.put("2", "COMPLETED");
        taskTovTodoStatusMap.put("3", "NEEDS-ACTION");
        taskTovTodoStatusMap.put("4", "CANCELLED");
        vTodoToTaskStatusMap.put("IN-PROCESS", "1");
        vTodoToTaskStatusMap.put("COMPLETED", "2");
        vTodoToTaskStatusMap.put("NEEDS-ACTION", "3");
        vTodoToTaskStatusMap.put("CANCELLED", "4");
        GALFIND_CRITERIA_MAP = new HashMap();
        GALFIND_CRITERIA_MAP.put("imapUid", "AN");
        GALFIND_CRITERIA_MAP.put("smtpemail1", "EM");
        GALFIND_CRITERIA_MAP.put("cn", "DN");
        GALFIND_CRITERIA_MAP.put("givenName", "FN");
        GALFIND_CRITERIA_MAP.put("sn", "LN");
        GALFIND_CRITERIA_MAP.put("title", "TL");
        GALFIND_CRITERIA_MAP.put("o", "CP");
        GALFIND_CRITERIA_MAP.put("l", "OF");
        GALFIND_CRITERIA_MAP.put("department", "DP");
        GALLOOKUP_ATTRIBUTES = new HashSet();
        GALLOOKUP_ATTRIBUTES.add("givenName");
        GALLOOKUP_ATTRIBUTES.add("initials");
        GALLOOKUP_ATTRIBUTES.add("sn");
        GALLOOKUP_ATTRIBUTES.add("street");
        GALLOOKUP_ATTRIBUTES.add("st");
        GALLOOKUP_ATTRIBUTES.add("postalcode");
        GALLOOKUP_ATTRIBUTES.add("co");
        GALLOOKUP_ATTRIBUTES.add("departement");
        GALLOOKUP_ATTRIBUTES.add("mobile");
        GALFIND_ATTRIBUTE_MAP = new HashMap();
        GALFIND_ATTRIBUTE_MAP.put("uid", "AN");
        GALFIND_ATTRIBUTE_MAP.put("smtpemail1", "EM");
        GALFIND_ATTRIBUTE_MAP.put("cn", "DN");
        GALFIND_ATTRIBUTE_MAP.put("displayName", "DN");
        GALFIND_ATTRIBUTE_MAP.put("telephoneNumber", "PH");
        GALFIND_ATTRIBUTE_MAP.put("l", "OFFICE");
        GALFIND_ATTRIBUTE_MAP.put("o", "CP");
        GALFIND_ATTRIBUTE_MAP.put("title", "TL");
        GALFIND_ATTRIBUTE_MAP.put("givenName", "first");
        GALFIND_ATTRIBUTE_MAP.put("initials", "initials");
        GALFIND_ATTRIBUTE_MAP.put("sn", "last");
        GALFIND_ATTRIBUTE_MAP.put("street", "street");
        GALFIND_ATTRIBUTE_MAP.put("st", "state");
        GALFIND_ATTRIBUTE_MAP.put("postalcode", "zip");
        GALFIND_ATTRIBUTE_MAP.put("co", "country");
        GALFIND_ATTRIBUTE_MAP.put("department", "department");
        GALFIND_ATTRIBUTE_MAP.put("mobile", "mobile");
        GALFIND_ATTRIBUTE_MAP.put("roomnumber", "office");
        OPERATOR_MAP = new HashMap<ExchangeSession.Operator, String>();
        OPERATOR_MAP.put(ExchangeSession.Operator.IsEqualTo, " = ");
        OPERATOR_MAP.put(ExchangeSession.Operator.IsGreaterThanOrEqualTo, " >= ");
        OPERATOR_MAP.put(ExchangeSession.Operator.IsGreaterThan, " > ");
        OPERATOR_MAP.put(ExchangeSession.Operator.IsLessThanOrEqualTo, " <= ");
        OPERATOR_MAP.put(ExchangeSession.Operator.IsLessThan, " < ");
        OPERATOR_MAP.put(ExchangeSession.Operator.Like, " like ");
        OPERATOR_MAP.put(ExchangeSession.Operator.IsNull, " is null");
        OPERATOR_MAP.put(ExchangeSession.Operator.IsFalse, " = false");
        OPERATOR_MAP.put(ExchangeSession.Operator.IsTrue, " = true");
        OPERATOR_MAP.put(ExchangeSession.Operator.StartsWith, " = ");
        OPERATOR_MAP.put(ExchangeSession.Operator.Contains, " = ");
        FOLDER_PROPERTIES = new HashSet<String>();
        FOLDER_PROPERTIES.add("displayname");
        FOLDER_PROPERTIES.add("folderclass");
        FOLDER_PROPERTIES.add("hassubs");
        FOLDER_PROPERTIES.add("nosubs");
        FOLDER_PROPERTIES.add("count");
        FOLDER_PROPERTIES.add("unreadcount");
        FOLDER_PROPERTIES.add("contenttag");
        FOLDER_PROPERTIES.add("lastmodified");
        FOLDER_PROPERTIES.add("uidNext");
        FOLDER_PROPERTIES_NAME_SET = new DavPropertyNameSet();
        for (String attribute : FOLDER_PROPERTIES) {
            FOLDER_PROPERTIES_NAME_SET.add(Field.getPropertyName(attribute));
        }
        ITEM_PROPERTIES = new HashSet<String>();
        ITEM_PROPERTIES.add("etag");
        ITEM_PROPERTIES.add("displayname");
        ITEM_PROPERTIES.add("instancetype");
        ITEM_PROPERTIES.add("urlcompname");
        ITEM_PROPERTIES.add("subject");
        ITEM_PROPERTIES.add("contentclass");
        EVENT_REQUEST_PROPERTIES = new HashSet<String>();
        EVENT_REQUEST_PROPERTIES.add("permanenturl");
        EVENT_REQUEST_PROPERTIES.add("urlcompname");
        EVENT_REQUEST_PROPERTIES.add("etag");
        EVENT_REQUEST_PROPERTIES.add("contentclass");
        EVENT_REQUEST_PROPERTIES.add("displayname");
        EVENT_REQUEST_PROPERTIES.add("subject");
        EVENT_REQUEST_PROPERTIES_NAME_SET = new DavPropertyNameSet();
        for (String attribute : EVENT_REQUEST_PROPERTIES) {
            EVENT_REQUEST_PROPERTIES_NAME_SET.add(Field.getPropertyName(attribute));
        }
        importanceToPriorityMap = new HashMap<String, String>();
        importanceToPriorityMap.put("high", "1");
        importanceToPriorityMap.put("normal", "5");
        importanceToPriorityMap.put("low", "9");
        priorityToImportanceMap = new HashMap<String, String>();
        priorityToImportanceMap.put("1", "high");
        priorityToImportanceMap.put("5", "normal");
        priorityToImportanceMap.put("9", "low");
    }

    public class Event
    extends ExchangeSession.Event {
        protected String instancetype;

        public Event(MultiStatusResponse multiStatusResponse) throws IOException {
            this.setHref(URIUtil.decode(multiStatusResponse.getHref()));
            DavPropertySet properties = multiStatusResponse.getProperties(200);
            this.permanentUrl = HC4DavExchangeSession.this.getURLPropertyIfExists(properties, "permanenturl");
            this.etag = HC4DavExchangeSession.this.getPropertyIfExists(properties, "etag");
            this.displayName = HC4DavExchangeSession.this.getPropertyIfExists(properties, "displayname");
            this.subject = HC4DavExchangeSession.this.getPropertyIfExists(properties, "subject");
            this.instancetype = HC4DavExchangeSession.this.getPropertyIfExists(properties, "instancetype");
            this.contentClass = HC4DavExchangeSession.this.getPropertyIfExists(properties, "contentclass");
        }

        public Event(String folderPath, String itemName, String contentClass, String itemBody, String etag, String noneMatch) throws IOException {
            super(folderPath, itemName, contentClass, itemBody, etag, noneMatch);
        }

        protected byte[] getICSFromInternetContentProperty() throws IOException, DavException, MessagingException {
            byte[] result = null;
            String propertyValue = HC4DavExchangeSession.this.getItemProperty(this.permanentUrl, "internetContent");
            if (propertyValue != null) {
                result = this.getICS(new ByteArrayInputStream(IOUtil.decodeBase64(propertyValue)));
            }
            return result;
        }

        @Override
        public byte[] getEventContent() throws IOException {
            byte[] result;
            block18: {
                result = null;
                LOGGER.debug((Object)("Get event subject: " + this.subject + " contentclass: " + this.contentClass + " href: " + this.getHref() + " permanentUrl: " + this.permanentUrl));
                if (!"urn:content-classes:task".equals(this.contentClass)) {
                    try {
                        result = this.getICSFromInternetContentProperty();
                        if (result != null) break block18;
                        HttpGet httpGet = new HttpGet(HC4DavExchangeSession.this.encodeAndFixUrl(this.permanentUrl));
                        httpGet.setHeader("Content-Type", "text/xml; charset=utf-8");
                        httpGet.setHeader("Translate", "f");
                        try (CloseableHttpResponse response = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)httpGet);){
                            result = this.getICS(response.getEntity().getContent());
                        }
                    }
                    catch (IOException | MessagingException | DavException e) {
                        LOGGER.warn((Object)e.getMessage());
                    }
                }
            }
            if (result == null) {
                try {
                    result = this.getICSFromItemProperties();
                }
                catch (IOException e) {
                    this.deleteBroken();
                    throw e;
                }
            }
            return result;
        }

        private byte[] getICSFromItemProperties() throws HttpNotFoundException {
            byte[] result;
            try {
                HashSet<String> eventProperties = new HashSet<String>();
                eventProperties.add("method");
                eventProperties.add("created");
                eventProperties.add("calendarlastmodified");
                eventProperties.add("dtstamp");
                eventProperties.add("calendaruid");
                eventProperties.add("subject");
                eventProperties.add("dtstart");
                eventProperties.add("dtend");
                eventProperties.add("transparent");
                eventProperties.add("organizer");
                eventProperties.add("to");
                eventProperties.add("description");
                eventProperties.add("rrule");
                eventProperties.add("exdate");
                eventProperties.add("sensitivity");
                eventProperties.add("alldayevent");
                eventProperties.add("busystatus");
                eventProperties.add("reminderset");
                eventProperties.add("reminderdelta");
                eventProperties.add("importance");
                eventProperties.add("uid");
                eventProperties.add("taskstatus");
                eventProperties.add("percentcomplete");
                eventProperties.add("keywords");
                eventProperties.add("startdate");
                eventProperties.add("duedate");
                eventProperties.add("datecompleted");
                MultiStatusResponse[] responses = HC4DavExchangeSession.this.searchItems(this.folderPath, eventProperties, HC4DavExchangeSession.this.isEqualTo("urlcompname", HC4DavExchangeSession.this.convertItemNameToEML(this.itemName)), FolderQueryTraversal.Shallow, 1);
                if (responses.length == 0) {
                    throw new HttpNotFoundException(this.permanentUrl + " not found");
                }
                DavPropertySet davPropertySet = responses[0].getProperties(200);
                VCalendar localVCalendar = new VCalendar();
                localVCalendar.setPropertyValue("PRODID", "-//davmail.sf.net/NONSGML DavMail Calendar V1.1//EN");
                localVCalendar.setPropertyValue("VERSION", "2.0");
                localVCalendar.setPropertyValue("METHOD", HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "method"));
                VObject vEvent = new VObject();
                vEvent.setPropertyValue("CREATED", HC4DavExchangeSession.this.convertDateFromExchange(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "created")));
                vEvent.setPropertyValue("LAST-MODIFIED", HC4DavExchangeSession.this.convertDateFromExchange(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "calendarlastmodified")));
                vEvent.setPropertyValue("DTSTAMP", HC4DavExchangeSession.this.convertDateFromExchange(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "dtstamp")));
                String uid = HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "calendaruid");
                if (uid == null) {
                    uid = HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "uid");
                }
                vEvent.setPropertyValue("UID", uid);
                vEvent.setPropertyValue("SUMMARY", HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "subject"));
                vEvent.setPropertyValue("DESCRIPTION", HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "description"));
                vEvent.setPropertyValue("PRIORITY", HC4DavExchangeSession.this.convertPriorityFromExchange(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "importance")));
                vEvent.setPropertyValue("CATEGORIES", HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "keywords"));
                String sensitivity = HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "sensitivity");
                if ("2".equals(sensitivity)) {
                    vEvent.setPropertyValue("CLASS", "PRIVATE");
                } else if ("3".equals(sensitivity)) {
                    vEvent.setPropertyValue("CLASS", "CONFIDENTIAL");
                } else if ("0".equals(sensitivity)) {
                    vEvent.setPropertyValue("CLASS", "PUBLIC");
                }
                if (this.instancetype == null) {
                    vEvent.type = "VTODO";
                    double percentComplete = HC4DavExchangeSession.this.getDoublePropertyIfExists(davPropertySet, "percentcomplete");
                    if (percentComplete > 0.0) {
                        vEvent.setPropertyValue("PERCENT-COMPLETE", String.valueOf((int)(percentComplete * 100.0)));
                    }
                    vEvent.setPropertyValue("STATUS", taskTovTodoStatusMap.get(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "taskstatus")));
                    vEvent.setPropertyValue("DUE;VALUE=DATE", HC4DavExchangeSession.this.convertDateFromExchangeToTaskDate(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "duedate")));
                    vEvent.setPropertyValue("DTSTART;VALUE=DATE", HC4DavExchangeSession.this.convertDateFromExchangeToTaskDate(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "startdate")));
                    vEvent.setPropertyValue("COMPLETED;VALUE=DATE", HC4DavExchangeSession.this.convertDateFromExchangeToTaskDate(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "datecompleted")));
                } else {
                    String toHeader;
                    vEvent.type = "VEVENT";
                    String dtstart = HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "dtstart");
                    if (dtstart != null) {
                        vEvent.setPropertyValue("DTSTART", HC4DavExchangeSession.this.convertDateFromExchange(dtstart));
                    } else {
                        LOGGER.warn((Object)"missing dtstart on item, using fake value. Set davmail.deleteBroken=true to delete broken events");
                        vEvent.setPropertyValue("DTSTART", "20000101T000000Z");
                        this.deleteBroken();
                    }
                    String dtend = HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "dtend");
                    if (dtend != null) {
                        vEvent.setPropertyValue("DTEND", HC4DavExchangeSession.this.convertDateFromExchange(dtend));
                    } else {
                        LOGGER.warn((Object)"missing dtend on item, using fake value. Set davmail.deleteBroken=true to delete broken events");
                        vEvent.setPropertyValue("DTEND", "20000101T010000Z");
                        this.deleteBroken();
                    }
                    vEvent.setPropertyValue("TRANSP", HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "transparent"));
                    vEvent.setPropertyValue("RRULE", HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "rrule"));
                    String exdates = HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "exdate");
                    if (exdates != null) {
                        String[] exdatearray;
                        for (String string : exdatearray = exdates.split(",")) {
                            vEvent.addPropertyValue("EXDATE", StringUtil.convertZuluDateTimeToAllDay(HC4DavExchangeSession.this.convertDateFromExchange(string)));
                        }
                    }
                    String organizer = HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "organizer");
                    String organizerEmail = null;
                    if (organizer != null) {
                        InternetAddress organizerAddress = new InternetAddress(organizer);
                        organizerEmail = organizerAddress.getAddress();
                        vEvent.setPropertyValue("ORGANIZER", "MAILTO:" + organizerEmail);
                    }
                    if ((toHeader = HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "to")) != null && !toHeader.equals(organizerEmail)) {
                        InternetAddress[] attendees;
                        for (InternetAddress attendee : attendees = InternetAddress.parseHeader((String)toHeader, (boolean)false)) {
                            if (attendee.getAddress().equalsIgnoreCase(organizerEmail)) continue;
                            VProperty vProperty = new VProperty("ATTENDEE", attendee.getAddress());
                            if (attendee.getPersonal() != null) {
                                vProperty.addParam("CN", attendee.getPersonal());
                            }
                            vEvent.addProperty(vProperty);
                        }
                    }
                    vEvent.setPropertyValue("X-MICROSOFT-CDO-ALLDAYEVENT", "1".equals(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "alldayevent")) ? "TRUE" : "FALSE");
                    vEvent.setPropertyValue("X-MICROSOFT-CDO-BUSYSTATUS", HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "busystatus"));
                    if ("1".equals(HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "reminderset"))) {
                        VObject vAlarm = new VObject();
                        vAlarm.type = "VALARM";
                        vAlarm.setPropertyValue("ACTION", "DISPLAY");
                        vAlarm.setPropertyValue("DISPLAY", "Reminder");
                        String string = HC4DavExchangeSession.this.getPropertyIfExists(davPropertySet, "reminderdelta");
                        VProperty vProperty = new VProperty("TRIGGER", "-PT" + string + 'M');
                        vProperty.addParam("VALUE", "DURATION");
                        vAlarm.addProperty(vProperty);
                        vEvent.addVObject(vAlarm);
                    }
                }
                localVCalendar.addVObject(vEvent);
                result = localVCalendar.toString().getBytes(StandardCharsets.UTF_8);
            }
            catch (IOException | MessagingException e) {
                LOGGER.warn((Object)("Unable to rebuild event content: " + e.getMessage()), e);
                throw new HttpNotFoundException("Unable to get event " + this.getName() + " subject: " + this.subject + " at " + this.permanentUrl + ": " + e.getMessage());
            }
            return result;
        }

        protected void deleteBroken() {
            if (Settings.getBooleanProperty("davmail.deleteBroken")) {
                LOGGER.warn((Object)("Deleting broken event at: " + this.permanentUrl));
                try {
                    HttpDelete httpDelete = new HttpDelete(HC4DavExchangeSession.this.encodeAndFixUrl(this.permanentUrl));
                    try (CloseableHttpResponse response = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)httpDelete);){
                        LOGGER.warn((Object)("deleteBroken returned " + response.getStatusLine().getStatusCode()));
                    }
                }
                catch (IOException e) {
                    LOGGER.warn((Object)("Unable to delete broken event at: " + this.permanentUrl));
                }
            }
        }

        protected CloseableHttpResponse internalCreateOrUpdate(String encodedHref, byte[] mimeContent) throws IOException {
            HttpPut httpPut = new HttpPut(encodedHref);
            httpPut.setHeader("Translate", "f");
            httpPut.setHeader("Overwrite", "f");
            if (this.etag != null) {
                httpPut.setHeader("If-Match", this.etag);
            }
            if (this.noneMatch != null) {
                httpPut.setHeader("If-None-Match", this.noneMatch);
            }
            httpPut.setHeader("Content-Type", "message/rfc822");
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(mimeContent, ContentType.getByMimeType((String)"message/rfc822")));
            try (CloseableHttpResponse response = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)httpPut);){
                CloseableHttpResponse closeableHttpResponse = response;
                return closeableHttpResponse;
            }
        }

        @Override
        public ExchangeSession.ItemResult createOrUpdate() throws IOException {
            ExchangeSession.ItemResult itemResult = new ExchangeSession.ItemResult();
            if (this.vCalendar.isTodo()) {
                if ((HC4DavExchangeSession.this.mailPath + HC4DavExchangeSession.this.calendarName).equals(this.folderPath)) {
                    this.folderPath = HC4DavExchangeSession.this.mailPath + HC4DavExchangeSession.this.tasksName;
                }
                String encodedHref = URIUtil.encodePath(this.getHref());
                HashSet<PropertyValue> propertyValues = new HashSet<PropertyValue>();
                if (this.noneMatch != null) {
                    propertyValues.add(Field.createPropertyValue("contentclass", "urn:content-classes:task"));
                    propertyValues.add(Field.createPropertyValue("outlookmessageclass", "IPM.Task"));
                    propertyValues.add(Field.createPropertyValue("calendaruid", this.vCalendar.getFirstVeventPropertyValue("UID")));
                }
                propertyValues.add(Field.createPropertyValue("subject", this.vCalendar.getFirstVeventPropertyValue("SUMMARY")));
                propertyValues.add(Field.createPropertyValue("description", this.vCalendar.getFirstVeventPropertyValue("DESCRIPTION")));
                propertyValues.add(Field.createPropertyValue("importance", HC4DavExchangeSession.this.convertPriorityToExchange(this.vCalendar.getFirstVeventPropertyValue("PRIORITY"))));
                String percentComplete = this.vCalendar.getFirstVeventPropertyValue("PERCENT-COMPLETE");
                if (percentComplete == null) {
                    percentComplete = "0";
                }
                propertyValues.add(Field.createPropertyValue("percentcomplete", String.valueOf(Double.parseDouble(percentComplete) / 100.0)));
                String taskStatus = vTodoToTaskStatusMap.get(this.vCalendar.getFirstVeventPropertyValue("STATUS"));
                propertyValues.add(Field.createPropertyValue("taskstatus", taskStatus));
                propertyValues.add(Field.createPropertyValue("keywords", this.vCalendar.getFirstVeventPropertyValue("CATEGORIES")));
                propertyValues.add(Field.createPropertyValue("startdate", HC4DavExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DTSTART"))));
                propertyValues.add(Field.createPropertyValue("duedate", HC4DavExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DUE"))));
                propertyValues.add(Field.createPropertyValue("datecompleted", HC4DavExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("COMPLETED"))));
                propertyValues.add(Field.createPropertyValue("iscomplete", "2".equals(taskStatus) ? "true" : "false"));
                propertyValues.add(Field.createPropertyValue("commonstart", HC4DavExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DTSTART"))));
                propertyValues.add(Field.createPropertyValue("commonend", HC4DavExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DUE"))));
                ExchangePropPatchRequest propPatchMethod = new ExchangePropPatchRequest(encodedHref, propertyValues);
                propPatchMethod.setHeader("Translate", "f");
                if (this.etag != null) {
                    propPatchMethod.setHeader("If-Match", this.etag);
                }
                if (this.noneMatch != null) {
                    propPatchMethod.setHeader("If-None-Match", this.noneMatch);
                }
                try (CloseableHttpResponse response = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)propPatchMethod);){
                    int status = response.getStatusLine().getStatusCode();
                    if (status == 207) {
                        ExchangeSession.Item newItem = HC4DavExchangeSession.this.getItem(this.folderPath, this.itemName);
                        try {
                            itemResult.status = propPatchMethod.getResponseStatusCode();
                        }
                        catch (HttpResponseException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                        itemResult.etag = newItem.etag;
                    }
                    itemResult.status = status;
                }
            } else {
                byte[] mimeContent;
                String encodedHref = URIUtil.encodePath(this.getHref());
                CloseableHttpResponse httpResponse = this.internalCreateOrUpdate(encodedHref, mimeContent = this.createMimeContent());
                int status = httpResponse.getStatusLine().getStatusCode();
                if (status == 200) {
                    LOGGER.debug((Object)("Updated event " + encodedHref));
                } else if (status == 201) {
                    LOGGER.debug((Object)("Created event " + encodedHref));
                } else if (status == 404) {
                    LOGGER.debug((Object)("Event not found at " + encodedHref + ", searching permanenturl by urlcompname"));
                    MultiStatusResponse[] responses = HC4DavExchangeSession.this.searchItems(this.folderPath, EVENT_REQUEST_PROPERTIES, HC4DavExchangeSession.this.isEqualTo("urlcompname", HC4DavExchangeSession.this.convertItemNameToEML(this.itemName)), FolderQueryTraversal.Shallow, 1);
                    if (responses.length == 1) {
                        encodedHref = HC4DavExchangeSession.this.getPropertyIfExists(responses[0].getProperties(200), "permanenturl");
                        LOGGER.warn((Object)("Event found, permanenturl is " + encodedHref));
                        httpResponse = this.internalCreateOrUpdate(encodedHref, mimeContent);
                        status = httpResponse.getStatusLine().getStatusCode();
                        if (status == 200) {
                            LOGGER.debug((Object)("Updated event " + encodedHref));
                        } else {
                            LOGGER.warn((Object)("Unable to create or update event " + status + ' ' + httpResponse.getStatusLine().getReasonPhrase()));
                        }
                    }
                } else {
                    LOGGER.warn((Object)("Unable to create or update event " + status + ' ' + httpResponse.getStatusLine().getReasonPhrase()));
                }
                if (status == 440) {
                    status = 403;
                } else if (status == 401 && this.getHref().startsWith("/public")) {
                    LOGGER.warn((Object)"Ignore 401 unauthorized on public event");
                    status = 200;
                }
                itemResult.status = status;
                if (httpResponse.getFirstHeader("GetETag") != null) {
                    itemResult.etag = httpResponse.getFirstHeader("GetETag").getValue();
                }
                if ((status == 200 || status == 201) && Settings.getBooleanProperty("davmail.forceActiveSyncUpdate")) {
                    ArrayList<PropEntry> propertyList = new ArrayList<PropEntry>();
                    propertyList.add(Field.createDavProperty("contentclass", this.contentClass));
                    propertyList.add(Field.createDavProperty("internetContent", IOUtil.encodeBase64AsString(mimeContent)));
                    HttpProppatch propPatchMethod = new HttpProppatch(encodedHref, propertyList);
                    try (CloseableHttpResponse response = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)propPatchMethod);){
                        int patchStatus = response.getStatusLine().getStatusCode();
                        if (patchStatus != 207) {
                            LOGGER.warn((Object)"Unable to patch event to trigger activeSync push");
                        } else {
                            ExchangeSession.Item newItem = HC4DavExchangeSession.this.getItem(this.folderPath, this.itemName);
                            itemResult.etag = newItem.etag;
                        }
                    }
                }
            }
            return itemResult;
        }
    }

    public class Contact
    extends ExchangeSession.Contact {
        public Contact(MultiStatusResponse multiStatusResponse) throws IOException, DavMailException {
            this.setHref(URIUtil.decode(multiStatusResponse.getHref()));
            DavPropertySet properties = multiStatusResponse.getProperties(200);
            this.permanentUrl = HC4DavExchangeSession.this.getURLPropertyIfExists(properties, "permanenturl");
            this.etag = HC4DavExchangeSession.this.getPropertyIfExists(properties, "etag");
            this.displayName = HC4DavExchangeSession.this.getPropertyIfExists(properties, "displayname");
            for (String attributeName : ExchangeSession.CONTACT_ATTRIBUTES) {
                String value = HC4DavExchangeSession.this.getPropertyIfExists(properties, attributeName);
                if (value == null) continue;
                if ("bday".equals(attributeName) || "anniversary".equals(attributeName) || "lastmodified".equals(attributeName) || "datereceived".equals(attributeName)) {
                    value = HC4DavExchangeSession.this.convertDateFromExchange(value);
                } else if ("haspicture".equals(attributeName) || "private".equals(attributeName)) {
                    value = "1".equals(value) ? "true" : "false";
                }
                this.put(attributeName, value);
            }
        }

        public Contact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) {
            super(folderPath, itemName, properties, etag, noneMatch);
        }

        public Contact() {
        }

        protected Set<PropertyValue> buildProperties() {
            HashSet<PropertyValue> propertyValues = new HashSet<PropertyValue>();
            for (Map.Entry entry : this.entrySet()) {
                String key = (String)entry.getKey();
                if ("photo".equals(key)) continue;
                propertyValues.add(Field.createPropertyValue(key, (String)entry.getValue()));
                if (!key.startsWith("email")) continue;
                propertyValues.add(Field.createPropertyValue(key + "type", "SMTP"));
            }
            return propertyValues;
        }

        protected ExchangePropPatchRequest internalCreateOrUpdate(String encodedHref) throws IOException {
            ExchangePropPatchRequest propPatchRequest = new ExchangePropPatchRequest(encodedHref, this.buildProperties());
            propPatchRequest.setHeader("Translate", "f");
            if (this.etag != null) {
                propPatchRequest.setHeader("If-Match", this.etag);
            }
            if (this.noneMatch != null) {
                propPatchRequest.setHeader("If-None-Match", this.noneMatch);
            }
            try (CloseableHttpResponse response = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)propPatchRequest);){
                LOGGER.debug((Object)("internalCreateOrUpdate returned " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase()));
            }
            return propPatchRequest;
        }

        @Override
        public ExchangeSession.ItemResult createOrUpdate() throws IOException {
            String encodedHref = URIUtil.encodePath(this.getHref());
            ExchangePropPatchRequest propPatchRequest = this.internalCreateOrUpdate(encodedHref);
            int status = propPatchRequest.getStatusLine().getStatusCode();
            if (status == 207) {
                try {
                    status = propPatchRequest.getResponseStatusCode();
                }
                catch (HttpResponseException e) {
                    throw new IOException(e.getMessage(), e);
                }
                if (status == 201) {
                    LOGGER.debug((Object)("Created contact " + encodedHref));
                } else {
                    LOGGER.debug((Object)("Updated contact " + encodedHref));
                }
            } else if (status == 404) {
                LOGGER.debug((Object)("Contact not found at " + encodedHref + ", searching permanenturl by urlcompname"));
                MultiStatusResponse[] responses = HC4DavExchangeSession.this.searchItems(this.folderPath, EVENT_REQUEST_PROPERTIES, HC4DavExchangeSession.this.isEqualTo("urlcompname", HC4DavExchangeSession.this.convertItemNameToEML(this.itemName)), FolderQueryTraversal.Shallow, 1);
                if (responses.length == 1) {
                    encodedHref = HC4DavExchangeSession.this.getPropertyIfExists(responses[0].getProperties(200), "permanenturl");
                    LOGGER.warn((Object)("Contact found, permanenturl is " + encodedHref));
                    propPatchRequest = this.internalCreateOrUpdate(encodedHref);
                    status = propPatchRequest.getStatusLine().getStatusCode();
                    if (status == 207) {
                        try {
                            status = propPatchRequest.getResponseStatusCode();
                        }
                        catch (HttpResponseException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                        LOGGER.debug((Object)("Updated contact " + encodedHref));
                    } else {
                        LOGGER.warn((Object)("Unable to create or update contact " + status + ' ' + propPatchRequest.getStatusLine()));
                    }
                }
            } else {
                LOGGER.warn((Object)("Unable to create or update contact " + status + ' ' + propPatchRequest.getStatusLine().getReasonPhrase()));
            }
            ExchangeSession.ItemResult itemResult = new ExchangeSession.ItemResult();
            if (status == 440) {
                status = 403;
            }
            itemResult.status = status;
            if (status == 200 || status == 201) {
                Throwable throwable;
                CloseableHttpResponse response;
                block71: {
                    String contactPictureUrl = URIUtil.encodePath(this.getHref() + "/ContactPicture.jpg");
                    String photo = (String)this.get("photo");
                    if (photo != null) {
                        Throwable throwable2;
                        CloseableHttpResponse response2;
                        try {
                            HttpPut httpPut = new HttpPut(contactPictureUrl);
                            byte[] resizedImageBytes = IOUtil.resizeImage(IOUtil.decodeBase64(photo), 90);
                            httpPut.setHeader("Overwrite", "t");
                            httpPut.setHeader("Content-Type", "image/jpeg");
                            httpPut.setEntity((HttpEntity)new ByteArrayEntity(resizedImageBytes, ContentType.IMAGE_JPEG));
                            response2 = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)httpPut);
                            throwable2 = null;
                            try {
                                status = response2.getStatusLine().getStatusCode();
                                if (status != 200 && status != 201) {
                                    throw new IOException("Unable to update contact picture: " + status + ' ' + response2.getStatusLine().getReasonPhrase());
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (response2 != null) {
                                    if (throwable2 != null) {
                                        try {
                                            response2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                    } else {
                                        response2.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"Error in contact photo create or update", (Throwable)e);
                            throw e;
                        }
                        HashSet<PropertyValue> picturePropertyValues = new HashSet<PropertyValue>();
                        picturePropertyValues.add(Field.createPropertyValue("attachmentContactPhoto", "true"));
                        picturePropertyValues.add(Field.createPropertyValue("attachExtension", ".jpg"));
                        ExchangePropPatchRequest attachmentPropPatchRequest = new ExchangePropPatchRequest(contactPictureUrl, picturePropertyValues);
                        response2 = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)attachmentPropPatchRequest);
                        throwable2 = null;
                        try {
                            attachmentPropPatchRequest.handleResponse((HttpResponse)response2);
                            status = response2.getStatusLine().getStatusCode();
                            if (status != 207) {
                                LOGGER.error((Object)("Error in contact photo create or update: " + response2.getStatusLine().getStatusCode()));
                                throw new IOException("Unable to update contact picture");
                            }
                            break block71;
                        }
                        catch (Throwable throwable5) {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (response2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        response2.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable2.addSuppressed(throwable6);
                                    }
                                } else {
                                    response2.close();
                                }
                            }
                        }
                    }
                    HttpDelete httpDelete = new HttpDelete(contactPictureUrl);
                    response = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)httpDelete);
                    throwable = null;
                    try {
                        status = response.getStatusLine().getStatusCode();
                        if (status != 200 && status != 404) {
                            LOGGER.error((Object)("Error in contact photo delete: " + status));
                            throw new IOException("Unable to delete contact picture");
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (response != null) {
                            if (throwable != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                response.close();
                            }
                        }
                    }
                }
                HttpHead headMethod = new HttpHead(URIUtil.encodePath(this.getHref()));
                response = HC4DavExchangeSession.this.httpClientAdapter.execute((HttpRequestBase)headMethod);
                throwable = null;
                try {
                    if (response.getFirstHeader("ETag") != null) {
                        itemResult.etag = response.getFirstHeader("ETag").getValue();
                    }
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            response.close();
                        }
                    }
                }
            }
            return itemResult;
        }
    }

    public class Message
    extends ExchangeSession.Message {
        @Override
        public String getPermanentId() {
            return this.permanentUrl;
        }

        @Override
        protected InputStream getMimeHeaders() {
            ByteArrayInputStream result = null;
            try {
                String messageHeaders = HC4DavExchangeSession.this.getItemProperty(this.permanentUrl, "messageheaders");
                if (messageHeaders != null) {
                    String MS_HEADER = "Microsoft Mail Internet Headers Version 2.0";
                    if (messageHeaders.startsWith("Microsoft Mail Internet Headers Version 2.0")) {
                        if (!(messageHeaders = messageHeaders.substring("Microsoft Mail Internet Headers Version 2.0".length())).isEmpty() && messageHeaders.charAt(0) == '\r') {
                            messageHeaders = messageHeaders.substring(1);
                        }
                        if (!messageHeaders.isEmpty() && messageHeaders.charAt(0) == '\n') {
                            messageHeaders = messageHeaders.substring(1);
                        }
                    }
                    if (!messageHeaders.contains("From:")) {
                        String from = HC4DavExchangeSession.this.getItemProperty(this.permanentUrl, "from");
                        messageHeaders = "From: " + from + '\n' + messageHeaders;
                    }
                    result = new ByteArrayInputStream(messageHeaders.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getMessage());
            }
            return result;
        }
    }

    protected static class MonoCondition
    extends ExchangeSession.MonoCondition {
        protected MonoCondition(String attributeName, ExchangeSession.Operator operator) {
            super(attributeName, operator);
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append('\"').append(Field.get(this.attributeName).getUri()).append('\"');
            buffer.append(OPERATOR_MAP.get((Object)this.operator));
        }
    }

    protected static class HeaderCondition
    extends AttributeCondition {
        protected HeaderCondition(String attributeName, ExchangeSession.Operator operator, String value) {
            super(attributeName, operator, value);
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append('\"').append(Field.getHeader(this.attributeName).getUri()).append('\"');
            buffer.append(OPERATOR_MAP.get((Object)this.operator));
            buffer.append('\'');
            if (ExchangeSession.Operator.Like == this.operator) {
                buffer.append('%');
            }
            buffer.append(this.value);
            if (ExchangeSession.Operator.Like == this.operator) {
                buffer.append('%');
            }
            buffer.append('\'');
        }
    }

    protected static class AttributeCondition
    extends ExchangeSession.AttributeCondition {
        protected boolean isIntValue;

        protected AttributeCondition(String attributeName, ExchangeSession.Operator operator, String value) {
            super(attributeName, operator, value);
        }

        protected AttributeCondition(String attributeName, ExchangeSession.Operator operator, int value) {
            super(attributeName, operator, String.valueOf(value));
            this.isIntValue = true;
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            Field field = Field.get(this.attributeName);
            buffer.append('\"').append(field.getUri()).append('\"');
            buffer.append(OPERATOR_MAP.get((Object)this.operator));
            if (field.cast != null) {
                buffer.append("CAST (\"");
            } else if (!this.isIntValue && !field.isIntValue()) {
                buffer.append('\'');
            }
            if (ExchangeSession.Operator.Like == this.operator) {
                buffer.append('%');
            }
            if ("urlcompname".equals(field.alias)) {
                buffer.append(StringUtil.encodeUrlcompname(StringUtil.davSearchEncode(this.value)));
            } else if (field.isIntValue()) {
                try {
                    Integer.parseInt(this.value);
                    buffer.append(this.value);
                }
                catch (NumberFormatException e) {
                    buffer.append('0');
                }
            } else {
                buffer.append(StringUtil.davSearchEncode(this.value));
            }
            if (ExchangeSession.Operator.Like == this.operator || ExchangeSession.Operator.StartsWith == this.operator) {
                buffer.append('%');
            }
            if (field.cast != null) {
                buffer.append("\" as '").append(field.cast).append("')");
            } else if (!this.isIntValue && !field.isIntValue()) {
                buffer.append('\'');
            }
        }

        @Override
        public boolean isMatch(ExchangeSession.Contact contact) {
            String lowerCaseValue = this.value.toLowerCase();
            String actualValue = (String)contact.get(this.attributeName);
            ExchangeSession.Operator actualOperator = this.operator;
            if (actualValue == null && ("givenName".equals(this.attributeName) || "sn".equals(this.attributeName))) {
                actualValue = (String)contact.get("cn");
                actualOperator = ExchangeSession.Operator.Like;
            }
            if (actualValue == null) {
                return false;
            }
            actualValue = actualValue.toLowerCase();
            return actualOperator == ExchangeSession.Operator.IsEqualTo && actualValue.equals(lowerCaseValue) || actualOperator == ExchangeSession.Operator.Like && actualValue.contains(lowerCaseValue) || actualOperator == ExchangeSession.Operator.StartsWith && actualValue.startsWith(lowerCaseValue);
        }
    }

    protected static class NotCondition
    extends ExchangeSession.NotCondition {
        protected NotCondition(ExchangeSession.Condition condition) {
            super(condition);
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append("(Not ");
            this.condition.appendTo(buffer);
            buffer.append(')');
        }
    }

    protected static class MultiCondition
    extends ExchangeSession.MultiCondition {
        protected MultiCondition(ExchangeSession.Operator operator, ExchangeSession.Condition ... condition) {
            super(operator, condition);
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            boolean first = true;
            for (ExchangeSession.Condition condition : this.conditions) {
                if (condition == null || condition.isEmpty()) continue;
                if (first) {
                    buffer.append('(');
                    first = false;
                } else {
                    buffer.append(' ').append((Object)this.operator).append(' ');
                }
                condition.appendTo(buffer);
            }
            if (!first) {
                buffer.append(')');
            }
        }
    }

    protected static enum FolderQueryTraversal {
        Shallow,
        Deep;

    }
}

