/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.O365Authenticator;
import davmail.exchange.auth.O365ManualAuthenticatorDialog;
import davmail.exchange.auth.O365Token;
import davmail.exchange.ews.BaseShape;
import davmail.exchange.ews.DistinguishedFolderId;
import davmail.exchange.ews.GetFolderMethod;
import davmail.exchange.ews.GetUserConfigurationMethod;
import davmail.http.DavGatewayHttpClientFacade;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log4j.Logger;

public class O365ManualAuthenticator
implements ExchangeAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(O365ManualAuthenticator.class);
    String errorCode = null;
    String code = null;
    String resource = "https://outlook.office365.com";
    URI ewsUrl = URI.create(this.resource + "/EWS/Exchange.asmx");
    private O365ManualAuthenticatorDialog o365ManualAuthenticatorDialog;
    private String username;
    private String password;
    private O365Token token;

    @Override
    public O365Token getToken() {
        return this.token;
    }

    @Override
    public URI getExchangeUri() {
        return this.ewsUrl;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void authenticate() throws IOException {
        String clientId = Settings.getProperty("davmail.oauth.clientId", "facd6cff-a294-4415-b59f-c5b01937d7bd");
        String redirectUri = Settings.getProperty("davmail.oauth.redirectUri", "https://login.microsoftonline.com/common/oauth2/nativeclient");
        String tenantId = Settings.getProperty("davmail.oauth.tenantId", "common");
        this.token = O365Token.load(tenantId, clientId, redirectUri, this.username, this.password);
        if (this.token != null) {
            return;
        }
        String initUrl = O365Authenticator.buildAuthorizeUrl(tenantId, clientId, redirectUri, this.username);
        if (Settings.getBooleanProperty("davmail.server") || GraphicsEnvironment.isHeadless()) {
            this.code = this.getCodeFromConsole(initUrl);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this.o365ManualAuthenticatorDialog = new O365ManualAuthenticatorDialog(initUrl);
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
            this.code = this.o365ManualAuthenticatorDialog.getCode();
        }
        if (this.code == null) {
            LOGGER.error((Object)"Authentication failed, code not available");
            throw new DavMailException("EXCEPTION_AUTHENTICATION_FAILED_REASON", this.errorCode);
        }
        this.token = O365Token.build(tenantId, clientId, redirectUri, this.code, this.password);
        LOGGER.debug((Object)("Authenticated username: " + this.token.getUsername()));
        if (this.username != null && !this.username.isEmpty() && !this.username.equalsIgnoreCase(this.token.getUsername())) {
            throw new DavMailAuthenticationException("Authenticated username " + this.token.getUsername() + " does not match " + this.username);
        }
    }

    private String getCodeFromConsole(String initUrl) {
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
        StringBuilder buffer = new StringBuilder();
        buffer.append(BundleMessage.format("UI_0365_AUTHENTICATION_PROMPT_CONSOLE", initUrl)).append("\n").append(BundleMessage.format("UI_0365_AUTHENTICATION_CODE", new Object[0]));
        try {
            System.out.print(buffer.toString());
            this.code = inReader.readLine();
            if (this.code != null && this.code.contains("code=") && this.code.contains("&session_state=")) {
                this.code = this.code.substring(this.code.indexOf("code=") + 5, this.code.indexOf("&session_state="));
            }
        }
        catch (IOException e) {
            System.err.println(e + " " + e.getMessage());
        }
        return this.code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        try {
            Settings.setDefaultSettings();
            Settings.setProperty("davmail.server", "false");
            O365ManualAuthenticator authenticator = new O365ManualAuthenticator();
            authenticator.setUsername("");
            authenticator.authenticate();
            HttpClient httpClient = DavGatewayHttpClientFacade.getInstance(authenticator.ewsUrl.toString());
            GetFolderMethod checkMethod = new GetFolderMethod(BaseShape.ID_ONLY, DistinguishedFolderId.getInstance(null, DistinguishedFolderId.Name.root), null);
            checkMethod.setRequestHeader("Authorization", "Bearer " + authenticator.getToken().getAccessToken());
            try {
                httpClient.executeMethod((HttpMethod)checkMethod);
                checkMethod.checkSuccess();
            }
            finally {
                checkMethod.releaseConnection();
            }
            System.out.println("Retrieved folder id " + (String)checkMethod.getResponseItem().get("FolderId"));
            int i = 0;
            while (i++ < 1440) {
                GetUserConfigurationMethod getUserConfigurationMethod = new GetUserConfigurationMethod();
                getUserConfigurationMethod.setRequestHeader("Authorization", "Bearer " + authenticator.getToken().getAccessToken());
                httpClient.executeMethod((HttpMethod)getUserConfigurationMethod);
                System.out.println(getUserConfigurationMethod.getResponseItem());
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(e + " " + e.getMessage()), (Throwable)e);
        }
        System.exit(0);
    }
}

