/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HttpURLConnectionWrapper
extends HttpURLConnection {
    private static final Logger LOGGER = Logger.getLogger(HttpURLConnectionWrapper.class);
    HttpURLConnection httpURLConnection;

    HttpURLConnectionWrapper(HttpURLConnection httpURLConnection, URL url) {
        super(url);
        this.httpURLConnection = httpURLConnection;
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.httpURLConnection.setRequestMethod(method);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.httpURLConnection.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.httpURLConnection.getInstanceFollowRedirects();
    }

    @Override
    public String getRequestMethod() {
        return this.httpURLConnection.getRequestMethod();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.httpURLConnection.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.httpURLConnection.getResponseMessage();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        LOGGER.debug(this.httpURLConnection.getHeaderFields());
        return this.httpURLConnection.getHeaderFields();
    }

    @Override
    public String getHeaderField(String name) {
        return this.httpURLConnection.getHeaderField(name);
    }

    @Override
    public String getHeaderField(int n) {
        return this.httpURLConnection.getHeaderField(n);
    }

    @Override
    public void disconnect() {
        this.httpURLConnection.disconnect();
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        this.httpURLConnection.setDoOutput(dooutput);
    }

    @Override
    public boolean usingProxy() {
        return this.httpURLConnection.usingProxy();
    }

    @Override
    public void connect() throws IOException {
        try {
            this.httpURLConnection.connect();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.httpURLConnection.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.httpURLConnection.getOutputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.httpURLConnection.getErrorStream();
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.httpURLConnection.setRequestProperty(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.httpURLConnection.setRequestProperty(key, value);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.httpURLConnection.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String key) {
        return this.httpURLConnection.getRequestProperty(key);
    }

    @Override
    public String getContentType() {
        String contentType = this.httpURLConnection.getContentType();
        if (contentType == null && this.getContentLength() > 0) {
            LOGGER.debug((Object)("Fix missing content-type at " + this.url.toString()));
            return "text/html";
        }
        return contentType;
    }
}

